/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.ui;

import com.intellij.ide.ui.UISettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.ColoredItem;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.ui.BackgroundSupplier;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.DirtyUI;
import com.intellij.ui.ExperimentalUI;
import com.intellij.ui.LoadingNode;
import com.intellij.ui.SeparatorWithText;
import com.intellij.ui.hover.TreeHoverListener;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.ui.render.RenderingHelper;
import com.intellij.ui.render.RenderingUtil;
import com.intellij.ui.tree.TreePathBackgroundSupplier;
import com.intellij.ui.tree.ui.CompactPainter;
import com.intellij.ui.tree.ui.Control;
import com.intellij.ui.tree.ui.CustomBoundsTreeUI;
import com.intellij.ui.tree.ui.DefaultControl;
import com.intellij.ui.tree.ui.DefaultTreeLayoutCache;
import com.intellij.ui.tree.ui.DispatchThreadValidator;
import com.intellij.ui.tree.ui.LoadingNodeRenderer;
import com.intellij.ui.tree.ui.PlainSelectionTree;
import com.intellij.ui.tree.ui.TreeAction;
import com.intellij.ui.treeStructure.BgtAwareTreeModel;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.ui.treeStructure.TreeUiBulkExpandCollapseSupport;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ReflectionUtil;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.EdtInvocationManager;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.MouseEventAdapter;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Function;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicTreeUI;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.FixedHeightLayoutCache;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.VariableHeightLayoutCache;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@DirtyUI
public class DefaultTreeUI
extends BasicTreeUI
implements TreeUiBulkExpandCollapseSupport,
CustomBoundsTreeUI {
    @ApiStatus.Internal
    public static final Key<Boolean> LARGE_MODEL_ALLOWED = Key.create((String)"allows to use large model (only for synchronous tree models)");
    public static final Key<Boolean> AUTO_EXPAND_ALLOWED = Key.create((String)"allows to expand a single child node automatically in tests");
    public static final Key<Function<Object, Boolean>> AUTO_EXPAND_FILTER = Key.create((String)"allows to filter single child nodes which should not be auto-expanded");
    @ApiStatus.Internal
    public static final int HORIZONTAL_SELECTION_OFFSET = 12;
    private static final Logger LOG = Logger.getInstance(DefaultTreeUI.class);
    private static final Collection<Class<?>> SUSPICIOUS = ContainerUtil.createWeakSet();
    private final Control myDefaultControl = new DefaultControl();
    private final AtomicBoolean painting = new AtomicBoolean();
    private final DispatchThreadValidator validator = new DispatchThreadValidator();
    @NotNull
    private final AtomicInteger bulkOperationsInProgress = new AtomicInteger();
    @Nullable
    private ComponentListener resizeListener;

    @NotNull
    private static Control.Painter getPainter(@NotNull JTree tree2) {
        Control.Painter painter;
        if (tree2 == null) {
            DefaultTreeUI.$$$reportNull$$$0(0);
        }
        if ((painter = (Control.Painter)ClientProperty.get((Component)tree2, Control.Painter.KEY)) != null) {
            Control.Painter painter2 = painter;
            if (painter2 == null) {
                DefaultTreeUI.$$$reportNull$$$0(1);
            }
            return painter2;
        }
        Application application = ApplicationManager.getApplication();
        if (application != null && (painter = (Control.Painter)application.getUserData(Control.Painter.KEY)) != null) {
            Control.Painter painter3 = painter;
            if (painter3 == null) {
                DefaultTreeUI.$$$reportNull$$$0(2);
            }
            return painter3;
        }
        UISettings settings = UISettings.getInstanceOrNull();
        if (settings != null && settings.getCompactTreeIndents()) {
            Control.Painter painter4 = Control.Painter.COMPACT;
            if (painter4 == null) {
                DefaultTreeUI.$$$reportNull$$$0(3);
            }
            return painter4;
        }
        if (Registry.is((String)"ide.tree.painter.classic.compact")) {
            Control.Painter painter5 = Control.Painter.COMPACT;
            if (painter5 == null) {
                DefaultTreeUI.$$$reportNull$$$0(4);
            }
            return painter5;
        }
        if (Registry.is((String)"ide.tree.painter.compact.default")) {
            Control.Painter painter6 = CompactPainter.DEFAULT;
            if (painter6 == null) {
                DefaultTreeUI.$$$reportNull$$$0(5);
            }
            return painter6;
        }
        Control.Painter painter7 = Control.Painter.DEFAULT;
        if (painter7 == null) {
            DefaultTreeUI.$$$reportNull$$$0(6);
        }
        return painter7;
    }

    @ApiStatus.Internal
    @Nullable
    public static Color getBackground(@NotNull JTree tree2, @NotNull TreePath path, int row2, boolean selected) {
        BackgroundSupplier supplier;
        Color background;
        Color background2;
        if (tree2 == null) {
            DefaultTreeUI.$$$reportNull$$$0(7);
        }
        if (path == null) {
            DefaultTreeUI.$$$reportNull$$$0(8);
        }
        Object node = TreeUtil.getLastUserObject((TreePath)path);
        if (selected) {
            BackgroundSupplier supplier2;
            Color background3;
            if (node instanceof BackgroundSupplier && (background3 = (supplier2 = (BackgroundSupplier)node).getSelectedElementBackground(row2)) != null) {
                return background3;
            }
            return RenderingUtil.getSelectionBackground((JTree)tree2);
        }
        if (row2 == TreeHoverListener.getHoveredRow((JTree)tree2) && (background2 = RenderingUtil.getHoverBackground((JTree)tree2)) != null) {
            return background2;
        }
        if (node instanceof ColoredItem && (background2 = ((ColoredItem)node).getColor()) != null) {
            return background2;
        }
        if (node instanceof BackgroundSupplier && (background = (supplier = (BackgroundSupplier)node).getElementBackground(row2)) != null) {
            return background;
        }
        if (tree2 instanceof TreePathBackgroundSupplier && (background = (supplier = (TreePathBackgroundSupplier)tree2).getPathBackground(path, row2)) != null) {
            return background;
        }
        return null;
    }

    @ApiStatus.Internal
    public static void setBackground(@NotNull JTree tree2, @NotNull Component component2, int row2) {
        TreePath path;
        if (tree2 == null) {
            DefaultTreeUI.$$$reportNull$$$0(9);
        }
        if (component2 == null) {
            DefaultTreeUI.$$$reportNull$$$0(10);
        }
        Color background = (path = tree2.getPathForRow(row2)) == null ? null : DefaultTreeUI.getBackground(tree2, path, row2, tree2.isRowSelected(row2));
        DefaultTreeUI.setBackground(tree2, component2, background, true);
    }

    @ApiStatus.Internal
    public static boolean isSeparator(@Nullable TreePath path) {
        return path != null && DefaultTreeUI.isSeparator(path.getLastPathComponent());
    }

    private static void setBackground(@NotNull JTree tree2, @NotNull Component component2, @Nullable Color background, boolean opaque) {
        if (tree2 == null) {
            DefaultTreeUI.$$$reportNull$$$0(11);
        }
        if (component2 == null) {
            DefaultTreeUI.$$$reportNull$$$0(12);
        }
        if (component2 instanceof JComponent) {
            ((JComponent)component2).setOpaque(opaque);
        }
        if (background != null) {
            component2.setBackground(background);
        } else if (component2.isOpaque()) {
            component2.setBackground(RenderingUtil.getBackground((JTree)tree2));
        }
    }

    private static boolean isSuspiciousRenderer(Component component2) {
        if (component2 instanceof JComponent) {
            Method method = ReflectionUtil.getMethod(component2.getClass(), (String)"validate", (Class[])new Class[0]);
            Class<?> type = method == null ? null : method.getDeclaringClass();
            return Component.class.equals(type) || Container.class.equals(type);
        }
        return true;
    }

    private static boolean isLeadSelectionNeeded(@NotNull JTree tree2, int row2) {
        if (tree2 == null) {
            DefaultTreeUI.$$$reportNull$$$0(13);
        }
        return 1 < tree2.getSelectionCount() && tree2.isRowSelected(row2 - 1) && tree2.isRowSelected(row2 + 1);
    }

    private static boolean isLargeModelAllowed(@Nullable JTree tree2) {
        return Registry.is((String)"ide.tree.large.model.allowed") || ClientProperty.isTrue((Component)tree2, LARGE_MODEL_ALLOWED);
    }

    private static boolean isAutoExpandAllowed(@NotNull JTree tree2) {
        Boolean allowed;
        if (tree2 == null) {
            DefaultTreeUI.$$$reportNull$$$0(14);
        }
        return (allowed = (Boolean)ClientProperty.get((Component)tree2, AUTO_EXPAND_ALLOWED)) != null ? allowed.booleanValue() : tree2.isShowing();
    }

    private static boolean isAutoExpandAllowed(@NotNull JTree tree2, @NotNull Object node) {
        Function filter2;
        if (tree2 == null) {
            DefaultTreeUI.$$$reportNull$$$0(15);
        }
        if (node == null) {
            DefaultTreeUI.$$$reportNull$$$0(16);
        }
        if ((filter2 = (Function)ClientProperty.get((Component)tree2, AUTO_EXPAND_FILTER)) != null) {
            return (Boolean)filter2.apply(node) == false;
        }
        if (node instanceof AbstractTreeNode) {
            AbstractTreeNode treeNode = (AbstractTreeNode)node;
            return treeNode.isAutoExpandAllowed();
        }
        return true;
    }

    public static ComponentUI createUI(JComponent component2) {
        assert (component2 instanceof JTree);
        return new DefaultTreeUI();
    }

    @NotNull
    private Control getControl(@NotNull JComponent c, @NotNull TreePath path) {
        Function controlResolver;
        if (c == null) {
            DefaultTreeUI.$$$reportNull$$$0(17);
        }
        if (path == null) {
            DefaultTreeUI.$$$reportNull$$$0(18);
        }
        Control resolvedControl = (controlResolver = (Function)ClientProperty.get((Component)c, Control.CUSTOM_CONTROL)) != null ? (Control)controlResolver.apply(path) : this.myDefaultControl;
        Control control = (Control)ObjectUtils.chooseNotNull((Object)resolvedControl, (Object)this.myDefaultControl);
        if (control == null) {
            DefaultTreeUI.$$$reportNull$$$0(19);
        }
        return control;
    }

    @Nullable
    private JTree getTree() {
        return this.tree;
    }

    @Nullable
    private Component getRenderer(JTree tree2, Object value, boolean selected, boolean expanded, boolean leaf, int row2, boolean focused) {
        Class<?> type;
        TreeCellRenderer renderer2;
        if (DefaultTreeUI.isSeparator(value) && value instanceof Component) {
            return (Component)value;
        }
        TreeCellRenderer treeCellRenderer = renderer2 = value instanceof LoadingNode ? LoadingNodeRenderer.SHARED : this.currentCellRenderer;
        if (renderer2 == null) {
            return null;
        }
        Component component2 = renderer2.getTreeCellRendererComponent(tree2, value, selected, expanded, leaf, row2, focused);
        if (component2 == null) {
            return null;
        }
        CellRendererPane pane2 = this.rendererPane;
        if (pane2 != null && pane2 != component2.getParent()) {
            pane2.add(component2);
        }
        if (LOG.isDebugEnabled() && !SUSPICIOUS.contains(type = renderer2.getClass()) && DefaultTreeUI.isSuspiciousRenderer(component2) && SUSPICIOUS.add(type)) {
            LOG.debug("suspicious renderer " + String.valueOf(type));
        }
        return component2;
    }

    private boolean isLeaf(@Nullable Object value) {
        return value == null || DefaultTreeUI.isSeparator(value) || this.treeModel.isLeaf(value);
    }

    private static boolean isSeparator(@Nullable Object value) {
        return value instanceof SeparatorWithText;
    }

    private boolean isValid(@Nullable JTree tree2) {
        if (!this.validator.isValidThread()) {
            LOG.error("TreeUI should be accessed only from EDT");
            return false;
        }
        if (tree2 != null && tree2 == this.getTree()) {
            return true;
        }
        LOG.warn((Throwable)new IllegalStateException(tree2 != null ? "unexpected tree" : "undefined tree"));
        return false;
    }

    private void repaintPath(@Nullable TreePath path) {
        JTree tree2 = this.getTree();
        if (tree2 != null) {
            TreeUtil.repaintPath((JTree)tree2, (TreePath)path);
        }
    }

    private void removeCachedRenderers() {
        CellRendererPane pane2;
        CellRendererPane cellRendererPane = pane2 = this.painting.get() ? null : this.rendererPane;
        if (pane2 != null) {
            pane2.removeAll();
        }
    }

    @Nullable
    public Rectangle getActualPathBounds(@NotNull JTree tree2, @NotNull TreePath path) {
        if (tree2 == null) {
            DefaultTreeUI.$$$reportNull$$$0(20);
        }
        if (path == null) {
            DefaultTreeUI.$$$reportNull$$$0(21);
        }
        RenderingHelper helper = new RenderingHelper(tree2);
        Control.Painter painter = DefaultTreeUI.getPainter(tree2);
        return this.getActualPathBounds(tree2, path, helper, painter);
    }

    private Rectangle getActualPathBounds(@NotNull JTree tree2, @NotNull TreePath path, RenderingHelper helper, Control.Painter painter) {
        if (tree2 == null) {
            DefaultTreeUI.$$$reportNull$$$0(22);
        }
        if (path == null) {
            DefaultTreeUI.$$$reportNull$$$0(23);
        }
        AbstractLayoutCache cache2 = this.treeState;
        Insets insets = tree2.getInsets();
        Rectangle bounds = new Rectangle();
        cache2.getBounds(path, bounds);
        bounds.y += insets.top;
        Object value = path.getLastPathComponent();
        int depth = TreeUtil.getNodeDepth((JTree)tree2, (TreePath)path);
        boolean leaf = this.isLeaf(value);
        Control control = this.getControl(tree2, path);
        int offset = painter.getRendererOffset(control, depth, leaf);
        int width = helper.getX() + helper.getWidth() - insets.left - offset;
        int row2 = cache2.getRowForPath(path);
        if ((width -= helper.getRightMargin()) < bounds.width && helper.isRendererShrinkingDisabled(row2)) {
            width = bounds.width;
        }
        return new Rectangle(insets.left + offset, bounds.y, width, bounds.height);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void paint(Graphics g, JComponent c) {
        block35: {
            AbstractLayoutCache cache2 = this.treeState;
            if (cache2 == null) {
                return;
            }
            JTree tree2 = (JTree)c;
            if (!this.isValid(tree2)) {
                return;
            }
            g = g.create();
            try {
                this.painting.set(true);
                Rectangle paintBounds = g.getClipBounds();
                Insets insets = tree2.getInsets();
                TreePath path = cache2.getPathClosestTo(0, paintBounds.y - insets.top);
                int row2 = cache2.getRowForPath(path);
                if (row2 < 0) break block35;
                boolean dark = ColorUtil.isDark((Color)JBUI.CurrentTheme.Tree.BACKGROUND);
                Control.Painter painter = DefaultTreeUI.getPainter(tree2);
                Rectangle buffer2 = new Rectangle();
                RenderingHelper helper = new RenderingHelper(tree2);
                int maxPaintY = paintBounds.y + paintBounds.height;
                while (path != null) {
                    Color background;
                    Rectangle bounds = cache2.getBounds(path, buffer2);
                    if (bounds == null) {
                        break;
                    }
                    bounds.y += insets.top;
                    int depth = TreeUtil.getNodeDepth((JTree)tree2, (TreePath)path);
                    Object value = path.getLastPathComponent();
                    boolean leaf = this.isLeaf(value);
                    boolean expanded = !leaf && cache2.getExpandedState(path);
                    boolean selected = tree2.isRowSelected(row2);
                    boolean focused = RenderingUtil.isFocused((JComponent)tree2);
                    boolean lead = focused && row2 == this.getLeadSelectionRow();
                    boolean selectedControl = selected && focused;
                    Color color = background = DefaultTreeUI.isSeparator(value) ? null : DefaultTreeUI.getBackground(tree2, path, row2, selected);
                    if (background != null) {
                        g.setColor(background);
                        if (g instanceof Graphics2D && ExperimentalUI.isNewUI() && Registry.is((String)"ide.experimental.ui.tree.selection") && !(tree2 instanceof PlainSelectionTree) && (selected || row2 == TreeHoverListener.getHoveredRow((JTree)tree2))) {
                            int treeRight;
                            int borderOffset = JBUI.scale((int)12);
                            Control control = this.getControl(c, path);
                            int rendererOffset = painter.getRendererOffset(control, depth, leaf);
                            int controlOffset = painter.getControlOffset(control, depth, leaf);
                            int left = Math.min(helper.getX() + borderOffset, insets.left + (controlOffset < 0 ? rendererOffset : controlOffset));
                            int right = treeRight = helper.getX() + helper.getWidth() - borderOffset;
                            if (helper.isShrinkingSelectionDisabled(row2)) {
                                int rendererRight = insets.left + rendererOffset + bounds.width + JBUI.scale((int)4);
                                right = Math.max(treeRight, rendererRight);
                            }
                            int[] rows = tree2.getSelectionRows();
                            boolean shouldPaintTop = false;
                            boolean shouldPaintBottom = false;
                            if (rows != null && rows.length > 1) {
                                for (int selectedRow : rows) {
                                    int delta = selectedRow - row2;
                                    if (delta == 1) {
                                        shouldPaintBottom = true;
                                    }
                                    if (delta == -1) {
                                        shouldPaintTop = true;
                                    }
                                    if (shouldPaintTop && shouldPaintBottom) break;
                                }
                            }
                            if (shouldPaintTop && shouldPaintBottom) {
                                g.fillRect(left, bounds.y, right - left, bounds.height);
                            } else {
                                int arc = JBUI.CurrentTheme.Tree.ARC.get();
                                RectanglePainter.FILL.paint((Graphics2D)g, left, bounds.y, right - left, bounds.height, (Object)arc);
                                if (shouldPaintTop) {
                                    g.fillRect(left, bounds.y, right - left, arc);
                                }
                                if (shouldPaintBottom) {
                                    g.fillRect(left, bounds.y + bounds.height - arc, right - left, arc);
                                }
                            }
                        } else {
                            g.fillRect(helper.getX(), bounds.y, helper.getWidth(), bounds.height);
                        }
                        if (selectedControl && !dark && !ColorUtil.isDark((Color)background)) {
                            selectedControl = false;
                        }
                    }
                    Control control = this.getControl(c, path);
                    int offset = painter.getRendererOffset(control, depth, leaf);
                    painter.paint(tree2, g, insets.left, bounds.y, offset, bounds.height, control, depth, leaf, expanded, selectedControl);
                    if (this.editingComponent == null || this.editingRow != row2) {
                        JTree.DropLocation dropLocation;
                        int width = helper.getX() + helper.getWidth() - insets.left - offset;
                        if (width > 0) {
                            Component component2 = this.getRenderer(tree2, value, selected, expanded, leaf, row2, lead);
                            if (DefaultTreeUI.isSeparator(component2)) {
                                int x;
                                if (ExperimentalUI.isNewUI()) {
                                    Insets separatorInsets = JBUI.CurrentTheme.Popup.separatorInsets();
                                    x = paintBounds.x + separatorInsets.left;
                                    width = paintBounds.width - separatorInsets.left - separatorInsets.right;
                                } else {
                                    int separatorWidthGap = JBUI.scale((int)3);
                                    x = paintBounds.x + separatorWidthGap;
                                    width = paintBounds.width - 2 * separatorWidthGap;
                                }
                                if (width > 0) {
                                    this.rendererPane.paintComponent(g, component2, tree2, x, bounds.y, width, bounds.height, true);
                                }
                            } else if (component2 != null) {
                                Rectangle compBounds = this.getActualPathBounds(tree2, path, helper, painter);
                                if (compBounds.width > 0) {
                                    DefaultTreeUI.setBackground(tree2, component2, background, false);
                                    this.rendererPane.paintComponent(g, component2, tree2, compBounds.x, compBounds.y, compBounds.width, compBounds.height, true);
                                }
                            }
                        }
                        if (!SystemInfo.isMac && lead && g instanceof Graphics2D) {
                            if (!selected) {
                                g.setColor(DefaultTreeUI.getBackground(tree2, path, row2, true));
                                RectanglePainter.DRAW.paint((Graphics2D)g, helper.getX(), bounds.y, helper.getWidth(), bounds.height, (Object)0);
                            } else if (DefaultTreeUI.isLeadSelectionNeeded(tree2, row2)) {
                                g.setColor(RenderingUtil.getBackground((JTree)tree2));
                                RectanglePainter.DRAW.paint((Graphics2D)g, helper.getX() + 1, bounds.y + 1, helper.getWidth() - 2, bounds.height - 2, (Object)0);
                            }
                        }
                        if ((dropLocation = tree2.getDropLocation()) != null && g instanceof Graphics2D && path.equals(dropLocation.getPath())) {
                            g.setColor(JBUI.CurrentTheme.DragAndDrop.ROW_BACKGROUND);
                            RectanglePainter.FILL.paint((Graphics2D)g, helper.getX(), bounds.y, helper.getWidth(), bounds.height, (Object)0);
                            g.setColor(JBUI.CurrentTheme.DragAndDrop.BORDER_COLOR);
                            RectanglePainter.DRAW.paint((Graphics2D)g, helper.getX(), bounds.y, helper.getWidth(), bounds.height, (Object)0);
                        }
                    }
                    if (bounds.y + bounds.height >= maxPaintY) {
                        break;
                    }
                    path = cache2.getPathForRow(++row2);
                }
            }
            finally {
                g.dispose();
                this.painting.set(false);
                this.removeCachedRenderers();
            }
        }
    }

    @Override
    protected void installDefaults() {
        JTree tree2;
        super.installDefaults();
        if (!DefaultTreeUI.isLargeModelAllowed(this.getTree())) {
            this.largeModel = false;
        }
        if ((tree2 = this.getTree()) != null) {
            LookAndFeel.installBorder(tree2, "Tree.border");
            if (tree2.isForegroundSet()) {
                tree2.setForeground(null);
            }
            if (UIManager.get("Tree.showsRootHandles") == null) {
                LookAndFeel.installProperty(tree2, "showsRootHandles", Boolean.TRUE);
            }
        }
    }

    @Override
    protected void installKeyboardActions() {
        super.installKeyboardActions();
        TreeAction.installTo(this.tree.getActionMap());
        TreeAction.installTo(this.tree.getInputMap(0));
    }

    @Override
    protected boolean isToggleEvent(MouseEvent event) {
        if (!super.isToggleEvent(event)) {
            return false;
        }
        JTree tree2 = this.getTree();
        return tree2 != null && tree2.getToggleClickCount() == event.getClickCount() && EditSourceOnDoubleClickHandler.isExpandPreferable((JTree)tree2, (TreePath)tree2.getSelectionPath());
    }

    @Override
    protected void toggleExpandState(TreePath path) {
        if (!this.tree.isExpanded(path) && this.tree instanceof Tree) {
            ((Tree)this.tree).startMeasuringExpandDuration(path);
        }
        super.toggleExpandState(path);
    }

    @ApiStatus.Internal
    public boolean isLocationInExpandControl(@NotNull Point location) {
        JTree tree2;
        if (location == null) {
            DefaultTreeUI.$$$reportNull$$$0(24);
        }
        if ((tree2 = this.getTree()) == null) {
            return false;
        }
        TreePath path = this.getClosestPathForLocation(tree2, location.x, location.y);
        if (path == null) {
            return false;
        }
        return this.isLocationInExpandControl(path, location.x, location.y);
    }

    @Override
    protected boolean isLocationInExpandControl(TreePath path, int mouseX, int mouseY) {
        JTree tree2 = this.getTree();
        if (tree2 == null) {
            return false;
        }
        Rectangle bounds = this.getPathBounds(tree2, path);
        if (bounds == null) {
            return false;
        }
        Control control = this.getControl(tree2, path);
        bounds.x = DefaultTreeUI.getPainter(tree2).getControlOffset(control, TreeUtil.getNodeDepth((JTree)tree2, (TreePath)path), this.isLeaf(path.getLastPathComponent()));
        if (bounds.x < 0) {
            return false;
        }
        Insets insets = tree2.getInsets();
        bounds.x += insets.left;
        bounds.width = control.getWidth();
        int height = 2 + control.getHeight();
        if (height < bounds.height) {
            bounds.y += (bounds.height - height) / 2;
            bounds.height = height;
        }
        return bounds.contains(mouseX, mouseY);
    }

    @Override
    protected void configureLayoutCache() {
        super.configureLayoutCache();
        JTree tree2 = this.getTree();
        if (tree2 != null && null == ReflectionUtil.getField(BasicTreeUI.class, (Object)this, null, (String)"componentListener")) {
            final ComponentListener listener2 = this.createComponentListener();
            ComponentAdapter adapter = new ComponentAdapter(){

                @Override
                public void componentMoved(ComponentEvent event) {
                    AbstractLayoutCache cache2 = DefaultTreeUI.this.treeState;
                    if (cache2 != null && Registry.is((String)"ide.tree.experimental.preferred.width", (boolean)true)) {
                        listener2.componentMoved(event);
                    }
                }
            };
            ReflectionUtil.setField(BasicTreeUI.class, (Object)this, null, (String)"componentListener", (Object)adapter);
            tree2.addComponentListener(adapter);
        }
    }

    @Override
    public Dimension getPreferredSize(JComponent c, boolean checkConsistency) {
        AbstractLayoutCache abstractLayoutCache = this.treeState;
        if (abstractLayoutCache instanceof DefaultTreeLayoutCache) {
            DefaultTreeLayoutCache cache2 = (DefaultTreeLayoutCache)abstractLayoutCache;
            if (!cache2.isCachedSizeValid) {
                this.validCachedPreferredSize = false;
            }
            Dimension result2 = super.getPreferredSize(c, checkConsistency);
            cache2.isCachedSizeValid = true;
            return result2;
        }
        return super.getPreferredSize(c, checkConsistency);
    }

    @Override
    protected void updateCachedPreferredSize() {
        JTree tree2 = this.getTree();
        AbstractLayoutCache cache2 = this.treeState;
        if (tree2 == null || !this.isValid(tree2) || cache2 == null) {
            this.preferredSize.width = 0;
            this.preferredSize.height = 0;
            this.validCachedPreferredSize = true;
        } else if (Registry.is((String)"ide.tree.experimental.preferred.width", (boolean)true)) {
            JScrollBar bar2;
            JScrollPane pane2;
            Rectangle paintBounds = tree2.getVisibleRect();
            Insets insets = tree2.getInsets();
            int visibleRowCount = tree2.getVisibleRowCount();
            if (paintBounds.isEmpty()) {
                paintBounds.width = 1 + insets.left + insets.right;
                paintBounds.height = tree2.getRowHeight() * visibleRowCount + insets.top + insets.bottom;
            }
            if ((pane2 = (JScrollPane)UIUtil.getParentOfType(JScrollPane.class, (Component)tree2)) != null && (bar2 = pane2.getHorizontalScrollBar()) != null && bar2.isOpaque() && bar2.isVisible()) {
                paintBounds.height += bar2.getPreferredSize().height;
            }
            TreePath path = cache2.getPathClosestTo(0, paintBounds.y - insets.top);
            int width = 0;
            int row2 = cache2.getRowForPath(path);
            if (row2 >= 0) {
                Rectangle buffer2 = new Rectangle();
                int maxPaintX = paintBounds.x + paintBounds.width;
                int maxPaintY = paintBounds.y + paintBounds.height;
                int rowsUsed = 0;
                while (path != null) {
                    Rectangle bounds = cache2.getBounds(path, buffer2);
                    if (bounds == null) {
                        LOG.warn("The bounds for the row " + row2 + " of the tree " + String.valueOf(tree2) + " with model " + String.valueOf(this.treeModel) + " are null, looks like a bug in " + String.valueOf(cache2));
                    } else {
                        width = Math.max(width, bounds.x + bounds.width);
                        if (bounds.y + bounds.height >= maxPaintY && (visibleRowCount <= 0 || ++rowsUsed >= visibleRowCount)) break;
                    }
                    path = cache2.getPathForRow(++row2);
                }
                if ((width += insets.left + insets.right) < maxPaintX) {
                    int margin;
                    if (!Registry.is((String)"ide.tree.prefer.to.shrink.width.on.scroll")) {
                        width = maxPaintX;
                    } else if (!(paintBounds.width >= width && Registry.is((String)"ide.tree.prefer.aggressive.scrolling.to.the.left") || (margin = Registry.intValue((String)"ide.tree.preferable.right.margin", (int)25)) <= 0)) {
                        width = Math.min(width + paintBounds.width * margin / 100, maxPaintX);
                    }
                }
            } else {
                width = insets.left + insets.right;
            }
            this.preferredSize.width = width;
            this.preferredSize.height = insets.top + insets.bottom + cache2.getPreferredHeight();
            this.validCachedPreferredSize = true;
        } else {
            super.updateCachedPreferredSize();
        }
    }

    @Override
    protected int getRowX(int row2, int depth) {
        JTree tree2 = this.getTree();
        if (tree2 == null) {
            return 0;
        }
        TreePath path = this.getPathForRow(tree2, row2);
        if (path == null) {
            return 0;
        }
        Control control = this.getControl(tree2, path);
        return DefaultTreeUI.getPainter(tree2).getRendererOffset(control, TreeUtil.getNodeDepth((JTree)tree2, (TreePath)path), this.isLeaf(path.getLastPathComponent()));
    }

    @Override
    protected void setRootVisible(boolean newValue) {
        if (this.treeModel instanceof BgtAwareTreeModel) {
            EdtInvocationManager.invokeLaterIfNeeded(() -> super.setRootVisible(newValue));
        } else {
            super.setRootVisible(newValue);
        }
    }

    @Override
    protected void setLargeModel(boolean large) {
        super.setLargeModel(large && DefaultTreeUI.isLargeModelAllowed(this.getTree()));
    }

    @Override
    protected void setModel(TreeModel model2) {
        if (!DefaultTreeUI.isLargeModelAllowed(this.getTree())) {
            this.largeModel = false;
        }
        super.setModel(model2);
    }

    @Override
    protected void updateSize() {
        if (this.getTree() != null) {
            super.updateSize();
        }
    }

    @Override
    protected void completeEditing() {
        if (this.getTree() != null) {
            super.completeEditing();
        }
    }

    @Override
    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        return new AbstractLayoutCache.NodeDimensions(){

            @Override
            public Rectangle getNodeDimensions(Object value, int row2, int depth, boolean expanded, Rectangle bounds) {
                JTree tree2 = DefaultTreeUI.this.getTree();
                if (tree2 == null) {
                    return null;
                }
                boolean leaf = DefaultTreeUI.this.isLeaf(value);
                Dimension size2 = null;
                if (DefaultTreeUI.this.editingComponent != null && DefaultTreeUI.this.editingRow == row2) {
                    size2 = DefaultTreeUI.this.editingComponent.getPreferredSize();
                } else {
                    boolean selected = tree2.isRowSelected(row2);
                    Component component2 = DefaultTreeUI.this.getRenderer(tree2, value, selected, expanded, leaf, row2, false);
                    if (component2 != null) {
                        component2.validate();
                        size2 = component2.getPreferredSize();
                        DefaultTreeUI.this.removeCachedRenderers();
                    }
                }
                if (size2 == null) {
                    return null;
                }
                int x = DefaultTreeUI.getPainter(tree2).getRendererOffset(DefaultTreeUI.this.myDefaultControl, depth + TreeUtil.getDepthOffset((JTree)tree2), leaf);
                int height = DefaultTreeUI.this.getRowHeight();
                if (height <= 0) {
                    height = size2.height;
                }
                if (bounds == null) {
                    return new Rectangle(x, 0, size2.width, height);
                }
                bounds.x = x;
                bounds.y = 0;
                bounds.width = size2.width;
                bounds.height = height;
                return bounds;
            }
        };
    }

    @Override
    protected AbstractLayoutCache createLayoutCache() {
        if (Registry.is((String)"ide.tree.experimental.layout.cache", (boolean)true)) {
            return new DefaultTreeLayoutCache((Function1<? super TreePath, Unit>)((Function1)path -> {
                this.handleAutoExpand((TreePath)path);
                return Unit.INSTANCE;
            }));
        }
        if (this.isLargeModel() && this.getRowHeight() > 0) {
            return new FixedHeightLayoutCache();
        }
        return new VariableHeightLayoutCache(){

            @Override
            public void setExpandedState(TreePath path, boolean isExpanded) {
                int oldRowCount = this.getRowCount();
                super.setExpandedState(path, isExpanded);
                if (isExpanded) {
                    this.onSingleChildInserted(path, oldRowCount);
                }
            }

            @Override
            public void treeNodesInserted(TreeModelEvent event) {
                int oldRowCount = this.getRowCount();
                super.treeNodesInserted(event);
                this.onSingleChildInserted(event.getTreePath(), oldRowCount);
            }

            private void onSingleChildInserted(TreePath path, int oldRowCount) {
                if (path == null || oldRowCount + 1 != this.getRowCount()) {
                    return;
                }
                JTree tree2 = DefaultTreeUI.this.getTree();
                if (!DefaultTreeUI.shouldAutoExpand(tree2, path)) {
                    return;
                }
                TreeModel model2 = tree2.getModel();
                if (model2 instanceof BgtAwareTreeModel && 1 == model2.getChildCount(path.getLastPathComponent())) {
                    int pathCount = 1 + path.getPathCount();
                    for (int i2 = 0; i2 <= oldRowCount; ++i2) {
                        TreePath row2 = this.getPathForRow(i2);
                        if (row2 == null || pathCount != row2.getPathCount() || !path.equals(row2.getParentPath())) continue;
                        DefaultTreeUI.this.handleAutoExpand(row2);
                        return;
                    }
                }
            }
        };
    }

    @ApiStatus.Internal
    public void beginBulkOperation() {
        if (!this.bulkOperationsSupported()) {
            return;
        }
        this.bulkOperationsInProgress.incrementAndGet();
    }

    @ApiStatus.Internal
    public void endBulkOperation() {
        if (!this.bulkOperationsSupported()) {
            return;
        }
        if (this.bulkOperationsInProgress.decrementAndGet() == 0) {
            this.completeEditing();
            DefaultTreeLayoutCache layoutCache = (DefaultTreeLayoutCache)this.treeState;
            layoutCache.updateExpandedPaths(((Tree)this.tree).getExpandedPaths());
            this.updateLeadSelectionRow();
            this.updateSize();
        }
    }

    @Override
    protected TreeExpansionListener createTreeExpansionListener() {
        return new MyTreeExpansionListener(super.createTreeExpansionListener());
    }

    private boolean bulkOperationsSupported() {
        return this.tree instanceof Tree && this.treeState instanceof DefaultTreeLayoutCache;
    }

    private static boolean shouldAutoExpand(JTree tree2, TreePath path) {
        return tree2 != null && DefaultTreeUI.isAutoExpandAllowed(tree2) && tree2.isVisible(path);
    }

    private void handleAutoExpand(@NotNull TreePath row2) {
        Object node;
        JTree tree2;
        if (row2 == null) {
            DefaultTreeUI.$$$reportNull$$$0(25);
        }
        if (!DefaultTreeUI.shouldAutoExpand(tree2 = this.getTree(), row2.getParentPath())) {
            return;
        }
        if (tree2.getModel() instanceof BgtAwareTreeModel && DefaultTreeUI.isAutoExpandAllowed(tree2, node = row2.getLastPathComponent())) {
            EdtInvocationManager.invokeLaterIfNeeded(() -> tree2.expandPath(row2));
        }
    }

    @Override
    protected void installListeners() {
        super.installListeners();
        if (this.resizeListener == null) {
            this.resizeListener = new ComponentAdapter(){

                @Override
                public void componentResized(ComponentEvent e) {
                    DefaultTreeUI.this.resizeEditorIfNeeded();
                }
            };
        }
        this.tree.addComponentListener(this.resizeListener);
    }

    @Override
    protected void uninstallListeners() {
        this.tree.removeComponentListener(this.resizeListener);
        super.uninstallListeners();
    }

    @Override
    protected boolean startEditing(TreePath path, MouseEvent event) {
        boolean started = super.startEditing(path, event);
        this.resizeEditorIfNeeded();
        return started;
    }

    private void resizeEditorIfNeeded() {
        if (this.editingComponent == null || this.tree == null || this.editingPath == null || !ClientProperty.isTrue((Component)this.tree, RenderingHelper.RESIZE_EDITOR_TO_RENDERER_SIZE)) {
            return;
        }
        Rectangle bounds = this.getActualPathBounds(this.tree, this.editingPath);
        if (bounds != null) {
            this.editingComponent.setSize(bounds.getSize());
            this.editingComponent.revalidate();
            this.editingComponent.repaint();
        }
    }

    @Override
    protected MouseListener createMouseListener() {
        return new MouseEventAdapter<MouseListener>(super.createMouseListener()){

            public void mouseDragged(MouseEvent event) {
                Object property;
                Object component2 = event.getSource();
                Object object = property = component2 instanceof Component ? ClientProperty.get((Component)((Component)component2), (Object)"DnD Source") : null;
                if (property == null) {
                    super.mouseDragged(event);
                }
            }

            @NotNull
            protected MouseEvent convert(@NotNull MouseEvent event) {
                Rectangle bounds;
                int y;
                int x;
                TreePath path;
                JTree tree2;
                if (event == null) {
                    5.$$$reportNull$$$0(0);
                }
                if ((tree2 = DefaultTreeUI.this.getTree()) == null || tree2 != event.getSource() || !tree2.isEnabled()) {
                    MouseEvent mouseEvent = event;
                    if (mouseEvent == null) {
                        5.$$$reportNull$$$0(1);
                    }
                    return mouseEvent;
                }
                if (!event.isConsumed() && SwingUtilities.isLeftMouseButton(event) && (path = DefaultTreeUI.this.getClosestPathForLocation(tree2, x = event.getX(), y = event.getY())) != null && !DefaultTreeUI.this.isLocationInExpandControl(path, x, y) && (bounds = DefaultTreeUI.this.getPathBounds(tree2, path)) != null && bounds.y <= y && y <= bounds.y + bounds.height && (x = Math.max(bounds.x, Math.min(x, bounds.x + bounds.width - 1))) != event.getX()) {
                    event = 5.convert((MouseEvent)event, (Component)tree2, (int)x, (int)y);
                }
                MouseEvent mouseEvent = event;
                if (mouseEvent == null) {
                    5.$$$reportNull$$$0(2);
                }
                return mouseEvent;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 1, 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/ui/tree/ui/DefaultTreeUI$5";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/ui/tree/ui/DefaultTreeUI$5";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "convert";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "convert";
                        break;
                    }
                    case 1: 
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 1, 2 -> new IllegalStateException(string);
                };
            }
        };
    }

    @Override
    protected PropertyChangeListener createPropertyChangeListener() {
        final PropertyChangeListener parent = super.createPropertyChangeListener();
        return new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent event) {
                String name2 = event.getPropertyName();
                if ("anchorSelectionPath".equals(name2)) {
                    return;
                }
                if ("leadSelectionPath".equals(name2)) {
                    DefaultTreeUI.this.updateLeadSelectionRow();
                    DefaultTreeUI.this.repaintPath((TreePath)event.getOldValue());
                    DefaultTreeUI.this.repaintPath((TreePath)event.getNewValue());
                } else if (parent != null) {
                    parent.propertyChange(event);
                }
            }
        };
    }

    @Override
    public Rectangle getPathBounds(JTree tree2, TreePath path) {
        return path != null && this.isValid(tree2) ? super.getPathBounds(tree2, path) : null;
    }

    @Override
    public TreePath getPathForRow(JTree tree2, int row2) {
        return this.isValid(tree2) ? super.getPathForRow(tree2, row2) : null;
    }

    @Override
    public int getRowForPath(JTree tree2, TreePath path) {
        if (path == null || !this.isValid(tree2)) {
            return -1;
        }
        return super.getRowForPath(tree2, path);
    }

    @Override
    public int getRowCount(JTree tree2) {
        if (!this.isValid(tree2)) {
            return 0;
        }
        return super.getRowCount(tree2);
    }

    @Override
    public TreePath getClosestPathForLocation(JTree tree2, int x, int y) {
        return this.isValid(tree2) ? super.getClosestPathForLocation(tree2, x, y) : null;
    }

    @Override
    public boolean isEditing(JTree tree2) {
        return this.isValid(tree2) && super.isEditing(tree2);
    }

    @Override
    public boolean stopEditing(JTree tree2) {
        return this.isValid(tree2) && super.stopEditing(tree2);
    }

    @Override
    public void cancelEditing(JTree tree2) {
        if (!this.isValid(tree2)) {
            return;
        }
        super.cancelEditing(tree2);
    }

    @Override
    public void startEditingAtPath(JTree tree2, TreePath path) {
        if (path == null || !this.isValid(tree2)) {
            return;
        }
        super.startEditingAtPath(tree2, path);
    }

    @Override
    public TreePath getEditingPath(JTree tree2) {
        if (!this.isValid(tree2)) {
            return null;
        }
        return super.getEditingPath(tree2);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 6, 19 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "tree";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/ui/DefaultTreeUI";
                break;
            }
            case 8: 
            case 18: 
            case 21: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "c";
                break;
            }
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
            case 25: {
                objectArray2 = objectArray3;
                objectArray3[0] = "row";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/ui/DefaultTreeUI";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getPainter";
                break;
            }
            case 19: {
                objectArray = objectArray2;
                objectArray2[1] = "getControl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getPainter";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 19: {
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getBackground";
                break;
            }
            case 9: 
            case 10: 
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "setBackground";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "isLeadSelectionNeeded";
                break;
            }
            case 14: 
            case 15: 
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "isAutoExpandAllowed";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "getControl";
                break;
            }
            case 20: 
            case 21: 
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "getActualPathBounds";
                break;
            }
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "isLocationInExpandControl";
                break;
            }
            case 25: {
                objectArray = objectArray;
                objectArray[2] = "handleAutoExpand";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 6, 19 -> new IllegalStateException(string);
        };
    }

    private class MyTreeExpansionListener
    implements TreeExpansionListener {
        private final TreeExpansionListener myOriginal;

        MyTreeExpansionListener(TreeExpansionListener original) {
            this.myOriginal = original;
        }

        @Override
        public void treeExpanded(TreeExpansionEvent event) {
            if (DefaultTreeUI.this.bulkOperationsInProgress.get() == 0) {
                this.myOriginal.treeExpanded(event);
            }
        }

        @Override
        public void treeCollapsed(TreeExpansionEvent event) {
            if (DefaultTreeUI.this.bulkOperationsInProgress.get() == 0) {
                this.myOriginal.treeCollapsed(event);
            }
        }
    }
}

