/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.ui;

import com.intellij.openapi.diagnostic.Logger;
import java.awt.EventQueue;

final class DispatchThreadValidator {
    private static final Logger LOG = Logger.getInstance(DispatchThreadValidator.class);
    private volatile Thread background = DispatchThreadValidator.getBackgroundThread();

    DispatchThreadValidator() {
    }

    private static Thread getBackgroundThread() {
        return EventQueue.isDispatchThread() ? null : Thread.currentThread();
    }

    public boolean isValidThread() {
        Thread thread2 = DispatchThreadValidator.getBackgroundThread();
        if (thread2 == null) {
            this.background = null;
            return true;
        }
        if (thread2 == this.background) {
            return true;
        }
        LOG.debug((Throwable)new IllegalStateException("unexpected thread: " + String.valueOf(thread2)));
        return false;
    }
}

