/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ui.tree.ui;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.ui.tree.ChildrenProvider;
import com.intellij.ui.tree.LeafState;
import com.intellij.util.concurrency.EdtExecutorService;
import com.intellij.util.concurrency.Invoker;
import com.intellij.util.concurrency.InvokerSupplier;
import java.awt.EventQueue;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.function.Function;
import java.util.function.IntFunction;
import javax.swing.tree.TreeModel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.AsyncPromise;
import org.jetbrains.concurrency.CancellablePromise;
import org.jetbrains.concurrency.Obsolescent;

final class ModelAccessor {
    private static final Logger LOG = Logger.getInstance(ModelAccessor.class);
    private final TreeModel model;
    private final Invoker invoker;

    ModelAccessor(@NotNull TreeModel model2) {
        if (model2 == null) {
            ModelAccessor.$$$reportNull$$$0(0);
        }
        this.model = model2;
        if (model2 instanceof InvokerSupplier) {
            InvokerSupplier supplier = (InvokerSupplier)model2;
            this.invoker = supplier.getInvoker();
        } else {
            this.invoker = null;
        }
    }

    public boolean isActualModel(@Nullable TreeModel model2) {
        return this.model == model2;
    }

    @NotNull
    public CancellablePromise<NodeContent> promiseRootContent() {
        return this.compute(obsolescent -> this.getRootContent((Obsolescent)obsolescent));
    }

    @NotNull
    public CancellablePromise<NodeStructure> promiseNodeStructure(@NotNull Object node) {
        if (node == null) {
            ModelAccessor.$$$reportNull$$$0(1);
        }
        return this.compute(obsolescent -> this.getNodeStructure((Obsolescent)obsolescent, node));
    }

    @NotNull
    private <T> CancellablePromise<T> compute(@NotNull Function<? super Obsolescent, ? extends T> function) {
        if (function == null) {
            ModelAccessor.$$$reportNull$$$0(2);
        }
        AsyncPromise promise = new AsyncPromise();
        if (this.invoker != null) {
            this.invoker.compute(() -> function.apply(() -> ((AsyncPromise)promise).isDone())).onError(arg_0 -> ((AsyncPromise)promise).setError(arg_0)).onSuccess(result2 -> EventQueue.invokeLater(() -> {
                if (!promise.isDone()) {
                    promise.setResult(result2);
                }
            }));
        } else if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(() -> ModelAccessor.computeOnEDT(function, promise));
        } else {
            ModelAccessor.computeOnEDT(function, promise);
        }
        AsyncPromise asyncPromise = promise;
        if (asyncPromise == null) {
            ModelAccessor.$$$reportNull$$$0(3);
        }
        return asyncPromise;
    }

    private static <T> void computeOnEDT(@NotNull Function<? super Obsolescent, ? extends T> function, @NotNull AsyncPromise<T> promise) {
        T result2;
        if (function == null) {
            ModelAccessor.$$$reportNull$$$0(4);
        }
        if (promise == null) {
            ModelAccessor.$$$reportNull$$$0(5);
        }
        assert (EventQueue.isDispatchThread());
        try {
            result2 = function.apply((Obsolescent)((Obsolescent)() -> promise.isDone()));
        }
        catch (ProcessCanceledException | IndexNotReadyException exception) {
            EdtExecutorService.getScheduledExecutorInstance().schedule(() -> ModelAccessor.computeOnEDT(function, promise), 10L, TimeUnit.MILLISECONDS);
            return;
        }
        catch (Throwable error2) {
            promise.setError(error2);
            return;
        }
        promise.setResult(result2);
    }

    @Nullable
    private NodeContent getRootContent(@NotNull Obsolescent obsolescent) {
        if (obsolescent == null) {
            ModelAccessor.$$$reportNull$$$0(6);
        }
        assert (this.invoker == null ? EventQueue.isDispatchThread() : this.invoker.isValidThread());
        if (obsolescent.isObsolete()) {
            return null;
        }
        Object root = this.model.getRoot();
        if (root == null || obsolescent.isObsolete()) {
            return null;
        }
        return new NodeContent(root, LeafState.get((Object)root, (TreeModel)this.model));
    }

    @Nullable
    private NodeStructure getNodeStructure(@NotNull Obsolescent obsolescent, @NotNull Object node) {
        if (obsolescent == null) {
            ModelAccessor.$$$reportNull$$$0(7);
        }
        if (node == null) {
            ModelAccessor.$$$reportNull$$$0(8);
        }
        assert (this.invoker == null ? EventQueue.isDispatchThread() : this.invoker.isValidThread());
        if (obsolescent.isObsolete()) {
            return null;
        }
        LeafState state2 = LeafState.get((Object)node, (TreeModel)this.model);
        if (obsolescent.isObsolete()) {
            return null;
        }
        List<NodeContent> list2 = Collections.emptyList();
        if (state2 != LeafState.ALWAYS) {
            TreeModel treeModel = this.model;
            if (treeModel instanceof ChildrenProvider) {
                ChildrenProvider provider = (ChildrenProvider)((Object)treeModel);
                List children2 = provider.getChildren(node);
                if (children2 == null) {
                    throw new ProcessCanceledException();
                }
                list2 = this.getChildren(obsolescent, children2.size(), children2::get);
            } else {
                list2 = this.getChildren(obsolescent, this.model.getChildCount(node), index -> this.model.getChild(node, index));
            }
        }
        if (state2 == LeafState.ASYNC) {
            state2 = list2.isEmpty() ? LeafState.ALWAYS : LeafState.NEVER;
        }
        return new NodeStructure(new NodeContent(node, state2), list2);
    }

    @NotNull
    private List<NodeContent> getChildren(@NotNull Obsolescent obsolescent, int count, @NotNull IntFunction<?> function) {
        if (obsolescent == null) {
            ModelAccessor.$$$reportNull$$$0(9);
        }
        if (function == null) {
            ModelAccessor.$$$reportNull$$$0(10);
        }
        if (count < 0) {
            LOG.warn("illegal child count: " + count);
        }
        if (count <= 0) {
            List<NodeContent> list2 = Collections.emptyList();
            if (list2 == null) {
                ModelAccessor.$$$reportNull$$$0(11);
            }
            return list2;
        }
        ArrayList<NodeContent> list3 = new ArrayList<NodeContent>(count);
        for (int index = 0; index < count; ++index) {
            ProgressManager.checkCanceled();
            if (obsolescent.isObsolete()) {
                List<NodeContent> list4 = Collections.emptyList();
                if (list4 == null) {
                    ModelAccessor.$$$reportNull$$$0(12);
                }
                return list4;
            }
            Object node = function.apply(index);
            if (node == null) {
                LOG.warn("ignore null child at " + index);
                continue;
            }
            if (list3.stream().anyMatch(content2 -> content2.hasUserNode(node))) {
                LOG.warn("ignore duplicated child at " + index + ": " + String.valueOf(node));
                continue;
            }
            if (obsolescent.isObsolete()) {
                List<NodeContent> list5 = Collections.emptyList();
                if (list5 == null) {
                    ModelAccessor.$$$reportNull$$$0(13);
                }
                return list5;
            }
            list3.add(new NodeContent(node, LeafState.get(node, (TreeModel)this.model)));
        }
        ArrayList<NodeContent> arrayList = list3;
        if (arrayList == null) {
            ModelAccessor.$$$reportNull$$$0(14);
        }
        return arrayList;
    }

    public String toString() {
        return this.model.toString();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 11, 12, 13, 14 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "model";
                break;
            }
            case 1: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 2: 
            case 4: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "function";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ui/tree/ui/ModelAccessor";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "promise";
                break;
            }
            case 6: 
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "obsolescent";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ui/tree/ui/ModelAccessor";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "compute";
                break;
            }
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "promiseNodeStructure";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "compute";
                break;
            }
            case 3: 
            case 11: 
            case 12: 
            case 13: 
            case 14: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "computeOnEDT";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "getRootContent";
                break;
            }
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getNodeStructure";
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "getChildren";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 11, 12, 13, 14 -> new IllegalStateException(string);
        };
    }

    static final class NodeContent {
        private final int hashCode;
        private final Object userNode;
        private final LeafState leafState;

        private NodeContent(@NotNull Object node, @NotNull LeafState state2) {
            if (node == null) {
                NodeContent.$$$reportNull$$$0(0);
            }
            if (state2 == null) {
                NodeContent.$$$reportNull$$$0(1);
            }
            assert (state2 != LeafState.DEFAULT) : "resolved state required";
            this.hashCode = node.hashCode();
            this.userNode = node;
            this.leafState = state2;
        }

        @NotNull
        public Object getUserNode() {
            Object object = this.userNode;
            if (object == null) {
                NodeContent.$$$reportNull$$$0(2);
            }
            return object;
        }

        @NotNull
        public LeafState getLeafState() {
            LeafState leafState = this.leafState;
            if (leafState == null) {
                NodeContent.$$$reportNull$$$0(3);
            }
            return leafState;
        }

        boolean hasUserNodeFrom(@NotNull NodeContent content2) {
            if (content2 == null) {
                NodeContent.$$$reportNull$$$0(4);
            }
            return this.hasUserNode(content2.userNode, content2.hashCode);
        }

        boolean hasUserNode(@NotNull Object node) {
            if (node == null) {
                NodeContent.$$$reportNull$$$0(5);
            }
            return this.hasUserNode(node, node.hashCode());
        }

        boolean hasUserNode(@NotNull Object node, int hash) {
            if (node == null) {
                NodeContent.$$$reportNull$$$0(6);
            }
            return this.hashCode == hash && (this.userNode == node || this.userNode.equals(node));
        }

        public boolean equals(Object object) {
            return object == this || object instanceof NodeContent && this.hasUserNodeFrom((NodeContent)object);
        }

        public int hashCode() {
            return this.hashCode;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "node";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "state";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/ui/ModelAccessor$NodeContent";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/ui/ModelAccessor$NodeContent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUserNode";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getLeafState";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "hasUserNodeFrom";
                    break;
                }
                case 5: 
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "hasUserNode";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }

    static final class NodeStructure {
        private final NodeContent content;
        private final List<NodeContent> children;

        private NodeStructure(@NotNull NodeContent content2, @NotNull List<NodeContent> children2) {
            if (content2 == null) {
                NodeStructure.$$$reportNull$$$0(0);
            }
            if (children2 == null) {
                NodeStructure.$$$reportNull$$$0(1);
            }
            this.content = content2;
            this.children = children2;
        }

        @NotNull
        public NodeContent getContent() {
            NodeContent nodeContent = this.content;
            if (nodeContent == null) {
                NodeStructure.$$$reportNull$$$0(2);
            }
            return nodeContent;
        }

        @NotNull
        public List<NodeContent> getChildren() {
            List<NodeContent> list2 = this.children;
            if (list2 == null) {
                NodeStructure.$$$reportNull$$$0(3);
            }
            return list2;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "content";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "children";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ui/tree/ui/ModelAccessor$NodeStructure";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ui/tree/ui/ModelAccessor$NodeStructure";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getContent";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getChildren";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

