/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util;

import com.intellij.codeInsight.daemon.GutterMark;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.ex.EditorGutterComponentEx;
import com.intellij.openapi.editor.ex.util.EditorUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.popup.JBPopupFactory;
import com.intellij.openapi.wm.WindowManager;
import com.intellij.ui.awt.RelativePoint;
import com.intellij.ui.popup.PopupFactoryImpl;
import com.intellij.util.PopupUtilsKt;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.JRootPane;
import javax.swing.JTable;
import javax.swing.JTree;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.comparisons.ComparisonsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a\u000e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u000e\u0010\u0004\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\u0005\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0006\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0007\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a+\u0010\b\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0017\u0010\t\u001a\u0013\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\f0\n\u00a2\u0006\u0002\b\rH\u0002\u001a\u0012\u0010\u000e\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0002\u001a\u0012\u0010\u0012\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0013\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a\u0010\u0010\u0015\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a$\u0010\u0016\u001a\u0004\u0018\u0001H\u0017\"\n\b\u0000\u0010\u0017\u0018\u0001*\u00020\u00182\u0006\u0010\u0002\u001a\u00020\u0003H\u0082\b\u00a2\u0006\u0002\u0010\u0019\u001a\f\u0010\u001a\u001a\u00020\f*\u00020\u000bH\u0002\u001a\f\u0010\u001b\u001a\u00020\f*\u00020\u000bH\u0002\u001a\f\u0010\u001c\u001a\u00020\f*\u00020\u000bH\u0002\u001a\f\u0010\u001d\u001a\u00020\f*\u00020\u000bH\u0002\u00a8\u0006\u001e"}, d2={"getBestPopupPosition", "Lcom/intellij/ui/awt/RelativePoint;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "getBestBalloonPosition", "getBestPopupPositionInsideGutter", "getBestPopupPositionInsideComponent", "getBestBalloonPositionInsideGutter", "getBestPositionInsideGutter", "location", "Lkotlin/Function1;", "Ljava/awt/Rectangle;", "Ljava/awt/Point;", "Lkotlin/ExtensionFunctionType;", "getBestBalloonPositionInsideEditor", "getCaretVisualPosition", "Lcom/intellij/openapi/editor/VisualPosition;", "Lcom/intellij/openapi/editor/Editor;", "getBestBalloonPositionInsideList", "getBestBalloonPositionInsideTree", "getBestBalloonPositionInsideTable", "getBestBalloonPositionInsideComponent", "getFocusComponent", "C", "Ljavax/swing/JComponent;", "(Lcom/intellij/openapi/actionSystem/DataContext;)Ljavax/swing/JComponent;", "topCenter", "bottomCenter", "center", "position", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nPopupUtils.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PopupUtils.kt\ncom/intellij/util/PopupUtilsKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,153:1\n138#1,4:154\n142#1,3:159\n138#1,4:162\n142#1,3:167\n138#1,4:170\n142#1,3:175\n138#1,4:179\n142#1,3:184\n138#1,4:187\n142#1,3:192\n1#2:158\n1#2:166\n1#2:174\n1#2:183\n1#2:191\n1#2:195\n6608#3:178\n*S KotlinDebug\n*F\n+ 1 PopupUtils.kt\ncom/intellij/util/PopupUtilsKt\n*L\n55#1:154,4\n55#1:159,3\n89#1:162,4\n89#1:167,3\n105#1:170,4\n105#1:175,3\n123#1:179,4\n123#1:184,3\n133#1:187,4\n133#1:192,3\n55#1:158\n89#1:166\n105#1:174\n123#1:183\n133#1:191\n115#1:178\n*E\n"})
public final class PopupUtilsKt {
    @NotNull
    public static final RelativePoint getBestPopupPosition(@NotNull DataContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        RelativePoint relativePoint = PopupUtilsKt.getBestPopupPositionInsideGutter(context2);
        if (relativePoint == null) {
            relativePoint = PopupUtilsKt.getBestPopupPositionInsideComponent(context2);
        }
        return relativePoint;
    }

    @NotNull
    public static final RelativePoint getBestBalloonPosition(@NotNull DataContext context2) {
        Intrinsics.checkNotNullParameter((Object)context2, (String)"context");
        RelativePoint relativePoint = PopupUtilsKt.getBestBalloonPositionInsideGutter(context2);
        if (relativePoint == null && (relativePoint = PopupUtilsKt.getBestBalloonPositionInsideEditor(context2)) == null && (relativePoint = PopupUtilsKt.getBestBalloonPositionInsideList(context2)) == null && (relativePoint = PopupUtilsKt.getBestBalloonPositionInsideTree(context2)) == null && (relativePoint = PopupUtilsKt.getBestBalloonPositionInsideTable(context2)) == null) {
            relativePoint = PopupUtilsKt.getBestBalloonPositionInsideComponent(context2);
        }
        return relativePoint;
    }

    private static final RelativePoint getBestPopupPositionInsideGutter(DataContext context2) {
        return PopupUtilsKt.getBestPositionInsideGutter(context2, (Function1<? super Rectangle, ? extends Point>)((Function1)getBestPopupPositionInsideGutter.1.INSTANCE));
    }

    private static final RelativePoint getBestPopupPositionInsideComponent(DataContext context2) {
        RelativePoint relativePoint = JBPopupFactory.getInstance().guessBestPopupLocation(context2);
        Intrinsics.checkNotNullExpressionValue((Object)relativePoint, (String)"guessBestPopupLocation(...)");
        return relativePoint;
    }

    private static final RelativePoint getBestBalloonPositionInsideGutter(DataContext context2) {
        return PopupUtilsKt.getBestPositionInsideGutter(context2, (Function1<? super Rectangle, ? extends Point>)((Function1)getBestBalloonPositionInsideGutter.1.INSTANCE));
    }

    private static final RelativePoint getBestPositionInsideGutter(DataContext context2, Function1<? super Rectangle, ? extends Point> location) {
        JComponent jComponent;
        DataContext context$iv = context2;
        boolean $i$f$getFocusComponent = false;
        Component component$iv = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(context$iv);
        if (component$iv instanceof EditorGutterComponentEx) {
            jComponent = (JComponent)component$iv;
        } else {
            JFrame frame$iv;
            JFrame jFrame;
            Project project$iv;
            Project project2 = project$iv = (Project)CommonDataKeys.PROJECT.getData(context$iv);
            if (project2 != null) {
                Project it$iv = project2;
                boolean bl = false;
                jFrame = WindowManager.getInstance().getFrame(it$iv);
            } else {
                jFrame = null;
            }
            JFrame jFrame2 = frame$iv = jFrame;
            JRootPane focusOwner$iv = jFrame2 != null ? jFrame2.getRootPane() : null;
            jComponent = focusOwner$iv instanceof EditorGutterComponentEx ? (JComponent)focusOwner$iv : null;
        }
        EditorGutterComponentEx editorGutterComponentEx = (EditorGutterComponentEx)jComponent;
        if (editorGutterComponentEx == null) {
            return null;
        }
        EditorGutterComponentEx component2 = editorGutterComponentEx;
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(context2);
        if (editor2 == null) {
            return null;
        }
        Editor editor3 = editor2;
        Integer n = (Integer)context2.getData(EditorGutterComponentEx.LOGICAL_LINE_AT_CURSOR);
        if (n == null) {
            return null;
        }
        int logicalLine = n;
        Point point = (Point)context2.getData(EditorGutterComponentEx.ICON_CENTER_POSITION);
        if (point == null) {
            return null;
        }
        Point iconCenterPosition = point;
        GutterMark gutterMark = component2.getGutterRenderer(iconCenterPosition);
        if (gutterMark == null) {
            return null;
        }
        GutterMark renderer2 = gutterMark;
        Rectangle visibleArea = component2.getVisibleRect();
        int x = iconCenterPosition.x - renderer2.getIcon().getIconWidth() / 2;
        Point point2 = editor3.logicalPositionToXY(new LogicalPosition(logicalLine, 0));
        Intrinsics.checkNotNullExpressionValue((Object)point2, (String)"logicalPositionToXY(...)");
        Point linePoint = point2;
        Rectangle rect = new Rectangle(x, linePoint.y, renderer2.getIcon().getIconWidth(), editor3.getLineHeight());
        if (!visibleArea.contains(rect)) {
            component2.scrollRectToVisible(rect);
        }
        return new RelativePoint((Component)component2, (Point)location.invoke((Object)rect));
    }

    private static final RelativePoint getBestBalloonPositionInsideEditor(DataContext context2) {
        Component component2 = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(context2);
        Editor editor2 = (Editor)CommonDataKeys.EDITOR.getData(context2);
        if (editor2 == null) {
            return null;
        }
        Editor editor3 = editor2;
        JComponent jComponent = editor3.getContentComponent();
        Intrinsics.checkNotNullExpressionValue((Object)jComponent, (String)"getContentComponent(...)");
        JComponent contentComponent = jComponent;
        if (contentComponent != component2) {
            return null;
        }
        VisualPosition caretVisualPosition = PopupUtilsKt.getCaretVisualPosition(editor3);
        Point point = editor3.visualPositionToXY(caretVisualPosition);
        Intrinsics.checkNotNullExpressionValue((Object)point, (String)"visualPositionToXY(...)");
        Point caretPosition = point;
        Rectangle rectangle = editor3.getScrollingModel().getVisibleArea();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleArea(...)");
        Rectangle visibleArea = rectangle;
        Rectangle rect = new Rectangle(caretPosition, new Dimension(EditorUtil.getDefaultCaretWidth(), editor3.getLineHeight()));
        if (!visibleArea.contains(rect)) {
            ((JComponent)component2).scrollRectToVisible(rect);
        }
        return new RelativePoint((Component)contentComponent, caretPosition);
    }

    private static final VisualPosition getCaretVisualPosition(Editor $this$getCaretVisualPosition) {
        VisualPosition anchorPosition = (VisualPosition)$this$getCaretVisualPosition.getUserData(PopupFactoryImpl.ANCHOR_POPUP_POSITION);
        if (anchorPosition != null) {
            return anchorPosition;
        }
        if ($this$getCaretVisualPosition.getCaretModel().isUpToDate()) {
            VisualPosition visualPosition = $this$getCaretVisualPosition.getCaretModel().getVisualPosition();
            Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"getVisualPosition(...)");
            return visualPosition;
        }
        VisualPosition visualPosition = $this$getCaretVisualPosition.offsetToVisualPosition($this$getCaretVisualPosition.getCaretModel().getOffset());
        Intrinsics.checkNotNullExpressionValue((Object)visualPosition, (String)"offsetToVisualPosition(...)");
        return visualPosition;
    }

    private static final RelativePoint getBestBalloonPositionInsideList(DataContext context2) {
        JComponent jComponent;
        DataContext context$iv = context2;
        boolean $i$f$getFocusComponent = false;
        Component component$iv = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(context$iv);
        if (component$iv instanceof JList) {
            jComponent = (JComponent)component$iv;
        } else {
            JFrame frame$iv;
            JFrame jFrame;
            Project project$iv;
            Project project2 = project$iv = (Project)CommonDataKeys.PROJECT.getData(context$iv);
            if (project2 != null) {
                Project it$iv = project2;
                boolean bl = false;
                jFrame = WindowManager.getInstance().getFrame(it$iv);
            } else {
                jFrame = null;
            }
            JFrame jFrame2 = frame$iv = jFrame;
            JRootPane focusOwner$iv = jFrame2 != null ? jFrame2.getRootPane() : null;
            jComponent = focusOwner$iv instanceof JList ? (JComponent)focusOwner$iv : null;
        }
        JList jList = (JList)jComponent;
        if (jList == null) {
            return null;
        }
        JList component2 = jList;
        Rectangle visibleRect = component2.getVisibleRect();
        int firstVisibleIndex = component2.getFirstVisibleIndex();
        int lastVisibleIndex = component2.getLastVisibleIndex();
        int[] selectedIndices = component2.getSelectedIndices();
        Intrinsics.checkNotNull((Object)selectedIndices);
        for (int index : selectedIndices) {
            boolean bl = firstVisibleIndex <= index ? index <= lastVisibleIndex : false;
            if (!bl) continue;
            Rectangle cellBounds = component2.getCellBounds(index, index);
            Point position2 = new Point(visibleRect.x + visibleRect.width / 4, cellBounds.y);
            return new RelativePoint((Component)component2, position2);
        }
        return null;
    }

    private static final RelativePoint getBestBalloonPositionInsideTree(DataContext context2) {
        JComponent jComponent;
        DataContext context$iv = context2;
        boolean $i$f$getFocusComponent22 = false;
        Component component$iv = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(context$iv);
        if (component$iv instanceof JTree) {
            jComponent = (JComponent)component$iv;
        } else {
            JFrame frame$iv;
            JFrame jFrame;
            Project project$iv;
            Project project2 = project$iv = (Project)CommonDataKeys.PROJECT.getData(context$iv);
            if (project2 != null) {
                Project it$iv = project2;
                boolean bl = false;
                jFrame = WindowManager.getInstance().getFrame(it$iv);
            } else {
                jFrame = null;
            }
            JFrame jFrame2 = frame$iv = jFrame;
            JRootPane focusOwner$iv = jFrame2 != null ? jFrame2.getRootPane() : null;
            jComponent = focusOwner$iv instanceof JTree ? (JComponent)focusOwner$iv : null;
        }
        JTree jTree = (JTree)jComponent;
        if (jTree == null) {
            return null;
        }
        JTree component2 = jTree;
        Rectangle visibleRect = component2.getVisibleRect();
        int[] nArray = component2.getSelectionRows();
        if (nArray == null) {
            return null;
        }
        int[] selectionRows = nArray;
        Iterator $i$f$getFocusComponent22 = ArraysKt.sorted((int[])selectionRows).iterator();
        while ($i$f$getFocusComponent22.hasNext()) {
            int row2 = ((Number)$i$f$getFocusComponent22.next()).intValue();
            Rectangle rowBounds = component2.getRowBounds(row2);
            if (!visibleRect.contains(rowBounds)) continue;
            Component component3 = component2;
            Intrinsics.checkNotNull((Object)rowBounds);
            return new RelativePoint(component3, PopupUtilsKt.topCenter(rowBounds));
        }
        Intrinsics.checkNotNull((Object)visibleRect);
        Point visibleCenter = PopupUtilsKt.center(visibleRect);
        Function1 distance = arg_0 -> PopupUtilsKt.getBestBalloonPositionInsideTree$lambda$0(visibleCenter, component2, arg_0);
        int[] $this$sortedBy$iv = selectionRows;
        boolean $i$f$sortedBy = false;
        Integer n = (Integer)CollectionsKt.firstOrNull((List)ArraysKt.sortedWith((int[])$this$sortedBy$iv, (Comparator)new Comparator(distance){
            final /* synthetic */ Function1 $selector;
            {
                this.$selector = $selector;
            }

            public final int compare(T a, T b) {
                Function1 function1 = this.$selector;
                return ComparisonsKt.compareValues((Comparable)((Comparable)function1.invoke(a)), (Comparable)((Comparable)function1.invoke(b)));
            }
        }));
        if (n == null) {
            return null;
        }
        int nearestRow = n;
        Rectangle rowBounds = component2.getRowBounds(nearestRow);
        int n2 = visibleRect.width;
        int n3 = rowBounds.width;
        Dimension dimension = new Dimension(Math.min(n2, n3), rowBounds.height);
        Intrinsics.checkNotNull((Object)rowBounds);
        component2.scrollRectToVisible(new Rectangle(PopupUtilsKt.position(rowBounds), dimension));
        return new RelativePoint((Component)component2, PopupUtilsKt.topCenter(rowBounds));
    }

    private static final RelativePoint getBestBalloonPositionInsideTable(DataContext context2) {
        JComponent jComponent;
        DataContext context$iv = context2;
        boolean $i$f$getFocusComponent = false;
        Component component$iv = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(context$iv);
        if (component$iv instanceof JTable) {
            jComponent = (JComponent)component$iv;
        } else {
            JFrame frame$iv;
            JFrame jFrame;
            Project project$iv;
            Project project2 = project$iv = (Project)CommonDataKeys.PROJECT.getData(context$iv);
            if (project2 != null) {
                Project it$iv = project2;
                boolean bl = false;
                jFrame = WindowManager.getInstance().getFrame(it$iv);
            } else {
                jFrame = null;
            }
            JFrame jFrame2 = frame$iv = jFrame;
            JRootPane focusOwner$iv = jFrame2 != null ? jFrame2.getRootPane() : null;
            jComponent = focusOwner$iv instanceof JTable ? (JComponent)focusOwner$iv : null;
        }
        JTable jTable = (JTable)jComponent;
        if (jTable == null) {
            return null;
        }
        JTable component2 = jTable;
        Rectangle visibleRect = component2.getVisibleRect();
        int column = component2.getColumnModel().getSelectionModel().getLeadSelectionIndex();
        int row2 = Math.max(component2.getSelectionModel().getLeadSelectionIndex(), component2.getSelectionModel().getAnchorSelectionIndex());
        Rectangle rect = component2.getCellRect(row2, column, false);
        if (!visibleRect.intersects(rect)) {
            component2.scrollRectToVisible(rect);
        }
        Component component3 = component2;
        Intrinsics.checkNotNull((Object)rect);
        return new RelativePoint(component3, PopupUtilsKt.position(rect));
    }

    private static final RelativePoint getBestBalloonPositionInsideComponent(DataContext context2) {
        JComponent jComponent;
        DataContext context$iv = context2;
        boolean $i$f$getFocusComponent = false;
        Component component$iv = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(context$iv);
        if (component$iv instanceof JComponent) {
            jComponent = (JComponent)component$iv;
        } else {
            JFrame frame$iv;
            JFrame jFrame;
            Project project$iv;
            Project project2 = project$iv = (Project)CommonDataKeys.PROJECT.getData(context$iv);
            if (project2 != null) {
                Project it$iv = project2;
                boolean bl = false;
                jFrame = WindowManager.getInstance().getFrame(it$iv);
            } else {
                jFrame = null;
            }
            JFrame jFrame2 = frame$iv = jFrame;
            JRootPane focusOwner$iv = jFrame2 != null ? jFrame2.getRootPane() : null;
            jComponent = focusOwner$iv instanceof JComponent ? (JComponent)focusOwner$iv : null;
        }
        Intrinsics.checkNotNull((Object)jComponent);
        JComponent component2 = jComponent;
        Component component3 = component2;
        Rectangle rectangle = component2.getVisibleRect();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getVisibleRect(...)");
        return new RelativePoint(component3, PopupUtilsKt.center(rectangle));
    }

    private static final /* synthetic */ <C extends JComponent> C getFocusComponent(DataContext context2) {
        JFrame frame;
        JFrame jFrame;
        Project project2;
        boolean $i$f$getFocusComponent = false;
        Component component2 = (Component)PlatformCoreDataKeys.CONTEXT_COMPONENT.getData(context2);
        Intrinsics.reifiedOperationMarker((int)3, (String)"C");
        if (component2 instanceof JComponent) {
            return (C)((JComponent)component2);
        }
        Project project3 = project2 = (Project)CommonDataKeys.PROJECT.getData(context2);
        if (project3 != null) {
            Project it = project3;
            boolean bl = false;
            jFrame = WindowManager.getInstance().getFrame(it);
        } else {
            jFrame = null;
        }
        JFrame jFrame2 = frame = jFrame;
        JRootPane focusOwner = jFrame2 != null ? jFrame2.getRootPane() : null;
        Intrinsics.reifiedOperationMarker((int)3, (String)"C");
        if (focusOwner instanceof JComponent) {
            return (C)focusOwner;
        }
        return null;
    }

    private static final Point topCenter(Rectangle $this$topCenter) {
        return new Point((int)$this$topCenter.getCenterX(), $this$topCenter.y);
    }

    private static final Point bottomCenter(Rectangle $this$bottomCenter) {
        return new Point((int)$this$bottomCenter.getCenterX(), $this$bottomCenter.y + $this$bottomCenter.height);
    }

    private static final Point center(Rectangle $this$center) {
        return new Point((int)$this$center.getCenterX(), (int)$this$center.getCenterY());
    }

    private static final Point position(Rectangle $this$position) {
        return new Point($this$position.x, $this$position.y);
    }

    private static final double getBestBalloonPositionInsideTree$lambda$0(Point $visibleCenter, JTree $component, int it) {
        Rectangle rectangle = $component.getRowBounds(it);
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getRowBounds(...)");
        return $visibleCenter.distance(PopupUtilsKt.center(rectangle));
    }

    public static final /* synthetic */ Point access$bottomCenter(Rectangle $receiver) {
        return PopupUtilsKt.bottomCenter($receiver);
    }

    public static final /* synthetic */ Point access$topCenter(Rectangle $receiver) {
        return PopupUtilsKt.topCenter($receiver);
    }
}

