/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.util.ui.table;

import com.intellij.configurationStore.XmlSerializer;
import com.intellij.ide.IdeBundle;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.ui.AnActionButton;
import com.intellij.ui.AnActionButtonRunnable;
import com.intellij.ui.AnActionButtonUpdater;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.TableUtil;
import com.intellij.ui.ToolbarDecorator;
import com.intellij.ui.table.JBTable;
import com.intellij.ui.table.TableView;
import com.intellij.util.Function;
import com.intellij.util.FunctionUtil;
import com.intellij.util.PlatformIcons;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.CollectionItemEditor;
import com.intellij.util.ui.CollectionModelEditor;
import com.intellij.util.ui.ColumnInfo;
import com.intellij.util.ui.ElementProducer;
import com.intellij.util.ui.ItemRemovable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.ListTableModel;
import com.intellij.util.ui.table.ComboBoxTableCellEditor;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import javax.swing.table.TableModel;
import org.jdom.Element;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class TableModelEditor<T>
extends CollectionModelEditor<T, CollectionItemEditor<T>> {
    private final TableView<T> table;
    private final ToolbarDecorator toolbarDecorator;
    private final MyListTableModel model;

    public TableModelEditor(ColumnInfo @NotNull [] columns, @NotNull CollectionItemEditor<T> itemEditor2, @NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String emptyText) {
        if (itemEditor2 == null) {
            TableModelEditor.$$$reportNull$$$0(0);
        }
        if (emptyText == null) {
            TableModelEditor.$$$reportNull$$$0(1);
        }
        if (columns == null) {
            TableModelEditor.$$$reportNull$$$0(2);
        }
        this(Collections.emptyList(), columns, itemEditor2, emptyText);
    }

    public TableModelEditor(@NotNull List<T> items2, ColumnInfo @NotNull [] columns, @NotNull CollectionItemEditor<T> itemEditor2, @NotNull @Nls(capitalization=Nls.Capitalization.Sentence) String emptyText) {
        if (items2 == null) {
            TableModelEditor.$$$reportNull$$$0(3);
        }
        if (itemEditor2 == null) {
            TableModelEditor.$$$reportNull$$$0(4);
        }
        if (emptyText == null) {
            TableModelEditor.$$$reportNull$$$0(5);
        }
        if (columns == null) {
            TableModelEditor.$$$reportNull$$$0(6);
        }
        super(itemEditor2);
        this.model = new MyListTableModel(columns, new ArrayList<T>(items2));
        this.table = new TableView((ListTableModel)this.model);
        this.table.setShowGrid(false);
        this.table.setDefaultEditor(Enum.class, (TableCellEditor)ComboBoxTableCellEditor.INSTANCE);
        this.table.setEnableAntialiasing(true);
        this.table.setPreferredScrollableViewportSize((Dimension)JBUI.size((int)200, (int)-1));
        this.table.setVisibleRowCount(7);
        TableSpeedSearch.installOn(this.table);
        ColumnInfo firstColumn = columns[0];
        if ((firstColumn.getColumnClass() == Boolean.TYPE || firstColumn.getColumnClass() == Boolean.class) && firstColumn.getName().isEmpty()) {
            TableUtil.setupCheckboxColumn((TableColumn)this.table.getColumnModel().getColumn(0), (int)0);
            JBTable.setupCheckboxShortcut(this.table, (int)0);
        }
        boolean needTableHeader = false;
        for (ColumnInfo column : columns) {
            if (StringUtil.isEmpty((String)column.getName())) continue;
            needTableHeader = true;
            break;
        }
        if (!needTableHeader) {
            this.table.setTableHeader(null);
        }
        this.table.getEmptyText().setText(emptyText);
        MyRemoveAction removeAction = new MyRemoveAction();
        this.toolbarDecorator = ToolbarDecorator.createDecorator(this.table, (ElementProducer)this).setRemoveAction((AnActionButtonRunnable)removeAction).setRemoveActionUpdater((AnActionButtonUpdater)removeAction);
        if (itemEditor2 instanceof DialogItemEditor) {
            this.addDialogActions();
        }
    }

    private void addDialogActions() {
        this.toolbarDecorator.setEditAction(button2 -> {
            Object item = this.table.getSelectedObject();
            if (item != null) {
                Function mutator;
                if (this.helper.isMutable(item)) {
                    mutator = FunctionUtil.id();
                } else {
                    int selectedRow = this.table.getSelectedRow();
                    mutator = item12 -> this.helper.getMutable(item12, selectedRow);
                }
                ((DialogItemEditor)this.itemEditor).edit(item, mutator, false);
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(this.table, true));
            }
        }).setEditActionUpdater(e -> {
            Object item = this.table.getSelectedObject();
            return item != null && ((DialogItemEditor)this.itemEditor).isEditable(item);
        });
        if (((DialogItemEditor)this.itemEditor).isUseDialogToAdd()) {
            this.toolbarDecorator.setAddAction(button2 -> {
                Object item = this.createElement();
                ((DialogItemEditor)this.itemEditor).edit(item, item1 -> {
                    this.model.addRow(item1);
                    return item1;
                }, true);
            });
        }
    }

    @NotNull
    public TableModelEditor<T> disableUpDownActions() {
        this.toolbarDecorator.disableUpDownActions();
        TableModelEditor tableModelEditor = this;
        if (tableModelEditor == null) {
            TableModelEditor.$$$reportNull$$$0(7);
        }
        return tableModelEditor;
    }

    public void setShowGrid(boolean v) {
        this.table.setShowGrid(v);
    }

    @NotNull
    public TableModelEditor<T> enabled(boolean value) {
        this.table.setEnabled(value);
        TableModelEditor tableModelEditor = this;
        if (tableModelEditor == null) {
            TableModelEditor.$$$reportNull$$$0(8);
        }
        return tableModelEditor;
    }

    public TableModelEditor<T> modelListener(@NotNull DataChangedListener<T> listener2) {
        if (listener2 == null) {
            TableModelEditor.$$$reportNull$$$0(9);
        }
        this.model.dataChangedListener = listener2;
        this.model.addTableModelListener(listener2);
        return this;
    }

    @NotNull
    public ListTableModel<T> getModel() {
        MyListTableModel myListTableModel = this.model;
        if (myListTableModel == null) {
            TableModelEditor.$$$reportNull$$$0(10);
        }
        return myListTableModel;
    }

    public static <T> void cloneUsingXmlSerialization(@NotNull T oldItem, @NotNull T newItem) {
        Element serialized;
        if (oldItem == null) {
            TableModelEditor.$$$reportNull$$$0(11);
        }
        if (newItem == null) {
            TableModelEditor.$$$reportNull$$$0(12);
        }
        if ((serialized = XmlSerializer.serialize(oldItem)) != null) {
            com.intellij.util.xmlb.XmlSerializer.deserializeInto(newItem, (Element)serialized);
        }
    }

    @NotNull
    public JComponent createComponent() {
        JPanel jPanel = this.toolbarDecorator.addExtraAction((AnAction)new DumbAwareAction(IdeBundle.message((String)"button.copy", (Object[])new Object[0]), null, PlatformIcons.COPY_ICON){

            public void actionPerformed(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(0);
                }
                TableUtil.stopEditing(TableModelEditor.this.table);
                List selectedItems = TableModelEditor.this.table.getSelectedObjects();
                if (selectedItems.isEmpty()) {
                    return;
                }
                for (Object item : selectedItems) {
                    TableModelEditor.this.model.addRow(TableModelEditor.this.itemEditor.clone(item, false));
                }
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(TableModelEditor.this.table, true));
                TableUtil.updateScroller(TableModelEditor.this.table);
            }

            public void update(@NotNull AnActionEvent e) {
                if (e == null) {
                    1.$$$reportNull$$$0(1);
                }
                e.getPresentation().setEnabled(!TableModelEditor.this.table.getSelectedObjects().isEmpty());
            }

            @NotNull
            public ActionUpdateThread getActionUpdateThread() {
                ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
                if (actionUpdateThread == null) {
                    1.$$$reportNull$$$0(2);
                }
                return actionUpdateThread;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 3;
                    case 2 -> 2;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "e";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/util/ui/table/TableModelEditor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/util/ui/table/TableModelEditor$1";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getActionUpdateThread";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray;
                        objectArray[2] = "actionPerformed";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "update";
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalArgumentException(string);
                    case 2 -> new IllegalStateException(string);
                };
            }
        }).createPanel();
        if (jPanel == null) {
            TableModelEditor.$$$reportNull$$$0(13);
        }
        return jPanel;
    }

    @Override
    @NotNull
    protected List<T> getItems() {
        List list2 = this.model.items;
        if (list2 == null) {
            TableModelEditor.$$$reportNull$$$0(14);
        }
        return list2;
    }

    public void selectItem(@NotNull T item) {
        Ref ref2;
        if (item == null) {
            TableModelEditor.$$$reportNull$$$0(15);
        }
        this.table.clearSelection();
        if (this.helper.hasModifiedItems()) {
            ref2 = Ref.create();
            this.helper.process((modified, original) -> {
                if (item == original) {
                    ref2.set(modified);
                }
                return ref2.isNull();
            });
        } else {
            ref2 = null;
        }
        this.table.addSelection(ref2 == null || ref2.isNull() ? item : ref2.get());
    }

    @NotNull
    public List<T> apply() {
        if (this.helper.hasModifiedItems()) {
            ColumnInfo[] columns = this.model.getColumnInfos();
            this.helper.process((newItem, oldItem) -> {
                for (ColumnInfo column : columns) {
                    if (!column.isCellEditable(newItem)) continue;
                    column.setValue(oldItem, column.valueOf(newItem));
                }
                if (this.itemEditor instanceof DialogItemEditor) {
                    ((DialogItemEditor)this.itemEditor).applyEdited(oldItem, newItem);
                }
                this.model.items.set(ContainerUtil.indexOfIdentity(this.model.items, (Object)newItem), oldItem);
                return true;
            });
        }
        this.helper.reset(this.model.items);
        List list2 = this.model.items;
        if (list2 == null) {
            TableModelEditor.$$$reportNull$$$0(16);
        }
        return list2;
    }

    @Override
    public void reset(@NotNull List<? extends T> items2) {
        if (items2 == null) {
            TableModelEditor.$$$reportNull$$$0(17);
        }
        super.reset(items2);
        this.model.setItems(new ArrayList<T>(items2));
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 7, 8, 10, 13, 14, 16 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "itemEditor";
                break;
            }
            case 1: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "emptyText";
                break;
            }
            case 2: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "columns";
                break;
            }
            case 3: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "items";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/util/ui/table/TableModelEditor";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "oldItem";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newItem";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "item";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/util/ui/table/TableModelEditor";
                break;
            }
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "disableUpDownActions";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "enabled";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getModel";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "createComponent";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getItems";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "apply";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 7: 
            case 8: 
            case 10: 
            case 13: 
            case 14: 
            case 16: {
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "modelListener";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "cloneUsingXmlSerialization";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "selectItem";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "reset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 7, 8, 10, 13, 14, 16 -> new IllegalStateException(string);
        };
    }

    private final class MyListTableModel
    extends ListTableModel<T> {
        private List<T> items;
        private DataChangedListener<T> dataChangedListener;

        MyListTableModel(@NotNull ColumnInfo[] columns, List<T> items2) {
            if (items2 == null) {
                MyListTableModel.$$$reportNull$$$0(0);
            }
            if (columns == null) {
                MyListTableModel.$$$reportNull$$$0(1);
            }
            super(columns, items2);
            this.items = items2;
        }

        public void setItems(@NotNull List<T> items2) {
            if (items2 == null) {
                MyListTableModel.$$$reportNull$$$0(2);
            }
            this.items = items2;
            super.setItems(items2);
        }

        public void removeRow(int index) {
            TableModelEditor.this.helper.remove(this.getItem(index));
            super.removeRow(index);
        }

        public void setValueAt(Object newValue, int rowIndex, int columnIndex) {
            if (rowIndex < this.getRowCount()) {
                ColumnInfo column = this.getColumnInfos()[columnIndex];
                Object item = this.getItem(rowIndex);
                Object oldValue = column.valueOf(item);
                if (column.getColumnClass() == String.class ? !Comparing.strEqual((String)((String)oldValue), (String)((String)newValue)) : !Comparing.equal((Object)oldValue, (Object)newValue)) {
                    column.setValue(TableModelEditor.this.helper.getMutable(item, rowIndex), newValue);
                    if (this.dataChangedListener != null) {
                        this.dataChangedListener.dataChanged(column, rowIndex);
                    }
                }
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "items";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "columns";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/ui/table/TableModelEditor$MyListTableModel";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "setItems";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class MyRemoveAction
    implements AnActionButtonRunnable,
    AnActionButtonUpdater,
    TableUtil.ItemChecker {
        private MyRemoveAction() {
        }

        public void run(AnActionButton button2) {
            if (TableUtil.doRemoveSelectedItems(TableModelEditor.this.table, (ItemRemovable)TableModelEditor.this.model, (TableUtil.ItemChecker)this)) {
                IdeFocusManager.getGlobalInstance().doWhenFocusSettlesDown(() -> IdeFocusManager.getGlobalInstance().requestFocus(TableModelEditor.this.table, true));
                TableUtil.updateScroller(TableModelEditor.this.table);
            }
        }

        public boolean isOperationApplyable(@NotNull TableModel ignored, int row2) {
            Object item;
            if (ignored == null) {
                MyRemoveAction.$$$reportNull$$$0(0);
            }
            return (item = TableModelEditor.this.model.getItem(row2)) != null && TableModelEditor.this.itemEditor.isRemovable(item);
        }

        public boolean isEnabled(@NotNull AnActionEvent e) {
            if (e == null) {
                MyRemoveAction.$$$reportNull$$$0(1);
            }
            return TableModelEditor.this.areSelectedItemsRemovable(TableModelEditor.this.table.getSelectionModel());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "ignored";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/util/ui/table/TableModelEditor$MyRemoveAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isOperationApplyable";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isEnabled";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    public static interface DialogItemEditor<T>
    extends CollectionItemEditor<T> {
        public void edit(@NotNull T var1, @NotNull Function<? super T, ? extends T> var2, boolean var3);

        public void applyEdited(@NotNull T var1, @NotNull T var2);

        default public boolean isEditable(@NotNull T item) {
            if (item == null) {
                DialogItemEditor.$$$reportNull$$$0(0);
            }
            return true;
        }

        default public boolean isUseDialogToAdd() {
            return false;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "item", "com/intellij/util/ui/table/TableModelEditor$DialogItemEditor", "isEditable"));
        }
    }

    public static abstract class DataChangedListener<T>
    implements TableModelListener {
        public abstract void dataChanged(@NotNull ColumnInfo<T, ?> var1, int var2);

        @Override
        public void tableChanged(@NotNull TableModelEvent e) {
            if (e == null) {
                DataChangedListener.$$$reportNull$$$0(0);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/util/ui/table/TableModelEditor$DataChangedListener", "tableChanged"));
        }
    }

    public static abstract class EditableColumnInfo<Item, Aspect>
    extends ColumnInfo<Item, Aspect> {
        public EditableColumnInfo(@NlsContexts.ColumnName @NotNull String name2) {
            if (name2 == null) {
                EditableColumnInfo.$$$reportNull$$$0(0);
            }
            super(name2);
        }

        public EditableColumnInfo() {
            super("");
        }

        public boolean isCellEditable(Item item) {
            return true;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "name", "com/intellij/util/ui/table/TableModelEditor$EditableColumnInfo", "<init>"));
        }
    }
}

