/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.xml.breadcrumbs;

import com.intellij.application.options.colors.ColorAndFontOptions;
import com.intellij.ide.DataManager;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationBundle;
import com.intellij.openapi.editor.ex.EditorSettingsExternalizable;
import com.intellij.openapi.options.colors.pages.GeneralColorsPage;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowLayout;
import com.intellij.ui.dsl.builder.RowsRange;
import com.intellij.ui.dsl.builder.TopGap;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.xml.breadcrumbs.BreadcrumbsConfigurable;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001B\u0015\u0012\f\u0010\u0002\u001a\b\u0012\u0004\u0012\u00020\u00040\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0007\u001a\u00020\bX\u0082.\u00a2\u0006\u0002\n\u0000R\u001a\u0010\t\u001a\u00020\nX\u0086.\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000e\u00a8\u0006\u000f"}, d2={"Lcom/intellij/xml/breadcrumbs/BreadcrumbsConfigurableUI;", "", "configurables", "", "Lcom/intellij/xml/breadcrumbs/BreadcrumbsConfigurable$BreadcrumbsProviderConfigurable;", "<init>", "(Ljava/util/List;)V", "show", "Ljavax/swing/JCheckBox;", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "getPanel", "()Lcom/intellij/openapi/ui/DialogPanel;", "setPanel", "(Lcom/intellij/openapi/ui/DialogPanel;)V", "intellij.platform.ide.impl"})
@SourceDebugExtension(value={"SMAP\nBreadcrumbsConfigurableUI.kt\nKotlin\n*S Kotlin\n*F\n+ 1 BreadcrumbsConfigurableUI.kt\ncom/intellij/xml/breadcrumbs/BreadcrumbsConfigurableUI\n+ 2 ButtonsGroup.kt\ncom/intellij/ui/dsl/builder/ButtonsGroupKt\n*L\n1#1,79:1\n27#2:80\n*S KotlinDebug\n*F\n+ 1 BreadcrumbsConfigurableUI.kt\ncom/intellij/xml/breadcrumbs/BreadcrumbsConfigurableUI\n*L\n46#1:80\n*E\n"})
public final class BreadcrumbsConfigurableUI {
    private JCheckBox show;
    public DialogPanel panel;

    public BreadcrumbsConfigurableUI(@NotNull List<BreadcrumbsConfigurable.BreadcrumbsProviderConfigurable> configurables2) {
        Intrinsics.checkNotNullParameter(configurables2, (String)"configurables");
        this.setPanel(BuilderKt.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> BreadcrumbsConfigurableUI._init_$lambda$0(configurables2, this, arg_0))));
    }

    @NotNull
    public final DialogPanel getPanel() {
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel != null) {
            return dialogPanel;
        }
        Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
        return null;
    }

    public final void setPanel(@NotNull DialogPanel dialogPanel) {
        Intrinsics.checkNotNullParameter((Object)dialogPanel, (String)"<set-?>");
        this.panel = dialogPanel;
    }

    private static final Unit _init_$lambda$0(List $configurables, BreadcrumbsConfigurableUI this$0, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        EditorSettingsExternalizable settings = EditorSettingsExternalizable.getInstance();
        Map map2 = new LinkedHashMap();
        for (BreadcrumbsConfigurable.BreadcrumbsProviderConfigurable configurable : $configurables) {
            String id2;
            Intrinsics.checkNotNullExpressionValue((Object)configurable.getId(), (String)"getId(...)");
            if (map2.containsKey(id2)) continue;
            map2.put(id2, configurable.createComponent());
        }
        List sortedList = CollectionsKt.sortedWith((Iterable)MapsKt.toList((Map)map2), BreadcrumbsConfigurableUI::lambda$0$0);
        Panel.row$default($this$panel, null, arg_0 -> BreadcrumbsConfigurableUI.lambda$0$1(this$0, settings, arg_0), 1, null);
        RowsRange rowsRange = $this$panel.indent((Function1<? super Panel, Unit>)((Function1)arg_0 -> BreadcrumbsConfigurableUI.lambda$0$2(settings, sortedList, arg_0)));
        JCheckBox jCheckBox = this$0.show;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"show");
            jCheckBox = null;
        }
        rowsRange.enabledIf(ComponentPredicateKt.getSelected((AbstractButton)jCheckBox));
        Panel.row$default($this$panel, null, arg_0 -> BreadcrumbsConfigurableUI.lambda$0$3(this$0, arg_0), 1, null).topGap(TopGap.SMALL);
        return Unit.INSTANCE;
    }

    private static final int lambda$0$0(Pair o1, Pair o2) {
        return StringUtil.naturalCompare((String)((JCheckBox)o1.getSecond()).getText(), (String)((JCheckBox)o2.getSecond()).getText());
    }

    private static final Unit lambda$0$1(BreadcrumbsConfigurableUI this$0, EditorSettingsExternalizable $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = ApplicationBundle.message((String)"checkbox.show.breadcrumbs", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        Cell<JBCheckBox> cell = $this$row.checkBox(string);
        Intrinsics.checkNotNull((Object)$settings);
        this$0.show = (JCheckBox)ButtonKt.bindSelected(cell, (Function0<Boolean>)((Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((EditorSettingsExternalizable)this.receiver).isBreadcrumbsShown();
            }
        }), (Function1<? super Boolean, Unit>)((Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((EditorSettingsExternalizable)this.receiver).setBreadcrumbsShown(p0);
            }
        })).getComponent();
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit lambda$0$2(EditorSettingsExternalizable $settings, List $sortedList, Panel $this$indent) {
        void getter$iv;
        void $this$bind$iv;
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        ButtonsGroup buttonsGroup = Panel.buttonsGroup$default($this$indent, null, false, BreadcrumbsConfigurableUI::lambda$0$2$0, 3, null);
        Intrinsics.checkNotNull((Object)$settings);
        Function0 function0 = (Function0)new Function0<Boolean>((Object)$settings){

            public final Boolean invoke() {
                return ((EditorSettingsExternalizable)this.receiver).isBreadcrumbsAbove();
            }
        };
        Function1 setter$iv = (Function1)new Function1<Boolean, Unit>((Object)$settings){

            public final void invoke(boolean p0) {
                ((EditorSettingsExternalizable)this.receiver).setBreadcrumbsAbove(p0);
            }
        };
        boolean $i$f$bind = false;
        $this$bind$iv.bind(MutablePropertyKt.MutableProperty((Function0)getter$iv, (Function1)setter$iv), Boolean.class);
        if (!((Collection)$sortedList).isEmpty()) {
            Panel.row$default($this$indent, null, BreadcrumbsConfigurableUI::lambda$0$2$1, 1, null);
            $this$indent.panel((Function1<? super Panel, Unit>)((Function1)arg_0 -> BreadcrumbsConfigurableUI.lambda$0$2$2($sortedList, $settings, arg_0)));
        }
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$2$0(Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        String string = ApplicationBundle.message((String)"label.breadcrumbs.placement", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$buttonsGroup.row(string, (Function1<? super Row, Unit>)((Function1)BreadcrumbsConfigurableUI::lambda$0$2$0$0));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$2$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = ApplicationBundle.message((String)"radio.show.breadcrumbs.above", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.radioButton(string, true);
        String string2 = ApplicationBundle.message((String)"radio.show.breadcrumbs.below", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"message(...)");
        $this$row.radioButton(string2, false);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$2$1(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = ApplicationBundle.message((String)"label.breadcrumbs.languages", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.label(string);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$2$2(List $sortedList, EditorSettingsExternalizable $settings, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        int rowCount = ($sortedList.size() + 2) / 3;
        int i2 = 0;
        int n = rowCount - 1;
        if (i2 <= n) {
            while (true) {
                Panel.row$default($this$panel, null, arg_0 -> BreadcrumbsConfigurableUI.lambda$0$2$2$0($sortedList, i2, rowCount, $settings, arg_0), 1, null).layout(RowLayout.PARENT_GRID);
                if (i2 == n) break;
                ++i2;
            }
        }
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$2$2$0(List $sortedList, int $i, int $rowCount, EditorSettingsExternalizable $settings, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        for (int j = 0; j < 3; ++j) {
            Pair pair;
            if ((Pair)CollectionsKt.getOrNull((List)$sortedList, (int)($i + $rowCount * j)) == null) continue;
            boolean bl = false;
            String id2 = (String)pair.component1();
            JCheckBox checkBox = (JCheckBox)pair.component2();
            ButtonKt.bindSelected($this$row.cell((JComponent)checkBox), (Function0<Boolean>)((Function0)() -> BreadcrumbsConfigurableUI.lambda$0$2$2$0$0$0($settings, id2)), (Function1<? super Boolean, Unit>)((Function1)arg_0 -> BreadcrumbsConfigurableUI.lambda$0$2$2$0$0$1($settings, id2, arg_0))).gap(RightGap.COLUMNS);
        }
        return Unit.INSTANCE;
    }

    private static final boolean lambda$0$2$2$0$0$0(EditorSettingsExternalizable $settings, String $id) {
        return $settings.isBreadcrumbsShownFor($id);
    }

    private static final Unit lambda$0$2$2$0$0$1(EditorSettingsExternalizable $settings, String $id, boolean it) {
        $settings.setBreadcrumbsShownFor($id, it);
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$3(BreadcrumbsConfigurableUI this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        String string = ApplicationBundle.message((String)"configure.breadcrumbs.colors", (Object[])new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        $this$row.link(string, (Function1<? super ActionEvent, Unit>)((Function1)arg_0 -> BreadcrumbsConfigurableUI.lambda$0$3$0(this$0, arg_0)));
        return Unit.INSTANCE;
    }

    private static final Unit lambda$0$3$0(BreadcrumbsConfigurableUI this$0, ActionEvent it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        DataContext dataContext2 = DataManager.getInstance().getDataContext((Component)this$0.getPanel());
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"getDataContext(...)");
        DataContext context2 = dataContext2;
        ColorAndFontOptions.selectOrEditColor(context2, "Breadcrumbs//Current", GeneralColorsPage.class);
        return Unit.INSTANCE;
    }
}

