/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufUtil;
import io.netty.util.CharsetUtil;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.CharacterCodingException;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CoderResult;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000(\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a\u001c\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\b\b\u0002\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006\u001a \u0010\u0007\u001a\u00020\u00012\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0006H\u0002\u001a\u0016\u0010\r\u001a\u00020\u00012\u0006\u0010\u000e\u001a\u00020\u00042\u0006\u0010\u000f\u001a\u00020\u0002\u00a8\u0006\u0010"}, d2={"readIntoCharBuffer", "", "Lio/netty/buffer/ByteBuf;", "byteCount", "", "charBuffer", "Ljava/nio/CharBuffer;", "decodeString", "decoder", "Ljava/nio/charset/CharsetDecoder;", "src", "Ljava/nio/ByteBuffer;", "dst", "writeIntAsAscii", "value", "buffer", "intellij.platform.ide.util.netty"})
public final class BufferToCharsKt {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final void readIntoCharBuffer(@NotNull ByteBuf $this$readIntoCharBuffer, int byteCount, @NotNull CharBuffer charBuffer) {
        Intrinsics.checkNotNullParameter((Object)$this$readIntoCharBuffer, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)charBuffer, (String)"charBuffer");
        CharsetDecoder decoder = CharsetUtil.decoder((Charset)Charsets.UTF_8);
        if ($this$readIntoCharBuffer.nioBufferCount() == 1) {
            Intrinsics.checkNotNull((Object)decoder);
            ByteBuffer byteBuffer = $this$readIntoCharBuffer.internalNioBuffer($this$readIntoCharBuffer.readerIndex(), byteCount);
            Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"internalNioBuffer(...)");
            BufferToCharsKt.decodeString(decoder, byteBuffer, charBuffer);
        } else {
            ByteBuf buffer2 = $this$readIntoCharBuffer.alloc().heapBuffer(byteCount);
            try {
                buffer2.writeBytes($this$readIntoCharBuffer, $this$readIntoCharBuffer.readerIndex(), byteCount);
                Intrinsics.checkNotNull((Object)decoder);
                ByteBuffer byteBuffer = buffer2.internalNioBuffer(0, byteCount);
                Intrinsics.checkNotNullExpressionValue((Object)byteBuffer, (String)"internalNioBuffer(...)");
                BufferToCharsKt.decodeString(decoder, byteBuffer, charBuffer);
            }
            finally {
                buffer2.release();
            }
        }
    }

    public static /* synthetic */ void readIntoCharBuffer$default(ByteBuf byteBuf, int n, CharBuffer charBuffer, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = byteBuf.readableBytes();
        }
        BufferToCharsKt.readIntoCharBuffer(byteBuf, n, charBuffer);
    }

    private static final void decodeString(CharsetDecoder decoder, ByteBuffer src, CharBuffer dst) {
        try {
            CoderResult cr = decoder.decode(src, dst, true);
            if (!cr.isUnderflow()) {
                cr.throwException();
            }
            if (!(cr = decoder.flush(dst)).isUnderflow()) {
                cr.throwException();
            }
        }
        catch (CharacterCodingException x) {
            throw new IllegalStateException(x);
        }
    }

    public static final void writeIntAsAscii(int value, @NotNull ByteBuf buffer2) {
        Intrinsics.checkNotNullParameter((Object)buffer2, (String)"buffer");
        ByteBufUtil.writeAscii((ByteBuf)buffer2, (CharSequence)new StringBuilder().append(value));
    }
}

