/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.io;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.containers.CollectionFactory;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelFutureListener;
import io.netty.handler.codec.http.LastHttpContent;
import io.netty.util.concurrent.GenericFutureListener;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.io.ByteRange;
import org.jetbrains.io.FileResponses;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000>\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010%\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010$\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\u001a\u0016\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u0005\u001a\u001c\u0010\u0012\u001a\u0004\u0018\u00010\u00132\b\u0010\u0014\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0015\u001a\u00020\u0016H\u0002\"c\u0010\u0006\u001aJ\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b \t*#\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b\u0012\f\u0012\n \t*\u0004\u0018\u00010\b0\b0\u000b\u00a2\u0006\u0002\b\n0\u0007\u00a2\u0006\u0002\b\n8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000e\u0010\u000f\u001a\u0004\b\f\u0010\r\"\u0016\u0010\u0010\u001a\n \t*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0017"}, d2={"flushChunkedResponse", "", "channel", "Lio/netty/channel/Channel;", "isKeepAlive", "", "fileExtToMimeType", "", "", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "", "getFileExtToMimeType", "()Ljava/util/Map;", "fileExtToMimeType$delegate", "Lkotlin/Lazy;", "RANGE_HEADER", "Ljava/util/regex/Pattern;", "parseRange", "Lorg/jetbrains/io/ByteRange;", "header", "size", "", "intellij.platform.ide.util.netty"})
@SourceDebugExtension(value={"SMAP\nFileResponses.kt\nKotlin\n*S Kotlin\n*F\n+ 1 FileResponses.kt\norg/jetbrains/io/FileResponsesKt\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,206:1\n13#2:207\n13#2:208\n13#2:209\n57#3:210\n1#4:211\n*S KotlinDebug\n*F\n+ 1 FileResponses.kt\norg/jetbrains/io/FileResponsesKt\n*L\n178#1:207\n197#1:208\n201#1:209\n33#1:210\n33#1:211\n*E\n"})
public final class FileResponsesKt {
    @NotNull
    private static final Lazy fileExtToMimeType$delegate = LazyKt.lazy(FileResponsesKt::fileExtToMimeType_delegate$lambda$0);
    private static final Pattern RANGE_HEADER = Pattern.compile("bytes=(\\d+)?-(\\d+)?");

    public static final void flushChunkedResponse(@NotNull Channel channel, boolean isKeepAlive) {
        Intrinsics.checkNotNullParameter((Object)channel, (String)"channel");
        ChannelFuture future = channel.writeAndFlush((Object)LastHttpContent.EMPTY_LAST_CONTENT);
        if (!isKeepAlive) {
            future.addListener((GenericFutureListener)ChannelFutureListener.CLOSE);
        }
    }

    private static final Map<String, String> getFileExtToMimeType() {
        Lazy lazy = fileExtToMimeType$delegate;
        return (Map)lazy.getValue();
    }

    private static final ByteRange parseRange(String header, long size2) {
        ByteRange byteRange;
        CharSequence charSequence = header;
        if (charSequence == null || charSequence.length() == 0) {
            return null;
        }
        Matcher m = RANGE_HEADER.matcher(header);
        if (!m.matches()) {
            boolean $i$f$logger = false;
            Logger logger2 = Logger.getInstance(FileResponses.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger2, (String)"getInstance(...)");
            logger2.error("Range header is invalid: " + header);
            return null;
        }
        CharSequence $i$f$logger = m.group(1);
        if ($i$f$logger == null || $i$f$logger.length() == 0) {
            String string = m.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
            return new ByteRange(size2 - Long.parseLong(string), size2);
        }
        String string = m.group(1);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"group(...)");
        long start2 = Long.parseLong(string);
        long end = 0L;
        CharSequence charSequence2 = m.group(2);
        if (charSequence2 == null || charSequence2.length() == 0) {
            end = size2 - 1L;
        } else {
            String string2 = m.group(2);
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"group(...)");
            end = Long.parseLong(string2);
        }
        if (end < start2) {
            boolean $i$f$logger2 = false;
            Logger logger3 = Logger.getInstance(FileResponses.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger3, (String)"getInstance(...)");
            logger3.error("start (" + start2 + ") must be greater than end (" + end + ")");
            byteRange = null;
        } else if (end >= size2) {
            boolean $i$f$logger3 = false;
            Logger logger4 = Logger.getInstance(FileResponses.class);
            Intrinsics.checkNotNullExpressionValue((Object)logger4, (String)"getInstance(...)");
            logger4.error("end (" + end + ") must be lesser than size (" + size2 + ")");
            byteRange = null;
        } else {
            byteRange = new ByteRange(start2, end + 1L);
        }
        return byteRange;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Map fileExtToMimeType_delegate$lambda$0() {
        Map map2 = CollectionFactory.createSmallMemoryFootprintMap((int)1100);
        Intrinsics.checkNotNullExpressionValue((Object)map2, (String)"createSmallMemoryFootprintMap(...)");
        Map map3 = map2;
        InputStream inputStream = FileResponses.INSTANCE.getClass().getResourceAsStream("/mime-types.csv");
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"getResourceAsStream(...)");
        InputStream inputStream2 = inputStream;
        Charset charset = Charsets.UTF_8;
        Closeable closeable = new InputStreamReader(inputStream2, charset);
        int n = 8192;
        Reader $this$useLines$iv = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        boolean $i$f$useLines = false;
        closeable = $this$useLines$iv;
        n = 8192;
        closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
        Throwable throwable = null;
        try {
            BufferedReader it$iv = (BufferedReader)closeable;
            boolean bl = false;
            Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
            boolean bl2 = false;
            for (String line : it) {
                if (StringsKt.isBlank((CharSequence)line)) continue;
                int commaIndex = StringsKt.indexOf$default((CharSequence)line, (char)',', (int)0, (boolean)false, (int)6, null);
                String string = line.substring(0, commaIndex);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                String string2 = line.substring(commaIndex + 1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                map3.put(string, string2);
            }
            Unit unit = Unit.INSTANCE;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return map3;
    }

    public static final /* synthetic */ ByteRange access$parseRange(String header, long size2) {
        return FileResponsesKt.parseRange(header, size2);
    }

    public static final /* synthetic */ Map access$getFileExtToMimeType() {
        return FileResponsesKt.getFileExtToMimeType();
    }
}

