/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.debugger.impl.frontend;

import com.intellij.frontend.FrontendApplicationInfo;
import com.intellij.frontend.FrontendType;
import com.intellij.openapi.project.Project;
import com.intellij.platform.debugger.impl.frontend.FrontendXDebuggerManager;
import com.intellij.platform.debugger.impl.frontend.evaluate.quick.FrontendXValue;
import com.intellij.platform.debugger.impl.frontend.frame.FrontendXExecutionStack;
import com.intellij.platform.debugger.impl.rpc.XDebugSessionId;
import com.intellij.platform.debugger.impl.rpc.XExecutionStackId;
import com.intellij.platform.debugger.impl.rpc.XValueId;
import com.intellij.platform.debugger.impl.shared.XDebuggerWatchesManager;
import com.intellij.platform.debugger.impl.shared.proxy.XBreakpointManagerProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugManagerProxy;
import com.intellij.platform.debugger.impl.shared.proxy.XDebugSessionProxy;
import com.intellij.xdebugger.SplitDebuggerMode;
import com.intellij.xdebugger.frame.XExecutionStack;
import com.intellij.xdebugger.frame.XValue;
import com.intellij.xdebugger.impl.XDebugSessionImpl;
import com.intellij.xdebugger.impl.XDebuggerExecutionPointManagerImpl;
import com.intellij.xdebugger.impl.proxy.MonolithXDebugManagerProxyKt;
import com.intellij.xdebugger.impl.util.XDebugMonolithUtils;
import java.util.List;
import kotlin.Metadata;
import kotlin.coroutines.Continuation;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000n\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H\u0016J\u0010\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\bH\u0016JH\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u000b\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\r2\"\u0010\u000e\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u0010\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0013J\u0012\u0010\u0014\u001a\u0004\u0018\u00010\u00102\u0006\u0010\u000b\u001a\u00020\bH\u0016J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016JH\u0010\t\u001a\u0002H\n\"\u0004\b\u0000\u0010\n2\u0006\u0010\u0017\u001a\u00020\u00182\u0006\u0010\f\u001a\u00020\r2\"\u0010\u000e\u001a\u001e\b\u0001\u0012\u0004\u0012\u00020\u0016\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\n0\u0011\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u000fH\u0096@\u00a2\u0006\u0002\u0010\u0019J\u0012\u0010\u001a\u001a\u0004\u0018\u00010\r2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0018\u0010\u001d\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\r0\u001e2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0016\u0010\u001f\u001a\b\u0012\u0004\u0012\u00020\r0 2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010!\u001a\u00020\"2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010#\u001a\u00020$2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010%\u001a\u00020&2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016J\u0010\u0010'\u001a\u00020(2\u0006\u0010\u001b\u001a\u00020\u001cH\u0002\u00a8\u0006)"}, d2={"Lcom/intellij/platform/debugger/impl/frontend/FrontendXDebugManagerProxy;", "Lcom/intellij/platform/debugger/impl/shared/proxy/XDebugManagerProxy;", "<init>", "()V", "isEnabled", "", "hasBackendCounterpart", "xValue", "Lcom/intellij/xdebugger/frame/XValue;", "withId", "T", "value", "session", "Lcom/intellij/platform/debugger/impl/shared/proxy/XDebugSessionProxy;", "block", "Lkotlin/Function2;", "Lcom/intellij/platform/debugger/impl/rpc/XValueId;", "Lkotlin/coroutines/Continuation;", "", "(Lcom/intellij/xdebugger/frame/XValue;Lcom/intellij/platform/debugger/impl/shared/proxy/XDebugSessionProxy;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getXValueId", "getXExecutionStackId", "Lcom/intellij/platform/debugger/impl/rpc/XExecutionStackId;", "stack", "Lcom/intellij/xdebugger/frame/XExecutionStack;", "(Lcom/intellij/xdebugger/frame/XExecutionStack;Lcom/intellij/platform/debugger/impl/shared/proxy/XDebugSessionProxy;Lkotlin/jvm/functions/Function2;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "getCurrentSessionProxy", "project", "Lcom/intellij/openapi/project/Project;", "getCurrentSessionFlow", "Lkotlinx/coroutines/flow/Flow;", "getSessions", "", "getBreakpointManagerProxy", "Lcom/intellij/platform/debugger/impl/shared/proxy/XBreakpointManagerProxy;", "getDebuggerExecutionPointManager", "Lcom/intellij/xdebugger/impl/XDebuggerExecutionPointManagerImpl;", "getWatchesManager", "Lcom/intellij/platform/debugger/impl/shared/XDebuggerWatchesManager;", "getFrontendManager", "Lcom/intellij/platform/debugger/impl/frontend/FrontendXDebuggerManager;", "intellij.platform.debugger.impl.frontend"})
final class FrontendXDebugManagerProxy
implements XDebugManagerProxy {
    public boolean isEnabled() {
        FrontendType frontendType = FrontendApplicationInfo.INSTANCE.getFrontendType();
        return SplitDebuggerMode.isSplitDebugger() || frontendType instanceof FrontendType.Remote && ((FrontendType.Remote)frontendType).isGuest();
    }

    public boolean hasBackendCounterpart(@NotNull XValue xValue) {
        Intrinsics.checkNotNullParameter((Object)xValue, (String)"xValue");
        return FrontendXValue.Companion.asFrontendXValueOrNull(xValue) != null || FrontendApplicationInfo.INSTANCE.getFrontendType() instanceof FrontendType.Monolith;
    }

    @Nullable
    public <T> Object withId(@NotNull XValue value, @NotNull XDebugSessionProxy session, @NotNull Function2<? super XValueId, ? super Continuation<? super T>, ? extends Object> block, @NotNull Continuation<? super T> $completion) {
        FrontendXValue frontendXValue = FrontendXValue.Companion.asFrontendXValueOrNull(value);
        if (frontendXValue != null) {
            return block.invoke((Object)frontendXValue.getXValueDto().getId(), $completion);
        }
        XDebugSessionImpl xDebugSessionImpl = XDebugMonolithUtils.findSessionById((XDebugSessionId)session.getId());
        if (xDebugSessionImpl == null) {
            throw new IllegalStateException(("XValue is not a FrontendXValue: " + value).toString());
        }
        XDebugSessionImpl monolithSession = xDebugSessionImpl;
        return MonolithXDebugManagerProxyKt.withTemporaryXValueId((XValue)value, (XDebugSessionImpl)monolithSession, block, $completion);
    }

    @Nullable
    public XValueId getXValueId(@NotNull XValue value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        FrontendXValue frontendXValue = FrontendXValue.Companion.asFrontendXValueOrNull(value);
        return frontendXValue != null && (frontendXValue = frontendXValue.getXValueDto()) != null ? frontendXValue.getId() : null;
    }

    @Nullable
    public XExecutionStackId getXExecutionStackId(@NotNull XExecutionStack stack) {
        Intrinsics.checkNotNullParameter((Object)stack, (String)"stack");
        FrontendXExecutionStack frontendXExecutionStack = stack instanceof FrontendXExecutionStack ? (FrontendXExecutionStack)stack : null;
        return frontendXExecutionStack != null ? frontendXExecutionStack.getId() : null;
    }

    @Nullable
    public <T> Object withId(@NotNull XExecutionStack stack, @NotNull XDebugSessionProxy session, @NotNull Function2<? super XExecutionStackId, ? super Continuation<? super T>, ? extends Object> block, @NotNull Continuation<? super T> $completion) {
        Intrinsics.checkNotNull((Object)stack, (String)"null cannot be cast to non-null type com.intellij.platform.debugger.impl.frontend.frame.FrontendXExecutionStack");
        XExecutionStackId executionStackId = ((FrontendXExecutionStack)stack).getId();
        return block.invoke((Object)executionStackId, $completion);
    }

    @Nullable
    public XDebugSessionProxy getCurrentSessionProxy(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getFrontendManager(project).getCurrentSession();
    }

    @NotNull
    public Flow<XDebugSessionProxy> getCurrentSessionFlow(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return (Flow)this.getFrontendManager(project).getCurrentSessionFlow();
    }

    @NotNull
    public List<XDebugSessionProxy> getSessions(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getFrontendManager(project).getSessions$intellij_platform_debugger_impl_frontend();
    }

    @NotNull
    public XBreakpointManagerProxy getBreakpointManagerProxy(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return this.getFrontendManager(project).getBreakpointsManager();
    }

    @NotNull
    public XDebuggerExecutionPointManagerImpl getDebuggerExecutionPointManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        return XDebuggerExecutionPointManagerImpl.Companion.getInstance(project);
    }

    @NotNull
    public XDebuggerWatchesManager getWatchesManager(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        XDebuggerWatchesManager xDebuggerWatchesManager = this.getFrontendManager(project).getWatchesManager$intellij_platform_debugger_impl_frontend();
        Intrinsics.checkNotNullExpressionValue((Object)xDebuggerWatchesManager, (String)"<get-watchesManager>(...)");
        return xDebuggerWatchesManager;
    }

    private final FrontendXDebuggerManager getFrontendManager(Project project) {
        return FrontendXDebuggerManager.Companion.getInstance(project);
    }
}

