/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.ide.impl.wsl.ijent.nio;

import com.intellij.execution.ijent.nio.IjentNioPosixFileAttributesWithDosAdapterKt;
import com.intellij.execution.wsl.WSLDistribution;
import com.intellij.execution.wsl.WslDistributionManager;
import com.intellij.execution.wsl.WslPath;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.platform.core.nio.fs.RoutingAwareFileSystemProvider;
import com.intellij.platform.eel.provider.utils.EelPathUtils;
import com.intellij.platform.ide.impl.wsl.ijent.nio.IjentWslNioFileSystem;
import com.intellij.platform.ide.impl.wsl.ijent.nio.IjentWslNioFileSystemProvider;
import com.intellij.platform.ide.impl.wsl.ijent.nio.IjentWslNioPath;
import com.intellij.platform.ijent.community.impl.nio.IjentNioPath;
import com.intellij.util.io.Sanitize_nameKt;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.nio.channels.AsynchronousFileChannel;
import java.nio.channels.FileChannel;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.AccessMode;
import java.nio.file.CopyOption;
import java.nio.file.DirectoryStream;
import java.nio.file.FileStore;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemException;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.ProviderMismatchException;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.BasicFileAttributes;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.FileAttributeView;
import java.nio.file.spi.FileSystemProvider;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.atomic.AtomicReference;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u00e0\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010#\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\b\b\u0007\u0018\u0000 u2\u00020\u00012\u00020\u0002:\u0001uB$\u0012\u000b\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0001\u0012\u0006\u0010\u0007\u001a\u00020\u0001\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b\u0018J\b\u0010\u0019\u001a\u00020\u0004H\u0016J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0015\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u001c\u001a\u00020\u001dH\u0000\u00a2\u0006\u0002\b J\f\u0010!\u001a\u00020\u001f*\u00020\u001dH\u0002J\u001d\u0010\"\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010#\u001a\u00020\u0004H\u0000\u00a2\u0006\u0002\b$J\u0015\u0010\"\u001a\u00020\u001d*\u00020\u001d2\u0006\u0010#\u001a\u00020\u0004H\u0082\u0010J\r\u0010%\u001a\u00020\u001d*\u00020\u001dH\u0082\u0010J\b\u0010&\u001a\u00020\u0004H\u0016J$\u0010'\u001a\u00020\u00152\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u0003\u0018\u00010\u0014H\u0016J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u000fH\u0016J$\u0010'\u001a\u00020\u00152\u0006\u0010*\u001a\u00020\u000f2\u0012\u0010(\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0002\b\u0003\u0018\u00010\u0014H\u0016J\u0010\u0010)\u001a\u00020\u00152\u0006\u0010\u0003\u001a\u00020\u0004H\u0002J\u0012\u0010+\u001a\u0004\u0018\u00010\u00042\u0006\u0010\u001c\u001a\u00020\u001dH\u0002J)\u0010,\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\u0012\u0010-\u001a\n\u0012\u0006\b\u0001\u0012\u00020/0.\"\u00020/H\u0016\u00a2\u0006\u0002\u00100J-\u00101\u001a\u0002022\u0006\u0010\u001c\u001a\u00020\u001d2\u0016\u00103\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001040.\"\u0004\u0018\u000104H\u0016\u00a2\u0006\u0002\u00105J-\u00106\u001a\u0002072\u0006\u0010\u001c\u001a\u00020\u001d2\u0016\u00103\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u0001040.\"\u0004\u0018\u000104H\u0016\u00a2\u0006\u0002\u00108JG\u00109\u001a\u00020:2\u0006\u0010\u001c\u001a\u00020\u001d2\u0010\u00103\u001a\f\u0012\u0006\b\u0001\u0012\u000204\u0018\u00010;2\u001e\u0010<\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010=0.\"\b\u0012\u0002\b\u0003\u0018\u00010=H\u0016\u00a2\u0006\u0002\u0010>JQ\u0010?\u001a\u00020@2\u0006\u0010\u001c\u001a\u00020\u001d2\u0010\u00103\u001a\f\u0012\u0006\b\u0001\u0012\u000204\u0018\u00010;2\b\u0010A\u001a\u0004\u0018\u00010B2\u001e\u0010<\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010=0.\"\b\u0012\u0002\b\u0003\u0018\u00010=H\u0016\u00a2\u0006\u0002\u0010CJ=\u0010D\u001a\u00020\u00172\u0006\u0010E\u001a\u00020\u001d2\u0006\u0010F\u001a\u00020\u001d2\u001e\u0010<\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010=0.\"\b\u0012\u0002\b\u0003\u0018\u00010=H\u0016\u00a2\u0006\u0002\u0010GJ\u0018\u0010H\u001a\u00020\u00172\u0006\u0010E\u001a\u00020\u001d2\u0006\u0010I\u001a\u00020\u001dH\u0016J\u0010\u0010J\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010K\u001a\u00020L2\u0006\u0010E\u001a\u00020\u001dH\u0016J\u0010\u0010M\u001a\u00020\u001d2\u0006\u0010*\u001a\u00020\u000fH\u0016JG\u0010N\u001a\u00020O2\u0006\u0010\u001c\u001a\u00020\u001d2\u0010\u00103\u001a\f\u0012\u0006\b\u0001\u0012\u000204\u0018\u00010;2\u001e\u0010<\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010=0.\"\b\u0012\u0002\b\u0003\u0018\u00010=H\u0016\u00a2\u0006\u0002\u0010PJ(\u0010Q\u001a\b\u0012\u0004\u0012\u00020\u001d0R2\u0006\u0010S\u001a\u00020\u001d2\u0010\u0010T\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u001d\u0018\u00010UH\u0016J5\u0010V\u001a\u00020\u00172\u0006\u0010S\u001a\u00020\u001d2\u001e\u0010<\u001a\u0010\u0012\f\b\u0001\u0012\b\u0012\u0002\b\u0003\u0018\u00010=0.\"\b\u0012\u0002\b\u0003\u0018\u00010=H\u0016\u00a2\u0006\u0002\u0010WJ\u0010\u0010X\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J1\u0010Y\u001a\u00020\u00172\u0006\u0010Z\u001a\u00020\u001d2\u0006\u0010F\u001a\u00020\u001d2\u0012\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00020[0.\"\u00020[H\u0016\u00a2\u0006\u0002\u0010\\J1\u0010]\u001a\u00020\u00172\u0006\u0010Z\u001a\u00020\u001d2\u0006\u0010F\u001a\u00020\u001d2\u0012\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00020[0.\"\u00020[H\u0016\u00a2\u0006\u0002\u0010\\J\u0018\u0010^\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010_\u001a\u00020\u001dH\u0016J\u0010\u0010`\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u0010\u0010a\u001a\u00020b2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016JA\u0010c\u001a\u0002Hd\"\b\b\u0000\u0010d*\u00020e2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010f\u001a\b\u0012\u0004\u0012\u0002Hd0g2\u0012\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00020h0.\"\u00020hH\u0016\u00a2\u0006\u0002\u0010iJA\u0010j\u001a\u0002Hk\"\b\b\u0000\u0010k*\u00020l2\u0006\u0010\u001c\u001a\u00020\u001d2\f\u0010f\u001a\b\u0012\u0004\u0012\u0002Hk0g2\u0012\u00103\u001a\n\u0012\u0006\b\u0001\u0012\u00020h0.\"\u00020hH\u0016\u00a2\u0006\u0002\u0010mJC\u0010j\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020n0\u00142\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010o\u001a\u0004\u0018\u00010\u00042\u0016\u00103\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010h0.\"\u0004\u0018\u00010hH\u0016\u00a2\u0006\u0002\u0010pJA\u0010q\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001d2\b\u0010r\u001a\u0004\u0018\u00010\u00042\b\u0010s\u001a\u0004\u0018\u00010n2\u0016\u00103\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010h0.\"\u0004\u0018\u00010hH\u0016\u00a2\u0006\u0002\u0010tR\u0016\u0010\u0003\u001a\u00070\u0004\u00a2\u0006\u0002\b\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\u0006\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\u0001X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u000e\u001a\u00020\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0010\u001a\n \u0012*\u0004\u0018\u00010\u00110\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0013\u001a\u000e\u0012\u0004\u0012\u00020\u0004\u0012\u0004\u0012\u00020\u00150\u0014X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006v"}, d2={"Lcom/intellij/platform/ide/impl/wsl/ijent/nio/IjentWslNioFileSystemProvider;", "Ljava/nio/file/spi/FileSystemProvider;", "Lcom/intellij/platform/core/nio/fs/RoutingAwareFileSystemProvider;", "wslId", "", "Lcom/intellij/openapi/util/NlsSafe;", "ijentFsProvider", "originalFsProvider", "<init>", "(Ljava/lang/String;Ljava/nio/file/spi/FileSystemProvider;Ljava/nio/file/spi/FileSystemProvider;)V", "getWslId", "()Ljava/lang/String;", "getOriginalFsProvider$intellij_platform_ide_impl_wsl", "()Ljava/nio/file/spi/FileSystemProvider;", "ijentFsUri", "Ljava/net/URI;", "originalFs", "Ljava/nio/file/FileSystem;", "kotlin.jvm.PlatformType", "createdFileSystems", "", "Lcom/intellij/platform/ide/impl/wsl/ijent/nio/IjentWslNioFileSystem;", "removeFileSystem", "", "removeFileSystem$intellij_platform_ide_impl_wsl", "toString", "canHandleRouting", "", "path", "Ljava/nio/file/Path;", "toIjentNioPath", "Lcom/intellij/platform/ijent/community/impl/nio/IjentNioPath;", "toIjentNioPath$intellij_platform_ide_impl_wsl", "toIjentPath", "toOriginalPath", "notation", "toOriginalPath$intellij_platform_ide_impl_wsl", "toOriginalPathWithSameNotation", "getScheme", "newFileSystem", "env", "getFileSystem", "uri", "wslIdFromPath", "checkAccess", "modes", "", "Ljava/nio/file/AccessMode;", "(Ljava/nio/file/Path;[Ljava/nio/file/AccessMode;)V", "newInputStream", "Ljava/io/InputStream;", "options", "Ljava/nio/file/OpenOption;", "(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Ljava/io/InputStream;", "newOutputStream", "Ljava/io/OutputStream;", "(Ljava/nio/file/Path;[Ljava/nio/file/OpenOption;)Ljava/io/OutputStream;", "newFileChannel", "Ljava/nio/channels/FileChannel;", "", "attrs", "Ljava/nio/file/attribute/FileAttribute;", "(Ljava/nio/file/Path;Ljava/util/Set;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/channels/FileChannel;", "newAsynchronousFileChannel", "Ljava/nio/channels/AsynchronousFileChannel;", "executor", "Ljava/util/concurrent/ExecutorService;", "(Ljava/nio/file/Path;Ljava/util/Set;Ljava/util/concurrent/ExecutorService;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/channels/AsynchronousFileChannel;", "createSymbolicLink", "link", "target", "(Ljava/nio/file/Path;Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;)V", "createLink", "existing", "deleteIfExists", "readSymbolicLink", "Lcom/intellij/platform/ide/impl/wsl/ijent/nio/IjentWslNioPath;", "getPath", "newByteChannel", "Ljava/nio/channels/SeekableByteChannel;", "(Ljava/nio/file/Path;Ljava/util/Set;[Ljava/nio/file/attribute/FileAttribute;)Ljava/nio/channels/SeekableByteChannel;", "newDirectoryStream", "Ljava/nio/file/DirectoryStream;", "dir", "filter", "Ljava/nio/file/DirectoryStream$Filter;", "createDirectory", "(Ljava/nio/file/Path;[Ljava/nio/file/attribute/FileAttribute;)V", "delete", "copy", "source", "Ljava/nio/file/CopyOption;", "(Ljava/nio/file/Path;Ljava/nio/file/Path;[Ljava/nio/file/CopyOption;)V", "move", "isSameFile", "path2", "isHidden", "getFileStore", "Ljava/nio/file/FileStore;", "getFileAttributeView", "V", "Ljava/nio/file/attribute/FileAttributeView;", "type", "Ljava/lang/Class;", "Ljava/nio/file/LinkOption;", "(Ljava/nio/file/Path;Ljava/lang/Class;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/FileAttributeView;", "readAttributes", "A", "Ljava/nio/file/attribute/BasicFileAttributes;", "(Ljava/nio/file/Path;Ljava/lang/Class;[Ljava/nio/file/LinkOption;)Ljava/nio/file/attribute/BasicFileAttributes;", "", "attributes", "(Ljava/nio/file/Path;Ljava/lang/String;[Ljava/nio/file/LinkOption;)Ljava/util/Map;", "setAttribute", "attribute", "value", "(Ljava/nio/file/Path;Ljava/lang/String;Ljava/lang/Object;[Ljava/nio/file/LinkOption;)V", "Companion", "intellij.platform.ide.impl.wsl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nIjentWslNioFileSystemProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IjentWslNioFileSystemProvider.kt\ncom/intellij/platform/ide/impl/wsl/ijent/nio/IjentWslNioFileSystemProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,338:1\n1803#2,3:339\n1803#2,3:343\n669#2,11:346\n1563#2:357\n1634#2,3:358\n1563#2:361\n1634#2,3:362\n1563#2:365\n1634#2,3:366\n1#3:342\n13#4:369\n*S KotlinDebug\n*F\n+ 1 IjentWslNioFileSystemProvider.kt\ncom/intellij/platform/ide/impl/wsl/ijent/nio/IjentWslNioFileSystemProvider\n*L\n73#1:339,3\n87#1:343,3\n134#1:346,11\n332#1:357\n332#1:358,3\n327#1:361\n327#1:362,3\n328#1:365\n328#1:366,3\n336#1:369\n*E\n"})
public final class IjentWslNioFileSystemProvider
extends FileSystemProvider
implements RoutingAwareFileSystemProvider {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String wslId;
    @NotNull
    private final FileSystemProvider ijentFsProvider;
    @NotNull
    private final FileSystemProvider originalFsProvider;
    @NotNull
    private final URI ijentFsUri;
    private final FileSystem originalFs;
    @NotNull
    private final Map<String, IjentWslNioFileSystem> createdFileSystems;
    @NotNull
    private static final Lazy<AtomicReference<Set<String>>> allWslDistributionIds$delegate = LazyKt.lazy(IjentWslNioFileSystemProvider::allWslDistributionIds_delegate$lambda$0);
    @NotNull
    private static final Logger LOG;

    public IjentWslNioFileSystemProvider(@NotNull String wslId, @NotNull FileSystemProvider ijentFsProvider, @NotNull FileSystemProvider originalFsProvider) {
        Intrinsics.checkNotNullParameter((Object)wslId, (String)"wslId");
        Intrinsics.checkNotNullParameter((Object)ijentFsProvider, (String)"ijentFsProvider");
        Intrinsics.checkNotNullParameter((Object)originalFsProvider, (String)"originalFsProvider");
        this.wslId = wslId;
        this.ijentFsProvider = ijentFsProvider;
        this.originalFsProvider = originalFsProvider;
        this.ijentFsUri = new URI("ijent", "wsl", "/" + this.wslId, null, null);
        this.originalFs = this.originalFsProvider.getFileSystem(new URI("file:/"));
        this.createdFileSystems = new ConcurrentHashMap();
    }

    @NotNull
    public final String getWslId() {
        return this.wslId;
    }

    @NotNull
    public final FileSystemProvider getOriginalFsProvider$intellij_platform_ide_impl_wsl() {
        return this.originalFsProvider;
    }

    public final void removeFileSystem$intellij_platform_ide_impl_wsl(@NotNull String wslId) {
        Intrinsics.checkNotNullParameter((Object)wslId, (String)"wslId");
        this.createdFileSystems.remove(wslId);
    }

    @NotNull
    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.wslId + ")";
    }

    public boolean canHandleRouting(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return true;
    }

    @NotNull
    public final IjentNioPath toIjentNioPath$intellij_platform_ide_impl_wsl(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.toIjentPath(path);
    }

    /*
     * WARNING - void declaration
     */
    private final IjentNioPath toIjentPath(Path $this$toIjentPath) {
        IjentNioPath ijentNioPath;
        if ($this$toIjentPath instanceof IjentNioPath) {
            ijentNioPath = (IjentNioPath)$this$toIjentPath;
        } else if ($this$toIjentPath instanceof IjentWslNioPath) {
            ijentNioPath = this.toIjentPath(((IjentWslNioPath)$this$toIjentPath).getPresentablePath());
        } else if ($this$toIjentPath.isAbsolute()) {
            void $this$fold$iv;
            Iterable iterable = $this$toIjentPath;
            Path path = this.ijentFsProvider.getPath(this.ijentFsUri);
            Intrinsics.checkNotNull((Object)path, (String)"null cannot be cast to non-null type com.intellij.platform.ijent.community.impl.nio.IjentNioPath");
            IjentNioPath initial$iv = (IjentNioPath)path;
            boolean $i$f$fold = false;
            IjentNioPath accumulator$iv = initial$iv;
            for (Object element$iv : $this$fold$iv) {
                void newPart;
                Path path2 = (Path)element$iv;
                IjentNioPath nioPath = accumulator$iv;
                boolean bl = false;
                accumulator$iv = nioPath.resolve(newPart.toString());
            }
            ijentNioPath = accumulator$iv;
        } else {
            FileSystem ijentNioFs = this.ijentFsProvider.getFileSystem(this.ijentFsUri);
            String string = ((Object)$this$toIjentPath).toString();
            String string2 = ijentNioFs.getSeparator();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getSeparator(...)");
            Path path = ijentNioFs.getPath(StringsKt.replace$default((String)string, (String)"\\", (String)string2, (boolean)false, (int)4, null), new String[0]);
            Intrinsics.checkNotNull((Object)path, (String)"null cannot be cast to non-null type com.intellij.platform.ijent.community.impl.nio.IjentNioPath");
            ijentNioPath = (IjentNioPath)path;
        }
        return ijentNioPath;
    }

    @NotNull
    public final Path toOriginalPath$intellij_platform_ide_impl_wsl(@NotNull Path path, @NotNull String notation) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)notation, (String)"notation");
        return this.toOriginalPath(path, notation);
    }

    /*
     * WARNING - void declaration
     */
    private final Path toOriginalPath(Path $this$toOriginalPath, String notation) {
        Path path;
        block4: {
            IjentWslNioFileSystemProvider ijentWslNioFileSystemProvider = this;
            while (true) {
                Iterable iterable;
                String notationLowerCase;
                boolean bl;
                Intrinsics.checkNotNullExpressionValue((Object)notation.toLowerCase(Locale.ROOT), (String)"toLowerCase(...)");
                boolean bl2 = bl = Intrinsics.areEqual((Object)notationLowerCase, (Object)"wsl.localhost") || Intrinsics.areEqual((Object)notationLowerCase, (Object)"wsl$");
                if (_Assertions.ENABLED && !bl) {
                    boolean bl3 = false;
                    String string = notation;
                    throw new AssertionError((Object)string);
                }
                Path path2 = $this$toOriginalPath;
                if (path2 instanceof IjentNioPath) {
                    void $this$fold$iv;
                    iterable = $this$toOriginalPath;
                    Path initial$iv = ijentWslNioFileSystemProvider.originalFs.getPath("\\\\" + notation + "\\" + ijentWslNioFileSystemProvider.wslId + "\\", new String[0]);
                    boolean $i$f$fold = false;
                    Path accumulator$iv = initial$iv;
                    for (Object element$iv : $this$fold$iv) {
                        void file;
                        Path path3 = (Path)element$iv;
                        Path parent = accumulator$iv;
                        boolean bl4 = false;
                        accumulator$iv = parent.resolve(file.toString());
                    }
                    Path path4 = accumulator$iv;
                    path = path4;
                    Intrinsics.checkNotNullExpressionValue((Object)path4, (String)"fold(...)");
                    break block4;
                }
                if (!(path2 instanceof IjentWslNioPath)) break;
                IjentWslNioFileSystemProvider ijentWslNioFileSystemProvider2 = ijentWslNioFileSystemProvider;
                iterable = ((IjentWslNioPath)$this$toOriginalPath).getPresentablePath();
                String string = notation;
                ijentWslNioFileSystemProvider = ijentWslNioFileSystemProvider2;
                $this$toOriginalPath = iterable;
                notation = string;
            }
            path = $this$toOriginalPath;
        }
        return path;
    }

    private final Path toOriginalPathWithSameNotation(Path $this$toOriginalPathWithSameNotation) {
        IjentWslNioFileSystemProvider ijentWslNioFileSystemProvider = this;
        while (true) {
            Path path;
            if ((path = $this$toOriginalPathWithSameNotation) instanceof IjentNioPath) {
                throw new IllegalStateException(((Object)$this$toOriginalPathWithSameNotation).toString());
            }
            if (!(path instanceof IjentWslNioPath)) break;
            IjentWslNioFileSystemProvider ijentWslNioFileSystemProvider2 = ijentWslNioFileSystemProvider;
            Path path2 = ((IjentWslNioPath)$this$toOriginalPathWithSameNotation).getPresentablePath();
            ijentWslNioFileSystemProvider = ijentWslNioFileSystemProvider2;
            $this$toOriginalPathWithSameNotation = path2;
        }
        return $this$toOriginalPathWithSameNotation;
    }

    @Override
    @NotNull
    public String getScheme() {
        String string = this.originalFsProvider.getScheme();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getScheme(...)");
        return string;
    }

    @Override
    @NotNull
    public IjentWslNioFileSystem newFileSystem(@NotNull Path path, @Nullable Map<String, ?> env) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        URI uRI = path.toUri();
        Intrinsics.checkNotNullExpressionValue((Object)uRI, (String)"toUri(...)");
        return this.getFileSystem(uRI);
    }

    @Override
    @NotNull
    public IjentWslNioFileSystem getFileSystem(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        if (!Intrinsics.areEqual((Object)uri.getScheme(), (Object)this.getScheme())) {
            boolean bl = false;
            String string = "Wrong scheme in `" + uri + "` (expected `" + this.getScheme() + "`)";
            throw new IllegalArgumentException(string.toString());
        }
        Path path = this.originalFsProvider.getPath(uri);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        String string = this.wslIdFromPath(path);
        if (string == null) {
            throw new FileSystemNotFoundException("Cannot find WSL distribution for " + uri + ". The URL is incorrect or the distribution does not exist.");
        }
        String wslId = string;
        return this.getFileSystem(wslId);
    }

    @Override
    @NotNull
    public IjentWslNioFileSystem newFileSystem(@NotNull URI uri, @Nullable Map<String, ?> env) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        return this.getFileSystem(uri);
    }

    private final IjentWslNioFileSystem getFileSystem(String wslId) {
        IjentWslNioFileSystem ijentWslNioFileSystem = this.createdFileSystems.computeIfAbsent(wslId, arg_0 -> IjentWslNioFileSystemProvider.getFileSystem$lambda$2(arg_0 -> IjentWslNioFileSystemProvider.getFileSystem$lambda$1(this, arg_0), arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)ijentWslNioFileSystem, (String)"computeIfAbsent(...)");
        return ijentWslNioFileSystem;
    }

    private final String wslIdFromPath(Path path) {
        Object v2;
        block3: {
            String wslMarker;
            String root = ((Object)path.toAbsolutePath().getRoot()).toString();
            if (!StringsKt.startsWith((String)root, (String)(wslMarker = "\\\\wsl"), (boolean)true)) {
                return null;
            }
            String string = root.substring(wslMarker.length());
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            char[] cArray = new char[]{'\\'};
            String wslIdWithProbablyWrongCase = StringsKt.trimEnd((String)StringsKt.substringAfter$default((String)string, (char)'\\', null, (int)2, null), (char[])cArray);
            Object v = IjentWslNioFileSystemProvider.Companion.getAllWslDistributionIds().get();
            Intrinsics.checkNotNullExpressionValue(v, (String)"get(...)");
            Iterable $this$singleOrNull$iv = (Iterable)v;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                String wslId = (String)element$iv;
                boolean bl = false;
                if (!StringsKt.equals((String)wslId, (String)wslIdWithProbablyWrongCase, (boolean)true)) continue;
                if (found$iv) {
                    v2 = null;
                    break block3;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v2 = !found$iv ? null : single$iv;
        }
        return v2;
    }

    @Override
    public void checkAccess(@NotNull Path path, AccessMode ... modes) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)modes, (String)"modes");
        this.ijentFsProvider.checkAccess((Path)this.toIjentPath(path), Arrays.copyOf(modes, modes.length));
    }

    @Override
    @NotNull
    public InputStream newInputStream(@NotNull Path path, OpenOption ... options) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        InputStream inputStream = this.ijentFsProvider.newInputStream((Path)this.toIjentPath(path), Arrays.copyOf(options, options.length));
        Intrinsics.checkNotNullExpressionValue((Object)inputStream, (String)"newInputStream(...)");
        return inputStream;
    }

    @Override
    @NotNull
    public OutputStream newOutputStream(@NotNull Path path, OpenOption ... options) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        OutputStream outputStream = this.ijentFsProvider.newOutputStream((Path)this.toIjentPath(path), Arrays.copyOf(options, options.length));
        Intrinsics.checkNotNullExpressionValue((Object)outputStream, (String)"newOutputStream(...)");
        return outputStream;
    }

    @Override
    @NotNull
    public FileChannel newFileChannel(@NotNull Path path, @Nullable Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        FileChannel fileChannel = this.ijentFsProvider.newFileChannel((Path)this.toIjentPath(path), options, Arrays.copyOf(attrs, attrs.length));
        Intrinsics.checkNotNullExpressionValue((Object)fileChannel, (String)"newFileChannel(...)");
        return fileChannel;
    }

    @Override
    @NotNull
    public AsynchronousFileChannel newAsynchronousFileChannel(@NotNull Path path, @Nullable Set<? extends OpenOption> options, @Nullable ExecutorService executor, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        AsynchronousFileChannel asynchronousFileChannel = this.originalFsProvider.newAsynchronousFileChannel(this.toOriginalPathWithSameNotation(path), options, executor, Arrays.copyOf(attrs, attrs.length));
        Intrinsics.checkNotNullExpressionValue((Object)asynchronousFileChannel, (String)"newAsynchronousFileChannel(...)");
        return asynchronousFileChannel;
    }

    @Override
    public void createSymbolicLink(@NotNull Path link, @NotNull Path target, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        this.ijentFsProvider.createSymbolicLink((Path)this.toIjentPath(link), (Path)this.toIjentPath(target), Arrays.copyOf(attrs, attrs.length));
    }

    @Override
    public void createLink(@NotNull Path link, @NotNull Path existing) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        Intrinsics.checkNotNullParameter((Object)existing, (String)"existing");
        this.originalFsProvider.createLink(this.toOriginalPathWithSameNotation(link), this.toOriginalPathWithSameNotation(existing));
    }

    @Override
    public boolean deleteIfExists(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.ijentFsProvider.deleteIfExists((Path)this.toIjentPath(path));
    }

    @Override
    @NotNull
    public IjentWslNioPath readSymbolicLink(@NotNull Path link) {
        Intrinsics.checkNotNullParameter((Object)link, (String)"link");
        String string = this.wslIdFromPath(link);
        if (string == null) {
            throw new IOException("Cannot find WSL distribution for " + link + ". The URL is incorrect or the distribution does not exist.");
        }
        IjentWslNioFileSystem ijentWslNioFileSystem = this.getFileSystem(string);
        Path path = this.ijentFsProvider.readSymbolicLink((Path)this.toIjentPath(link));
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"readSymbolicLink(...)");
        return new IjentWslNioPath(ijentWslNioFileSystem, path, null);
    }

    @Override
    @NotNull
    public Path getPath(@NotNull URI uri) {
        Intrinsics.checkNotNullParameter((Object)uri, (String)"uri");
        Path path = this.originalFsProvider.getPath(uri);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        String string = this.wslIdFromPath(path);
        if (string == null) {
            throw new IllegalArgumentException("Cannot find WSL distribution for " + uri + ". The URL is incorrect or the distribution does not exist.");
        }
        IjentWslNioFileSystem ijentWslNioFileSystem = this.getFileSystem(string);
        Path path2 = this.originalFsProvider.getPath(uri);
        Intrinsics.checkNotNullExpressionValue((Object)path2, (String)"getPath(...)");
        return new IjentWslNioPath(ijentWslNioFileSystem, path2, null);
    }

    @Override
    @NotNull
    public SeekableByteChannel newByteChannel(@NotNull Path path, @Nullable Set<? extends OpenOption> options, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        SeekableByteChannel seekableByteChannel = this.ijentFsProvider.newByteChannel((Path)this.toIjentPath(path), options, Arrays.copyOf(attrs, attrs.length));
        Intrinsics.checkNotNullExpressionValue((Object)seekableByteChannel, (String)"newByteChannel(...)");
        return seekableByteChannel;
    }

    @Override
    @NotNull
    public DirectoryStream<Path> newDirectoryStream(@NotNull Path dir, @Nullable DirectoryStream.Filter<? super Path> filter) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        return new DirectoryStream<Path>(this, dir, filter){
            private final DirectoryStream<Path> delegate;
            private final String wslId;
            final /* synthetic */ IjentWslNioFileSystemProvider this$0;
            final /* synthetic */ Path $dir;
            {
                this.this$0 = $receiver;
                this.$dir = $dir;
                this.delegate = IjentWslNioFileSystemProvider.access$getIjentFsProvider$p($receiver).newDirectoryStream((Path)IjentWslNioFileSystemProvider.access$toIjentPath($receiver, $dir), $filter);
                String string = IjentWslNioFileSystemProvider.access$wslIdFromPath($receiver, $dir);
                if (string == null) {
                    throw new FileSystemException("Cannot find WSL distribution for " + $dir + ". The URL is incorrect or the distribution does not exist.");
                }
                this.wslId = string;
            }

            public final DirectoryStream<Path> getDelegate() {
                return this.delegate;
            }

            public final String getWslId() {
                return this.wslId;
            }

            public Iterator<Path> iterator() {
                return new Iterator<Path>(this, this.this$0, this.$dir){
                    private final Iterator<Path> delegateIterator;
                    final /* synthetic */ newDirectoryStream.1 this$0;
                    final /* synthetic */ IjentWslNioFileSystemProvider this$1;
                    final /* synthetic */ Path $dir;
                    {
                        this.this$0 = $receiver;
                        this.this$1 = $receiver2;
                        this.$dir = $dir;
                        Iterator<Path> iterator2 = $receiver.getDelegate().iterator();
                        Intrinsics.checkNotNullExpressionValue(iterator2, (String)"iterator(...)");
                        this.delegateIterator = iterator2;
                    }

                    public final Iterator<Path> getDelegateIterator() {
                        return this.delegateIterator;
                    }

                    public boolean hasNext() {
                        return this.delegateIterator.hasNext();
                    }

                    public Path next() {
                        Path path = this.delegateIterator.next();
                        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"next(...)");
                        IjentNioPath ijentPath = IjentWslNioFileSystemProvider.access$toIjentPath(this.this$1, path);
                        Path originalPath = this.$dir.resolve(Sanitize_nameKt.sanitizeFileName$default((String)((Object)ijentPath.getFileName()).toString(), null, (boolean)false, null, (int)14, null));
                        IjentWslNioFileSystem ijentWslNioFileSystem = IjentWslNioFileSystemProvider.access$getFileSystem(this.this$1, this.this$0.getWslId());
                        Intrinsics.checkNotNull((Object)originalPath);
                        return new IjentWslNioPath(ijentWslNioFileSystem, IjentWslNioFileSystemProvider.access$toOriginalPathWithSameNotation(this.this$1, originalPath), IjentNioPosixFileAttributesWithDosAdapterKt.getCachedFileAttributesAndWrapToDosAttributesAdapter((IjentNioPath)ijentPath));
                    }

                    public void remove() {
                        this.delegateIterator.remove();
                    }
                };
            }

            public void close() {
                this.delegate.close();
            }
        };
    }

    @Override
    public void createDirectory(@NotNull Path dir, FileAttribute<?> ... attrs) {
        Intrinsics.checkNotNullParameter((Object)dir, (String)"dir");
        Intrinsics.checkNotNullParameter(attrs, (String)"attrs");
        this.ijentFsProvider.createDirectory((Path)this.toIjentPath(dir), Arrays.copyOf(attrs, attrs.length));
    }

    @Override
    public void delete(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        this.ijentFsProvider.delete((Path)this.toIjentPath(path));
    }

    @Override
    public void copy(@NotNull Path source, @NotNull Path target, CopyOption ... options) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        WslPath sourceWsl = WslPath.Companion.parseWindowsUncPath(((Object)source.getRoot()).toString());
        WslPath targetWsl = WslPath.Companion.parseWindowsUncPath(((Object)target.getRoot()).toString());
        if (sourceWsl != null && Intrinsics.areEqual((Object)sourceWsl, (Object)targetWsl)) {
            this.ijentFsProvider.copy((Path)this.toIjentPath(source), (Path)this.toIjentPath(target), Arrays.copyOf(options, options.length));
        } else if (sourceWsl == null && targetWsl == null) {
            LOG.warn("This branch is not supposed to execute. Copying " + source + " => " + target + " through inappropriate FileSystemProvider");
            this.originalFsProvider.copy(this.toOriginalPathWithSameNotation(source), this.toOriginalPathWithSameNotation(target), Arrays.copyOf(options, options.length));
        } else {
            EelPathUtils.INSTANCE.walkingTransfer(source, target, false, ArraysKt.contains((Object[])options, (Object)StandardCopyOption.COPY_ATTRIBUTES));
        }
    }

    @Override
    public void move(@NotNull Path source, @NotNull Path target, CopyOption ... options) {
        Intrinsics.checkNotNullParameter((Object)source, (String)"source");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        WslPath sourceWsl = WslPath.Companion.parseWindowsUncPath(((Object)source.getRoot()).toString());
        WslPath targetWsl = WslPath.Companion.parseWindowsUncPath(((Object)target.getRoot()).toString());
        if (sourceWsl != null && Intrinsics.areEqual((Object)sourceWsl, (Object)targetWsl)) {
            this.ijentFsProvider.move((Path)this.toIjentPath(source), (Path)this.toIjentPath(target), Arrays.copyOf(options, options.length));
        } else if (sourceWsl == null && targetWsl == null) {
            LOG.warn("This branch is not supposed to execute. Moving " + source + " => " + target + " through inappropriate FileSystemProvider");
            this.originalFsProvider.move(this.toOriginalPathWithSameNotation(source), this.toOriginalPathWithSameNotation(target), Arrays.copyOf(options, options.length));
        } else {
            EelPathUtils.INSTANCE.walkingTransfer(source, target, true, ArraysKt.contains((Object[])options, (Object)StandardCopyOption.COPY_ATTRIBUTES));
        }
    }

    @Override
    public boolean isSameFile(@NotNull Path path, @NotNull Path path2) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)path2, (String)"path2");
        if (!(path instanceof IjentWslNioPath)) {
            if (!(path2 instanceof IjentWslNioPath)) {
                throw new ProviderMismatchException("Neither " + path + " (" + Reflection.getOrCreateKotlinClass(path.getClass()) + ") nor " + path2 + " (" + Reflection.getOrCreateKotlinClass(path2.getClass()) + ") are " + IjentWslNioPath.class.getName());
            }
            return this.isSameFile(path2, path);
        }
        if (!(path2 instanceof IjentWslNioPath)) {
            return Intrinsics.areEqual((Object)((IjentWslNioPath)path).getActualPath().getFileSystem().provider(), (Object)path2.getFileSystem().provider()) ? Files.isSameFile(((IjentWslNioPath)path).getActualPath(), path2) : false;
        }
        if (Intrinsics.areEqual((Object)((IjentWslNioPath)path).getActualPath(), (Object)((IjentWslNioPath)path).getPresentablePath()) && Intrinsics.areEqual((Object)((IjentWslNioPath)path2).getActualPath(), (Object)((IjentWslNioPath)path2).getPresentablePath())) {
            return Files.isSameFile((Path)this.toIjentPath(path), (Path)this.toIjentPath(path2));
        }
        if (Intrinsics.areEqual((Object)((IjentWslNioPath)path).getActualPath().getFileSystem().provider(), (Object)((IjentWslNioPath)path2).getActualPath().getFileSystem().provider())) {
            return Files.isSameFile(((IjentWslNioPath)path).getActualPath(), ((IjentWslNioPath)path2).getActualPath());
        }
        return false;
    }

    @Override
    public boolean isHidden(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        return this.originalFsProvider.isHidden(this.toOriginalPathWithSameNotation(path));
    }

    @Override
    @NotNull
    public FileStore getFileStore(@NotNull Path path) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        FileStore fileStore = this.ijentFsProvider.getFileStore((Path)this.toIjentPath(path));
        Intrinsics.checkNotNullExpressionValue((Object)fileStore, (String)"getFileStore(...)");
        return fileStore;
    }

    @Override
    @NotNull
    public <V extends FileAttributeView> V getFileAttributeView(@NotNull Path path, @NotNull Class<V> type, LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return (V)IjentNioPosixFileAttributesWithDosAdapterKt.getFileAttributeViewUsingDosAttributesAdapter((FileSystemProvider)this.ijentFsProvider, (IjentNioPath)this.toIjentPath(path), type, (LinkOption[])Arrays.copyOf(options, options.length));
    }

    @Override
    @NotNull
    public <A extends BasicFileAttributes> A readAttributes(@NotNull Path path, @NotNull Class<A> type, LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter(type, (String)"type");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        return (A)IjentNioPosixFileAttributesWithDosAdapterKt.readAttributesUsingDosAttributesAdapter((FileSystemProvider)this.ijentFsProvider, (Path)path, (IjentNioPath)this.toIjentPath(path), type, (LinkOption[])Arrays.copyOf(options, options.length));
    }

    @Override
    @NotNull
    public Map<String, Object> readAttributes(@NotNull Path path, @Nullable String attributes, LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        Map<String, Object> map = this.ijentFsProvider.readAttributes((Path)this.toIjentPath(path), attributes, Arrays.copyOf(options, options.length));
        Intrinsics.checkNotNullExpressionValue(map, (String)"readAttributes(...)");
        return map;
    }

    @Override
    public void setAttribute(@NotNull Path path, @Nullable String attribute, @Nullable Object value, LinkOption ... options) {
        Intrinsics.checkNotNullParameter((Object)path, (String)"path");
        Intrinsics.checkNotNullParameter((Object)options, (String)"options");
        this.ijentFsProvider.setAttribute((Path)this.toIjentPath(path), attribute, value, Arrays.copyOf(options, options.length));
    }

    private static final IjentWslNioFileSystem getFileSystem$lambda$1(IjentWslNioFileSystemProvider this$0, String wslId) {
        Intrinsics.checkNotNullParameter((Object)wslId, (String)"wslId");
        FileSystem fileSystem = this$0.ijentFsProvider.getFileSystem(new URI("ijent", "wsl", "/" + wslId, null, null));
        Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"getFileSystem(...)");
        FileSystem fileSystem2 = this$0.originalFsProvider.getFileSystem(new URI("file:/"));
        Intrinsics.checkNotNullExpressionValue((Object)fileSystem2, (String)"getFileSystem(...)");
        return new IjentWslNioFileSystem(this$0, wslId, fileSystem, fileSystem2);
    }

    private static final IjentWslNioFileSystem getFileSystem$lambda$2(Function1 $tmp0, Object p0) {
        return (IjentWslNioFileSystem)$tmp0.invoke(p0);
    }

    /*
     * WARNING - void declaration
     */
    private static final AtomicReference allWslDistributionIds_delegate$lambda$0() {
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        AtomicReference<Set> ref = new AtomicReference<Set>(SetsKt.emptySet());
        WslDistributionManager wslDistributionManager = WslDistributionManager.getInstance();
        Intrinsics.checkNotNullExpressionValue((Object)wslDistributionManager, (String)"getInstance(...)");
        WslDistributionManager wslDistributionManager2 = wslDistributionManager;
        wslDistributionManager2.addWslDistributionsChangeListener((arg_0, arg_1) -> IjentWslNioFileSystemProvider.allWslDistributionIds_delegate$lambda$0$0(ref, arg_0, arg_1));
        List list = wslDistributionManager2.getInstalledDistributions();
        Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getInstalledDistributions(...)");
        Iterable iterable = list;
        AtomicReference<Set> atomicReference = ref;
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            WSLDistribution wSLDistribution = (WSLDistribution)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        atomicReference.set(CollectionsKt.toHashSet((Iterable)((List)destination$iv$iv)));
        return ref;
    }

    private static final void allWslDistributionIds_delegate$lambda$0$0(AtomicReference $ref, Set old, Set set) {
        Intrinsics.checkNotNullParameter((Object)old, (String)"old");
        Intrinsics.checkNotNullParameter((Object)set, (String)"new");
        $ref.updateAndGet(arg_0 -> IjentWslNioFileSystemProvider.allWslDistributionIds_delegate$lambda$0$0$0(old, set, arg_0));
    }

    private static final Set allWslDistributionIds_delegate$lambda$0$0$0(Set $old, Set $new, Set oldFromRef) {
        WSLDistribution it;
        Collection collection;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        HashSet result = new HashSet(oldFromRef);
        Intrinsics.checkNotNull((Object)$old);
        Iterable iterable = $old;
        HashSet hashSet = result;
        boolean $i$f$map = false;
        void var6_7 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            WSLDistribution wSLDistribution = (WSLDistribution)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        hashSet.removeAll((List)destination$iv$iv);
        Intrinsics.checkNotNull((Object)$new);
        $this$map$iv = $new;
        hashSet = result;
        $i$f$map = false;
        $this$mapTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (WSLDistribution)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getId());
        }
        hashSet.addAll((List)destination$iv$iv);
        return result;
    }

    public static final /* synthetic */ FileSystemProvider access$getIjentFsProvider$p(IjentWslNioFileSystemProvider $this) {
        return $this.ijentFsProvider;
    }

    public static final /* synthetic */ IjentNioPath access$toIjentPath(IjentWslNioFileSystemProvider $this, Path $receiver) {
        return $this.toIjentPath($receiver);
    }

    public static final /* synthetic */ String access$wslIdFromPath(IjentWslNioFileSystemProvider $this, Path path) {
        return $this.wslIdFromPath(path);
    }

    public static final /* synthetic */ IjentWslNioFileSystem access$getFileSystem(IjentWslNioFileSystemProvider $this, String wslId) {
        return $this.getFileSystem(wslId);
    }

    public static final /* synthetic */ Path access$toOriginalPathWithSameNotation(IjentWslNioFileSystemProvider $this, Path $receiver) {
        return $this.toOriginalPathWithSameNotation($receiver);
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(IjentWslNioFileSystemProvider.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R'\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00058BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\n\u0010\u000b\u001a\u0004\b\b\u0010\tR\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lcom/intellij/platform/ide/impl/wsl/ijent/nio/IjentWslNioFileSystemProvider$Companion;", "", "<init>", "()V", "allWslDistributionIds", "Ljava/util/concurrent/atomic/AtomicReference;", "", "", "getAllWslDistributionIds", "()Ljava/util/concurrent/atomic/AtomicReference;", "allWslDistributionIds$delegate", "Lkotlin/Lazy;", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "intellij.platform.ide.impl.wsl"})
    public static final class Companion {
        private Companion() {
        }

        private final AtomicReference<Set<String>> getAllWslDistributionIds() {
            Lazy lazy = allWslDistributionIds$delegate;
            return (AtomicReference)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

