/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.statistic.eventLog.dictionary;

import com.intellij.internal.statistic.eventLog.dictionary.Dictionary;
import com.intellij.internal.statistic.eventLog.dictionary.HashSetDictionary;
import com.intellij.internal.statistic.eventLog.dictionary.InMemoryFileHandle;
import com.jetbrains.fus.reporting.FileHandle;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.collections.ArraysKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\u0018\u0000 \u000b2\u00020\u0001:\u0001\u000bB\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u0005H\u0016R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082.\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"Lcom/intellij/internal/statistic/eventLog/dictionary/HashSetDictionary;", "Lcom/intellij/internal/statistic/eventLog/dictionary/Dictionary;", "()V", "hashSet", "", "", "close", "", "contains", "", "value", "Companion", "ap-validation"})
public final class HashSetDictionary
implements Dictionary {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private Set<String> hashSet;

    @Override
    public boolean contains(@NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        Set<String> set = this.hashSet;
        if (set == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"hashSet");
            set = null;
        }
        return set.contains(value);
    }

    @Override
    public void close() {
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u000e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u0006J\u0016\u0010\u0003\u001a\u00020\u00042\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\t0\bH\u0002J\u000e\u0010\n\u001a\u00020\u00042\u0006\u0010\u000b\u001a\u00020\f\u00a8\u0006\r"}, d2={"Lcom/intellij/internal/statistic/eventLog/dictionary/HashSetDictionary$Companion;", "", "()V", "create", "Lcom/intellij/internal/statistic/eventLog/dictionary/Dictionary;", "bytes", "", "lines", "", "", "openFile", "file", "Lcom/jetbrains/fus/reporting/FileHandle;", "ap-validation"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final Dictionary openFile(@NotNull FileHandle file) {
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            byte[] lines2 = file.readAll();
            return this.create(lines2);
        }

        @NotNull
        public final Dictionary create(@NotNull byte[] bytes) {
            Intrinsics.checkNotNullParameter((Object)bytes, (String)"bytes");
            String metadataJson = Dictionary.Companion.readLastLine(new InMemoryFileHandle(bytes), bytes.length);
            Triple<Integer, Integer, String> metadata = Dictionary.Companion.parseDictionaryMetadata(metadataJson);
            List lines2 = SequencesKt.toList((Sequence)SequencesKt.map((Sequence)SequencesKt.chunked((Sequence)SequencesKt.take((Sequence)ArraysKt.asSequence((byte[])bytes), (int)((Number)metadata.getSecond()).intValue()), (int)((Number)metadata.getFirst()).intValue()), (Function1)create.lines.1.INSTANCE));
            return this.create(lines2);
        }

        private final Dictionary create(List<String> lines2) {
            HashSet<String> hashSet = new HashSet<String>((int)Math.ceil((double)(lines2.size() - 1) / 0.75));
            int n = lines2.size() - 1;
            for (int i = 0; i < n; ++i) {
                hashSet.add(((Object)StringsKt.trim((CharSequence)lines2.get(i))).toString());
            }
            HashSetDictionary dictionary = new HashSetDictionary();
            dictionary.hashSet = hashSet;
            return dictionary;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

