/*
 * Decompiled with CFR 0.152.
 */
package com.jetbrains.fus.reporting.anonymization;

import com.jetbrains.fus.reporting.MetadataStorage;
import com.jetbrains.fus.reporting.anonymization.LogAnonymizer;
import com.jetbrains.fus.reporting.model.lion4.FusReport;
import com.jetbrains.fus.reporting.model.lion4.LogEvent;
import com.jetbrains.fus.reporting.model.lion4.LogEventAction;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0019\u0012\n\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u000e\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\nJ\u0018\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u001c\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u00020\u0010\u0012\u0004\u0012\u00020\u00100\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u0006\u0012\u0002\b\u00030\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0015"}, d2={"Lcom/jetbrains/fus/reporting/anonymization/EventLogAnonymizer;", "", "fieldsToAnonymizeStorage", "Lcom/jetbrains/fus/reporting/MetadataStorage;", "salt", "", "(Lcom/jetbrains/fus/reporting/MetadataStorage;[B)V", "anonymizer", "Lcom/jetbrains/fus/reporting/anonymization/LogAnonymizer;", "anonymize", "Lcom/jetbrains/fus/reporting/model/lion4/FusReport;", "report", "anonymizeEventAction", "Lcom/jetbrains/fus/reporting/model/lion4/LogEventAction;", "eventAction", "groupId", "", "anonymizeIds", "", "event", "Lcom/jetbrains/fus/reporting/model/lion4/LogEvent;", "anonymization"})
@SourceDebugExtension(value={"SMAP\nEventLogAnonymizer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 EventLogAnonymizer.kt\ncom/jetbrains/fus/reporting/anonymization/EventLogAnonymizer\n+ 2 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,66:1\n453#2:67\n403#2:68\n1238#3,4:69\n*S KotlinDebug\n*F\n+ 1 EventLogAnonymizer.kt\ncom/jetbrains/fus/reporting/anonymization/EventLogAnonymizer\n*L\n44#1:67\n44#1:68\n44#1:69,4\n*E\n"})
public final class EventLogAnonymizer {
    @NotNull
    private final MetadataStorage<?> fieldsToAnonymizeStorage;
    @NotNull
    private final LogAnonymizer anonymizer;

    public EventLogAnonymizer(@NotNull MetadataStorage<?> fieldsToAnonymizeStorage, @NotNull byte[] salt) {
        Intrinsics.checkNotNullParameter(fieldsToAnonymizeStorage, (String)"fieldsToAnonymizeStorage");
        Intrinsics.checkNotNullParameter((Object)salt, (String)"salt");
        this.fieldsToAnonymizeStorage = fieldsToAnonymizeStorage;
        this.anonymizer = new LogAnonymizer(salt, LogAnonymizer.Mode.CLIENT);
    }

    @NotNull
    public final FusReport anonymize(@NotNull FusReport report) {
        Intrinsics.checkNotNullParameter((Object)report, (String)"report");
        List events = new ArrayList();
        for (LogEvent event : report.getEvents()) {
            String session = event.getSession();
            String anonymizedSession = session == null ? null : this.anonymizer.anonymize(session);
            LogEventAction anonymizedEvent = this.anonymizeEventAction(event.getEvent(), event.getGroup().getId());
            events.add(new LogEvent(event.getRecorder(), event.getProduct(), this.anonymizeIds(event), event.getInternal(), event.getTime(), event.getBuild(), anonymizedSession, event.getGroup(), event.getBucket(), anonymizedEvent, event.getSystem_data(), event.getClient_data()));
        }
        return new FusReport(events);
    }

    /*
     * WARNING - void declaration
     */
    private final Map<String, String> anonymizeIds(LogEvent event) {
        void $this$mapValuesTo$iv$iv;
        Set<String> skipAnonymizationIds = this.fieldsToAnonymizeStorage.getSkipAnonymizationIds();
        Map<String, String> $this$mapValues$iv = event.getIds();
        boolean $i$f$mapValues = false;
        Map<String, String> map2 = $this$mapValues$iv;
        Map destination$iv$iv = new LinkedHashMap(MapsKt.mapCapacity((int)$this$mapValues$iv.size()));
        boolean $i$f$mapValuesTo = false;
        Iterable $this$associateByTo$iv$iv$iv = $this$mapValuesTo$iv$iv.entrySet();
        boolean $i$f$associateByTo = false;
        for (Object element$iv$iv$iv : $this$associateByTo$iv$iv$iv) {
            void it$iv$iv;
            Map.Entry entry = (Map.Entry)element$iv$iv$iv;
            Map map3 = destination$iv$iv;
            boolean bl = false;
            Map.Entry entry2 = (Map.Entry)element$iv$iv$iv;
            Object k = it$iv$iv.getKey();
            Map map4 = map3;
            boolean bl2 = false;
            String key = (String)entry2.getKey();
            String value = (String)entry2.getValue();
            String string = skipAnonymizationIds.contains(key) ? value : this.anonymizer.anonymize(value);
            map4.put(k, string);
        }
        return destination$iv$iv;
    }

    private final LogEventAction anonymizeEventAction(LogEventAction eventAction, String groupId) {
        Set<String> fieldsToAnonymize = this.fieldsToAnonymizeStorage.getFieldsToAnonymize(groupId, eventAction.getId());
        if (fieldsToAnonymize.isEmpty()) {
            return eventAction;
        }
        HashMap anonymizedData = new HashMap();
        for (Map.Entry<String, Object> eventData : eventAction.getData().entrySet()) {
            ((Map)anonymizedData).put(eventData.getKey(), this.anonymizer.anonymizeValue(eventData.getKey(), eventData.getValue(), fieldsToAnonymize));
        }
        return new LogEventAction(eventAction.getId(), anonymizedData, eventAction.getCount());
    }
}

