/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.action;

import java.awt.event.ActionEvent;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.UnknownHostException;
import java.security.AccessControlException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Icon;

public class ServerAction
extends AbstractAction {
    private static final Logger LOG = Logger.getLogger(ServerAction.class.getName());
    private static final String PARAMS = "action-params";
    private static final String HEADERS = "action-headers";
    private static final String URL = "action-url";
    private static final String URL_CACHE = "_URL-CACHE__";

    public ServerAction() {
        this("action");
    }

    public ServerAction(String name) {
        super(name);
    }

    public ServerAction(String name, String command) {
        this(name, command, null);
    }

    public ServerAction(String name, Icon icon) {
        super(name, icon);
    }

    public ServerAction(String name, String command, Icon icon) {
        super(name, icon);
        this.putValue("ActionCommandKey", command);
    }

    public void setURL(String url) {
        this.putValue(URL, url);
        this.putValue(URL_CACHE, null);
    }

    public String getURL() {
        return (String)this.getValue(URL);
    }

    private Map<String, String> getParams() {
        return (Map)this.getValue(PARAMS);
    }

    private void setParams(Map<String, String> params) {
        this.putValue(PARAMS, params);
    }

    public void addParam(String name, String value) {
        Map<String, String> params = this.getParams();
        if (params == null) {
            params = new HashMap<String, String>();
            this.setParams(params);
        }
        params.put(name, value);
    }

    public String getParamValue(String name) {
        Map<String, String> params = this.getParams();
        return params == null ? null : params.get(name);
    }

    public Set<String> getParamNames() {
        Map<String, String> params = this.getParams();
        return params == null ? null : params.keySet();
    }

    private Map<String, String> getHeaders() {
        return (Map)this.getValue(HEADERS);
    }

    private void setHeaders(Map<String, String> headers) {
        this.putValue(HEADERS, headers);
    }

    public void addHeader(String name, String value) {
        Map<String, String> map2 = this.getHeaders();
        if (map2 == null) {
            map2 = new HashMap<String, String>();
            this.setHeaders(map2);
        }
        map2.put(name, value);
    }

    public String getHeaderValue(String name) {
        Map<String, String> headers = this.getHeaders();
        return headers == null ? null : headers.get(name);
    }

    public Set<String> getHeaderNames() {
        Map<String, String> headers = this.getHeaders();
        return headers == null ? null : headers.keySet();
    }

    @Override
    public void actionPerformed(ActionEvent evt) {
        URL execURL = (URL)this.getValue(URL_CACHE);
        if (execURL == null && !"".equals(this.getURL())) {
            try {
                String url = this.getURL();
                if (url.startsWith("http")) {
                    execURL = new URL(url);
                }
                if (execURL == null) {
                    return;
                }
                this.putValue(URL_CACHE, execURL);
            }
            catch (MalformedURLException ex) {
                LOG.log(Level.WARNING, "something went wrong...", ex);
            }
        }
        try {
            URLConnection uc = execURL.openConnection();
            Set<String> headerNames = this.getHeaderNames();
            if (headerNames != null && !headerNames.isEmpty()) {
                for (String name : headerNames) {
                    uc.setRequestProperty(name, this.getHeaderValue(name));
                }
            }
            uc.setUseCaches(false);
            uc.setDoOutput(true);
            ByteArrayOutputStream byteStream = new ByteArrayOutputStream(512);
            PrintWriter out = new PrintWriter(byteStream, true);
            out.print(this.getPostData());
            out.flush();
            String length = String.valueOf(byteStream.size());
            uc.setRequestProperty("Content-length", length);
            byteStream.writeTo(uc.getOutputStream());
            BufferedReader buf = null;
            if (uc instanceof HttpURLConnection) {
                String line;
                HttpURLConnection huc = (HttpURLConnection)uc;
                int code = huc.getResponseCode();
                String message = huc.getResponseMessage();
                buf = code < 400 ? new BufferedReader(new InputStreamReader(uc.getInputStream())) : new BufferedReader(new InputStreamReader(huc.getErrorStream()));
                StringBuffer buffer = new StringBuffer();
                while ((line = buf.readLine()) != null) {
                    buffer.append(line);
                    buffer.append('\n');
                }
                LOG.finer("returned from connection\n" + buffer.toString());
            }
        }
        catch (UnknownHostException ex) {
            LOG.log(Level.WARNING, "UnknownHostException detected. Could it be a proxy issue?", ex);
        }
        catch (AccessControlException ex) {
            LOG.log(Level.WARNING, "AccessControlException detected", ex);
        }
        catch (IOException ex) {
            LOG.log(Level.WARNING, "IOException detected", ex);
        }
    }

    private String getPostData() {
        StringBuffer postData = new StringBuffer();
        Set<String> paramNames = this.getParamNames();
        if (paramNames != null && !paramNames.isEmpty()) {
            Iterator<String> iter = paramNames.iterator();
            try {
                while (iter.hasNext()) {
                    String name = iter.next();
                    postData.append('&').append(name).append('=');
                    postData.append(this.getParamValue(name));
                }
            }
            catch (Exception ex) {
                // empty catch block
            }
            postData.setCharAt(0, '?');
        }
        LOG.finer("ServerAction: POST data: " + postData.toString());
        return postData.toString();
    }

    private String createMessage(int code, String msg) {
        StringBuffer buffer = new StringBuffer("The action \"");
        buffer.append(this.getValue("Name"));
        if (code < 400) {
            buffer.append("\" has succeeded ");
        } else {
            buffer.append("\" has failed\nPlease check the Java console for more details.\n");
        }
        buffer.append("\nServer response:\nCode: ");
        buffer.append(code);
        buffer.append(" Message: ");
        buffer.append(msg);
        return buffer.toString();
    }
}

