/*
 * Decompiled with CFR 0.152.
 */
package org.jdesktop.swingx.plaf.basic;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Insets;
import java.awt.KeyboardFocusManager;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyVetoException;
import java.text.DateFormat;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import java.util.logging.Logger;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.Icon;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFormattedTextField;
import javax.swing.JPopupMenu;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.event.PopupMenuEvent;
import javax.swing.event.PopupMenuListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.UIResource;
import javax.swing.text.DefaultFormatterFactory;
import javax.swing.text.View;
import org.jdesktop.swingx.JXDatePicker;
import org.jdesktop.swingx.JXMonthView;
import org.jdesktop.swingx.SwingXUtilities;
import org.jdesktop.swingx.calendar.CalendarUtils;
import org.jdesktop.swingx.calendar.DatePickerFormatter;
import org.jdesktop.swingx.calendar.DateSelectionModel;
import org.jdesktop.swingx.event.DateSelectionEvent;
import org.jdesktop.swingx.event.DateSelectionListener;
import org.jdesktop.swingx.plaf.DatePickerUI;

public class BasicDatePickerUI
extends DatePickerUI {
    private static final Logger LOG = Logger.getLogger(BasicDatePickerUI.class.getName());
    protected JXDatePicker datePicker;
    private JButton popupButton;
    private BasicDatePickerPopup popup;
    private Handler handler;
    protected PropertyChangeListener propertyChangeListener;
    private FocusListener focusListener;
    protected MouseListener mouseListener;
    protected MouseMotionListener mouseMotionListener;
    private ActionListener editorActionListener;
    private EditorCancelAction editorCancelAction;
    private PropertyChangeListener editorPropertyListener;
    private DateSelectionListener monthViewSelectionListener;
    private ActionListener monthViewActionListener;
    private PropertyChangeListener monthViewPropertyListener;
    private PopupRemover popupRemover;
    private PopupMenuListener popupMenuListener;

    public static ComponentUI createUI(JComponent c) {
        return new BasicDatePickerUI();
    }

    @Override
    public void installUI(JComponent c) {
        this.datePicker = (JXDatePicker)c;
        this.datePicker.setLayout(this.createLayoutManager());
        this.installComponents();
        this.installDefaults();
        this.installKeyboardActions();
        this.installListeners();
    }

    @Override
    public void uninstallUI(JComponent c) {
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallDefaults();
        this.uninstallComponents();
        this.datePicker.setLayout(null);
        this.datePicker = null;
    }

    protected void installComponents() {
        JFormattedTextField editor = this.datePicker.getEditor();
        if (SwingXUtilities.isUIInstallable(editor)) {
            DateFormat[] formats = this.getCustomFormats(editor);
            this.datePicker.setEditor(this.createEditor());
            if (formats != null) {
                this.datePicker.setFormats(formats);
            }
        }
        this.updateFromEditorChanged(null, false);
        this.popupButton = this.createPopupButton();
        if (this.popupButton != null) {
            JComboBox box = new JComboBox();
            Object preventHide = box.getClientProperty("doNotCancelPopup");
            this.popupButton.putClientProperty("doNotCancelPopup", preventHide);
            this.datePicker.add(this.popupButton);
            this.popupButton.setEnabled(this.datePicker.isEnabled());
        }
        this.updateChildLocale(this.datePicker.getLocale());
    }

    private DateFormat[] getCustomFormats(JFormattedTextField editor) {
        JFormattedTextField.AbstractFormatter formatter;
        JFormattedTextField.AbstractFormatterFactory factory;
        DateFormat[] formats = null;
        if (editor != null && (factory = editor.getFormatterFactory()) != null && (formatter = factory.getFormatter(editor)) instanceof DatePickerFormatter && !(formatter instanceof UIResource)) {
            formats = ((DatePickerFormatter)formatter).getFormats();
        }
        return formats;
    }

    protected void uninstallComponents() {
        JFormattedTextField editor = this.datePicker.getEditor();
        if (editor != null) {
            this.datePicker.remove(editor);
        }
        if (this.popupButton != null) {
            this.datePicker.remove(this.popupButton);
            this.popupButton = null;
        }
    }

    protected void installDefaults() {
        boolean zoomable = Boolean.TRUE.equals(UIManager.get("JXDatePicker.forceZoomable"));
        if (zoomable) {
            this.datePicker.getMonthView().setZoomable(true);
        }
    }

    protected void uninstallDefaults() {
    }

    protected void installKeyboardActions() {
        ActionMap pickerMap = this.datePicker.getActionMap();
        pickerMap.put("datePickerCancel", this.createCancelAction());
        pickerMap.put("datePickerCommit", this.createCommitAction());
        pickerMap.put("navigateHome", this.createHomeAction(false));
        pickerMap.put("commitHome", this.createHomeAction(true));
        TogglePopupAction popupAction = this.createTogglePopupAction();
        pickerMap.put("TOGGLE_POPUP", popupAction);
        InputMap pickerInputMap = this.datePicker.getInputMap(1);
        pickerInputMap.put(KeyStroke.getKeyStroke("ENTER"), "datePickerCommit");
        pickerInputMap.put(KeyStroke.getKeyStroke("ESCAPE"), "datePickerCancel");
        pickerInputMap.put(KeyStroke.getKeyStroke("F5"), "commitHome");
        pickerInputMap.put(KeyStroke.getKeyStroke("shift F5"), "navigateHome");
        pickerInputMap.put(KeyStroke.getKeyStroke("alt DOWN"), "TOGGLE_POPUP");
        this.installLinkPanelKeyboardActions();
    }

    protected void uninstallKeyboardActions() {
        this.uninstallLinkPanelKeyboardActions(this.datePicker.getLinkPanel());
    }

    protected void installLinkPanelKeyboardActions() {
        if (this.datePicker.getLinkPanel() == null) {
            return;
        }
        ActionMap map2 = this.datePicker.getLinkPanel().getActionMap();
        map2.put("commitHome", this.datePicker.getActionMap().get("commitHome"));
        map2.put("navigateHome", this.datePicker.getActionMap().get("navigateHome"));
        InputMap inputMap = this.datePicker.getLinkPanel().getInputMap(2);
        inputMap.put(KeyStroke.getKeyStroke("F5"), "commitHome");
        inputMap.put(KeyStroke.getKeyStroke("shift F5"), "navigateHome");
    }

    protected void uninstallLinkPanelKeyboardActions(JComponent panel) {
        if (panel == null) {
            return;
        }
        ActionMap map2 = panel.getActionMap();
        map2.remove("commitHome");
        map2.remove("navigateHome");
        InputMap inputMap = panel.getInputMap(2);
        inputMap.remove(KeyStroke.getKeyStroke("F5"));
        inputMap.remove(KeyStroke.getKeyStroke("shift F5"));
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        this.mouseListener = this.createMouseListener();
        this.mouseMotionListener = this.createMouseMotionListener();
        this.focusListener = this.createFocusListener();
        this.editorActionListener = this.createEditorActionListener();
        this.editorPropertyListener = this.createEditorPropertyListener();
        this.monthViewSelectionListener = this.createMonthViewSelectionListener();
        this.monthViewActionListener = this.createMonthViewActionListener();
        this.monthViewPropertyListener = this.createMonthViewPropertyListener();
        this.popupRemover = new PopupRemover();
        this.datePicker.addPropertyChangeListener(this.propertyChangeListener);
        this.datePicker.addFocusListener(this.focusListener);
        if (this.popupButton != null) {
            this.popupButton.addPropertyChangeListener(this.propertyChangeListener);
            this.popupButton.addMouseListener(this.mouseListener);
            this.popupButton.addMouseMotionListener(this.mouseMotionListener);
        }
        this.updateEditorListeners(null);
        this.updateFromMonthViewChanged(null);
    }

    protected void uninstallListeners() {
        this.datePicker.removePropertyChangeListener(this.propertyChangeListener);
        this.datePicker.removeFocusListener(this.focusListener);
        this.datePicker.getMonthView().getSelectionModel().removeDateSelectionListener(this.monthViewSelectionListener);
        this.datePicker.getMonthView().removeActionListener(this.monthViewActionListener);
        this.datePicker.getMonthView().removePropertyChangeListener(this.propertyChangeListener);
        if (this.datePicker.getEditor() != null) {
            this.uninstallEditorListeners(this.datePicker.getEditor());
        }
        if (this.popupButton != null) {
            this.popupButton.removePropertyChangeListener(this.propertyChangeListener);
            this.popupButton.removeMouseListener(this.mouseListener);
            this.popupButton.removeMouseMotionListener(this.mouseMotionListener);
        }
        this.popupRemover.unload();
        this.popupRemover = null;
        this.propertyChangeListener = null;
        this.mouseListener = null;
        this.mouseMotionListener = null;
        this.editorActionListener = null;
        this.editorPropertyListener = null;
        this.monthViewSelectionListener = null;
        this.monthViewActionListener = null;
        this.monthViewPropertyListener = null;
        this.handler = null;
    }

    protected void updateMonthViewListeners(JXMonthView oldMonthView) {
        DateSelectionModel oldModel = null;
        if (oldMonthView != null) {
            oldMonthView.removePropertyChangeListener(this.monthViewPropertyListener);
            oldMonthView.removeActionListener(this.monthViewActionListener);
            oldModel = oldMonthView.getSelectionModel();
        }
        this.datePicker.getMonthView().addPropertyChangeListener(this.monthViewPropertyListener);
        this.datePicker.getMonthView().addActionListener(this.monthViewActionListener);
        this.updateSelectionModelListeners(oldModel);
    }

    protected void updateEditorListeners(JFormattedTextField oldEditor) {
        if (oldEditor != null) {
            this.uninstallEditorListeners(oldEditor);
        }
        this.datePicker.getEditor().addPropertyChangeListener(this.editorPropertyListener);
        this.datePicker.getEditor().addActionListener(this.editorActionListener);
        this.datePicker.getEditor().addFocusListener(this.focusListener);
        this.editorCancelAction = new EditorCancelAction(this.datePicker.getEditor());
    }

    private void uninstallEditorListeners(JFormattedTextField oldEditor) {
        oldEditor.removePropertyChangeListener(this.editorPropertyListener);
        oldEditor.removeActionListener(this.editorActionListener);
        oldEditor.removeFocusListener(this.focusListener);
        if (this.editorCancelAction != null) {
            this.editorCancelAction.uninstall();
            this.editorCancelAction = null;
        }
    }

    protected void updateSelectionModelListeners(DateSelectionModel oldModel) {
        if (oldModel != null) {
            oldModel.removeDateSelectionListener(this.monthViewSelectionListener);
        }
        this.datePicker.getMonthView().getSelectionModel().addDateSelectionListener(this.monthViewSelectionListener);
    }

    protected JFormattedTextField createEditor() {
        DefaultEditor f = new DefaultEditor(new DatePickerFormatter.DatePickerFormatterUIResource(this.datePicker.getLocale()));
        f.setName("dateField");
        Border border = UIManager.getBorder("JXDatePicker.border");
        if (border != null) {
            f.setBorder(border);
        }
        return f;
    }

    protected JButton createPopupButton() {
        JButton b = new JButton();
        b.setName("popupButton");
        b.setRolloverEnabled(false);
        b.setMargin(new Insets(0, 3, 0, 3));
        Icon icon = UIManager.getIcon("JXDatePicker.arrowIcon");
        if (icon == null) {
            icon = (Icon)UIManager.get("Tree.expandedIcon");
        }
        b.setIcon(icon);
        b.setFocusable(false);
        return b;
    }

    @Override
    public Dimension getMinimumSize(JComponent c) {
        return this.getPreferredSize(c);
    }

    @Override
    public Dimension getPreferredSize(JComponent c) {
        Dimension dim = this.datePicker.getEditor().getPreferredSize();
        if (this.popupButton != null) {
            dim.width += this.popupButton.getPreferredSize().width;
        }
        Insets insets = this.datePicker.getInsets();
        dim.width += insets.left + insets.right;
        dim.height += insets.top + insets.bottom;
        return (Dimension)dim.clone();
    }

    @Override
    public int getBaseline(int width, int height) {
        JFormattedTextField editor = this.datePicker.getEditor();
        View rootView = editor.getUI().getRootView(editor);
        if (rootView.getViewCount() > 0) {
            Insets insets = editor.getInsets();
            Insets insetsOut = this.datePicker.getInsets();
            int nh = height - insets.top - insets.bottom - insetsOut.top - insetsOut.bottom;
            int y = insets.top + insetsOut.top;
            View fieldView = rootView.getView(0);
            int vspan = (int)fieldView.getPreferredSpan(1);
            if (nh != vspan) {
                int slop = nh - vspan;
                y += slop / 2;
            }
            FontMetrics fm = editor.getFontMetrics(editor.getFont());
            return y += fm.getAscent();
        }
        return -1;
    }

    @Override
    public Date getSelectableDate(Date date) throws PropertyVetoException {
        Date cleaned;
        Date date2 = cleaned = date == null ? null : this.datePicker.getMonthView().getSelectionModel().getNormalizedDate(date);
        if (CalendarUtils.areEqual(cleaned, this.datePicker.getDate())) {
            throw new PropertyVetoException("date not selectable", null);
        }
        if (cleaned == null) {
            return cleaned;
        }
        if (this.datePicker.getMonthView().isUnselectableDate(cleaned)) {
            throw new PropertyVetoException("date not selectable", null);
        }
        return cleaned;
    }

    protected void updateFromDateChanged() {
        Date visibleHook = this.datePicker.getDate() != null ? this.datePicker.getDate() : this.datePicker.getLinkDay();
        this.datePicker.getMonthView().ensureDateVisible(visibleHook);
        this.datePicker.getEditor().setValue(this.datePicker.getDate());
    }

    protected void updateFromValueChanged(Date oldDate, Date newDate) {
        if (newDate != null && this.datePicker.getMonthView().isUnselectableDate(newDate)) {
            this.revertValue(oldDate);
            return;
        }
        if (!CalendarUtils.areEqual(newDate, this.datePicker.getMonthView().getSelectionDate())) {
            this.datePicker.getMonthView().setSelectionDate(newDate);
        }
        this.datePicker.setDate(newDate);
    }

    private void revertValue(Date oldDate) {
        this.datePicker.getEditor().setValue(oldDate);
    }

    protected void updateFromSelectionChanged(DateSelectionEvent.EventType eventType, boolean adjusting) {
        if (adjusting) {
            return;
        }
        this.updateEditorValue();
    }

    protected void updateFromMonthViewChanged(JXMonthView oldMonthView) {
        this.uninstallPopup();
        this.updateMonthViewListeners(oldMonthView);
        TimeZone oldTimeZone = null;
        if (oldMonthView != null) {
            oldMonthView.setComponentInputMapEnabled(false);
            oldTimeZone = oldMonthView.getTimeZone();
        }
        this.datePicker.getMonthView().setComponentInputMapEnabled(true);
        this.updateTimeZone(oldTimeZone);
        this.updateEditorValue();
    }

    protected void updateFromEditorChanged(JFormattedTextField oldEditor, boolean updateListeners) {
        if (oldEditor != null) {
            this.datePicker.remove(oldEditor);
            oldEditor.putClientProperty("doNotCancelPopup", null);
        }
        this.datePicker.add(this.datePicker.getEditor());
        JComboBox box = new JComboBox();
        Object preventHide = box.getClientProperty("doNotCancelPopup");
        this.datePicker.getEditor().putClientProperty("doNotCancelPopup", preventHide);
        this.updateEditorValue();
        this.updateEditorProperties();
        if (updateListeners) {
            this.updateEditorListeners(oldEditor);
            this.datePicker.revalidate();
        }
    }

    private void updateEditorProperties() {
        this.datePicker.getEditor().setEnabled(this.datePicker.isEnabled());
        this.datePicker.getEditor().setEditable(this.datePicker.isEditable());
    }

    protected void updateFromSelectionModelChanged(DateSelectionModel oldModel) {
        this.updateSelectionModelListeners(oldModel);
        this.updateEditorValue();
    }

    private void updateEditorValue() {
        this.datePicker.getEditor().setValue(this.datePicker.getMonthView().getSelectionDate());
    }

    protected void updateFromEditableChanged() {
        boolean isEditable = this.datePicker.isEditable();
        this.datePicker.getMonthView().setEnabled(isEditable);
        this.datePicker.getEditor().setEditable(isEditable);
        this.setActionEnabled("commitHome", isEditable);
        this.setActionEnabled("navigateHome", isEditable);
    }

    protected void updateFromEnabledChanged() {
        boolean isEnabled = this.datePicker.isEnabled();
        this.popupButton.setEnabled(isEnabled);
        this.datePicker.getEditor().setEnabled(isEnabled);
    }

    private void setActionEnabled(String key, boolean enabled) {
        Action action = this.datePicker.getActionMap().get(key);
        if (action != null) {
            action.setEnabled(enabled);
        }
    }

    protected void updateFormatsFromTimeZone(TimeZone zone) {
        for (DateFormat format : this.datePicker.getFormats()) {
            format.setTimeZone(zone);
        }
    }

    protected void updateTimeZone(TimeZone old) {
        this.updateFormatsFromTimeZone(this.datePicker.getTimeZone());
        this.updateLinkDate();
    }

    protected void updateLinkDate() {
        this.datePicker.setLinkDay(this.datePicker.getMonthView().getToday());
    }

    protected void updateLocale() {
        Locale locale = this.datePicker.getLocale();
        this.updateFormatLocale(locale);
        this.updateChildLocale(locale);
    }

    private void updateFormatLocale(Locale locale) {
        if (locale != null && this.getCustomFormats(this.datePicker.getEditor()) == null) {
            this.datePicker.getEditor().setFormatterFactory(new DefaultFormatterFactory(new DatePickerFormatter.DatePickerFormatterUIResource(locale)));
        }
    }

    private void updateChildLocale(Locale locale) {
        if (locale != null) {
            this.datePicker.getEditor().setLocale(locale);
            this.datePicker.getLinkPanel().setLocale(locale);
            this.datePicker.getMonthView().setLocale(locale);
        }
    }

    protected void updateLinkPanel(JComponent oldLinkPanel) {
        if (oldLinkPanel != null) {
            this.uninstallLinkPanelKeyboardActions(oldLinkPanel);
        }
        this.installLinkPanelKeyboardActions();
        if (this.popup != null) {
            this.popup.updateLinkPanel(oldLinkPanel);
        }
    }

    protected void commit() {
        this.hidePopup();
        try {
            this.datePicker.commitEdit();
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    protected void cancel() {
        if (this.isPopupVisible()) {
            this.popup.putClientProperty("JPopupMenu.firePopupMenuCanceled", Boolean.TRUE);
        }
        this.hidePopup();
        this.datePicker.cancelEdit();
    }

    public void hidePopup() {
        if (this.popup != null) {
            this.popup.setVisible(false);
        }
    }

    public boolean isPopupVisible() {
        if (this.popup != null) {
            return this.popup.isVisible();
        }
        return false;
    }

    protected void home(boolean commit) {
        if (commit) {
            Calendar cal = this.datePicker.getMonthView().getCalendar();
            cal.setTime(this.datePicker.getLinkDay());
            this.datePicker.getMonthView().setSelectionDate(cal.getTime());
            this.datePicker.getMonthView().commitSelection();
        } else {
            this.datePicker.getMonthView().ensureDateVisible(this.datePicker.getLinkDay());
        }
    }

    private Action createCommitAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicDatePickerUI.this.commit();
            }
        };
        return action;
    }

    private Action createCancelAction() {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicDatePickerUI.this.cancel();
            }
        };
        return action;
    }

    private Action createHomeAction(final boolean commit) {
        AbstractAction action = new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                BasicDatePickerUI.this.home(commit);
            }
        };
        return action;
    }

    protected TogglePopupAction createTogglePopupAction() {
        return new TogglePopupAction();
    }

    public void toggleShowPopup() {
        if (this.popup == null) {
            this.installPopup();
        }
        if (this.popup.isVisible()) {
            this.popup.setVisible(false);
        } else {
            this.datePicker.getEditor().requestFocusInWindow();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    BasicDatePickerUI.this.popup.show(BasicDatePickerUI.this.datePicker, 0, BasicDatePickerUI.this.datePicker.getHeight());
                }
            });
        }
    }

    protected void installPopup() {
        this.popup = this.createMonthViewPopup();
        this.popup.addPopupMenuListener(this.getPopupMenuListener());
    }

    protected void uninstallPopup() {
        if (this.popup != null) {
            this.popup.removePopupMenuListener(this.getPopupMenuListener());
        }
        this.popup = null;
    }

    protected PopupMenuListener getPopupMenuListener() {
        if (this.popupMenuListener == null) {
            this.popupMenuListener = this.createPopupMenuListener();
        }
        return this.popupMenuListener;
    }

    protected PopupMenuListener createPopupMenuListener() {
        PopupMenuListener l = new PopupMenuListener(){

            @Override
            public void popupMenuCanceled(PopupMenuEvent e) {
                PopupMenuListener[] ls = BasicDatePickerUI.this.datePicker.getPopupMenuListeners();
                PopupMenuEvent retargeted = null;
                for (PopupMenuListener listener : ls) {
                    if (retargeted == null) {
                        retargeted = new PopupMenuEvent(BasicDatePickerUI.this.datePicker);
                    }
                    listener.popupMenuCanceled(retargeted);
                }
            }

            @Override
            public void popupMenuWillBecomeInvisible(PopupMenuEvent e) {
                PopupMenuListener[] ls = BasicDatePickerUI.this.datePicker.getPopupMenuListeners();
                PopupMenuEvent retargeted = null;
                for (PopupMenuListener listener : ls) {
                    if (retargeted == null) {
                        retargeted = new PopupMenuEvent(BasicDatePickerUI.this.datePicker);
                    }
                    listener.popupMenuWillBecomeInvisible(retargeted);
                }
            }

            @Override
            public void popupMenuWillBecomeVisible(PopupMenuEvent e) {
                PopupMenuListener[] ls = BasicDatePickerUI.this.datePicker.getPopupMenuListeners();
                PopupMenuEvent retargeted = null;
                for (PopupMenuListener listener : ls) {
                    if (retargeted == null) {
                        retargeted = new PopupMenuEvent(BasicDatePickerUI.this.datePicker);
                    }
                    listener.popupMenuWillBecomeVisible(retargeted);
                }
            }
        };
        return l;
    }

    private BasicDatePickerPopup createMonthViewPopup() {
        BasicDatePickerPopup popup = new BasicDatePickerPopup();
        popup.setLightWeightPopupEnabled(this.datePicker.isLightWeightPopupEnabled());
        return popup;
    }

    protected PropertyChangeListener createMonthViewPropertyListener() {
        return this.getHandler();
    }

    protected FocusListener createFocusListener() {
        return this.getHandler();
    }

    protected ActionListener createEditorActionListener() {
        return this.getHandler();
    }

    protected ActionListener createMonthViewActionListener() {
        return this.getHandler();
    }

    protected DateSelectionListener createMonthViewSelectionListener() {
        return this.getHandler();
    }

    protected PropertyChangeListener createEditorPropertyListener() {
        return this.getHandler();
    }

    private Handler getHandler() {
        if (this.handler == null) {
            this.handler = new Handler();
        }
        return this.handler;
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return this.getHandler();
    }

    protected LayoutManager createLayoutManager() {
        return this.getHandler();
    }

    protected MouseListener createMouseListener() {
        return this.getHandler();
    }

    protected MouseMotionListener createMouseMotionListener() {
        return this.getHandler();
    }

    public class PopupRemover
    implements PropertyChangeListener {
        private KeyboardFocusManager manager;
        private boolean loaded;

        public void load() {
            if (this.manager != KeyboardFocusManager.getCurrentKeyboardFocusManager()) {
                this.unload();
                this.manager = KeyboardFocusManager.getCurrentKeyboardFocusManager();
            }
            if (!this.loaded) {
                this.manager.addPropertyChangeListener("permanentFocusOwner", this);
                this.loaded = true;
            }
        }

        private void unload(boolean nullManager) {
            if (this.manager != null) {
                this.manager.removePropertyChangeListener("permanentFocusOwner", this);
                if (nullManager) {
                    this.manager = null;
                }
            }
            this.loaded = false;
        }

        public void unload() {
            this.unload(true);
        }

        @Override
        public void propertyChange(PropertyChangeEvent evt) {
            if (!BasicDatePickerUI.this.isPopupVisible()) {
                this.unload(false);
                return;
            }
            Component comp = this.manager.getPermanentFocusOwner();
            if (comp != null && !SwingXUtilities.isDescendingFrom(comp, BasicDatePickerUI.this.datePicker)) {
                this.unload(false);
                BasicDatePickerUI.this.hidePopup();
                comp.requestFocusInWindow();
            }
        }
    }

    private class Handler
    implements LayoutManager,
    MouseListener,
    MouseMotionListener,
    PropertyChangeListener,
    DateSelectionListener,
    ActionListener,
    FocusListener {
        private boolean _forwardReleaseEvent = false;

        private Handler() {
        }

        @Override
        public void mouseClicked(MouseEvent ev) {
        }

        @Override
        public void mousePressed(MouseEvent ev) {
            if (!BasicDatePickerUI.this.datePicker.isEnabled()) {
                return;
            }
            BasicDatePickerUI.this.toggleShowPopup();
        }

        @Override
        public void mouseReleased(MouseEvent ev) {
            if (!BasicDatePickerUI.this.datePicker.isEnabled() || !BasicDatePickerUI.this.datePicker.isEditable()) {
                return;
            }
            if (this._forwardReleaseEvent) {
                JXMonthView monthView = BasicDatePickerUI.this.datePicker.getMonthView();
                ev = SwingUtilities.convertMouseEvent(BasicDatePickerUI.this.popupButton, ev, monthView);
                monthView.dispatchEvent(ev);
                this._forwardReleaseEvent = false;
            }
        }

        @Override
        public void mouseEntered(MouseEvent ev) {
        }

        @Override
        public void mouseExited(MouseEvent ev) {
        }

        @Override
        public void mouseDragged(MouseEvent ev) {
            if (!BasicDatePickerUI.this.datePicker.isEnabled() || !BasicDatePickerUI.this.datePicker.isEditable()) {
                return;
            }
            this._forwardReleaseEvent = true;
            if (!BasicDatePickerUI.this.popup.isShowing()) {
                return;
            }
            JXMonthView monthView = BasicDatePickerUI.this.datePicker.getMonthView();
            ev = SwingUtilities.convertMouseEvent(BasicDatePickerUI.this.popupButton, ev, monthView);
            monthView.dispatchEvent(ev);
        }

        @Override
        public void mouseMoved(MouseEvent ev) {
        }

        @Override
        public void valueChanged(DateSelectionEvent ev) {
            BasicDatePickerUI.this.updateFromSelectionChanged(ev.getEventType(), ev.isAdjusting());
        }

        @Override
        public void propertyChange(PropertyChangeEvent e) {
            if (e.getSource() == BasicDatePickerUI.this.datePicker) {
                this.datePickerPropertyChange(e);
            } else if (e.getSource() == BasicDatePickerUI.this.datePicker.getEditor()) {
                this.editorPropertyChange(e);
            } else if (e.getSource() == BasicDatePickerUI.this.datePicker.getMonthView()) {
                this.monthViewPropertyChange(e);
            } else if (e.getSource() == BasicDatePickerUI.this.popupButton) {
                this.buttonPropertyChange(e);
            } else if ("value".equals(e.getPropertyName())) {
                throw new IllegalStateException("editor listening is moved to dedicated propertyChangeLisener");
            }
        }

        private void editorPropertyChange(PropertyChangeEvent evt) {
            if ("value".equals(evt.getPropertyName())) {
                BasicDatePickerUI.this.updateFromValueChanged((Date)evt.getOldValue(), (Date)evt.getNewValue());
            }
        }

        private void datePickerPropertyChange(PropertyChangeEvent e) {
            String property = e.getPropertyName();
            if ("date".equals(property)) {
                BasicDatePickerUI.this.updateFromDateChanged();
            } else if ("enabled".equals(property)) {
                BasicDatePickerUI.this.updateFromEnabledChanged();
            } else if ("editable".equals(property)) {
                BasicDatePickerUI.this.updateFromEditableChanged();
            } else if ("ToolTipText".equals(property)) {
                String tip = BasicDatePickerUI.this.datePicker.getToolTipText();
                BasicDatePickerUI.this.datePicker.getEditor().setToolTipText(tip);
                BasicDatePickerUI.this.popupButton.setToolTipText(tip);
            } else if ("monthView".equals(property)) {
                BasicDatePickerUI.this.updateFromMonthViewChanged((JXMonthView)e.getOldValue());
            } else if ("linkPanel".equals(property)) {
                BasicDatePickerUI.this.updateLinkPanel((JComponent)e.getOldValue());
            } else if ("editor".equals(property)) {
                BasicDatePickerUI.this.updateFromEditorChanged((JFormattedTextField)e.getOldValue(), true);
            } else if ("componentOrientation".equals(property)) {
                BasicDatePickerUI.this.datePicker.revalidate();
            } else if ("lightWeightPopupEnabled".equals(property)) {
                if (BasicDatePickerUI.this.popup != null) {
                    BasicDatePickerUI.this.popup.setVisible(false);
                }
                BasicDatePickerUI.this.uninstallPopup();
            } else if ("formats".equals(property)) {
                BasicDatePickerUI.this.updateFormatsFromTimeZone(BasicDatePickerUI.this.datePicker.getTimeZone());
            } else if ("locale".equals(property)) {
                BasicDatePickerUI.this.updateLocale();
            }
        }

        private void monthViewPropertyChange(PropertyChangeEvent e) {
            if ("selectionModel".equals(e.getPropertyName())) {
                BasicDatePickerUI.this.updateFromSelectionModelChanged((DateSelectionModel)e.getOldValue());
            } else if ("timeZone".equals(e.getPropertyName())) {
                BasicDatePickerUI.this.updateTimeZone((TimeZone)e.getOldValue());
            } else if ("today".equals(e.getPropertyName())) {
                BasicDatePickerUI.this.updateLinkDate();
            }
        }

        private void buttonPropertyChange(PropertyChangeEvent e) {
        }

        @Override
        public void addLayoutComponent(String name, Component comp) {
        }

        @Override
        public void removeLayoutComponent(Component comp) {
        }

        @Override
        public Dimension preferredLayoutSize(Container parent) {
            return parent.getPreferredSize();
        }

        @Override
        public Dimension minimumLayoutSize(Container parent) {
            return parent.getMinimumSize();
        }

        @Override
        public void layoutContainer(Container parent) {
            Insets insets = BasicDatePickerUI.this.datePicker.getInsets();
            int width = BasicDatePickerUI.this.datePicker.getWidth() - insets.left - insets.right;
            int height = BasicDatePickerUI.this.datePicker.getHeight() - insets.top - insets.bottom;
            int popupButtonWidth = BasicDatePickerUI.this.popupButton != null ? ((BasicDatePickerUI)BasicDatePickerUI.this).popupButton.getPreferredSize().width : 0;
            boolean ltr = BasicDatePickerUI.this.datePicker.getComponentOrientation().isLeftToRight();
            BasicDatePickerUI.this.datePicker.getEditor().setBounds(ltr ? insets.left : insets.left + popupButtonWidth, insets.top, width - popupButtonWidth, height);
            if (BasicDatePickerUI.this.popupButton != null) {
                BasicDatePickerUI.this.popupButton.setBounds(ltr ? width - popupButtonWidth + insets.left : insets.left, insets.top, popupButtonWidth, height);
            }
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (e == null) {
                return;
            }
            if (e.getSource() == BasicDatePickerUI.this.datePicker.getMonthView()) {
                this.monthViewActionPerformed(e);
            } else if (e.getSource() == BasicDatePickerUI.this.datePicker.getEditor()) {
                this.editorActionPerformed(e);
            }
        }

        private void editorActionPerformed(ActionEvent e) {
            BasicDatePickerUI.this.commit();
        }

        private void monthViewActionPerformed(ActionEvent e) {
            if ("monthViewCancel".equals(e.getActionCommand())) {
                BasicDatePickerUI.this.cancel();
            } else if ("monthViewCommit".equals(e.getActionCommand())) {
                BasicDatePickerUI.this.commit();
            }
        }

        @Override
        public void focusGained(FocusEvent e) {
            if (e.isTemporary()) {
                return;
            }
            BasicDatePickerUI.this.popupRemover.load();
            if (e.getSource() == BasicDatePickerUI.this.datePicker) {
                BasicDatePickerUI.this.datePicker.getEditor().requestFocusInWindow();
            }
        }

        @Override
        public void focusLost(FocusEvent e) {
        }
    }

    protected class BasicDatePickerPopup
    extends JPopupMenu {
        public BasicDatePickerPopup() {
            this.setLayout(new BorderLayout());
            this.add((Component)BasicDatePickerUI.this.datePicker.getMonthView(), "Center");
            this.updateLinkPanel(null);
        }

        public void updateLinkPanel(JComponent oldLinkPanel) {
            if (oldLinkPanel != null) {
                this.remove(oldLinkPanel);
            }
            if (BasicDatePickerUI.this.datePicker.getLinkPanel() != null) {
                this.add((Component)BasicDatePickerUI.this.datePicker.getLinkPanel(), "South");
            }
        }
    }

    private class TogglePopupAction
    extends AbstractAction {
        public TogglePopupAction() {
            super("TogglePopup");
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            BasicDatePickerUI.this.toggleShowPopup();
        }
    }

    public class EditorCancelAction
    extends AbstractAction {
        private JFormattedTextField editor;
        private Action cancelAction;
        public static final String TEXT_CANCEL_KEY = "reset-field-edit";

        public EditorCancelAction(JFormattedTextField field) {
            this.install(field);
        }

        public void uninstall() {
            this.editor.getActionMap().remove(TEXT_CANCEL_KEY);
            this.cancelAction = null;
            this.editor = null;
        }

        private void install(JFormattedTextField editor) {
            this.editor = editor;
            this.cancelAction = editor.getActionMap().get(TEXT_CANCEL_KEY);
            editor.getActionMap().put(TEXT_CANCEL_KEY, this);
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.cancelAction.actionPerformed(null);
            BasicDatePickerUI.this.cancel();
        }
    }

    private class DefaultEditor
    extends JFormattedTextField
    implements UIResource {
        public DefaultEditor(JFormattedTextField.AbstractFormatter formatter) {
            super(formatter);
        }

        @Override
        public Dimension getPreferredSize() {
            Dimension preferredSize = super.getPreferredSize();
            if (this.getColumns() <= 0) {
                Dimension compare = this.getCompareMinimumSize();
                if (preferredSize.width < compare.width) {
                    return compare;
                }
            }
            return preferredSize;
        }

        @Override
        public Dimension getMinimumSize() {
            return this.getPreferredSize();
        }

        private Dimension getCompareMinimumSize() {
            JFormattedTextField field = new JFormattedTextField(this.getFormatter());
            field.setMargin(this.getMargin());
            field.setBorder(this.getBorder());
            field.setFont(this.getFont());
            field.setValue(new Date());
            Dimension min = field.getPreferredSize();
            field.setValue(null);
            min.width += Math.max(field.getPreferredSize().width, 4);
            return min;
        }
    }
}

