/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs;

import com.intellij.CommonBundle;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.command.CommandEvent;
import com.intellij.openapi.command.CommandListener;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.NlsActions;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.AbstractVcsHelper;
import com.intellij.openapi.vcs.ExternallyAddedFilesProcessorImpl;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.openapi.vcs.ProjectConfigurationFilesProcessorImpl;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsBundle;
import com.intellij.openapi.vcs.VcsConfiguration;
import com.intellij.openapi.vcs.VcsFileListenerIgnoredFilesProvider;
import com.intellij.openapi.vcs.VcsShowConfirmationOption;
import com.intellij.openapi.vcs.changes.ChangeListManager;
import com.intellij.openapi.vcs.changes.VcsIgnoreManager;
import com.intellij.openapi.vcs.changes.ignore.IgnoreFilesProcessorImpl;
import com.intellij.openapi.vfs.AsyncFileListener;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VFileProperty;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileContentChangeEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCopyEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileDeleteEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.SmartList;
import com.intellij.util.concurrency.AppJavaExecutorUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Unit;
import kotlin.jvm.functions.Function1;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.CoroutineScopeKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class VcsVFSListener
implements Disposable {
    protected static final Logger LOG = Logger.getInstance(VcsVFSListener.class);
    private final ProjectLevelVcsManager myVcsManager;
    private final VcsIgnoreManager myVcsIgnoreManager;
    protected final Project myProject;
    protected final AbstractVcs myVcs;
    @NotNull
    protected final CoroutineScope coroutineScope;
    private boolean myShouldCancelScope;
    protected final ChangeListManager myChangeListManager;
    protected final VcsShowConfirmationOption myAddOption;
    protected final VcsShowConfirmationOption myRemoveOption;
    protected final StateProcessor myProcessor;
    private final ProjectConfigurationFilesProcessorImpl myProjectConfigurationFilesProcessor;
    private final ExternallyAddedFilesProcessorImpl myExternalFilesProcessor;
    private final IgnoreFilesProcessorImpl myIgnoreFilesProcessor;
    private final List<VFileEvent> myEventsToProcess;

    protected VcsVFSListener(@NotNull AbstractVcs vcs, @NotNull CoroutineScope coroutineScope) {
        if (vcs == null) {
            VcsVFSListener.$$$reportNull$$$0(0);
        }
        if (coroutineScope == null) {
            VcsVFSListener.$$$reportNull$$$0(1);
        }
        this.myShouldCancelScope = true;
        this.myProcessor = new StateProcessor();
        this.myEventsToProcess = new SmartList();
        this.myProject = vcs.getProject();
        this.myVcs = vcs;
        this.coroutineScope = coroutineScope;
        this.myChangeListManager = ChangeListManager.getInstance((Project)this.myProject);
        this.myVcsIgnoreManager = VcsIgnoreManager.getInstance((Project)this.myProject);
        this.myVcsManager = ProjectLevelVcsManager.getInstance((Project)this.myProject);
        this.myAddOption = this.myVcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.ADD, vcs);
        this.myRemoveOption = this.myVcsManager.getStandardConfirmation(VcsConfiguration.StandardConfirmation.REMOVE, vcs);
        this.myProjectConfigurationFilesProcessor = this.createProjectConfigurationFilesProcessor();
        this.myExternalFilesProcessor = this.createExternalFilesProcessor();
        this.myIgnoreFilesProcessor = this.createIgnoreFilesProcessor();
        AppJavaExecutorUtil.awaitCancellationAndDispose((CoroutineScope)coroutineScope, (Disposable)this);
    }

    protected void installListeners() {
        VirtualFileManager.getInstance().addAsyncFileListener((AsyncFileListener)new MyAsyncVfsListener(), (Disposable)this);
        this.myProject.getMessageBus().connect(this.coroutineScope).subscribe(CommandListener.TOPIC, (Object)new MyCommandAdapter());
        this.myProjectConfigurationFilesProcessor.install();
        this.myExternalFilesProcessor.install(this.coroutineScope);
        this.myIgnoreFilesProcessor.install(this.coroutineScope);
    }

    public void dispose() {
        if (this.myShouldCancelScope) {
            CoroutineScopeKt.cancel((CoroutineScope)this.coroutineScope, null);
        }
    }

    protected boolean isEventAccepted(@NotNull VFileEvent event) {
        if (event == null) {
            VcsVFSListener.$$$reportNull$$$0(2);
        }
        return !event.isFromRefresh() && event.getFileSystem() instanceof LocalFileSystem;
    }

    protected boolean isEventIgnored(@NotNull VFileEvent event) {
        FilePath filePath;
        if (event == null) {
            VcsVFSListener.$$$reportNull$$$0(3);
        }
        return !this.isUnderMyVcs(filePath = VcsVFSListener.getEventFilePath(event)) || this.myChangeListManager.isIgnoredFile(filePath);
    }

    protected boolean isUnderMyVcs(@Nullable VirtualFile file) {
        return file != null && (Boolean)ReadAction.compute(() -> !this.myProject.isDisposed() && this.myVcsManager.getVcsFor(file) == this.myVcs) != false;
    }

    protected boolean isUnderMyVcs(@Nullable FilePath filePath) {
        return filePath != null && (Boolean)ReadAction.compute(() -> !this.myProject.isDisposed() && this.myVcsManager.getVcsFor(filePath) == this.myVcs) != false;
    }

    @NotNull
    private static FilePath getEventFilePath(@NotNull VFileEvent event) {
        if (event == null) {
            VcsVFSListener.$$$reportNull$$$0(4);
        }
        if (event instanceof VFileCreateEvent) {
            VFileCreateEvent createEvent = (VFileCreateEvent)event;
            FilePath filePath = VcsUtil.getFilePath((String)event.getPath(), (boolean)createEvent.isDirectory());
            if (filePath == null) {
                VcsVFSListener.$$$reportNull$$$0(5);
            }
            return filePath;
        }
        VirtualFile file = event.getFile();
        if (file != null) {
            FilePath filePath = VcsUtil.getFilePath((String)event.getPath(), (boolean)file.isDirectory());
            if (filePath == null) {
                VcsVFSListener.$$$reportNull$$$0(6);
            }
            return filePath;
        }
        LOG.error("VFileEvent should have VirtualFile: " + String.valueOf(event));
        FilePath filePath = VcsUtil.getFilePath((String)event.getPath());
        if (filePath == null) {
            VcsVFSListener.$$$reportNull$$$0(7);
        }
        return filePath;
    }

    private boolean allowedDeletion(@NotNull VFileEvent event) {
        if (event == null) {
            VcsVFSListener.$$$reportNull$$$0(8);
        }
        return VcsFileListenerIgnoredFilesProvider.isDeletionAllowed((Project)this.myProject, (FilePath)VcsVFSListener.getEventFilePath(event));
    }

    private boolean allowedAddition(@NotNull VFileEvent event) {
        if (event == null) {
            VcsVFSListener.$$$reportNull$$$0(9);
        }
        return VcsFileListenerIgnoredFilesProvider.isAdditionAllowed((Project)this.myProject, (FilePath)VcsVFSListener.getEventFilePath(event));
    }

    @RequiresBackgroundThread
    protected void executeAdd() {
        ThreadingAssertions.assertBackgroundThread();
        List<VirtualFile> addedFiles = this.myProcessor.acquireAddedFiles();
        Map<VirtualFile, VirtualFile> copyFromMap = this.myProcessor.acquireCopiedFiles();
        LOG.debug("executeAdd. addedFiles: ", new Object[]{addedFiles});
        VcsShowConfirmationOption.Value addOption = this.myAddOption.getValue();
        if (addOption == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            return;
        }
        addedFiles.removeIf(arg_0 -> ((VcsIgnoreManager)this.myVcsIgnoreManager).isPotentiallyIgnoredFile(arg_0));
        if (addedFiles.isEmpty()) {
            return;
        }
        this.executeAdd(addedFiles, copyFromMap);
    }

    protected void executeAdd(@NotNull List<VirtualFile> addedFiles, @NotNull Map<VirtualFile, VirtualFile> copyFromMap) {
        if (addedFiles == null) {
            VcsVFSListener.$$$reportNull$$$0(10);
        }
        if (copyFromMap == null) {
            VcsVFSListener.$$$reportNull$$$0(11);
        }
        if (ApplicationManager.getApplication().isDispatchThread()) {
            ApplicationManager.getApplication().executeOnPooledThread(() -> this.performAddingWithConfirmation(addedFiles, copyFromMap));
        } else {
            this.performAddingWithConfirmation(addedFiles, copyFromMap);
        }
    }

    @RequiresBackgroundThread
    protected void performAddingWithConfirmation(@NotNull List<VirtualFile> addedFiles, @NotNull Map<VirtualFile, VirtualFile> copyFromMap) {
        if (addedFiles == null) {
            VcsVFSListener.$$$reportNull$$$0(12);
        }
        if (copyFromMap == null) {
            VcsVFSListener.$$$reportNull$$$0(13);
        }
        ThreadingAssertions.assertBackgroundThread();
        VcsShowConfirmationOption.Value addOption = this.myAddOption.getValue();
        LOG.debug("executeAdd. add-option: ", new Object[]{addOption, ", files to add: ", addedFiles});
        if (addOption == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            return;
        }
        List<VirtualFile> filesToProcess = this.selectFilesToAdd(addedFiles = this.myProjectConfigurationFilesProcessor.filterNotProjectConfigurationFiles(addedFiles));
        if (filesToProcess.isEmpty()) {
            return;
        }
        this.performAdding(filesToProcess, copyFromMap);
    }

    @RequiresBackgroundThread
    private void executeMoveRename() {
        ThreadingAssertions.assertBackgroundThread();
        List<MovedFileInfo> movedFiles = this.myProcessor.acquireMovedFiles();
        LOG.debug("executeMoveRename ", new Object[]{movedFiles});
        if (movedFiles.isEmpty()) {
            return;
        }
        this.performMoveRename(movedFiles);
    }

    @RequiresBackgroundThread
    protected void executeDelete() {
        ThreadingAssertions.assertBackgroundThread();
        List<FilePath> deletedFiles = this.myProcessor.acquireDeletedFiles();
        LOG.debug("executeDelete ", new Object[]{deletedFiles});
        VcsShowConfirmationOption.Value removeOption = this.myRemoveOption.getValue();
        if (removeOption == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            return;
        }
        deletedFiles.removeIf(arg_0 -> ((VcsIgnoreManager)this.myVcsIgnoreManager).isPotentiallyIgnoredFile(arg_0));
        List<FilePath> filesToProcess = this.selectFilePathsToDelete(deletedFiles);
        if (filesToProcess.isEmpty()) {
            return;
        }
        this.performDeletion(filesToProcess);
    }

    protected void saveUnsavedVcsIgnoreFiles() {
        FileDocumentManager fileDocumentManager = FileDocumentManager.getInstance();
        Set ignoreFileNames = VcsUtil.getVcsIgnoreFileNames((Project)this.myProject);
        for (Document document : fileDocumentManager.getUnsavedDocuments()) {
            VirtualFile file = fileDocumentManager.getFile(document);
            if (file == null || !ignoreFileNames.contains(file.getName())) continue;
            ApplicationManager.getApplication().invokeAndWait(() -> fileDocumentManager.saveDocument(document));
        }
    }

    @NotNull
    protected List<FilePath> selectFilePathsToDelete(@NotNull List<FilePath> deletedFiles) {
        if (deletedFiles == null) {
            VcsVFSListener.$$$reportNull$$$0(14);
        }
        return this.selectFilePathsForOption(this.myRemoveOption, deletedFiles, this.getDeleteTitle(), this.getSingleFileDeleteTitle(), this.getSingleFileDeletePromptTemplate(), CommonBundle.message((String)"button.delete", (Object[])new Object[0]), CommonBundle.getCancelButtonText());
    }

    @NotNull
    protected List<FilePath> selectFilePathsToAdd(@NotNull List<FilePath> addFiles) {
        if (addFiles == null) {
            VcsVFSListener.$$$reportNull$$$0(15);
        }
        return this.selectFilePathsForOption(this.myAddOption, addFiles, this.getAddTitle(), this.getSingleFileAddTitle(), this.getSingleFileAddPromptTemplate(), CommonBundle.getAddButtonText(), CommonBundle.getCancelButtonText());
    }

    @NotNull
    protected List<VirtualFile> selectFilesToAdd(@NotNull List<VirtualFile> addFiles) {
        if (addFiles == null) {
            VcsVFSListener.$$$reportNull$$$0(16);
        }
        return this.selectFilesForOption(this.myAddOption, addFiles, this.getAddTitle(), this.getSingleFileAddTitle(), this.getSingleFileAddPromptTemplate());
    }

    @NotNull
    private List<FilePath> selectFilePathsForOption(@NotNull VcsShowConfirmationOption option, @NotNull List<FilePath> files, @NlsContexts.DialogTitle String title, @NlsContexts.DialogTitle String singleFileTitle, @NlsContexts.DialogMessage String singleFilePromptTemplate, @NlsActions.ActionText @Nullable String okActionName, @NlsActions.ActionText @Nullable String cancelActionName) {
        VcsShowConfirmationOption.Value optionValue;
        if (option == null) {
            VcsVFSListener.$$$reportNull$$$0(17);
        }
        if (files == null) {
            VcsVFSListener.$$$reportNull$$$0(18);
        }
        if ((optionValue = option.getValue()) == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            List<FilePath> list = Collections.emptyList();
            if (list == null) {
                VcsVFSListener.$$$reportNull$$$0(19);
            }
            return list;
        }
        if (optionValue == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
            List<FilePath> list = files;
            if (list == null) {
                VcsVFSListener.$$$reportNull$$$0(20);
            }
            return list;
        }
        if (files.isEmpty()) {
            List<FilePath> list = Collections.emptyList();
            if (list == null) {
                VcsVFSListener.$$$reportNull$$$0(21);
            }
            return list;
        }
        AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)this.myProject);
        Ref ref = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> ref.set((Object)helper.selectFilePathsToProcess(files, title, null, singleFileTitle, singleFilePromptTemplate, option, okActionName, cancelActionName)));
        Collection selectedFilePaths = (Collection)ref.get();
        ArrayList<FilePath> arrayList = selectedFilePaths != null ? new ArrayList<FilePath>(selectedFilePaths) : Collections.emptyList();
        if (arrayList == null) {
            VcsVFSListener.$$$reportNull$$$0(22);
        }
        return arrayList;
    }

    @NotNull
    private List<VirtualFile> selectFilesForOption(@NotNull VcsShowConfirmationOption option, @NotNull List<VirtualFile> files, @NlsContexts.DialogTitle String title, @NlsContexts.DialogTitle String singleFileTitle, @NlsContexts.DialogMessage String singleFilePromptTemplate) {
        VcsShowConfirmationOption.Value optionValue;
        if (option == null) {
            VcsVFSListener.$$$reportNull$$$0(23);
        }
        if (files == null) {
            VcsVFSListener.$$$reportNull$$$0(24);
        }
        if ((optionValue = option.getValue()) == VcsShowConfirmationOption.Value.DO_NOTHING_SILENTLY) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                VcsVFSListener.$$$reportNull$$$0(25);
            }
            return list;
        }
        if (optionValue == VcsShowConfirmationOption.Value.DO_ACTION_SILENTLY) {
            List<VirtualFile> list = files;
            if (list == null) {
                VcsVFSListener.$$$reportNull$$$0(26);
            }
            return list;
        }
        if (files.isEmpty()) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                VcsVFSListener.$$$reportNull$$$0(27);
            }
            return list;
        }
        AbstractVcsHelper helper = AbstractVcsHelper.getInstance((Project)this.myProject);
        Ref ref = Ref.create();
        ApplicationManager.getApplication().invokeAndWait(() -> ref.set((Object)helper.selectFilesToProcess(files, title, null, singleFileTitle, singleFilePromptTemplate, option)));
        Collection selectedFiles = (Collection)ref.get();
        ArrayList<VirtualFile> arrayList = selectedFiles != null ? new ArrayList<VirtualFile>(selectedFiles) : Collections.emptyList();
        if (arrayList == null) {
            VcsVFSListener.$$$reportNull$$$0(28);
        }
        return arrayList;
    }

    protected boolean processBeforeContentsChange() {
        return false;
    }

    @RequiresEdt
    protected void beforeContentsChange(@NotNull List<VFileContentChangeEvent> events) {
        if (events == null) {
            VcsVFSListener.$$$reportNull$$$0(29);
        }
        ThreadingAssertions.assertEventDispatchThread();
    }

    @RequiresEdt
    protected void processMovedFile(@NotNull VirtualFile file, @NotNull String newParentPath, @NotNull String newName) {
        if (file == null) {
            VcsVFSListener.$$$reportNull$$$0(30);
        }
        if (newParentPath == null) {
            VcsVFSListener.$$$reportNull$$$0(31);
        }
        if (newName == null) {
            VcsVFSListener.$$$reportNull$$$0(32);
        }
        ThreadingAssertions.assertEventDispatchThread();
    }

    protected boolean filterOutByStatus(@NotNull FileStatus status) {
        if (status == null) {
            VcsVFSListener.$$$reportNull$$$0(33);
        }
        return status == FileStatus.IGNORED || status == FileStatus.UNKNOWN;
    }

    protected boolean shouldIgnoreDeletion(@NotNull FileStatus status) {
        if (status == null) {
            VcsVFSListener.$$$reportNull$$$0(34);
        }
        return false;
    }

    @NlsContexts.DialogTitle
    @NotNull
    protected abstract String getAddTitle();

    @NlsContexts.DialogTitle
    @NotNull
    protected abstract String getSingleFileAddTitle();

    @NlsContexts.DialogMessage
    @NotNull
    protected abstract String getSingleFileAddPromptTemplate();

    @NlsContexts.DialogTitle
    @NotNull
    protected abstract String getDeleteTitle();

    @NlsContexts.DialogTitle
    protected abstract String getSingleFileDeleteTitle();

    @NlsContexts.DialogMessage
    protected abstract String getSingleFileDeletePromptTemplate();

    protected abstract void performAdding(@NotNull Collection<VirtualFile> var1, @NotNull Map<VirtualFile, VirtualFile> var2);

    protected abstract void performDeletion(@NotNull List<FilePath> var1);

    protected abstract void performMoveRename(@NotNull List<MovedFileInfo> var1);

    protected boolean isRecursiveDeleteSupported() {
        return false;
    }

    protected boolean isFileCopyingFromTrackingSupported() {
        return true;
    }

    private ExternallyAddedFilesProcessorImpl createExternalFilesProcessor() {
        return new ExternallyAddedFilesProcessorImpl(this.myProject, this, this.myVcs, (Function1<? super Collection<? extends VirtualFile>, Unit>)((Function1)files -> {
            this.performAdding((Collection<VirtualFile>)files, Collections.emptyMap());
            return Unit.INSTANCE;
        }));
    }

    private ProjectConfigurationFilesProcessorImpl createProjectConfigurationFilesProcessor() {
        return new ProjectConfigurationFilesProcessorImpl(this.myProject, this, this.myVcs, (Function1<? super Collection<? extends VirtualFile>, Unit>)((Function1)files -> {
            this.performAdding((Collection<VirtualFile>)files, Collections.emptyMap());
            return Unit.INSTANCE;
        }));
    }

    private IgnoreFilesProcessorImpl createIgnoreFilesProcessor() {
        return new IgnoreFilesProcessorImpl(this.myProject, this, this.myVcs);
    }

    @TestOnly
    protected final void waitForEventsProcessedInTestMode() {
        this.myExternalFilesProcessor.waitForEventsProcessedInTestMode();
        this.myProjectConfigurationFilesProcessor.waitForEventsProcessedInTestMode();
        this.myIgnoreFilesProcessor.waitForEventsProcessedInTestMode();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 5, 6, 7, 19, 20, 21, 22, 25, 26, 27, 28 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "vcs";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "coroutineScope";
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 8: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/VcsVFSListener";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addedFiles";
                break;
            }
            case 11: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "copyFromMap";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "deletedFiles";
                break;
            }
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "addFiles";
                break;
            }
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "option";
                break;
            }
            case 18: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "files";
                break;
            }
            case 29: {
                objectArray2 = objectArray3;
                objectArray3[0] = "events";
                break;
            }
            case 30: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 31: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newParentPath";
                break;
            }
            case 32: {
                objectArray2 = objectArray3;
                objectArray3[0] = "newName";
                break;
            }
            case 33: 
            case 34: {
                objectArray2 = objectArray3;
                objectArray3[0] = "status";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/VcsVFSListener";
                break;
            }
            case 5: 
            case 6: 
            case 7: {
                objectArray = objectArray2;
                objectArray2[1] = "getEventFilePath";
                break;
            }
            case 19: 
            case 20: 
            case 21: 
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "selectFilePathsForOption";
                break;
            }
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                objectArray = objectArray2;
                objectArray2[1] = "selectFilesForOption";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "isEventAccepted";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isEventIgnored";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getEventFilePath";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 25: 
            case 26: 
            case 27: 
            case 28: {
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "allowedDeletion";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "allowedAddition";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "executeAdd";
                break;
            }
            case 12: 
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "performAddingWithConfirmation";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "selectFilePathsToDelete";
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "selectFilePathsToAdd";
                break;
            }
            case 16: {
                objectArray = objectArray;
                objectArray[2] = "selectFilesToAdd";
                break;
            }
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "selectFilePathsForOption";
                break;
            }
            case 23: 
            case 24: {
                objectArray = objectArray;
                objectArray[2] = "selectFilesForOption";
                break;
            }
            case 29: {
                objectArray = objectArray;
                objectArray[2] = "beforeContentsChange";
                break;
            }
            case 30: 
            case 31: 
            case 32: {
                objectArray = objectArray;
                objectArray[2] = "processMovedFile";
                break;
            }
            case 33: {
                objectArray = objectArray;
                objectArray[2] = "filterOutByStatus";
                break;
            }
            case 34: {
                objectArray = objectArray;
                objectArray[2] = "shouldIgnoreDeletion";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 5, 6, 7, 19, 20, 21, 22, 25, 26, 27, 28 -> new IllegalStateException(string);
        };
    }

    protected final class StateProcessor {
        private final Set<VirtualFile> myAddedFiles = new SmartHashSet();
        private final Map<VirtualFile, VirtualFile> myCopyFromMap = new HashMap<VirtualFile, VirtualFile>();
        private final Set<FilePath> myDeletedFiles = new SmartHashSet();
        private final Set<MovedFileInfo> myMovedFiles = new SmartHashSet();
        private final ReentrantReadWriteLock PROCESSING_LOCK = new ReentrantReadWriteLock();

        protected StateProcessor() {
        }

        @NotNull
        public List<VirtualFile> acquireAddedFiles() {
            return this.acquireListUnderLock(this.myAddedFiles);
        }

        @NotNull
        public List<MovedFileInfo> acquireMovedFiles() {
            return this.acquireListUnderLock(this.myMovedFiles);
        }

        @NotNull
        public List<FilePath> acquireDeletedFiles() {
            List list = (List)ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> {
                ArrayList<FilePath> deletedFiles = new ArrayList<FilePath>(this.myDeletedFiles);
                this.myDeletedFiles.clear();
                return deletedFiles;
            });
            if (list == null) {
                StateProcessor.$$$reportNull$$$0(0);
            }
            return list;
        }

        @NotNull
        private <T> List<T> acquireListUnderLock(@NotNull Collection<? extends T> files) {
            if (files == null) {
                StateProcessor.$$$reportNull$$$0(1);
            }
            List list = (List)ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> {
                ArrayList copiedFiles = new ArrayList(files);
                files.clear();
                return copiedFiles;
            });
            if (list == null) {
                StateProcessor.$$$reportNull$$$0(2);
            }
            return list;
        }

        @NotNull
        public Map<VirtualFile, VirtualFile> acquireCopiedFiles() {
            Map map2 = (Map)ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> {
                HashMap<VirtualFile, VirtualFile> copyFromMap = new HashMap<VirtualFile, VirtualFile>(this.myCopyFromMap);
                this.myCopyFromMap.clear();
                return copyFromMap;
            });
            if (map2 == null) {
                StateProcessor.$$$reportNull$$$0(3);
            }
            return map2;
        }

        private void clearAllPendingTasks() {
            ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> {
                this.myAddedFiles.clear();
                this.myCopyFromMap.clear();
                this.myDeletedFiles.clear();
                this.myMovedFiles.clear();
            });
        }

        @RequiresBackgroundThread
        private void checkMovedAddedSourceBack() {
            ThreadingAssertions.assertBackgroundThread();
            if (this.myAddedFiles.isEmpty() || this.myMovedFiles.isEmpty()) {
                return;
            }
            HashMap<String, VirtualFile> addedPaths = new HashMap<String, VirtualFile>(this.myAddedFiles.size());
            for (VirtualFile file : this.myAddedFiles) {
                addedPaths.put(file.getPath(), file);
            }
            Iterator<MovedFileInfo> iterator = this.myMovedFiles.iterator();
            while (iterator.hasNext()) {
                MovedFileInfo movedFile = iterator.next();
                VirtualFile oldAdded = (VirtualFile)addedPaths.get(movedFile.myOldPath);
                if (oldAdded == null) continue;
                iterator.remove();
                this.myAddedFiles.remove(oldAdded);
                this.myAddedFiles.add(movedFile.myFile);
                if (!VcsVFSListener.this.isFileCopyingFromTrackingSupported()) continue;
                this.myCopyFromMap.put(oldAdded, movedFile.myFile);
            }
        }

        @RequiresBackgroundThread
        private void doNotDeleteAddedCopiedOrMovedFiles() {
            ThreadingAssertions.assertBackgroundThread();
            if (this.myDeletedFiles.isEmpty()) {
                return;
            }
            HashSet<String> copiedAddedMoved = new HashSet<String>();
            for (VirtualFile file : this.myCopyFromMap.keySet()) {
                copiedAddedMoved.add(file.getPath());
            }
            for (VirtualFile file : this.myAddedFiles) {
                copiedAddedMoved.add(file.getPath());
            }
            for (MovedFileInfo movedFileInfo : this.myMovedFiles) {
                copiedAddedMoved.add(movedFileInfo.myNewPath);
            }
            this.myDeletedFiles.removeIf(path -> copiedAddedMoved.contains(path.getPath()));
        }

        private boolean isAnythingToProcess() {
            return (Boolean)ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.readLock(), () -> !this.myAddedFiles.isEmpty() || !this.myDeletedFiles.isEmpty() || !this.myMovedFiles.isEmpty());
        }

        @RequiresBackgroundThread
        private void executePendingTasks() {
            ThreadingAssertions.assertBackgroundThread();
            ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> {
                this.doNotDeleteAddedCopiedOrMovedFiles();
                this.checkMovedAddedSourceBack();
            });
            VcsVFSListener.this.executeAdd();
            VcsVFSListener.this.executeDelete();
            VcsVFSListener.this.executeMoveRename();
        }

        @RequiresBackgroundThread
        private void processFileCreated(@NotNull VFileCreateEvent event) {
            if (event == null) {
                StateProcessor.$$$reportNull$$$0(4);
            }
            ThreadingAssertions.assertBackgroundThread();
            if (LOG.isDebugEnabled()) {
                LOG.debug("fileCreated: ", new Object[]{event.getFile()});
            }
            if (!event.isDirectory()) {
                VirtualFile file = event.getFile();
                if (file == null) {
                    return;
                }
                LOG.debug("Adding [", new Object[]{file, "] to added files"});
                ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> this.myAddedFiles.add(file));
            }
        }

        @RequiresBackgroundThread
        private void processFileMoved(@NotNull VFileMoveEvent event) {
            if (event == null) {
                StateProcessor.$$$reportNull$$$0(5);
            }
            ThreadingAssertions.assertBackgroundThread();
            VirtualFile file = event.getFile();
            VirtualFile oldParent = event.getOldParent();
            if (!VcsVFSListener.this.isUnderMyVcs(oldParent)) {
                ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> this.myAddedFiles.add(file));
            }
        }

        @RequiresBackgroundThread
        private void processFileCopied(@NotNull VFileCopyEvent event) {
            if (event == null) {
                StateProcessor.$$$reportNull$$$0(6);
            }
            ThreadingAssertions.assertBackgroundThread();
            VirtualFile newFile = event.getNewParent().findChild(event.getNewChildName());
            if (newFile == null || VcsVFSListener.this.myChangeListManager.isIgnoredFile(newFile)) {
                return;
            }
            VirtualFile originalFile = event.getFile();
            if (VcsVFSListener.this.isFileCopyingFromTrackingSupported() && VcsVFSListener.this.isUnderMyVcs(originalFile)) {
                ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> {
                    this.myAddedFiles.add(newFile);
                    this.myCopyFromMap.put(newFile, originalFile);
                });
            } else {
                ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> this.myAddedFiles.add(newFile));
            }
        }

        @RequiresEdt
        private void processBeforeDeletedFile(@NotNull VFileDeleteEvent event) {
            if (event == null) {
                StateProcessor.$$$reportNull$$$0(7);
            }
            ThreadingAssertions.assertEventDispatchThread();
            this.processBeforeDeletedFile(event.getFile());
        }

        private void processBeforeDeletedFile(@NotNull VirtualFile file) {
            if (file == null) {
                StateProcessor.$$$reportNull$$$0(8);
            }
            if (file.isDirectory() && file instanceof NewVirtualFile && !VcsVFSListener.this.isRecursiveDeleteSupported()) {
                for (VirtualFile child : ((NewVirtualFile)file).getCachedChildren()) {
                    ProgressManager.checkCanceled();
                    FileStatus status = VcsVFSListener.this.myChangeListManager.getStatus(child);
                    if (VcsVFSListener.this.filterOutByStatus(status)) continue;
                    this.processBeforeDeletedFile(child);
                }
            } else {
                FileStatus status = VcsVFSListener.this.myChangeListManager.getStatus(file);
                if (VcsVFSListener.this.filterOutByStatus(status) || VcsVFSListener.this.shouldIgnoreDeletion(status)) {
                    return;
                }
                FilePath filePath = VcsUtil.getFilePath((VirtualFile)file);
                ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> this.myDeletedFiles.add(filePath));
            }
        }

        @RequiresEdt
        private void processMovedFile(@NotNull VirtualFile file, @NotNull String newParentPath, @NotNull String newName) {
            if (file == null) {
                StateProcessor.$$$reportNull$$$0(9);
            }
            if (newParentPath == null) {
                StateProcessor.$$$reportNull$$$0(10);
            }
            if (newName == null) {
                StateProcessor.$$$reportNull$$$0(11);
            }
            ThreadingAssertions.assertEventDispatchThread();
            FileStatus status = VcsVFSListener.this.myChangeListManager.getStatus(file);
            LOG.debug("Checking moved file ", new Object[]{file, "; status=", status});
            String newPath = newParentPath + "/" + newName;
            ConcurrencyUtil.withLock((Lock)this.PROCESSING_LOCK.writeLock(), () -> {
                if (!VcsVFSListener.this.filterOutByStatus(status)) {
                    MovedFileInfo existingMovedFile = (MovedFileInfo)ContainerUtil.find(this.myMovedFiles, info -> Comparing.equal((Object)info.myFile, (Object)file));
                    if (existingMovedFile != null) {
                        LOG.debug("Reusing existing moved file [" + String.valueOf(file) + "] with new path [" + newPath + "]");
                        existingMovedFile.myNewPath = newPath;
                    } else {
                        LOG.debug("Registered moved file ", new Object[]{file});
                        this.myMovedFiles.add(new MovedFileInfo(file, newPath));
                    }
                } else {
                    this.myDeletedFiles.remove(VcsUtil.getFilePath((String)newPath, (boolean)file.isDirectory()));
                }
            });
        }

        @RequiresEdt
        private void processBeforeFileMovement(@NotNull VFileMoveEvent event) {
            if (event == null) {
                StateProcessor.$$$reportNull$$$0(12);
            }
            ThreadingAssertions.assertEventDispatchThread();
            VirtualFile file = event.getFile();
            if (VcsVFSListener.this.isUnderMyVcs(event.getNewParent())) {
                LOG.debug("beforeFileMovement ", new Object[]{event, " into same vcs"});
                this.addFileToMove(file, event.getNewParent().getPath(), file.getName());
            } else {
                LOG.debug("beforeFileMovement ", new Object[]{event, " into different vcs"});
                VcsVFSListener.this.myProcessor.processBeforeDeletedFile(file);
            }
        }

        @RequiresEdt
        private void processBeforePropertyChange(@NotNull VFilePropertyChangeEvent event) {
            if (event == null) {
                StateProcessor.$$$reportNull$$$0(13);
            }
            ThreadingAssertions.assertEventDispatchThread();
            if (event.isRename()) {
                LOG.debug("before file rename ", new Object[]{event});
                String newName = (String)event.getNewValue();
                VirtualFile file = event.getFile();
                VirtualFile parent = file.getParent();
                if (parent != null) {
                    this.addFileToMove(file, parent.getPath(), newName);
                }
            }
        }

        @RequiresEdt
        private void addFileToMove(@NotNull VirtualFile file, @NotNull String newParentPath, @NotNull String newName) {
            if (file == null) {
                StateProcessor.$$$reportNull$$$0(14);
            }
            if (newParentPath == null) {
                StateProcessor.$$$reportNull$$$0(15);
            }
            if (newName == null) {
                StateProcessor.$$$reportNull$$$0(16);
            }
            ThreadingAssertions.assertEventDispatchThread();
            if (file.isDirectory() && !file.is(VFileProperty.SYMLINK)) {
                VirtualFile[] children = file.getChildren();
                if (children != null) {
                    for (VirtualFile child : children) {
                        ProgressManager.checkCanceled();
                        this.addFileToMove(child, newParentPath + "/" + newName, child.getName());
                    }
                }
            } else {
                VcsVFSListener.this.processMovedFile(file, newParentPath, newName);
                VcsVFSListener.this.myProcessor.processMovedFile(file, newParentPath, newName);
            }
        }

        @RequiresEdt
        private void processBeforeEvents(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                StateProcessor.$$$reportNull$$$0(17);
            }
            ThreadingAssertions.assertEventDispatchThread();
            for (VFileEvent vFileEvent : events) {
                if (VcsVFSListener.this.isEventIgnored(vFileEvent)) continue;
                if (vFileEvent instanceof VFileDeleteEvent && VcsVFSListener.this.allowedDeletion(vFileEvent)) {
                    this.processBeforeDeletedFile((VFileDeleteEvent)vFileEvent);
                    continue;
                }
                if (vFileEvent instanceof VFileMoveEvent) {
                    this.processBeforeFileMovement((VFileMoveEvent)vFileEvent);
                    continue;
                }
                if (!(vFileEvent instanceof VFilePropertyChangeEvent)) continue;
                this.processBeforePropertyChange((VFilePropertyChangeEvent)vFileEvent);
            }
        }

        @RequiresBackgroundThread
        private void processAfterEvents(@NotNull List<? extends VFileEvent> events) {
            if (events == null) {
                StateProcessor.$$$reportNull$$$0(18);
            }
            ThreadingAssertions.assertBackgroundThread();
            for (VFileEvent vFileEvent : events) {
                ProgressManager.checkCanceled();
                if (VcsVFSListener.this.isEventIgnored(vFileEvent)) continue;
                if (vFileEvent instanceof VFileCreateEvent) {
                    this.processFileCreated((VFileCreateEvent)vFileEvent);
                    continue;
                }
                if (vFileEvent instanceof VFileCopyEvent) {
                    this.processFileCopied((VFileCopyEvent)vFileEvent);
                    continue;
                }
                if (!(vFileEvent instanceof VFileMoveEvent)) continue;
                this.processFileMoved((VFileMoveEvent)vFileEvent);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 2;
                case 1, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18 -> 3;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/VcsVFSListener$StateProcessor";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "files";
                    break;
                }
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 12: 
                case 13: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 8: 
                case 9: 
                case 14: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 10: 
                case 15: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newParentPath";
                    break;
                }
                case 11: 
                case 16: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newName";
                    break;
                }
                case 17: 
                case 18: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "acquireDeletedFiles";
                    break;
                }
                case 1: 
                case 4: 
                case 5: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 11: 
                case 12: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 18: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/VcsVFSListener$StateProcessor";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "acquireListUnderLock";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "acquireCopiedFiles";
                    break;
                }
            }
            switch (n) {
                default: {
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "acquireListUnderLock";
                    break;
                }
                case 4: {
                    objectArray = objectArray;
                    objectArray[2] = "processFileCreated";
                    break;
                }
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "processFileMoved";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "processFileCopied";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "processBeforeDeletedFile";
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    objectArray = objectArray;
                    objectArray[2] = "processMovedFile";
                    break;
                }
                case 12: {
                    objectArray = objectArray;
                    objectArray[2] = "processBeforeFileMovement";
                    break;
                }
                case 13: {
                    objectArray = objectArray;
                    objectArray[2] = "processBeforePropertyChange";
                    break;
                }
                case 14: 
                case 15: 
                case 16: {
                    objectArray = objectArray;
                    objectArray[2] = "addFileToMove";
                    break;
                }
                case 17: {
                    objectArray = objectArray;
                    objectArray[2] = "processBeforeEvents";
                    break;
                }
                case 18: {
                    objectArray = objectArray;
                    objectArray[2] = "processAfterEvents";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalStateException(string);
                case 1, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18 -> new IllegalArgumentException(string);
            };
        }
    }

    private class MyAsyncVfsListener
    implements AsyncFileListener {
        private MyAsyncVfsListener() {
        }

        private static boolean isBeforeEvent(@NotNull VFileEvent event) {
            if (event == null) {
                MyAsyncVfsListener.$$$reportNull$$$0(0);
            }
            return event instanceof VFileDeleteEvent || event instanceof VFileMoveEvent || event instanceof VFilePropertyChangeEvent;
        }

        private static boolean isAfterEvent(@NotNull VFileEvent event) {
            if (event == null) {
                MyAsyncVfsListener.$$$reportNull$$$0(1);
            }
            return event instanceof VFileCreateEvent || event instanceof VFileCopyEvent || event instanceof VFileMoveEvent;
        }

        @Nullable
        public AsyncFileListener.ChangeApplier prepareChange(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
            if (events == null) {
                MyAsyncVfsListener.$$$reportNull$$$0(2);
            }
            final ArrayList<VFileContentChangeEvent> contentChangedEvents = new ArrayList<VFileContentChangeEvent>();
            final ArrayList<VFileEvent> beforeEvents = new ArrayList<VFileEvent>();
            final ArrayList<VFileEvent> afterEvents = new ArrayList<VFileEvent>();
            for (VFileEvent vFileEvent : events) {
                ProgressManager.checkCanceled();
                if (vFileEvent instanceof VFileContentChangeEvent) {
                    VirtualFile file;
                    VFileContentChangeEvent contentChangeEvent = (VFileContentChangeEvent)vFileEvent;
                    if (!VcsVFSListener.this.processBeforeContentsChange() || !VcsVFSListener.this.isUnderMyVcs(file = contentChangeEvent.getFile())) continue;
                    contentChangedEvents.add(contentChangeEvent);
                    continue;
                }
                if (!VcsVFSListener.this.isEventAccepted(vFileEvent)) continue;
                if (MyAsyncVfsListener.isBeforeEvent(vFileEvent)) {
                    beforeEvents.add(vFileEvent);
                }
                if (!MyAsyncVfsListener.isAfterEvent(vFileEvent)) continue;
                afterEvents.add(vFileEvent);
            }
            if (contentChangedEvents.isEmpty() && beforeEvents.isEmpty() && afterEvents.isEmpty()) {
                return null;
            }
            return new AsyncFileListener.ChangeApplier(){

                public void beforeVfsChange() {
                    VcsVFSListener.this.beforeContentsChange(contentChangedEvents);
                    VcsVFSListener.this.myProcessor.processBeforeEvents(beforeEvents);
                }

                public void afterVfsChange() {
                    VcsVFSListener.this.myEventsToProcess.addAll(afterEvents);
                }
            };
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "event";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "events";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/openapi/vcs/VcsVFSListener$MyAsyncVfsListener";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isBeforeEvent";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[2] = "isAfterEvent";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[2] = "prepareChange";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private class MyCommandAdapter
    implements CommandListener {
        private MyCommandAdapter() {
        }

        public void commandFinished(@NotNull CommandEvent event) {
            if (event == null) {
                MyCommandAdapter.$$$reportNull$$$0(0);
            }
            if (VcsVFSListener.this.myProject != event.getProject()) {
                return;
            }
            List afterEvents = ContainerUtil.filter(VcsVFSListener.this.myEventsToProcess, e -> !(e instanceof VFileCreateEvent) || VcsVFSListener.this.allowedAddition((VFileEvent)e));
            VcsVFSListener.this.myEventsToProcess.clear();
            if (afterEvents.isEmpty() && !VcsVFSListener.this.myProcessor.isAnythingToProcess()) {
                return;
            }
            this.processEventsInBackground(afterEvents);
        }

        private void processEventsInBackground(final List<? extends VFileEvent> events) {
            new Task.Backgroundable(VcsVFSListener.this.myProject, VcsBundle.message((String)"progress.title.version.control.processing.changed.files", (Object[])new Object[0]), true){

                public void run(@NotNull ProgressIndicator indicator) {
                    if (indicator == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    try {
                        indicator.checkCanceled();
                        VcsVFSListener.this.myProcessor.processAfterEvents(events);
                        VcsVFSListener.this.myProcessor.executePendingTasks();
                    }
                    catch (ProcessCanceledException e) {
                        VcsVFSListener.this.myProcessor.clearAllPendingTasks();
                    }
                }

                public boolean isHeadless() {
                    return false;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "indicator", "com/intellij/openapi/vcs/VcsVFSListener$MyCommandAdapter$1", "run"));
                }
            }.queue();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/openapi/vcs/VcsVFSListener$MyCommandAdapter", "commandFinished"));
        }
    }

    protected static final class MovedFileInfo {
        @NotNull
        public final String myOldPath;
        @NotNull
        public String myNewPath;
        @NotNull
        private final VirtualFile myFile;

        MovedFileInfo(@NotNull VirtualFile file, @NotNull String newPath) {
            if (file == null) {
                MovedFileInfo.$$$reportNull$$$0(0);
            }
            if (newPath == null) {
                MovedFileInfo.$$$reportNull$$$0(1);
            }
            this.myOldPath = file.getPath();
            this.myNewPath = newPath;
            this.myFile = file;
        }

        public String toString() {
            return String.format("MovedFileInfo{[%s] -> [%s]}", this.myOldPath, this.myNewPath);
        }

        public boolean isCaseSensitive() {
            return this.myFile.isCaseSensitive();
        }

        @NotNull
        public FilePath getOldPath() {
            FilePath filePath = VcsUtil.getFilePath((String)this.myOldPath, (boolean)this.myFile.isDirectory());
            if (filePath == null) {
                MovedFileInfo.$$$reportNull$$$0(2);
            }
            return filePath;
        }

        @NotNull
        public FilePath getNewPath() {
            FilePath filePath = VcsUtil.getFilePath((String)this.myNewPath, (boolean)this.myFile.isDirectory());
            if (filePath == null) {
                MovedFileInfo.$$$reportNull$$$0(3);
            }
            return filePath;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "newPath";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/openapi/vcs/VcsVFSListener$MovedFileInfo";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/openapi/vcs/VcsVFSListener$MovedFileInfo";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getOldPath";
                    break;
                }
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNewPath";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

