/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.changes;

import com.intellij.openapi.components.Service;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsRoot;
import com.intellij.openapi.vcs.changes.FilesAndDirs;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeManagerImpl;
import com.intellij.openapi.vcs.changes.VcsDirtyScopeVfsListenerKt;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.events.VFileCreateEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.openapi.vfs.newvfs.events.VFileMoveEvent;
import com.intellij.openapi.vfs.newvfs.events.VFilePropertyChangeEvent;
import com.intellij.vcsUtil.VcsUtil;
import com.intellij.vfs.AsyncVfsEventsListener;
import com.intellij.vfs.AsyncVfsEventsPostProcessor;
import com.intellij.vfs.AsyncVfsEventsPostProcessorImpl;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Job;
import kotlinx.coroutines.JobKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

@Service(value={Service.Level.PROJECT})
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0007\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0010\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\tH\u0007J\b\u0010\r\u001a\u00020\u000bH\u0007J\u001c\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0096@\u00a2\u0006\u0002\u0010\u0012R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/intellij/openapi/vcs/changes/VcsDirtyScopeVfsListener;", "Lcom/intellij/vfs/AsyncVfsEventsListener;", "project", "Lcom/intellij/openapi/project/Project;", "coroutineScope", "Lkotlinx/coroutines/CoroutineScope;", "<init>", "(Lcom/intellij/openapi/project/Project;Lkotlinx/coroutines/CoroutineScope;)V", "isForbid", "", "setForbid", "", "forbid", "waitForAsyncTaskCompletion", "filesChanged", "events", "", "Lcom/intellij/openapi/vfs/newvfs/events/VFileEvent;", "(Ljava/util/List;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "intellij.platform.vcs.impl"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nVcsDirtyScopeVfsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsDirtyScopeVfsListener.kt\ncom/intellij/openapi/vcs/changes/VcsDirtyScopeVfsListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,139:1\n23#2:140\n1#3:141\n*S KotlinDebug\n*F\n+ 1 VcsDirtyScopeVfsListener.kt\ncom/intellij/openapi/vcs/changes/VcsDirtyScopeVfsListener\n*L\n44#1:140\n*E\n"})
public final class VcsDirtyScopeVfsListener
implements AsyncVfsEventsListener {
    @NotNull
    private final Project project;
    private boolean isForbid;

    public VcsDirtyScopeVfsListener(@NotNull Project project, @NotNull CoroutineScope coroutineScope) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)coroutineScope, (String)"coroutineScope");
        this.project = project;
        AsyncVfsEventsPostProcessor.getInstance().addListener((AsyncVfsEventsListener)this, coroutineScope);
    }

    @TestOnly
    public final void setForbid(boolean forbid) {
        this.isForbid = forbid;
    }

    @TestOnly
    public final void waitForAsyncTaskCompletion() {
        VcsDirtyScopeVfsListener $this$thisLogger$iv = this;
        boolean $i$f$thisLogger = false;
        Logger logger = Logger.getInstance(VcsDirtyScopeVfsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        logger.debug("waitForAsyncTaskCompletion");
        AsyncVfsEventsPostProcessorImpl.Companion.waitEventsProcessed();
    }

    @Nullable
    public Object filesChanged(@NotNull List<? extends VFileEvent> events, @NotNull Continuation<? super Unit> $completion) {
        ProjectLevelVcsManager vcsManager = ProjectLevelVcsManager.Companion.getInstance(this.project);
        if (this.isForbid || !vcsManager.hasActiveVcss()) {
            return Unit.INSTANCE;
        }
        FilesAndDirs dirtyFilesAndDirs = new FilesAndDirs();
        for (VFileEvent vFileEvent : events) {
            JobKt.ensureActive((Job)JobKt.getJob((CoroutineContext)$completion.getContext()));
            boolean isDirectory = false;
            if (vFileEvent instanceof VFileCreateEvent) {
                if (!((VFileCreateEvent)vFileEvent).getParent().isInLocalFileSystem()) continue;
                isDirectory = ((VFileCreateEvent)vFileEvent).isDirectory();
            } else {
                VirtualFile file;
                if (vFileEvent.getFile() == null) {
                    boolean bl = false;
                    String string = "All events but VFileCreateEvent have @NotNull getFile()";
                    throw new IllegalArgumentException(string.toString());
                }
                if (!file.isInLocalFileSystem()) continue;
                isDirectory = file.isDirectory();
            }
            if (vFileEvent instanceof VFileMoveEvent) {
                FilePath filePath = VcsUtil.getFilePath((String)((VFileMoveEvent)vFileEvent).getOldPath(), (boolean)isDirectory);
                Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
                VcsDirtyScopeVfsListenerKt.add$default(vcsManager, dirtyFilesAndDirs, filePath, false, 8, null);
                FilePath filePath2 = VcsUtil.getFilePath((String)((VFileMoveEvent)vFileEvent).getNewPath(), (boolean)isDirectory);
                Intrinsics.checkNotNullExpressionValue((Object)filePath2, (String)"getFilePath(...)");
                VcsDirtyScopeVfsListenerKt.add$default(vcsManager, dirtyFilesAndDirs, filePath2, false, 8, null);
                continue;
            }
            if (vFileEvent instanceof VFilePropertyChangeEvent && ((VFilePropertyChangeEvent)vFileEvent).isRename()) {
                FilePath newPath;
                FilePath oldPath;
                Intrinsics.checkNotNullExpressionValue((Object)VcsUtil.getFilePath((String)((VFilePropertyChangeEvent)vFileEvent).getOldPath(), (boolean)isDirectory), (String)"getFilePath(...)");
                Intrinsics.checkNotNullExpressionValue((Object)VcsUtil.getFilePath((String)((VFilePropertyChangeEvent)vFileEvent).getNewPath(), (boolean)isDirectory), (String)"getFilePath(...)");
                VcsDirtyScopeVfsListenerKt.access$addWithParentDirectory(vcsManager, dirtyFilesAndDirs, oldPath);
                VcsDirtyScopeVfsListenerKt.add$default(vcsManager, dirtyFilesAndDirs, newPath, false, 8, null);
                continue;
            }
            FilePath filePath = VcsUtil.getFilePath((String)vFileEvent.getPath(), (boolean)isDirectory);
            Intrinsics.checkNotNullExpressionValue((Object)filePath, (String)"getFilePath(...)");
            VcsDirtyScopeVfsListenerKt.add$default(vcsManager, dirtyFilesAndDirs, filePath, false, 8, null);
        }
        VcsDirtyScopeManagerImpl dirtyScopeManager = VcsDirtyScopeManagerImpl.Companion.getInstanceImpl(this.project);
        Map<VcsRoot, Set<FilePath>> map2 = dirtyFilesAndDirs.files.asMap();
        Intrinsics.checkNotNullExpressionValue(map2, (String)"asMap(...)");
        Map<VcsRoot, Set<FilePath>> map3 = dirtyFilesAndDirs.dirs.asMap();
        Intrinsics.checkNotNullExpressionValue(map3, (String)"asMap(...)");
        dirtyScopeManager.fileVcsPathsDirty$intellij_platform_vcs_impl(map2, map3);
        return Unit.INSTANCE;
    }
}

