/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.vcs.update.FileOrDirectoryTreeNode;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.pointers.VirtualFilePointer;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSetBase;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.util.PlatformIcons;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Set;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class FileTreeNode
extends FileOrDirectoryTreeNode {
    private static final Collection<VirtualFile> EMPTY_VIRTUAL_FILE_ARRAY = new ArrayList<VirtualFile>();

    public FileTreeNode(@NotNull String path, @NotNull SimpleTextAttributes invalidAttributes, @NotNull Project project, String parentPath) {
        if (path == null) {
            FileTreeNode.$$$reportNull$$$0(0);
        }
        if (invalidAttributes == null) {
            FileTreeNode.$$$reportNull$$$0(1);
        }
        if (project == null) {
            FileTreeNode.$$$reportNull$$$0(2);
        }
        super(path, invalidAttributes, project, parentPath);
    }

    @Override
    public Icon getIcon(boolean expanded) {
        if (this.myFile.isDirectory()) {
            return PlatformIcons.FOLDER_ICON;
        }
        return FileTypeManager.getInstance().getFileTypeByFileName(this.myFile.getName()).getIcon();
    }

    @Override
    protected boolean acceptFilter(@Nullable Pair<PackageSetBase, NamedScopesHolder> filter, boolean showOnlyFilteredItems) {
        try {
            VirtualFilePointer filePointer = this.getFilePointer();
            if (!filePointer.isValid()) {
                return false;
            }
            VirtualFile file = filePointer.getFile();
            if (file != null && file.isValid() && filter != null && ((PackageSetBase)filter.first).contains(file, this.getProject(), (NamedScopesHolder)filter.second)) {
                this.applyFilter(true);
                return true;
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return false;
    }

    @Override
    @NotNull
    public Collection<VirtualFile> getVirtualFiles() {
        VirtualFile virtualFile = this.getFilePointer().getFile();
        if (virtualFile == null) {
            Collection<VirtualFile> collection = EMPTY_VIRTUAL_FILE_ARRAY;
            if (collection == null) {
                FileTreeNode.$$$reportNull$$$0(3);
            }
            return collection;
        }
        Set<VirtualFile> set2 = Collections.singleton(virtualFile);
        if (set2 == null) {
            FileTreeNode.$$$reportNull$$$0(4);
        }
        return set2;
    }

    @Override
    @NotNull
    public Collection<File> getFiles() {
        if (this.getFilePointer().getFile() == null) {
            Set<File> set2 = Collections.singleton(this.myFile);
            if (set2 == null) {
                FileTreeNode.$$$reportNull$$$0(5);
            }
            return set2;
        }
        ArrayList arrayList = EMPTY_FILE_ARRAY;
        if (arrayList == null) {
            FileTreeNode.$$$reportNull$$$0(6);
        }
        return arrayList;
    }

    @Override
    protected int getItemsCount() {
        return 1;
    }

    @Override
    protected boolean showStatistics() {
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "invalidAttributes";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/vcs/update/FileTreeNode";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/vcs/update/FileTreeNode";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getVirtualFiles";
                break;
            }
            case 5: 
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getFiles";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6 -> new IllegalStateException(string);
        };
    }
}

