/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.vcs.update;

import com.intellij.ide.errorTreeView.HotfixData;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.components.ServicesKt;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.progress.CoroutinesKt;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vcs.AbstractVcs;
import com.intellij.openapi.vcs.FilePath;
import com.intellij.openapi.vcs.ProjectLevelVcsManager;
import com.intellij.openapi.vcs.VcsException;
import com.intellij.openapi.vcs.actions.DescindingFilesFilter;
import com.intellij.openapi.vcs.update.ActionInfo;
import com.intellij.openapi.vcs.update.ProjectVcsUpdateTaskExecutor;
import com.intellij.openapi.vcs.update.ScopeInfo;
import com.intellij.openapi.vcs.update.SequentialUpdatesContext;
import com.intellij.openapi.vcs.update.UpdateEnvironment;
import com.intellij.openapi.vcs.update.UpdateOrStatusOptionsDialog;
import com.intellij.openapi.vcs.update.UpdateSession;
import com.intellij.openapi.vcs.update.UpdatedFiles;
import com.intellij.openapi.vcs.update.VcsUpdateProcess;
import com.intellij.openapi.vcs.update.VcsUpdateProcessKt;
import com.intellij.openapi.vcs.update.VcsUpdateSpecification;
import com.intellij.openapi.vcs.update.VcsUpdateTask;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.SmartHashSet;
import com.intellij.vcsUtil.VcsUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.CoroutineContext;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Dispatchers;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u001e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u00c7\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J<\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\b\b\u0002\u0010\u0010\u001a\u00020\u0011H\u0007JJ\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u0012\u001a\u00020\u00112\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0003\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0007JS\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\u000e\u001a\u00020\u000f2\u000e\b\u0003\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00050\u0014H\u0007\u00a2\u0006\u0002\u0010\u001bJG\u0010\u001c\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\b\u001a\u00020\t2\u000b\u0010\u000e\u001a\u00070\u000f\u00a2\u0006\u0002\b\u001dH\u0087@\u00a2\u0006\u0002\u0010\u001eJC\u0010\u001f\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\b\u001a\u00020\t2\b\b\u0001\u0010\u000e\u001a\u00020\u000fH\u0007\u00a2\u0006\u0002\u0010 J=\u0010!\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\"\u001a\u00020\u0011H\u0007\u00a2\u0006\u0002\u0010#JG\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170%2\u0006\u0010&\u001a\u00020\u00112\u0014\u0010'\u001a\u0010\u0012\u0004\u0012\u00020)\u0012\u0006\u0012\u0004\u0018\u00010*0(H\u0002\u00a2\u0006\u0002\u0010+J1\u0010,\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u0010\u0006\u001a\u00020\u00072\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\u0006\u0010\b\u001a\u00020\tH\u0007\u00a2\u0006\u0002\u0010-J\u0016\u0010.\u001a\u00020\u00112\f\u0010/\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J6\u00100\u001a\u00020\u00112\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u00192\u0006\u00101\u001a\u00020\rH\u0007J2\u00102\u001a\u001e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020)03j\u000e\u0012\u0004\u0012\u000204\u0012\u0004\u0012\u00020)`52\f\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u001a0\u0019H\u0002J\u0016\u00106\u001a\u00020\u00112\f\u00107\u001a\b\u0012\u0004\u0012\u00020)0%H\u0007\u00a8\u00068"}, d2={"Lcom/intellij/openapi/vcs/update/VcsUpdateProcess;", "", "<init>", "()V", "launchUpdate", "", "project", "Lcom/intellij/openapi/project/Project;", "actionInfo", "Lcom/intellij/openapi/vcs/update/ActionInfo;", "scopeInfo", "Lcom/intellij/openapi/vcs/update/ScopeInfo;", "context", "Lcom/intellij/openapi/actionSystem/DataContext;", "actionName", "", "forceShowOptions", "", "showUpdateOptions", "onSuccess", "Lkotlin/Function0;", "roots", "", "Lcom/intellij/openapi/vcs/FilePath;", "updateSpec", "", "Lcom/intellij/openapi/vcs/update/VcsUpdateSpecification;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/vcs/FilePath;Ljava/util/List;Lcom/intellij/openapi/vcs/update/ActionInfo;Ljava/lang/String;Lkotlin/jvm/functions/Function0;)V", "update", "Lorg/jetbrains/annotations/Nls;", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/vcs/FilePath;Ljava/util/List;Lcom/intellij/openapi/vcs/update/ActionInfo;Ljava/lang/String;Lkotlin/coroutines/Continuation;)Ljava/lang/Object;", "runUpdateBlocking", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/vcs/FilePath;Ljava/util/List;Lcom/intellij/openapi/vcs/update/ActionInfo;Ljava/lang/String;)V", "getRoots", "filterDescending", "(Lcom/intellij/openapi/project/Project;Lcom/intellij/openapi/vcs/update/ActionInfo;Lcom/intellij/openapi/vcs/update/ScopeInfo;Lcom/intellij/openapi/actionSystem/DataContext;Z)[Lcom/intellij/openapi/vcs/FilePath;", "filterRoots", "", "filterExistsInVcs", "updateEnvironmentSupplier", "Lkotlin/Function1;", "Lcom/intellij/openapi/vcs/AbstractVcs;", "Lcom/intellij/openapi/vcs/update/UpdateEnvironment;", "(Lcom/intellij/openapi/project/Project;Ljava/util/Collection;ZLkotlin/jvm/functions/Function1;)[Lcom/intellij/openapi/vcs/FilePath;", "createUpdateSpec", "(Lcom/intellij/openapi/project/Project;[Lcom/intellij/openapi/vcs/FilePath;Lcom/intellij/openapi/vcs/update/ActionInfo;)Ljava/util/List;", "isUpdateSpecValid", "spec", "showOptionsDialog", "dataContext", "createConfigurableToEnvMap", "Ljava/util/LinkedHashMap;", "Lcom/intellij/openapi/options/Configurable;", "Lkotlin/collections/LinkedHashMap;", "checkUpdateHasCustomNotification", "vcss", "intellij.platform.vcs.impl"})
@ApiStatus.Experimental
@SourceDebugExtension(value={"SMAP\nVcsUpdateProcess.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VcsUpdateProcess.kt\ncom/intellij/openapi/vcs/update/VcsUpdateProcess\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n+ 3 services.kt\ncom/intellij/openapi/components/ServicesKt\n+ 4 ArraysJVM.kt\nkotlin/collections/ArraysKt__ArraysJVMKt\n+ 5 Maps.kt\nkotlin/collections/MapsKt__MapsKt\n+ 6 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,271:1\n60#2,5:272\n60#2,5:277\n60#2,5:282\n30#3,2:287\n37#4,2:289\n382#5,7:291\n1740#6,3:298\n*S KotlinDebug\n*F\n+ 1 VcsUpdateProcess.kt\ncom/intellij/openapi/vcs/update/VcsUpdateProcess\n*L\n57#1:272,5\n61#1:277,5\n67#1:282,5\n90#1:287,2\n169#1:289,2\n182#1:291,7\n233#1:298,3\n*E\n"})
public final class VcsUpdateProcess {
    @NotNull
    public static final VcsUpdateProcess INSTANCE = new VcsUpdateProcess();

    private VcsUpdateProcess() {
    }

    @RequiresEdt
    public final void launchUpdate(@NotNull Project project, @NotNull ActionInfo actionInfo, @NotNull ScopeInfo scopeInfo, @NotNull DataContext context, @Nls @NotNull String actionName, boolean forceShowOptions) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionInfo, (String)"actionInfo");
        Intrinsics.checkNotNullParameter((Object)scopeInfo, (String)"scopeInfo");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        boolean showUpdateOptions = actionInfo.showOptions(project) || forceShowOptions;
        VcsUpdateProcess.launchUpdate$default(this, project, actionInfo, scopeInfo, context, showUpdateOptions, actionName, null, 64, null);
    }

    public static /* synthetic */ void launchUpdate$default(VcsUpdateProcess vcsUpdateProcess, Project project, ActionInfo actionInfo, ScopeInfo scopeInfo, DataContext dataContext, String string, boolean bl, int n, Object object) {
        if ((n & 0x20) != 0) {
            bl = false;
        }
        vcsUpdateProcess.launchUpdate(project, actionInfo, scopeInfo, dataContext, string, bl);
    }

    @ApiStatus.Internal
    @RequiresEdt
    public final void launchUpdate(@NotNull Project project, @NotNull ActionInfo actionInfo, @NotNull ScopeInfo scopeInfo, @NotNull DataContext context, boolean showUpdateOptions, @Nls @NotNull String actionName, @RequiresEdt @NotNull Function0<Unit> onSuccess) {
        boolean dialogOk;
        Logger logger;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionInfo, (String)"actionInfo");
        Intrinsics.checkNotNullParameter((Object)scopeInfo, (String)"scopeInfo");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        Logger $this$debug_u24default$iv = VcsUpdateProcessKt.access$getLOG$p();
        Throwable t$iv = null;
        boolean $i$f$debug = false;
        if ($this$debug_u24default$iv.isDebugEnabled()) {
            logger = $this$debug_u24default$iv;
            boolean bl = false;
            logger.debug("project: " + project + ", show update options: " + showUpdateOptions, t$iv);
        }
        FilePath[] roots2 = VcsUpdateProcess.getRoots$default(project, actionInfo, scopeInfo, context, false, 16, null);
        if (roots2.length == 0) {
            Logger $this$debug_u24default$iv2 = VcsUpdateProcessKt.access$getLOG$p();
            Throwable t$iv2 = null;
            boolean $i$f$debug2 = false;
            if ($this$debug_u24default$iv2.isDebugEnabled()) {
                logger = $this$debug_u24default$iv2;
                boolean bl = false;
                logger.debug("No roots found.", t$iv2);
            }
            return;
        }
        List<VcsUpdateSpecification> updateSpec = VcsUpdateProcess.createUpdateSpec(project, roots2, actionInfo);
        if (!this.isUpdateSpecValid(updateSpec)) {
            Logger $this$debug_u24default$iv3 = VcsUpdateProcessKt.access$getLOG$p();
            Throwable t$iv3 = null;
            boolean $i$f$debug3 = false;
            if ($this$debug_u24default$iv3.isDebugEnabled()) {
                logger = $this$debug_u24default$iv3;
                boolean bl = false;
                logger.debug("Options not valid for update spec: " + updateSpec, t$iv3);
            }
            return;
        }
        if (showUpdateOptions && !(dialogOk = this.showOptionsDialog(project, actionInfo, scopeInfo, updateSpec, context))) {
            return;
        }
        this.launchUpdate(project, roots2, updateSpec, actionInfo, actionName, onSuccess);
    }

    public static /* synthetic */ void launchUpdate$default(VcsUpdateProcess vcsUpdateProcess, Project project, ActionInfo actionInfo, ScopeInfo scopeInfo, DataContext dataContext, boolean bl, String string, Function0 function0, int n, Object object) {
        if ((n & 0x40) != 0) {
            function0 = VcsUpdateProcess::launchUpdate$lambda$0;
        }
        vcsUpdateProcess.launchUpdate(project, actionInfo, scopeInfo, dataContext, bl, string, (Function0<Unit>)function0);
    }

    @ApiStatus.Internal
    public final void launchUpdate(@NotNull Project project, @NotNull FilePath[] roots2, @NotNull List<VcsUpdateSpecification> updateSpec, @NotNull ActionInfo actionInfo, @Nls @NotNull String actionName, @RequiresEdt @NotNull Function0<Unit> onSuccess) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)roots2, (String)"roots");
        Intrinsics.checkNotNullParameter(updateSpec, (String)"updateSpec");
        Intrinsics.checkNotNullParameter((Object)actionInfo, (String)"actionInfo");
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        Intrinsics.checkNotNullParameter(onSuccess, (String)"onSuccess");
        ComponentManager $this$service$iv = (ComponentManager)project;
        boolean $i$f$service = false;
        Class<ProjectVcsUpdateTaskExecutor> serviceClass$iv = ProjectVcsUpdateTaskExecutor.class;
        Object object = $this$service$iv.getService(serviceClass$iv);
        if (object == null) {
            throw ServicesKt.serviceNotFoundError((ComponentManager)$this$service$iv, serviceClass$iv);
        }
        ((ProjectVcsUpdateTaskExecutor)object).launchUpdate(roots2, updateSpec, actionInfo, actionName, onSuccess);
    }

    public static /* synthetic */ void launchUpdate$default(VcsUpdateProcess vcsUpdateProcess, Project project, FilePath[] filePathArray, List list, ActionInfo actionInfo, String string, Function0 function0, int n, Object object) {
        if ((n & 0x20) != 0) {
            function0 = VcsUpdateProcess::launchUpdate$lambda$4;
        }
        vcsUpdateProcess.launchUpdate(project, filePathArray, list, actionInfo, string, (Function0<Unit>)function0);
    }

    @ApiStatus.Internal
    @Nullable
    public final Object update(@NotNull Project project, @NotNull FilePath[] roots2, @NotNull List<VcsUpdateSpecification> updateSpec, @NotNull ActionInfo actionInfo, @NotNull String actionName, @NotNull Continuation<? super Unit> $completion) {
        Object object = BuildersKt.withContext((CoroutineContext)((CoroutineContext)Dispatchers.getDefault()), (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, roots2, updateSpec, actionInfo, actionName, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ FilePath[] $roots;
            final /* synthetic */ List<VcsUpdateSpecification> $updateSpec;
            final /* synthetic */ ActionInfo $actionInfo;
            final /* synthetic */ String $actionName;
            {
                this.$project = $project;
                this.$roots = $roots;
                this.$updateSpec = $updateSpec;
                this.$actionInfo = $actionInfo;
                this.$actionName = $actionName;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = new VcsUpdateTask(this.$project, this.$roots, this.$updateSpec, this.$actionInfo, this.$actionName).execute((Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }), $completion);
        if (object == IntrinsicsKt.getCOROUTINE_SUSPENDED()) {
            return object;
        }
        return Unit.INSTANCE;
    }

    @JvmStatic
    @ApiStatus.Obsolete
    @ApiStatus.Internal
    public static final void runUpdateBlocking(@NotNull Project project, @NotNull FilePath[] roots2, @NotNull List<VcsUpdateSpecification> updateSpec, @NotNull ActionInfo actionInfo, @Nls @NotNull String actionName) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)roots2, (String)"roots");
        Intrinsics.checkNotNullParameter(updateSpec, (String)"updateSpec");
        Intrinsics.checkNotNullParameter((Object)actionInfo, (String)"actionInfo");
        Intrinsics.checkNotNullParameter((Object)actionName, (String)"actionName");
        CoroutinesKt.runBlockingMaybeCancellable((Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(project, roots2, updateSpec, actionInfo, actionName, null){
            int label;
            final /* synthetic */ Project $project;
            final /* synthetic */ FilePath[] $roots;
            final /* synthetic */ List<VcsUpdateSpecification> $updateSpec;
            final /* synthetic */ ActionInfo $actionInfo;
            final /* synthetic */ String $actionName;
            {
                this.$project = $project;
                this.$roots = $roots;
                this.$updateSpec = $updateSpec;
                this.$actionInfo = $actionInfo;
                this.$actionName = $actionName;
                super(2, $completion);
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public final Object invokeSuspend(Object $result) {
                Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                switch (this.label) {
                    case 0: {
                        ResultKt.throwOnFailure((Object)$result);
                        this.label = 1;
                        Object object2 = new VcsUpdateTask(this.$project, this.$roots, this.$updateSpec, this.$actionInfo, this.$actionName).executeUpdate((Map<AbstractVcs, SequentialUpdatesContext>)new LinkedHashMap<K, V>(), UpdatedFiles.Companion.create(), (Map<HotfixData, List<VcsException>>)new LinkedHashMap<K, V>(), (List<UpdateSession>)new ArrayList<E>(), (Continuation<? super Unit>)((Continuation)this));
                        if (object2 != object) return Unit.INSTANCE;
                        return object;
                    }
                    case 1: {
                        ResultKt.throwOnFailure((Object)$result);
                        Object object2 = $result;
                        return Unit.INSTANCE;
                    }
                }
                throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
            }

            public final Continuation<Unit> create(Object value, Continuation<?> $completion) {
                return (Continuation)new /* invalid duplicate definition of identical inner class */;
            }

            public final Object invoke(CoroutineScope p1, Continuation<? super Unit> p2) {
                return (this.create(p1, p2)).invokeSuspend(Unit.INSTANCE);
            }
        }));
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final FilePath[] getRoots(@NotNull Project project, @NotNull ActionInfo actionInfo, @NotNull ScopeInfo scopeInfo, @NotNull DataContext context, boolean filterDescending) {
        FilePath[] filePathArray;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionInfo, (String)"actionInfo");
        Intrinsics.checkNotNullParameter((Object)scopeInfo, (String)"scopeInfo");
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        List<FilePath> filePaths = scopeInfo.getRoots(context, actionInfo);
        boolean filterExistsInVcs = scopeInfo.filterExistsInVcs();
        Intrinsics.checkNotNull(filePaths);
        FilePath[] roots2 = INSTANCE.filterRoots(project, (Collection<? extends FilePath>)filePaths, filterExistsInVcs, (Function1<? super AbstractVcs, ? extends UpdateEnvironment>)((Function1)new Function1<AbstractVcs, UpdateEnvironment>((Object)actionInfo){

            public final UpdateEnvironment invoke(AbstractVcs p0) {
                return ((ActionInfo)this.receiver).getEnvironment(p0);
            }
        }));
        if (filterDescending) {
            FilePath[] filePathArray2 = DescindingFilesFilter.filterDescindingFiles(roots2, project);
            Intrinsics.checkNotNull((Object)filePathArray2);
            filePathArray = filePathArray2;
        } else {
            filePathArray = roots2;
        }
        return filePathArray;
    }

    public static /* synthetic */ FilePath[] getRoots$default(Project project, ActionInfo actionInfo, ScopeInfo scopeInfo, DataContext dataContext, boolean bl, int n, Object object) {
        if ((n & 0x10) != 0) {
            bl = true;
        }
        return VcsUpdateProcess.getRoots(project, actionInfo, scopeInfo, dataContext, bl);
    }

    private final FilePath[] filterRoots(Project project, Collection<? extends FilePath> roots2, boolean filterExistsInVcs, Function1<? super AbstractVcs, ? extends UpdateEnvironment> updateEnvironmentSupplier) {
        ArrayList<FilePath> result2 = new ArrayList<FilePath>();
        for (FilePath filePath : roots2) {
            if (VcsUtil.getVcsFor((Project)project, (FilePath)filePath) == null) continue;
            if (!filterExistsInVcs || AbstractVcs.fileInVcsByFileStatus((Project)project, (FilePath)filePath)) {
                AbstractVcs vcs;
                UpdateEnvironment updateEnvironment = (UpdateEnvironment)updateEnvironmentSupplier.invoke((Object)vcs);
                if (updateEnvironment == null) continue;
                result2.add(filePath);
                continue;
            }
            VirtualFile virtualFile = filePath.getVirtualFile();
            if (virtualFile == null || !virtualFile.isDirectory()) continue;
            for (VirtualFile vcsRoot : ProjectLevelVcsManager.Companion.getInstance(project).getAllVersionedRoots()) {
                if (!VfsUtilCore.isAncestor((VirtualFile)virtualFile, (VirtualFile)vcsRoot, (boolean)false)) continue;
                result2.add(filePath);
            }
        }
        Collection $this$toTypedArray$iv = result2;
        boolean bl = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        return thisCollection$iv.toArray(new FilePath[0]);
    }

    @JvmStatic
    @ApiStatus.Internal
    @NotNull
    public static final List<VcsUpdateSpecification> createUpdateSpec(@NotNull Project project, @NotNull FilePath[] roots2, @NotNull ActionInfo actionInfo) {
        List list;
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)roots2, (String)"roots");
        Intrinsics.checkNotNullParameter((Object)actionInfo, (String)"actionInfo");
        Map resultPrep = new LinkedHashMap();
        for (FilePath file : roots2) {
            Object object;
            AbstractVcs vcs;
            if (VcsUtil.getVcsFor((Project)project, (FilePath)file) == null) continue;
            Map object2 = resultPrep;
            AbstractVcs key$iv = vcs;
            boolean $i$f$getOrPut = false;
            Object value$iv = object2.get(key$iv);
            if (value$iv == null) {
                boolean bl = false;
                Collection answer$iv = (Collection)new SmartHashSet();
                object2.put(key$iv, answer$iv);
                object = answer$iv;
            } else {
                object = value$iv;
            }
            ((Collection)object).add(file);
        }
        List $this$createUpdateSpec_u24lambda_u241 = list = CollectionsKt.createListBuilder();
        boolean bl = false;
        for (Map.Entry entry : resultPrep.entrySet()) {
            List uniqueRoots2;
            UpdateEnvironment environment;
            AbstractVcs vcs = (AbstractVcs)entry.getKey();
            Collection roots3 = (Collection)entry.getValue();
            if (actionInfo.getEnvironment(vcs) == null) continue;
            Intrinsics.checkNotNullExpressionValue((Object)vcs.filterUniqueRoots(CollectionsKt.toList((Iterable)roots3), arg_0 -> VcsUpdateProcess.createUpdateSpec$lambda$1$0(createUpdateSpec.2.uniqueRoots.1.INSTANCE, arg_0)), (String)"filterUniqueRoots(...)");
            $this$createUpdateSpec_u24lambda_u241.add(new VcsUpdateSpecification(vcs, environment, uniqueRoots2));
        }
        return CollectionsKt.build((List)list);
    }

    private final boolean isUpdateSpecValid(List<VcsUpdateSpecification> spec) {
        for (VcsUpdateSpecification vcsUpdateSpecification : spec) {
            Collection<FilePath> roots2;
            UpdateEnvironment updateEnvironment = vcsUpdateSpecification.component2();
            if (updateEnvironment.validateOptions(roots2 = vcsUpdateSpecification.component3())) continue;
            return false;
        }
        return true;
    }

    @ApiStatus.Internal
    public final boolean showOptionsDialog(@NotNull Project project, @NotNull ActionInfo actionInfo, @NotNull ScopeInfo scopeInfo, @NotNull List<VcsUpdateSpecification> updateSpec, @NotNull DataContext dataContext) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)actionInfo, (String)"actionInfo");
        Intrinsics.checkNotNullParameter((Object)scopeInfo, (String)"scopeInfo");
        Intrinsics.checkNotNullParameter(updateSpec, (String)"updateSpec");
        Intrinsics.checkNotNullParameter((Object)dataContext, (String)"dataContext");
        LinkedHashMap<Configurable, AbstractVcs> envToConfMap = this.createConfigurableToEnvMap(updateSpec);
        String scopeName = scopeInfo.getScopeName(dataContext, actionInfo);
        if (!envToConfMap.isEmpty()) {
            UpdateOrStatusOptionsDialog dialogOrStatus = actionInfo.createOptionsDialog(project, envToConfMap, scopeName);
            return dialogOrStatus.showAndGet();
        }
        return true;
    }

    private final LinkedHashMap<Configurable, AbstractVcs> createConfigurableToEnvMap(List<VcsUpdateSpecification> updateSpec) {
        LinkedHashMap<Configurable, AbstractVcs> envToConfMap = new LinkedHashMap<Configurable, AbstractVcs>();
        for (VcsUpdateSpecification vcsUpdateSpecification : updateSpec) {
            Collection<FilePath> roots2;
            AbstractVcs vcs = vcsUpdateSpecification.component1();
            UpdateEnvironment environment = vcsUpdateSpecification.component2();
            Configurable configurable = environment.createConfigurable(roots2 = vcsUpdateSpecification.component3());
            if (configurable == null) continue;
            ((Map)envToConfMap).put(configurable, vcs);
        }
        return envToConfMap;
    }

    @JvmStatic
    public static final boolean checkUpdateHasCustomNotification(@NotNull Collection<? extends AbstractVcs> vcss) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(vcss, (String)"vcss");
            Iterable $this$all$iv = vcss;
            boolean $i$f$all = false;
            if (((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    AbstractVcs vcs = (AbstractVcs)element$iv;
                    boolean bl2 = false;
                    UpdateEnvironment environment = vcs.getUpdateEnvironment();
                    if (environment != null && environment.hasCustomNotification()) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    private static final Unit launchUpdate$lambda$0() {
        return Unit.INSTANCE;
    }

    private static final Unit launchUpdate$lambda$4() {
        return Unit.INSTANCE;
    }

    private static final VirtualFile createUpdateSpec$lambda$1$0(Function1 $tmp0, Object p0) {
        return (VirtualFile)$tmp0.invoke(p0);
    }
}

