/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.credentialStore;

import com.intellij.credentialStore.CredentialStore;
import com.intellij.credentialStore.CredentialStoreBundle;
import com.intellij.credentialStore.CredentialStoreKt;
import com.intellij.credentialStore.CredentialStoreManager;
import com.intellij.credentialStore.EncryptionSpec;
import com.intellij.credentialStore.EncryptionSupportKt;
import com.intellij.credentialStore.EncryptionType;
import com.intellij.credentialStore.PasswordSafeConfigurableKt;
import com.intellij.credentialStore.PasswordSafeOptions;
import com.intellij.credentialStore.PasswordSafeSettings;
import com.intellij.credentialStore.ProviderType;
import com.intellij.credentialStore.gpg.Pgp;
import com.intellij.credentialStore.gpg.PgpKey;
import com.intellij.credentialStore.kdbx.IncorrectMainPasswordException;
import com.intellij.credentialStore.keePass.KeePassCredentialStoreKt;
import com.intellij.credentialStore.keePass.KeePassFileManager;
import com.intellij.credentialStore.keePass.MainKeyFileStorage;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.passwordSafe.PasswordSafe;
import com.intellij.ide.passwordSafe.impl.BasePasswordSafe;
import com.intellij.ide.passwordSafe.impl.PasswordSafeImplKt;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileChooser.FileChooserDescriptorFactory;
import com.intellij.openapi.options.ConfigurableUi;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.ui.ComboBox;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.MessageDialogBuilder;
import com.intellij.openapi.ui.TextFieldWithBrowseButton;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.SystemInfo;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.ui.CollectionComboBoxModel;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.AlignX;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.ButtonsGroup;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.ComboBoxKt;
import com.intellij.ui.dsl.builder.ExtensionsKt;
import com.intellij.ui.dsl.builder.MutablePropertyKt;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.RightGap;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.dsl.builder.RowsRange;
import com.intellij.ui.dsl.listCellRenderer.BuilderKt;
import com.intellij.ui.layout.ComponentPredicateKt;
import com.intellij.ui.layout.LayoutBuilderKt;
import com.intellij.util.text.StringKt;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.List;
import javax.swing.AbstractButton;
import javax.swing.ComboBoxModel;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.MutablePropertyReference0Impl;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.reflect.KMutableProperty0;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000z\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0007\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001:\u0003012B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016J\u0010\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016J\u0010\u0010 \u001a\u00020\u001f2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002J\u0010\u0010!\u001a\u00020\u001d2\u0006\u0010\u0003\u001a\u00020\u0002H\u0016J\u0010\u0010\"\u001a\u00020\u001d2\u0006\u0010\u0003\u001a\u00020\u0002H\u0002J\n\u0010#\u001a\u0004\u0018\u00010$H\u0002J\n\u0010%\u001a\u0004\u0018\u00010&H\u0002J\b\u0010'\u001a\u00020(H\u0016J\b\u0010)\u001a\u00020&H\u0003J\n\u0010*\u001a\u0004\u0018\u00010\fH\u0002J\n\u0010+\u001a\u0004\u0018\u00010,H\u0002J\b\u0010-\u001a\u00020.H\u0002J\n\u0010/\u001a\u0004\u0018\u00010\fH\u0002R\u000e\u0010\u0003\u001a\u00020\u0002X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082.\u00a2\u0006\u0002\n\u0000R\u0014\u0010\n\u001a\b\u0012\u0004\u0012\u00020\f0\u000bX\u0082.\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082.\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u000f\u001a\u0004\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\f0\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001b\u0010\u0013\u001a\u00020\u00148BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0017\u0010\u0018\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0019\u001a\b\u0012\u0004\u0012\u00020\u001b0\u001aX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00063"}, d2={"Lcom/intellij/credentialStore/PasswordSafeConfigurableUi;", "Lcom/intellij/openapi/options/ConfigurableUi;", "Lcom/intellij/credentialStore/PasswordSafeSettings;", "settings", "<init>", "(Lcom/intellij/credentialStore/PasswordSafeSettings;)V", "panel", "Lcom/intellij/openapi/ui/DialogPanel;", "usePgpKey", "Ljavax/swing/JCheckBox;", "pgpKeyCombo", "Lcom/intellij/openapi/ui/ComboBox;", "Lcom/intellij/credentialStore/gpg/PgpKey;", "keepassRadioButton", "Ljavax/swing/JRadioButton;", "keePassDbFile", "Lcom/intellij/openapi/ui/TextFieldWithBrowseButton;", "pgpListModel", "Lcom/intellij/ui/CollectionComboBoxModel;", "pgp", "Lcom/intellij/credentialStore/gpg/Pgp;", "getPgp", "()Lcom/intellij/credentialStore/gpg/Pgp;", "pgp$delegate", "Lkotlin/Lazy;", "secureRandom", "Lkotlin/Lazy;", "Ljava/security/SecureRandom;", "reset", "", "isModified", "", "isKeepassFileLocationChanged", "apply", "createAndSaveKeePassDatabaseWithNewOptions", "getNewDbFile", "Ljava/nio/file/Path;", "getNewDbFileAsString", "", "getComponent", "Ljavax/swing/JPanel;", "usePgpKeyText", "getSelectedPgpKey", "createKeePassFileManager", "Lcom/intellij/credentialStore/keePass/KeePassFileManager;", "getEncryptionSpec", "Lcom/intellij/credentialStore/EncryptionSpec;", "getNewPgpKey", "ClearKeePassDatabaseAction", "ImportKeePassDatabaseAction", "ChangeKeePassDatabaseMasterPasswordAction", "intellij.platform.credentialStore.ui"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nPasswordSafeConfigurable.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PasswordSafeConfigurable.kt\ncom/intellij/credentialStore/PasswordSafeConfigurableUi\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 4 ButtonsGroup.kt\ncom/intellij/ui/dsl/builder/ButtonsGroupKt\n*L\n1#1,343:1\n1#2:344\n295#3,2:345\n31#4:347\n*S KotlinDebug\n*F\n+ 1 PasswordSafeConfigurable.kt\ncom/intellij/credentialStore/PasswordSafeConfigurableUi\n*L\n268#1:345,2\n255#1:347\n*E\n"})
public final class PasswordSafeConfigurableUi
implements ConfigurableUi<PasswordSafeSettings> {
    @NotNull
    private final PasswordSafeSettings settings;
    private DialogPanel panel;
    private JCheckBox usePgpKey;
    private ComboBox<PgpKey> pgpKeyCombo;
    private JRadioButton keepassRadioButton;
    @Nullable
    private TextFieldWithBrowseButton keePassDbFile;
    @NotNull
    private final CollectionComboBoxModel<PgpKey> pgpListModel;
    @NotNull
    private final Lazy pgp$delegate;
    @NotNull
    private final Lazy<SecureRandom> secureRandom;

    public PasswordSafeConfigurableUi(@NotNull PasswordSafeSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        this.settings = settings;
        this.pgpListModel = new CollectionComboBoxModel();
        this.pgp$delegate = LazyKt.lazy(PasswordSafeConfigurableUi::pgp_delegate$lambda$0);
        this.secureRandom = LazyKt.lazy(PasswordSafeConfigurableUi::secureRandom$lambda$0);
    }

    private final Pgp getPgp() {
        Lazy lazy = this.pgp$delegate;
        return (Pgp)lazy.getValue();
    }

    public void reset(@NotNull PasswordSafeSettings settings) {
        block3: {
            Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
            List secretKeys = this.getPgp().listKeys();
            this.pgpListModel.replaceAll(secretKeys);
            JCheckBox jCheckBox = this.usePgpKey;
            if (jCheckBox == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"usePgpKey");
                jCheckBox = null;
            }
            jCheckBox.setText(this.usePgpKeyText());
            DialogPanel dialogPanel = this.panel;
            if (dialogPanel == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
                dialogPanel = null;
            }
            dialogPanel.reset();
            TextFieldWithBrowseButton textFieldWithBrowseButton = this.keePassDbFile;
            if (textFieldWithBrowseButton == null) break block3;
            String string = settings.getKeepassDb();
            if (string == null) {
                string = ((Object)KeePassCredentialStoreKt.getDefaultDbFile()).toString();
            }
            textFieldWithBrowseButton.setText(string);
        }
    }

    public boolean isModified(@NotNull PasswordSafeSettings settings) {
        Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        if (dialogPanel.isModified()) {
            return true;
        }
        if (this.keePassDbFile == null) {
            return false;
        }
        return this.isKeepassFileLocationChanged(settings);
    }

    private final boolean isKeepassFileLocationChanged(PasswordSafeSettings settings) {
        JRadioButton jRadioButton = this.keepassRadioButton;
        if (jRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"keepassRadioButton");
            jRadioButton = null;
        }
        return jRadioButton.isSelected() && !Intrinsics.areEqual((Object)this.getNewDbFileAsString(), (Object)settings.getKeepassDb());
    }

    public void apply(@NotNull PasswordSafeSettings settings) {
        ProviderType providerType;
        block20: {
            boolean pgpKeyChanged;
            block21: {
                Intrinsics.checkNotNullParameter((Object)settings, (String)"settings");
                PgpKey pgpKey = this.getNewPgpKey();
                pgpKeyChanged = !Intrinsics.areEqual((Object)(pgpKey != null ? pgpKey.getKeyId() : null), (Object)this.settings.getState().getPgpKeyId());
                ProviderType oldProviderType = this.settings.getProviderType();
                DialogPanel dialogPanel = this.panel;
                if (dialogPanel == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
                    dialogPanel = null;
                }
                dialogPanel.apply();
                providerType = this.settings.getProviderType();
                PasswordSafe passwordSafe = PasswordSafe.Companion.getInstance();
                Intrinsics.checkNotNull((Object)passwordSafe, (String)"null cannot be cast to non-null type com.intellij.ide.passwordSafe.impl.BasePasswordSafe");
                BasePasswordSafe passwordSafe2 = (BasePasswordSafe)passwordSafe;
                passwordSafe2.closeCurrentStore(false, providerType != ProviderType.MEMORY_ONLY);
                if (oldProviderType == providerType) break block21;
                switch (WhenMappings.$EnumSwitchMapping$0[providerType.ordinal()]) {
                    case 1: {
                        break block20;
                    }
                    case 2: {
                        try {
                            CredentialStore store = PasswordSafeImplKt.createPersistentCredentialStore();
                            if (store == null) {
                                throw new ConfigurationException(IdeBundle.message((String)"settings.password.internal.error.no.available.credential.store.implementation", (Object[])new Object[0]));
                            }
                            passwordSafe2.setCurrentProvider(store);
                            break block20;
                        }
                        catch (UnsatisfiedLinkError e) {
                            PasswordSafeConfigurableKt.access$getLOG().warn((Throwable)e);
                            if (SystemInfo.isLinux) {
                                throw new ConfigurationException(IdeBundle.message((String)"settings.password.package.libsecret.1.0.is.not.installed", (Object[])new Object[0]));
                            }
                            throw new ConfigurationException(e.getMessage());
                        }
                    }
                    case 3: {
                        this.createAndSaveKeePassDatabaseWithNewOptions(settings);
                        break block20;
                    }
                    default: {
                        Object[] objectArray = new Object[]{providerType};
                        throw new ConfigurationException(IdeBundle.message((String)"settings.password.unknown.provider.type", (Object[])objectArray));
                    }
                }
            }
            if (this.isKeepassFileLocationChanged(settings)) {
                this.createAndSaveKeePassDatabaseWithNewOptions(settings);
            } else if (providerType == ProviderType.KEEPASS && pgpKeyChanged) {
                try {
                    KeePassFileManager keePassFileManager = this.createKeePassFileManager();
                    if (keePassFileManager != null) {
                        keePassFileManager.saveMainKeyToApplyNewEncryptionSpec();
                    }
                }
                catch (ConfigurationException e) {
                    throw e;
                }
                catch (Exception e) {
                    PasswordSafeConfigurableKt.access$getLOG().error((Throwable)e);
                    Object[] objectArray = new Object[1];
                    String string = e.getMessage();
                    if (string == null) {
                        string = e.toString();
                    }
                    objectArray[0] = string;
                    throw new ConfigurationException(CredentialStoreBundle.INSTANCE.message("settings.password.internal.error", objectArray));
                }
            }
        }
        if (providerType == ProviderType.KEEPASS) {
            KeePassFileManager keePassFileManager = this.createKeePassFileManager();
            if (keePassFileManager != null) {
                keePassFileManager.setCustomMainPasswordIfNeeded(KeePassCredentialStoreKt.getDefaultDbFile());
            }
        }
        settings.setProviderType(providerType);
    }

    private final void createAndSaveKeePassDatabaseWithNewOptions(PasswordSafeSettings settings) {
        Path path = this.getNewDbFile();
        if (path == null) {
            throw new ConfigurationException(CredentialStoreBundle.INSTANCE.message("settings.password.keepass.database.path.is.empty", new Object[0]));
        }
        Path newDbFile = path;
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.isDirectory(newDbFile, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            throw new ConfigurationException(CredentialStoreBundle.INSTANCE.message("settings.password.keepass.database.file.is.directory.", new Object[0]));
        }
        if (!StringsKt.endsWith$default((String)((Object)newDbFile.getFileName()).toString(), (String)".kdbx", (boolean)false, (int)2, null)) {
            throw new ConfigurationException(CredentialStoreBundle.INSTANCE.message("settings.password.keepass.database.file.should.ends.with.kdbx", new Object[0]));
        }
        settings.setKeepassDb(((Object)newDbFile).toString());
        try {
            new KeePassFileManager(newDbFile, KeePassCredentialStoreKt.getDefaultMainPasswordFile(), this.getEncryptionSpec(), this.secureRandom).useExisting();
        }
        catch (IncorrectMainPasswordException e) {
            throw new ConfigurationException(CredentialStoreBundle.INSTANCE.message("settings.password.master.password.for.keepass.database.is.not.correct", new Object[0]));
        }
        catch (Exception e) {
            PasswordSafeConfigurableKt.access$getLOG().error((Throwable)e);
            Object[] objectArray = new Object[1];
            String string = e.getMessage();
            if (string == null) {
                string = e.toString();
            }
            objectArray[0] = string;
            throw new ConfigurationException(CredentialStoreBundle.INSTANCE.message("settings.password.internal.error", objectArray));
        }
    }

    private final Path getNewDbFile() {
        Path path;
        String string = this.getNewDbFileAsString();
        if (string != null) {
            String it = string;
            boolean bl = false;
            path = Paths.get(it, new String[0]);
        } else {
            path = null;
        }
        return path;
    }

    private final String getNewDbFileAsString() {
        TextFieldWithBrowseButton textFieldWithBrowseButton = this.keePassDbFile;
        Intrinsics.checkNotNull((Object)textFieldWithBrowseButton);
        String string = textFieldWithBrowseButton.getText();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getText(...)");
        return StringKt.nullize$default((String)((Object)StringsKt.trim((CharSequence)string)).toString(), (boolean)false, (int)1, null);
    }

    @NotNull
    public JPanel getComponent() {
        this.panel = com.intellij.ui.dsl.builder.BuilderKt.panel(arg_0 -> PasswordSafeConfigurableUi.getComponent$lambda$0(this, arg_0));
        DialogPanel dialogPanel = this.panel;
        if (dialogPanel == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"panel");
            dialogPanel = null;
        }
        return (JPanel)dialogPanel;
    }

    @NlsContexts.Checkbox
    private final String usePgpKeyText() {
        return this.pgpListModel.isEmpty() ? CredentialStoreBundle.INSTANCE.message("passwordSafeConfigurable.protect.master.password.using.pgp.key.no.keys", new Object[0]) : CredentialStoreBundle.INSTANCE.message("passwordSafeConfigurable.protect.master.password.using.pgp.key", new Object[0]);
    }

    private final PgpKey getSelectedPgpKey() {
        PgpKey pgpKey;
        Object v2;
        block3: {
            String string = this.settings.getState().getPgpKeyId();
            if (string == null) {
                return null;
            }
            String currentKeyId = string;
            List list = this.pgpListModel.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
            Iterable $this$firstOrNull$iv = list;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                PgpKey it = (PgpKey)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getKeyId(), (Object)currentKeyId)) continue;
                v2 = element$iv;
                break block3;
            }
            v2 = null;
        }
        if ((pgpKey = (PgpKey)v2) == null) {
            List list = this.pgpListModel.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
            pgpKey = (PgpKey)CollectionsKt.firstOrNull((List)list);
        }
        return pgpKey;
    }

    private final KeePassFileManager createKeePassFileManager() {
        Path path = this.getNewDbFile();
        if (path == null) {
            return null;
        }
        return new KeePassFileManager(path, KeePassCredentialStoreKt.getDefaultMainPasswordFile(), this.getEncryptionSpec(), this.secureRandom);
    }

    private final EncryptionSpec getEncryptionSpec() {
        PgpKey pgpKey = this.getNewPgpKey();
        return pgpKey == null ? new EncryptionSpec(EncryptionSupportKt.getDefaultEncryptionType(), null) : new EncryptionSpec(EncryptionType.PGP_KEY, pgpKey.getKeyId());
    }

    private final PgpKey getNewPgpKey() {
        Object object;
        ComboBox<PgpKey> comboBox = this.pgpKeyCombo;
        if (comboBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"pgpKeyCombo");
            comboBox = null;
        }
        return (object = comboBox.getSelectedItem()) instanceof PgpKey ? (PgpKey)object : null;
    }

    private static final Pgp pgp_delegate$lambda$0() {
        return new Pgp(null, 1, null);
    }

    private static final SecureRandom secureRandom$lambda$0() {
        return CredentialStoreKt.createSecureRandom();
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit getComponent$lambda$0(PasswordSafeConfigurableUi this$0, Panel $this$panel) {
        void $this$bind$iv;
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        ButtonsGroup buttonsGroup = Panel.buttonsGroup$default((Panel)$this$panel, (String)CredentialStoreBundle.INSTANCE.message("passwordSafeConfigurable.save.password", new Object[0]), (boolean)false, arg_0 -> PasswordSafeConfigurableUi.getComponent$lambda$0$0(this$0, arg_0), (int)2, null);
        KMutableProperty0 prop$iv = (KMutableProperty0)new MutablePropertyReference0Impl(this$0.settings){

            public Object get() {
                return ((PasswordSafeSettings)this.receiver).getProviderType();
            }

            public void set(Object value) {
                ((PasswordSafeSettings)this.receiver).setProviderType((ProviderType)value);
            }
        };
        boolean $i$f$bind = false;
        $this$bind$iv.bind(MutablePropertyKt.toMutableProperty((KMutableProperty0)prop$iv), ProviderType.class);
        return Unit.INSTANCE;
    }

    private static final Unit getComponent$lambda$0$0(PasswordSafeConfigurableUi this$0, Panel $this$buttonsGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$buttonsGroup, (String)"$this$buttonsGroup");
        Panel.row$default((Panel)$this$buttonsGroup, null, PasswordSafeConfigurableUi::getComponent$lambda$0$0$0, (int)1, null).visible(CredentialStoreManager.Companion.getInstance().isSupported(ProviderType.KEYCHAIN));
        Panel.row$default((Panel)$this$buttonsGroup, null, arg_0 -> PasswordSafeConfigurableUi.getComponent$lambda$0$0$1(this$0, arg_0), (int)1, null).visible(CredentialStoreManager.Companion.getInstance().isSupported(ProviderType.KEEPASS));
        RowsRange rowsRange = $this$buttonsGroup.indent(arg_0 -> PasswordSafeConfigurableUi.getComponent$lambda$0$0$2(this$0, arg_0));
        JRadioButton jRadioButton = this$0.keepassRadioButton;
        if (jRadioButton == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"keepassRadioButton");
            jRadioButton = null;
        }
        rowsRange.enabledIf(ComponentPredicateKt.getSelected((AbstractButton)jRadioButton)).visible(CredentialStoreManager.Companion.getInstance().isSupported(ProviderType.KEEPASS));
        Panel.row$default((Panel)$this$buttonsGroup, null, PasswordSafeConfigurableUi::getComponent$lambda$0$0$3, (int)1, null).visible(CredentialStoreManager.Companion.getInstance().isSupported(ProviderType.MEMORY_ONLY));
        return Unit.INSTANCE;
    }

    private static final Unit getComponent$lambda$0$0$0(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.radioButton(CredentialStoreBundle.INSTANCE.message("passwordSafeConfigurable.in.native.keychain", new Object[0]), (Object)ProviderType.KEYCHAIN);
        return Unit.INSTANCE;
    }

    private static final Unit getComponent$lambda$0$0$1(PasswordSafeConfigurableUi this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.keepassRadioButton = (JRadioButton)$this$row.radioButton(CredentialStoreBundle.INSTANCE.message("passwordSafeConfigurable.in.keepass", new Object[0]), (Object)ProviderType.KEEPASS).getComponent();
        return Unit.INSTANCE;
    }

    private static final Unit getComponent$lambda$0$0$2(PasswordSafeConfigurableUi this$0, Panel $this$indent) {
        Intrinsics.checkNotNullParameter((Object)$this$indent, (String)"$this$indent");
        $this$indent.row(CredentialStoreBundle.INSTANCE.message("settings.password.database", new Object[0]), arg_0 -> PasswordSafeConfigurableUi.getComponent$lambda$0$0$2$0(this$0, arg_0));
        Panel.row$default((Panel)$this$indent, null, arg_0 -> PasswordSafeConfigurableUi.getComponent$lambda$0$0$2$1(this$0, arg_0), (int)1, null);
        return Unit.INSTANCE;
    }

    /*
     * WARNING - void declaration
     */
    private static final Unit getComponent$lambda$0$0$2$0(PasswordSafeConfigurableUi this$0, Row $this$row) {
        AnAction[] anActionArray;
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleLocalFileDescriptor().withTitle(CredentialStoreBundle.INSTANCE.message("passwordSafeConfigurable.keepass.database.file", new Object[0])).withExtensionFilter("kdbx");
        Intrinsics.checkNotNull((Object)fileChooserDescriptor);
        AnAction[] anActionArray2 = anActionArray = Row.textFieldWithBrowseButton$default((Row)$this$row, (FileChooserDescriptor)fileChooserDescriptor, null, PasswordSafeConfigurableUi::getComponent$lambda$0$0$2$0$0, (int)2, null).resizableColumn().align((Align)AlignX.FILL.INSTANCE).gap(RightGap.SMALL);
        PasswordSafeConfigurableUi passwordSafeConfigurableUi = this$0;
        boolean bl = false;
        if (!SystemInfo.isWindows) {
            void $this$getComponent_u24lambda_u240_u240_u242_u240_u241;
            Cell.comment$default((Cell)$this$getComponent_u24lambda_u240_u240_u242_u240_u241, (String)CredentialStoreBundle.INSTANCE.message("passwordSafeConfigurable.weak.encryption", new Object[0]), (int)0, null, (int)6, null);
        }
        passwordSafeConfigurableUi.keePassDbFile = (TextFieldWithBrowseButton)anActionArray.getComponent();
        anActionArray = new AnAction[]{this$0.new ClearKeePassDatabaseAction(), this$0.new ImportKeePassDatabaseAction(), this$0.new ChangeKeePassDatabaseMasterPasswordAction()};
        ExtensionsKt.actionsButton$default((Row)$this$row, (AnAction[])anActionArray, null, null, (int)6, null);
        return Unit.INSTANCE;
    }

    private static final String getComponent$lambda$0$0$2$0$0(VirtualFile it) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        if (it.isDirectory()) {
            object = it.getPath() + File.separator + "c.kdbx";
        } else {
            String string = it.getPath();
            object = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        }
        Object path = object;
        String string = new File((String)path).getPath();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPath(...)");
        return string;
    }

    private static final Unit getComponent$lambda$0$0$2$1(PasswordSafeConfigurableUi this$0, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        this$0.usePgpKey = (JCheckBox)ButtonKt.bindSelected((Cell)$this$row.checkBox(this$0.usePgpKeyText()), () -> PasswordSafeConfigurableUi.getComponent$lambda$0$0$2$1$0(this$0), arg_0 -> PasswordSafeConfigurableUi.getComponent$lambda$0$0$2$1$1(this$0, arg_0)).gap(RightGap.SMALL).getComponent();
        Cell cell = ComboBoxKt.columns((Cell)ComboBoxKt.bindItem((Cell)$this$row.comboBox((ComboBoxModel)this$0.pgpListModel, BuilderKt.textListCellRenderer(PasswordSafeConfigurableUi::getComponent$lambda$0$0$2$1$2)), () -> PasswordSafeConfigurableUi.getComponent$lambda$0$0$2$1$3(this$0), arg_0 -> PasswordSafeConfigurableUi.getComponent$lambda$0$0$2$1$4(this$0, arg_0)), (int)25);
        JCheckBox jCheckBox = this$0.usePgpKey;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"usePgpKey");
            jCheckBox = null;
        }
        this$0.pgpKeyCombo = (ComboBox)cell.enabledIf(ComponentPredicateKt.getSelected((AbstractButton)jCheckBox)).getComponent();
        return Unit.INSTANCE;
    }

    private static final boolean getComponent$lambda$0$0$2$1$0(PasswordSafeConfigurableUi this$0) {
        return !this$0.pgpListModel.isEmpty() && this$0.settings.getState().getPgpKeyId() != null;
    }

    private static final Unit getComponent$lambda$0$0$2$1$1(PasswordSafeConfigurableUi this$0, boolean it) {
        if (!it) {
            this$0.settings.getState().setPgpKeyId(null);
        }
        return Unit.INSTANCE;
    }

    private static final String getComponent$lambda$0$0$2$1$2(PgpKey it) {
        String string;
        PgpKey pgpKey = it;
        if (pgpKey != null) {
            PgpKey it2 = pgpKey;
            boolean bl = false;
            string = it2.getUserId() + " (" + it2.getKeyId() + ")";
        } else {
            string = null;
        }
        return string;
    }

    private static final PgpKey getComponent$lambda$0$0$2$1$3(PasswordSafeConfigurableUi this$0) {
        PgpKey pgpKey = this$0.getSelectedPgpKey();
        if (pgpKey == null) {
            List list = this$0.pgpListModel.getItems();
            Intrinsics.checkNotNullExpressionValue((Object)list, (String)"getItems(...)");
            pgpKey = (PgpKey)CollectionsKt.firstOrNull((List)list);
        }
        return pgpKey;
    }

    private static final Unit getComponent$lambda$0$0$2$1$4(PasswordSafeConfigurableUi this$0, PgpKey it) {
        String string;
        PasswordSafeOptions passwordSafeOptions = this$0.settings.getState();
        JCheckBox jCheckBox = this$0.usePgpKey;
        if (jCheckBox == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"usePgpKey");
            jCheckBox = null;
        }
        if (jCheckBox.isSelected()) {
            PgpKey pgpKey = it;
            string = pgpKey != null ? pgpKey.getKeyId() : null;
        } else {
            string = null;
        }
        passwordSafeOptions.setPgpKeyId(string);
        return Unit.INSTANCE;
    }

    private static final Unit getComponent$lambda$0$0$3(Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.radioButton(CredentialStoreBundle.INSTANCE.message("passwordSafeConfigurable.do.not.save", new Object[0]), (Object)ProviderType.MEMORY_ONLY);
        return Unit.INSTANCE;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/credentialStore/PasswordSafeConfigurableUi$ChangeKeePassDatabaseMasterPasswordAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "(Lcom/intellij/credentialStore/PasswordSafeConfigurableUi;)V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "e", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.credentialStore.ui"})
    private final class ChangeKeePassDatabaseMasterPasswordAction
    extends DumbAwareAction {
        public ChangeKeePassDatabaseMasterPasswordAction() {
            super(new MainKeyFileStorage(KeePassCredentialStoreKt.getDefaultMainPasswordFile()).isAutoGenerated() ? CredentialStoreBundle.INSTANCE.message("action.set.password.text", new Object[0]) : CredentialStoreBundle.INSTANCE.message("action.change.password.text", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            PasswordSafeConfigurableKt.access$closeCurrentStore();
            KeePassFileManager keePassFileManager = PasswordSafeConfigurableUi.this.createKeePassFileManager();
            boolean bl = keePassFileManager != null ? KeePassFileManager.askAndSetMainKey$default((KeePassFileManager)keePassFileManager, (AnActionEvent)event, null, (int)2, null) : false;
            if (bl) {
                this.getTemplatePresentation().setText(CredentialStoreBundle.INSTANCE.message("settings.password.change.master.password", new Object[0]));
            }
        }

        public void update(@NotNull AnActionEvent e) {
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            e.getPresentation().setEnabled(PasswordSafeConfigurableUi.this.getNewDbFileAsString() != null);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\u0007H\u0016J\b\u0010\n\u001a\u00020\u000bH\u0016\u00a8\u0006\f"}, d2={"Lcom/intellij/credentialStore/PasswordSafeConfigurableUi$ClearKeePassDatabaseAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "(Lcom/intellij/credentialStore/PasswordSafeConfigurableUi;)V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "update", "e", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "intellij.platform.credentialStore.ui"})
    private final class ClearKeePassDatabaseAction
    extends DumbAwareAction {
        public ClearKeePassDatabaseAction() {
            super(CredentialStoreBundle.INSTANCE.message("action.text.password.safe.clear", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            block1: {
                Intrinsics.checkNotNullParameter((Object)event, (String)"event");
                if (!((MessageDialogBuilder.YesNo)MessageDialogBuilder.Companion.yesNo(CredentialStoreBundle.INSTANCE.message("passwordSafeConfigurable.clear.passwords", new Object[0]), CredentialStoreBundle.INSTANCE.message("passwordSafeConfigurable.are.you.sure", new Object[0])).yesText(CredentialStoreBundle.INSTANCE.message("passwordSafeConfigurable.remove.passwords", new Object[0]))).ask(event.getProject())) {
                    return;
                }
                PasswordSafeConfigurableKt.access$closeCurrentStore();
                PasswordSafeConfigurableKt.access$getLOG().info("Passwords cleared", (Throwable)new Error());
                KeePassFileManager keePassFileManager = PasswordSafeConfigurableUi.this.createKeePassFileManager();
                if (keePassFileManager == null) break block1;
                keePassFileManager.clear();
            }
        }

        public void update(@NotNull AnActionEvent e) {
            boolean bl;
            Intrinsics.checkNotNullParameter((Object)e, (String)"e");
            Presentation presentation = e.getPresentation();
            Path path = PasswordSafeConfigurableUi.this.getNewDbFile();
            if (path != null) {
                LinkOption[] linkOptionArray = new LinkOption[]{};
                bl = Files.exists(path, Arrays.copyOf(linkOptionArray, linkOptionArray.length));
            } else {
                bl = false;
            }
            presentation.setEnabled(bl);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            return ActionUpdateThread.BGT;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016\u00a8\u0006\b"}, d2={"Lcom/intellij/credentialStore/PasswordSafeConfigurableUi$ImportKeePassDatabaseAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "<init>", "(Lcom/intellij/credentialStore/PasswordSafeConfigurableUi;)V", "actionPerformed", "", "event", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "intellij.platform.credentialStore.ui"})
    private final class ImportKeePassDatabaseAction
    extends DumbAwareAction {
        public ImportKeePassDatabaseAction() {
            super(CredentialStoreBundle.INSTANCE.message("action.text.password.safe.import", new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent event) {
            Intrinsics.checkNotNullParameter((Object)event, (String)"event");
            PasswordSafeConfigurableKt.access$closeCurrentStore();
            FileChooserDescriptor fileChooserDescriptor = FileChooserDescriptorFactory.createSingleFileDescriptor().withExtensionFilter("kdbx");
            Intrinsics.checkNotNullExpressionValue((Object)fileChooserDescriptor, (String)"withExtensionFilter(...)");
            LayoutBuilderKt.chooseFile((FileChooserDescriptor)fileChooserDescriptor, (AnActionEvent)event, arg_0 -> ImportKeePassDatabaseAction.actionPerformed$lambda$0(PasswordSafeConfigurableUi.this, event, arg_0));
        }

        private static final Unit actionPerformed$lambda$0(PasswordSafeConfigurableUi this$0, AnActionEvent $event, VirtualFile it) {
            block0: {
                Intrinsics.checkNotNullParameter((Object)it, (String)"it");
                KeePassFileManager keePassFileManager = this$0.createKeePassFileManager();
                if (keePassFileManager == null) break block0;
                Path path = Paths.get(it.getPath(), new String[0]);
                Intrinsics.checkNotNullExpressionValue((Object)path, (String)"get(...)");
                keePassFileManager.import(path, $event);
            }
            return Unit.INSTANCE;
        }
    }

    @Metadata(mv={2, 2, 0}, k=3, xi=48)
    public static final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[ProviderType.values().length];
            try {
                nArray[ProviderType.MEMORY_ONLY.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProviderType.KEYCHAIN.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[ProviderType.KEEPASS.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

