/*
 * Decompiled with CFR 0.152.
 */
package fleet.util;

import fleet.reporting.shared.runtime.TlKt;
import fleet.reporting.shared.tracing.TracingKt;
import fleet.tracing.SpanInfoBuilder;
import fleet.tracing.runtime.CompletableSpan;
import fleet.tracing.runtime.Span;
import fleet.util.BytesKt;
import kotlin.Metadata;
import kotlin.Result;
import kotlin.ResultKt;
import kotlin.io.encoding.Base64;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.random.Random;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\u0018\u0000 \t2\u00020\u0001:\u0001\tB\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010\u0006\u001a\u00020\u0007J\b\u0010\b\u001a\u00020\u0007H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lfleet/util/Secret;", "", "secret", "", "<init>", "([B)V", "toBase64String", "", "toString", "Companion", "fleet.util.core"})
public final class Secret {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final byte[] secret;

    public Secret(@NotNull byte[] secret) {
        Intrinsics.checkNotNullParameter((Object)secret, (String)"secret");
        this.secret = secret;
        if (!(this.secret.length == 256)) {
            boolean bl = false;
            String string = "Secret should of size 256. " + this.secret.length + " given";
            throw new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final String toBase64String() {
        return Base64.encode$default((Base64)BytesKt.getUrlSafeBase64WithOptionalPadding(), (byte[])this.secret, (int)0, (int)0, (int)6, null);
    }

    @NotNull
    public String toString() {
        return "Secret<***>";
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Lfleet/util/Secret$Companion;", "", "<init>", "()V", "generate", "Lfleet/util/Secret;", "readFromString", "secretAsString", "", "fleet.util.core"})
    @SourceDebugExtension(value={"SMAP\nSecret.kt\nKotlin\n*S Kotlin\n*F\n+ 1 Secret.kt\nfleet/util/Secret$Companion\n+ 2 Tracing.kt\nfleet/reporting/shared/tracing/TracingKt\n+ 3 Tracing.kt\nfleet/reporting/shared/tracing/TracingKt$span$1\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n43#2,5:48\n69#2:53\n18#2:55\n48#2:57\n33#2,19:58\n43#3:54\n1#4:56\n1#4:77\n*S KotlinDebug\n*F\n+ 1 Secret.kt\nfleet/util/Secret$Companion\n*L\n20#1:48,5\n20#1:53\n20#1:55\n20#1:57\n20#1:58,19\n20#1:54\n20#1:56\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @NotNull
        public final Secret generate() {
            Object object;
            String name$iv = "generateSecret";
            boolean $i$f$span = false;
            Span span$iv = TlKt.getCurrentSpan();
            boolean bl = false;
            if (span$iv instanceof Span.Noop) {
                boolean bl2 = false;
                byte[] bytes = new byte[256];
                Random.Default.nextBytes(bytes);
                object = new Secret(bytes);
            } else {
                Object object2;
                void job$iv$iv;
                void name$iv$iv;
                SpanInfoBuilder spanInfoBuilder;
                String string = name$iv;
                Object object3 = span$iv.getJob();
                boolean isScope$iv$iv = false;
                boolean $i$f$spanInfo = false;
                SpanInfoBuilder bl2 = spanInfoBuilder = new SpanInfoBuilder((String)name$iv$iv, (Object)job$iv$iv, isScope$iv$iv);
                Span span2 = span$iv;
                boolean bl3 = false;
                SpanInfoBuilder spanInfoBuilder2 = bl2;
                CompletableSpan span$iv$iv = span2.startChild(spanInfoBuilder.build());
                boolean $i$f$withSpan = false;
                try {
                    Secret secret;
                    boolean bl4 = false;
                    Span child$iv = (Span)span$iv$iv;
                    boolean bl5 = false;
                    Span span$iv$iv2 = child$iv;
                    boolean $i$f$withCurrentSpan = false;
                    Span oldSpan$iv$iv = (Span)TlKt.getCurrentSpanThreadLocal().get();
                    boolean bl6 = false;
                    try {
                        TlKt.getCurrentSpanThreadLocal().set((Object)span$iv$iv2);
                        boolean bl7 = false;
                        byte[] bytes = new byte[256];
                        Random.Default.nextBytes(bytes);
                        secret = new Secret(bytes);
                    }
                    finally {
                        TlKt.getCurrentSpanThreadLocal().set((Object)oldSpan$iv$iv);
                    }
                    object2 = Result.constructor-impl((Object)secret);
                }
                catch (Throwable throwable) {
                    object2 = Result.constructor-impl((Object)ResultKt.createFailure((Throwable)throwable));
                }
                Object it$iv$iv = object2;
                boolean bl8 = false;
                TracingKt.completeWithResult((CompletableSpan)span$iv$iv, (Object)it$iv$iv);
                ResultKt.throwOnFailure((Object)object2);
                object = object2;
            }
            return object;
        }

        @Nullable
        public final Secret readFromString(@NotNull String secretAsString) {
            byte[] byArray;
            Intrinsics.checkNotNullParameter((Object)secretAsString, (String)"secretAsString");
            try {
                Secret secret;
                byte[] byArray2;
                byte[] it = byArray2 = Base64.decode$default((Base64)BytesKt.getUrlSafeBase64WithOptionalPadding(), (CharSequence)secretAsString, (int)0, (int)0, (int)6, null);
                boolean bl = false;
                Object object = byArray = (Object)(it.length == 256 ? byArray2 : null);
                if (byArray != null) {
                    it = byArray;
                    boolean bl2 = false;
                    secret = new Secret(it);
                } else {
                    secret = null;
                }
                byArray = secret;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                byArray = null;
            }
            return byArray;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

