/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.spellchecker.SpellCheckerManagerKt;
import com.intellij.spellchecker.dictionary.Loader;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.nio.charset.Charset;
import java.util.concurrent.CancellationException;
import java.util.function.Consumer;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.io.CloseableKt;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.text.Charsets;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0002\u0018\u00002\u00020\u0001B\u001b\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0016\u0010\b\u001a\u00020\t2\f\u0010\n\u001a\b\u0012\u0004\u0012\u00020\u00030\u000bH\u0016J\b\u0010\f\u001a\u00020\u0003H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0004\u001a\u0006\u0012\u0002\b\u00030\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\r"}, d2={"Lcom/intellij/spellchecker/StreamLoader;", "Lcom/intellij/spellchecker/dictionary/Loader;", "name", "", "loaderClass", "Ljava/lang/Class;", "<init>", "(Ljava/lang/String;Ljava/lang/Class;)V", "load", "", "consumer", "Ljava/util/function/Consumer;", "getName", "intellij.spellchecker"})
@SourceDebugExtension(value={"SMAP\nSpellCheckerManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 SpellCheckerManager.kt\ncom/intellij/spellchecker/StreamLoader\n+ 2 ReadWrite.kt\nkotlin/io/TextStreamsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 4 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,484:1\n57#2:485\n1#3:486\n1321#4,2:487\n*S KotlinDebug\n*F\n+ 1 SpellCheckerManager.kt\ncom/intellij/spellchecker/StreamLoader\n*L\n459#1:485\n459#1:486\n459#1:487,2\n*E\n"})
final class StreamLoader
implements Loader {
    @NotNull
    private final String name;
    @NotNull
    private final Class<?> loaderClass;

    public StreamLoader(@NotNull String name, @NotNull Class<?> loaderClass) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        Intrinsics.checkNotNullParameter(loaderClass, (String)"loaderClass");
        this.name = name;
        this.loaderClass = loaderClass;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(@NotNull Consumer<String> consumer) {
        Intrinsics.checkNotNullParameter(consumer, (String)"consumer");
        InputStream stream = this.loaderClass.getResourceAsStream(this.name);
        if (stream == null) {
            SpellCheckerManagerKt.access$getLOG$p().warn("Couldn't load dictionary " + this.name + " with loader '" + this.loaderClass + "'");
            return;
        }
        try {
            InputStream inputStream = stream;
            Charset charset = Charsets.UTF_8;
            Reader $this$useLines$iv = new InputStreamReader(inputStream, charset);
            boolean $i$f$useLines = false;
            Closeable closeable = $this$useLines$iv;
            int n = 8192;
            closeable = closeable instanceof BufferedReader ? (BufferedReader)closeable : new BufferedReader((Reader)closeable, n);
            Throwable throwable = null;
            try {
                BufferedReader it$iv = (BufferedReader)closeable;
                boolean bl = false;
                Sequence it = TextStreamsKt.lineSequence((BufferedReader)it$iv);
                boolean bl2 = false;
                Sequence $this$forEach$iv = it;
                boolean $i$f$forEach = false;
                for (Object element$iv : $this$forEach$iv) {
                    String p0 = (String)element$iv;
                    boolean bl3 = false;
                    consumer.accept(p0);
                }
                Unit unit = Unit.INSTANCE;
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
            }
        }
        catch (ProcessCanceledException exception) {
            throw exception;
        }
        catch (CancellationException exception) {
            throw exception;
        }
        catch (Exception e) {
            SpellCheckerManagerKt.access$getLOG$p().error((Throwable)e);
        }
    }

    @Override
    @NotNull
    public String getName() {
        return this.name;
    }
}

