/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.designer.model;

import com.intellij.designer.model.PropertiesContainer;
import com.intellij.designer.propertyTable.PropertyEditor;
import com.intellij.designer.propertyTable.PropertyRenderer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.psi.PsiElement;
import com.intellij.util.ui.TextTransferable;
import java.awt.datatransfer.Transferable;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class Property<T extends PropertiesContainer> {
    private final Property myParent;
    private final String myName;
    private boolean myImportant;
    private boolean myExpert;
    private boolean myDeprecated;

    public Property(@Nullable Property parent, @NotNull String name) {
        if (name == null) {
            Property.$$$reportNull$$$0(0);
        }
        this.myParent = parent;
        this.myName = name;
    }

    @Nullable
    public Property<T> createForNewPresentation() {
        return this.createForNewPresentation(this.myParent, this.myName);
    }

    @Nullable
    public Property<T> createForNewPresentation(@Nullable Property parent, @NotNull String name) {
        if (name == null) {
            Property.$$$reportNull$$$0(1);
        }
        return null;
    }

    @Nullable
    public String getGroup() {
        return null;
    }

    @Nullable
    public final Property getParent() {
        return this.myParent;
    }

    @NotNull
    public List<? extends Property<T>> getChildren(@Nullable T container) {
        List list2 = Collections.emptyList();
        if (list2 == null) {
            Property.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public String getPath() {
        Object object = this.myParent == null ? this.myName : this.myParent.getPath() + "/" + this.myName;
        if (object == null) {
            Property.$$$reportNull$$$0(3);
        }
        return object;
    }

    @Nullable
    public Object getValue(@NotNull T container) throws Exception {
        if (container == null) {
            Property.$$$reportNull$$$0(4);
        }
        return null;
    }

    public void setValue(@NotNull T container, @Nullable Object value) throws Exception {
        if (container == null) {
            Property.$$$reportNull$$$0(5);
        }
    }

    public boolean showAsDefault(@NotNull T container) throws Exception {
        if (container == null) {
            Property.$$$reportNull$$$0(6);
        }
        return this.isDefaultRecursively(container);
    }

    public final boolean isDefaultRecursively(@NotNull T container) throws Exception {
        if (container == null) {
            Property.$$$reportNull$$$0(7);
        }
        if (!this.isDefaultValue(container)) {
            return false;
        }
        for (Property<T> child : this.getChildren(container)) {
            if (child.isDefaultRecursively(container)) continue;
            return false;
        }
        return true;
    }

    public boolean isDefaultValue(@NotNull T container) throws Exception {
        if (container == null) {
            Property.$$$reportNull$$$0(8);
        }
        return true;
    }

    public void setDefaultValue(@NotNull T container) throws Exception {
        if (container == null) {
            Property.$$$reportNull$$$0(9);
        }
    }

    public boolean availableFor(List<PropertiesContainer> components) {
        return true;
    }

    public boolean needRefreshPropertyList(@NotNull T container, @Nullable Object oldValue, @Nullable Object newValue) throws Exception {
        if (container == null) {
            Property.$$$reportNull$$$0(10);
        }
        return false;
    }

    public boolean needRefreshPropertyList() {
        return false;
    }

    public boolean closeEditorDuringRefresh() {
        return false;
    }

    @NotNull
    public Transferable doCopy(@NotNull T container, @NotNull Object commonValue) {
        if (container == null) {
            Property.$$$reportNull$$$0(11);
        }
        if (commonValue == null) {
            Property.$$$reportNull$$$0(12);
        }
        return new TextTransferable(commonValue.toString());
    }

    @NotNull
    @NlsSafe
    public final String getName() {
        String string = this.myName;
        if (string == null) {
            Property.$$$reportNull$$$0(13);
        }
        return string;
    }

    @NlsContexts.Tooltip
    @Nullable
    public String getTooltip() {
        return null;
    }

    public boolean isImportant() {
        return this.myImportant;
    }

    public void setImportant(boolean important) {
        this.myImportant = important;
    }

    public boolean isExpert() {
        return this.myExpert;
    }

    public void setExpert(boolean expert) {
        this.myExpert = expert;
    }

    public boolean isDeprecated() {
        return this.myDeprecated;
    }

    public void setDeprecated(boolean deprecated) {
        this.myDeprecated = deprecated;
    }

    @NotNull
    public abstract PropertyRenderer getRenderer();

    @Nullable
    public abstract PropertyEditor getEditor();

    public boolean isEditable(@Nullable T component) {
        return this.getEditor() != null;
    }

    @Nullable
    public PsiElement getJavadocElement() {
        return null;
    }

    @Nullable
    @Nls
    public String getJavadocText() {
        return null;
    }

    public boolean equals(Object obj2) {
        return obj2 instanceof Property && this.getPath().equals(((Property)obj2).getPath());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 3, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "name";
                break;
            }
            case 2: 
            case 3: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/designer/model/Property";
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "container";
                break;
            }
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "commonValue";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/designer/model/Property";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildren";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getPath";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "createForNewPresentation";
                break;
            }
            case 2: 
            case 3: 
            case 13: {
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getValue";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "setValue";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "showAsDefault";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultRecursively";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "isDefaultValue";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "setDefaultValue";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "needRefreshPropertyList";
                break;
            }
            case 11: 
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "doCopy";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 3, 13 -> new IllegalStateException(string);
        };
    }
}

