/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution;

import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionListener;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.Executor;
import com.intellij.execution.RunProfileStarter;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Key;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.messages.Topic;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import kotlin.Deprecated;
import kotlin.Metadata;
import kotlin.jvm.JvmField;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlinx.coroutines.flow.Flow;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.concurrency.Promise;
import org.jetbrains.concurrency.Promises;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u009a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\"\n\u0002\b\u0003\b&\u0018\u0000 92\u00020\u0001:\u00019B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\b\u0010\u0004\u001a\u00020\u0005H'J\"\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\tH&J\u0013\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eH&\u00a2\u0006\u0002\u0010\u0010J\u0018\u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\n\u001a\u00020\u000bH&J&\u0010\u0011\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0014\u0010\u0012\u001a\u0010\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u00150\u0014H'J,\u0010\u0011\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u00020\u001a0\u0018H\u0007J4\u0010\u0011\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00192\u001a\u0010\u0017\u001a\u0016\u0012\u0004\u0012\u00020\u0019\u0012\u0006\u0012\u0004\u0018\u00010\u0016\u0012\u0004\u0012\u00020\u001a0\u0018H\u0007J:\u0010\u001c\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u001b\u001a\u00020\u00192 \u0010\u0017\u001a\u001c\u0012\u0004\u0012\u00020\u0019\u0012\f\u0012\n\u0012\u0006\u0012\u0004\u0018\u00010\u00160\u0015\u0012\u0004\u0012\u00020\u001a0\u0018H\u0007J \u0010\u0011\u001a\u00020\u00072\u0006\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\n\u001a\u00020\u000bH\u0007J2\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010\u000fJF\u0010\u001d\u001a\u00020\u00072\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0017\u001a\u00020 2\u0006\u0010!\u001a\u00020\"2\b\u0010#\u001a\u0004\u0018\u00010$2\b\u0010%\u001a\u0004\u0018\u00010\u000f2\u0010\u0010&\u001a\f\u0012\u0006\b\u0000\u0012\u00020\u000b\u0018\u00010'H&J\u0010\u0010\u001d\u001a\u00020\u00072\u0006\u0010\n\u001a\u00020\u000bH&J\u000e\u0010(\u001a\u00020)2\u0006\u0010\n\u001a\u00020\u000bJ\u0016\u0010*\u001a\b\u0012\u0004\u0012\u00020)0+2\u0006\u0010\n\u001a\u00020\u000bH\u0007J \u0010(\u001a\u00020)2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020-H'J&\u0010*\u001a\b\u0012\u0004\u0012\u00020)0+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020-2\u0006\u0010/\u001a\u00020-H'J \u00100\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\u00010\u00152\u0006\u0010\n\u001a\u00020\u000b2\u0006\u00101\u001a\u00020\u0019H'J\u001e\u00102\u001a\b\u0012\u0004\u0012\u00020\u0016032\u000e\u00104\u001a\n\u0012\u0006\b\u0000\u0012\u00020$05H'J\u0016\u00106\u001a\b\u0012\u0004\u0012\u00020 072\u0006\u00108\u001a\u00020\u0016H'\u00a8\u0006:"}, d2={"Lcom/intellij/execution/ExecutionManager;", "", "<init>", "()V", "getContentManager", "Lcom/intellij/execution/ui/RunContentManager;", "compileAndRun", "", "startRunnable", "Ljava/lang/Runnable;", "environment", "Lcom/intellij/execution/runners/ExecutionEnvironment;", "onCancelRunnable", "getRunningProcesses", "", "Lcom/intellij/execution/process/ProcessHandler;", "()[Lcom/intellij/execution/process/ProcessHandler;", "startRunProfile", "starter", "Lcom/intellij/execution/RunProfileStarter;", "Lkotlin/Function0;", "Lorg/jetbrains/concurrency/Promise;", "Lcom/intellij/execution/ui/RunContentDescriptor;", "executor", "Lcom/intellij/util/ThrowableConvertor;", "Lcom/intellij/execution/configurations/RunProfileState;", "Lcom/intellij/execution/ExecutionException;", "state", "startRunProfileWithPromise", "restartRunProfile", "project", "Lcom/intellij/openapi/project/Project;", "Lcom/intellij/execution/Executor;", "target", "Lcom/intellij/execution/ExecutionTarget;", "configuration", "Lcom/intellij/execution/RunnerAndConfigurationSettings;", "processHandler", "environmentCustomization", "Ljava/util/function/Consumer;", "isStarting", "", "isStartingFlow", "Lkotlinx/coroutines/flow/Flow;", "configurationId", "", "executorId", "runnerId", "executePreparationTasks", "currentState", "getRunningDescriptors", "", "condition", "Lcom/intellij/openapi/util/Condition;", "getExecutors", "", "descriptor", "Companion", "intellij.platform.execution"})
public abstract class ExecutionManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @JvmField
    @NotNull
    public static final Key<Object> EXECUTION_SESSION_ID_KEY;
    @JvmField
    @NotNull
    public static final Key<Boolean> EXECUTION_SKIP_RUN;
    @JvmField
    @Topic.ProjectLevel
    @NotNull
    public static final Topic<ExecutionListener> EXECUTION_TOPIC;

    @Deprecated(message="Use {@link RunContentManager#getInstance(Project)}")
    @NotNull
    public abstract RunContentManager getContentManager();

    public abstract void compileAndRun(@NotNull Runnable var1, @NotNull ExecutionEnvironment var2, @Nullable Runnable var3);

    @NotNull
    public abstract ProcessHandler[] getRunningProcesses();

    public abstract void startRunProfile(@NotNull RunProfileStarter var1, @NotNull ExecutionEnvironment var2);

    @ApiStatus.Internal
    public abstract void startRunProfile(@NotNull ExecutionEnvironment var1, @NotNull Function0<? extends Promise<RunContentDescriptor>> var2);

    @ApiStatus.Internal
    public final void startRunProfile(@NotNull ExecutionEnvironment environment, @NotNull ThrowableConvertor<RunProfileState, RunContentDescriptor, ExecutionException> executor) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        RunProfileState runProfileState = environment.getState();
        if (runProfileState == null) {
            return;
        }
        this.startRunProfile(environment, runProfileState, executor);
    }

    @ApiStatus.Internal
    public final void startRunProfile(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state, @NotNull ThrowableConvertor<RunProfileState, RunContentDescriptor, ExecutionException> executor) {
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        this.startRunProfile(environment, (Function0<? extends Promise<RunContentDescriptor>>)((Function0)() -> ExecutionManager.startRunProfile$lambda$0(executor, state)));
    }

    @ApiStatus.Internal
    public final void startRunProfileWithPromise(@NotNull ExecutionEnvironment environment, @NotNull RunProfileState state, @NotNull ThrowableConvertor<RunProfileState, Promise<RunContentDescriptor>, ExecutionException> executor) throws ExecutionException {
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter(executor, (String)"executor");
        this.startRunProfile(environment, (Function0<? extends Promise<RunContentDescriptor>>)((Function0)() -> ExecutionManager.startRunProfileWithPromise$lambda$0(executor, state)));
    }

    @Deprecated(message="Use {@link #startRunProfile(RunProfileStarter, ExecutionEnvironment)}")
    @ApiStatus.ScheduledForRemoval
    public final void startRunProfile(@NotNull RunProfileStarter starter, @NotNull RunProfileState state, @NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)starter, (String)"starter");
        Intrinsics.checkNotNullParameter((Object)state, (String)"state");
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        this.startRunProfile(starter, environment);
    }

    public final void restartRunProfile(@NotNull Project project, @NotNull Executor executor, @NotNull ExecutionTarget target, @Nullable RunnerAndConfigurationSettings configuration, @Nullable ProcessHandler processHandler2) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)executor, (String)"executor");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        this.restartRunProfile(project, executor, target, configuration, processHandler2, null);
    }

    public abstract void restartRunProfile(@NotNull Project var1, @NotNull Executor var2, @NotNull ExecutionTarget var3, @Nullable RunnerAndConfigurationSettings var4, @Nullable ProcessHandler var5, @Nullable Consumer<? super ExecutionEnvironment> var6);

    public abstract void restartRunProfile(@NotNull ExecutionEnvironment var1);

    public final boolean isStarting(@NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        Object object = environment.getRunnerAndConfigurationSettings();
        if (object == null || (object = object.getUniqueID()) == null) {
            object = "";
        }
        String string = environment.getExecutor().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String string2 = environment.getRunner().getRunnerId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRunnerId(...)");
        return this.isStarting((String)object, string, string2);
    }

    @ApiStatus.Internal
    @NotNull
    public final Flow<Boolean> isStartingFlow(@NotNull ExecutionEnvironment environment) {
        Intrinsics.checkNotNullParameter((Object)((Object)environment), (String)"environment");
        Object object = environment.getRunnerAndConfigurationSettings();
        if (object == null || (object = object.getUniqueID()) == null) {
            object = "";
        }
        String string = environment.getExecutor().getId();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getId(...)");
        String string2 = environment.getRunner().getRunnerId();
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getRunnerId(...)");
        return this.isStartingFlow((String)object, string, string2);
    }

    @ApiStatus.Internal
    public abstract boolean isStarting(@NotNull String var1, @NotNull String var2, @NotNull String var3);

    @ApiStatus.Internal
    @NotNull
    public abstract Flow<Boolean> isStartingFlow(@NotNull String var1, @NotNull String var2, @NotNull String var3);

    @ApiStatus.Experimental
    @NotNull
    public abstract Promise<Object> executePreparationTasks(@NotNull ExecutionEnvironment var1, @NotNull RunProfileState var2);

    @ApiStatus.Internal
    @NotNull
    public abstract List<RunContentDescriptor> getRunningDescriptors(@NotNull Condition<? super RunnerAndConfigurationSettings> var1);

    @ApiStatus.Internal
    @NotNull
    public abstract Set<Executor> getExecutors(@NotNull RunContentDescriptor var1);

    private static final Promise startRunProfile$lambda$0(ThrowableConvertor $executor, RunProfileState $state) {
        return Promises.resolvedPromise((Object)$executor.convert((Object)$state));
    }

    private static final Promise startRunProfileWithPromise$lambda$0(ThrowableConvertor $executor, RunProfileState $state) {
        Object object = $executor.convert((Object)$state);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"convert(...)");
        return (Promise)object;
    }

    @JvmStatic
    @NotNull
    public static final ExecutionManager getInstance(@NotNull Project project) {
        return Companion.getInstance(project);
    }

    static {
        Key key = Key.create((String)"EXECUTION_SESSION_ID_KEY");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        EXECUTION_SESSION_ID_KEY = key;
        Key key2 = Key.create((String)"EXECUTION_SKIP_RUN");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        EXECUTION_SKIP_RUN = key2;
        EXECUTION_TOPIC = new Topic("configuration executed", ExecutionListener.class, Topic.BroadcastDirection.TO_PARENT);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0007R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00010\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00070\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/intellij/execution/ExecutionManager$Companion;", "", "<init>", "()V", "EXECUTION_SESSION_ID_KEY", "Lcom/intellij/openapi/util/Key;", "EXECUTION_SKIP_RUN", "", "EXECUTION_TOPIC", "Lcom/intellij/util/messages/Topic;", "Lcom/intellij/execution/ExecutionListener;", "getInstance", "Lcom/intellij/execution/ExecutionManager;", "project", "Lcom/intellij/openapi/project/Project;", "intellij.platform.execution"})
    public static final class Companion {
        private Companion() {
        }

        @JvmStatic
        @NotNull
        public final ExecutionManager getInstance(@NotNull Project project) {
            Intrinsics.checkNotNullParameter((Object)project, (String)"project");
            Object object = project.getService(ExecutionManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ExecutionManager)object;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

