/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.rmi;

import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionException;
import com.intellij.execution.ExecutionManager;
import com.intellij.execution.ExecutionResult;
import com.intellij.execution.Executor;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.configurations.RunProfileState;
import com.intellij.execution.configurations.RunnerSettings;
import com.intellij.execution.executors.DefaultRunExecutor;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.process.ProcessOutputTypes;
import com.intellij.execution.rmi.IdeaWatchdog;
import com.intellij.execution.rmi.RemoteObject;
import com.intellij.execution.rmi.RemoteServer;
import com.intellij.execution.rmi.RemoteUtil;
import com.intellij.execution.runners.DefaultProgramRunnerKt;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ProgramRunner;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.Cancellation;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NlsSafe;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.ThrowableComputable;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.util.ExceptionUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ThrowableConvertor;
import com.intellij.util.concurrency.AppExecutorUtil;
import com.intellij.util.concurrency.ThreadingAssertions;
import com.intellij.util.concurrency.annotations.RequiresBackgroundThread;
import java.rmi.NotBoundException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.registry.LocateRegistry;
import java.rmi.registry.Registry;
import java.rmi.server.RMIClientSocketFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import kotlinx.coroutines.Job;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.TestOnly;

public abstract class RemoteProcessSupport<Target, EntryPoint, Parameters> {
    public static final Logger LOG = Logger.getInstance(RemoteProcessSupport.class);
    private final Class<EntryPoint> myValueClass;
    private final AtomicReference<Heartbeat> myHeartbeatRef;
    private final AtomicReference<Future> myShutdownFuture;
    private final Map<Pair<Target, Parameters>, Info> myProcMap;
    private final Map<Pair<Target, Parameters>, InProcessInfo<EntryPoint>> myInProcMap;

    public RemoteProcessSupport(@NotNull Class<EntryPoint> valueClass) {
        if (valueClass == null) {
            RemoteProcessSupport.$$$reportNull$$$0(0);
        }
        this.myHeartbeatRef = new AtomicReference();
        this.myShutdownFuture = new AtomicReference();
        this.myProcMap = new HashMap<Pair<Target, Parameters>, Info>();
        this.myInProcMap = new HashMap<Pair<Target, Parameters>, InProcessInfo<EntryPoint>>();
        this.myValueClass = valueClass;
    }

    protected abstract void fireModificationCountChanged();

    protected abstract String getName(@NotNull Target var1);

    protected void logText(@NotNull Parameters configuration, @NotNull ProcessEvent event, @NotNull Key outputType) {
        if (configuration == null) {
            RemoteProcessSupport.$$$reportNull$$$0(1);
        }
        if (event == null) {
            RemoteProcessSupport.$$$reportNull$$$0(2);
        }
        if (outputType == null) {
            RemoteProcessSupport.$$$reportNull$$$0(3);
        }
        String text2 = StringUtil.notNullize((String)event.getText());
        if (outputType == ProcessOutputTypes.STDERR) {
            LOG.warn(text2.trim());
        } else {
            LOG.debug(text2.trim());
        }
    }

    public void stopAll() {
        this.stopAll(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopAll(boolean wait) {
        CompletableFuture<Object> finishFuture = new CompletableFuture<Object>();
        if (this.myShutdownFuture.compareAndSet(null, finishFuture)) {
            ArrayList<Info> infos = new ArrayList<Info>();
            Map<Pair<Target, Parameters>, Info> map = this.myProcMap;
            synchronized (map) {
                for (Info o : this.myProcMap.values()) {
                    if (o.handler == null) continue;
                    infos.add(o);
                }
            }
            if (infos.isEmpty()) {
                finishFuture.complete(null);
                return;
            }
            ApplicationManager.getApplication().executeOnPooledThread(() -> {
                try {
                    RemoteProcessSupport.destroyProcessesImpl(infos);
                    if (wait) {
                        for (Info o : infos) {
                            o.handler.waitFor();
                        }
                    }
                    finishFuture.complete(null);
                }
                catch (Throwable e) {
                    finishFuture.completeExceptionally(e);
                }
            });
        }
        if (wait) {
            try {
                this.myShutdownFuture.get().get();
            }
            catch (InterruptedException infos) {
            }
            catch (java.util.concurrent.ExecutionException e) {
                LOG.warn((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Parameters> getActiveConfigurations(@NotNull Target target) {
        if (target == null) {
            RemoteProcessSupport.$$$reportNull$$$0(4);
        }
        ArrayList<Object> result2 = new ArrayList<Object>();
        Map<Pair<Target, Parameters>, Info> map = this.myProcMap;
        synchronized (map) {
            for (Pair<Target, Parameters> pair : this.myProcMap.keySet()) {
                if (pair.first != target) continue;
                result2.add(pair.second);
            }
        }
        if (RemoteObject.IN_PROCESS) {
            map = this.myInProcMap;
            synchronized (map) {
                for (Pair<Target, Parameters> pair : this.myInProcMap.keySet()) {
                    if (pair.first != target) continue;
                    result2.add(pair.second);
                }
            }
        }
        return result2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Set<Pair<Target, Parameters>> getActiveConfigurations() {
        HashSet<Pair<Target, Parameters>> configurations;
        Map<Pair<Target, Parameters>, Info> map = this.myProcMap;
        synchronized (map) {
            configurations = new HashSet<Pair<Target, Parameters>>(this.myProcMap.keySet());
        }
        if (RemoteObject.IN_PROCESS) {
            map = this.myInProcMap;
            synchronized (map) {
                configurations.addAll(this.myInProcMap.keySet());
            }
        }
        return configurations;
    }

    @Deprecated
    @ApiStatus.Internal
    public EntryPoint acquire(@NotNull Target target, @NotNull Parameters configuration) throws Exception {
        if (target == null) {
            RemoteProcessSupport.$$$reportNull$$$0(5);
        }
        if (configuration == null) {
            RemoteProcessSupport.$$$reportNull$$$0(6);
        }
        return this.acquire(target, configuration, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @RequiresBackgroundThread
    public EntryPoint acquire(@NotNull Target target, @NotNull Parameters configuration, @Nullable ProgressIndicator indicator) throws Exception {
        RunningInfo info;
        if (target == null) {
            RemoteProcessSupport.$$$reportNull$$$0(7);
        }
        if (configuration == null) {
            RemoteProcessSupport.$$$reportNull$$$0(8);
        }
        ThreadingAssertions.assertBackgroundThread();
        EntryPoint inProcess = this.acquireInProcess(target, configuration);
        if (inProcess != null) {
            return inProcess;
        }
        Ref ref = Ref.create(null);
        Pair key = Pair.create(target, configuration);
        boolean created = false;
        if (!this.getExistingInfo((Ref<RunningInfo>)ref, key)) {
            this.startProcess(target, configuration, key);
            if (ref.isNull()) {
                try {
                    Ref ref2 = ref;
                    synchronized (ref2) {
                        while (ref.isNull()) {
                            ref.wait(1000L);
                            RemoteProcessSupport.checkIndicator(indicator);
                        }
                    }
                }
                catch (InterruptedException e) {
                    RemoteProcessSupport.checkIndicator(indicator);
                }
            }
            created = true;
        }
        if ((info = (RunningInfo)ref.get()) instanceof FailedInfo) {
            FailedInfo o = (FailedInfo)info;
            String message = o.cause != null && StringUtil.isEmptyOrSpaces((String)o.stderr) ? o.cause.getMessage() : o.stderr;
            throw new ExecutionException(message, o.cause);
        }
        if (info == null || info.handler == null) {
            throw new ExecutionException(ExecutionBundle.message("dialog.remote.process.unable.to.acquire.remote.proxy.for", this.getName(target)));
        }
        EntryPoint result2 = this.acquire(info);
        if (created) {
            this.onCreated(target, configuration, result2);
        }
        return result2;
    }

    protected void onCreated(@NotNull Target target, @NotNull Parameters configuration, @NotNull EntryPoint result2) {
        if (target == null) {
            RemoteProcessSupport.$$$reportNull$$$0(9);
        }
        if (configuration == null) {
            RemoteProcessSupport.$$$reportNull$$$0(10);
        }
        if (result2 == null) {
            RemoteProcessSupport.$$$reportNull$$$0(11);
        }
    }

    private static void checkIndicator(@Nullable ProgressIndicator indicator) {
        if (indicator != null) {
            indicator.checkCanceled();
        } else {
            ProgressManager.checkCanceled();
        }
    }

    protected int publishPort(int port, @NotNull Target target) {
        if (target == null) {
            RemoteProcessSupport.$$$reportNull$$$0(12);
        }
        return port;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public Future<?> release(@NotNull Target target, @Nullable Parameters configuration) {
        if (target == null) {
            RemoteProcessSupport.$$$reportNull$$$0(13);
        }
        ArrayList<Info> infos = new ArrayList<Info>();
        Map<Pair<Target, Parameters>, Info> map = this.myProcMap;
        synchronized (map) {
            for (Pair<Target, Parameters> key : this.myProcMap.keySet()) {
                if (key.first != target || configuration != null && key.second != configuration) continue;
                Info o = this.myProcMap.get(key);
                if (o.handler == null) continue;
                infos.add(o);
            }
        }
        if (RemoteObject.IN_PROCESS) {
            map = this.myInProcMap;
            synchronized (map) {
                Iterator<Pair<Target, Parameters>> it = this.myInProcMap.keySet().iterator();
                while (it.hasNext()) {
                    Pair<Target, Parameters> key;
                    key = it.next();
                    if (key.first != target || configuration != null && key.second != configuration) continue;
                    it.remove();
                }
            }
        }
        Future<Object> future = infos.isEmpty() ? CompletableFuture.completedFuture(null) : ApplicationManager.getApplication().executeOnPooledThread(() -> {
            RemoteProcessSupport.destroyProcessesImpl(infos);
            this.fireModificationCountChanged();
            for (Info o : infos) {
                o.handler.waitFor();
            }
        });
        if (future == null) {
            RemoteProcessSupport.$$$reportNull$$$0(14);
        }
        return future;
    }

    private static void destroyProcessesImpl(@NotNull List<? extends Info> infos) {
        if (infos == null) {
            RemoteProcessSupport.$$$reportNull$$$0(15);
        }
        for (Info info : infos) {
            LOG.info("Terminating: " + String.valueOf(info));
            info.handler.destroyProcess();
        }
    }

    private void startProcess(@NotNull Target target, @NotNull Parameters configuration, @NotNull Pair<Target, Parameters> key) {
        ProcessHandler processHandler2;
        if (target == null) {
            RemoteProcessSupport.$$$reportNull$$$0(16);
        }
        if (configuration == null) {
            RemoteProcessSupport.$$$reportNull$$$0(17);
        }
        if (key == null) {
            RemoteProcessSupport.$$$reportNull$$$0(18);
        }
        ProgramRunner<RunnerSettings> runner = new ProgramRunner<RunnerSettings>(this){

            @Override
            @NotNull
            public String getRunnerId() {
                return "MyRunner";
            }

            @Override
            public void execute(@NotNull ExecutionEnvironment environment) throws ExecutionException {
                if (environment == null) {
                    1.$$$reportNull$$$0(0);
                }
                ExecutionManager.getInstance(environment.getProject()).startRunProfile(environment, (ThrowableConvertor<RunProfileState, RunContentDescriptor, ExecutionException>)((ThrowableConvertor)state -> DefaultProgramRunnerKt.executeState(state, environment, this)));
            }

            @Override
            public boolean canRun(@NotNull String executorId, @NotNull RunProfile profile) {
                if (executorId == null) {
                    1.$$$reportNull$$$0(1);
                }
                if (profile == null) {
                    1.$$$reportNull$$$0(2);
                }
                return true;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "environment";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "executorId";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "profile";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/rmi/RemoteProcessSupport$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "execute";
                        break;
                    }
                    case 1: 
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "canRun";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        Executor executor = DefaultRunExecutor.getRunExecutorInstance();
        try {
            RunProfileState state = this.getRunProfileState(target, configuration, executor);
            ExecutionResult result2 = state.execute(executor, runner);
            processHandler2 = result2.getProcessHandler();
        }
        catch (Throwable e) {
            this.dropProcessInfo(key, e, null);
            return;
        }
        processHandler2.addProcessListener(this.getProcessListener(key));
        processHandler2.startNotify();
    }

    protected abstract RunProfileState getRunProfileState(@NotNull Target var1, @NotNull Parameters var2, @NotNull Executor var3) throws ExecutionException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean getExistingInfo(@NotNull Ref<RunningInfo> ref, @NotNull Pair<Target, Parameters> key) {
        Info info;
        if (ref == null) {
            RemoteProcessSupport.$$$reportNull$$$0(19);
        }
        if (key == null) {
            RemoteProcessSupport.$$$reportNull$$$0(20);
        }
        Map<Pair<Target, Parameters>, Info> map = this.myProcMap;
        synchronized (map) {
            info = this.myProcMap.get(key);
            try {
                while (info != null && (!(info instanceof RunningInfo) || info.handler.isProcessTerminating() || info.handler.isProcessTerminated())) {
                    this.myProcMap.wait(1000L);
                    ProgressManager.checkCanceled();
                    info = this.myProcMap.get(key);
                }
            }
            catch (InterruptedException e) {
                ProgressManager.checkCanceled();
            }
            if (info == null) {
                LOG.info("Starring remote process. Existing info not found, creating PendingInfo:" + String.valueOf(key));
                this.myProcMap.put(key, new PendingInfo(ref, null));
            }
        }
        if (info instanceof RunningInfo) {
            map = ref;
            synchronized (map) {
                ref.set((Object)((RunningInfo)info));
                ref.notifyAll();
            }
        }
        return info != null;
    }

    private EntryPoint acquire(RunningInfo info) throws Exception {
        Object result2;
        info.entryPointHardRef = result2 = RemoteUtil.executeWithClassLoader(() -> {
            Registry registry = LocateRegistry.getRegistry(info.host, info.port, this.getClientSocketFactory());
            Remote remote = Objects.requireNonNull(registry.lookup(info.name));
            if (this.myValueClass.isInstance(remote)) {
                EntryPoint entryPoint = this.myValueClass.cast(remote);
                return RemoteUtil.substituteClassLoader(entryPoint, (ClassLoader)this.myValueClass.getClassLoader());
            }
            return RemoteUtil.castToLocal((Object)remote, this.myValueClass);
        }, (ClassLoader)this.getClass().getClassLoader());
        return (EntryPoint)result2;
    }

    protected RMIClientSocketFactory getClientSocketFactory() {
        return null;
    }

    private ProcessListener getProcessListener(final @NotNull Pair<Target, Parameters> key) {
        if (key == null) {
            RemoteProcessSupport.$$$reportNull$$$0(21);
        }
        return new ProcessListener(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void startNotified(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(0);
                }
                ProcessHandler processHandler2 = event.getProcessHandler();
                processHandler2.putUserData(ProcessHandler.SILENTLY_DESTROY_ON_CLOSE, (Object)Boolean.TRUE);
                Map map = RemoteProcessSupport.this.myProcMap;
                synchronized (map) {
                    Info o = RemoteProcessSupport.this.myProcMap.get(key);
                    if (o instanceof PendingInfo) {
                        LOG.info("Staring remote process, startNotified received, creating PendingInfo: " + String.valueOf(key));
                        RemoteProcessSupport.this.myProcMap.put(key, new PendingInfo(((PendingInfo)o).ref, processHandler2));
                    }
                }
                RemoteProcessSupport.this.sendDataAfterStart(processHandler2);
            }

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    2.$$$reportNull$$$0(1);
                }
                LOG.info("Remote process terminated with code: " + event.getExitCode() + " message = " + event.getText());
                if (RemoteProcessSupport.this.dropProcessInfo(key, null, event.getProcessHandler())) {
                    RemoteProcessSupport.this.fireModificationCountChanged();
                }
                RemoteProcessSupport.this.onProcessTerminated(event);
            }

            public void processWillTerminate(@NotNull ProcessEvent event, boolean willBeDestroyed) {
                Heartbeat heartbeat;
                if (event == null) {
                    2.$$$reportNull$$$0(2);
                }
                LOG.info("Remote process will terminate: " + event.getText() + " message = " + event.getText());
                if (RemoteProcessSupport.this.dropProcessInfo(key, null, event.getProcessHandler())) {
                    RemoteProcessSupport.this.fireModificationCountChanged();
                }
                if ((heartbeat = RemoteProcessSupport.this.myHeartbeatRef.get()) != null) {
                    heartbeat.stopBeat();
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void onTextAvailable(@NotNull ProcessEvent event, @NotNull Key outputType) {
                PendingInfo info;
                if (event == null) {
                    2.$$$reportNull$$$0(3);
                }
                if (outputType == null) {
                    2.$$$reportNull$$$0(4);
                }
                if (outputType == ProcessOutputTypes.STDOUT) {
                    LOG.debug("Remote process stdout:" + event.getText());
                } else if (outputType == ProcessOutputTypes.STDERR) {
                    LOG.warn("Remote process stderr:" + event.getText());
                } else if (outputType == ProcessOutputTypes.SYSTEM) {
                    LOG.info("Remote process system:" + event.getText());
                }
                String text2 = StringUtil.notNullize((String)event.getText());
                RemoteProcessSupport.this.logText(key.second, event, outputType);
                RunningInfo result2 = null;
                Map map = RemoteProcessSupport.this.myProcMap;
                synchronized (map) {
                    Info o = RemoteProcessSupport.this.myProcMap.get(key);
                    if (o instanceof PendingInfo) {
                        info = (PendingInfo)o;
                        if (outputType == ProcessOutputTypes.STDOUT) {
                            String prefix = "Port/ServicesPort/ID:";
                            if (text2.startsWith(prefix)) {
                                List data = StringUtil.split((String)text2.substring(prefix.length()).trim(), (String)"/");
                                int port = Integer.parseInt((String)data.get(0));
                                int servicesPort = Integer.parseInt((String)data.get(1));
                                String id = (String)data.get(2);
                                String host = RemoteProcessSupport.this.getRemoteHost();
                                LOG.info("Started remote process on: " + host + ":" + port + "with service port " + servicesPort + " and id = " + id);
                                result2 = new RunningInfo(info.handler, host, RemoteProcessSupport.this.publishPort(port, key.first), id, RemoteProcessSupport.this.publishPort(servicesPort, key.first));
                                RemoteProcessSupport.this.myProcMap.put(key, result2);
                                RemoteProcessSupport.this.myProcMap.notifyAll();
                            }
                        } else if (outputType == ProcessOutputTypes.STDERR) {
                            info.stderr.append(text2);
                        }
                    } else {
                        info = null;
                    }
                }
                if (result2 != null) {
                    map = info.ref;
                    synchronized (map) {
                        info.ref.set(result2);
                        info.ref.notifyAll();
                    }
                    RemoteProcessSupport.this.fireModificationCountChanged();
                    try {
                        Heartbeat heartbeat = new Heartbeat(result2.host, result2.port, RemoteProcessSupport.this.getClientSocketFactory());
                        heartbeat.startBeat();
                        RemoteProcessSupport.this.myHeartbeatRef.set(heartbeat);
                    }
                    catch (Throwable e) {
                        LOG.warn("The cook failed to start due to " + String.valueOf(ExceptionUtil.getRootCause((Throwable)e)));
                    }
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "event";
                        break;
                    }
                    case 4: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "outputType";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/rmi/RemoteProcessSupport$2";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "startNotified";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processTerminated";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "processWillTerminate";
                        break;
                    }
                    case 3: 
                    case 4: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onTextAvailable";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
    }

    protected void onProcessTerminated(ProcessEvent event) {
    }

    protected void sendDataAfterStart(ProcessHandler handler) {
    }

    protected String getRemoteHost() {
        return (String)ObjectUtils.notNull((Object)System.getProperty("java.rmi.server.hostname"), (Object)"127.0.0.1");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean dropProcessInfo(Pair<Target, Parameters> key, @Nullable Throwable error, @Nullable ProcessHandler handler) {
        Info info;
        Map<Pair<Target, Parameters>, Info> map = this.myProcMap;
        synchronized (map) {
            info = this.myProcMap.get(key);
            if (info != null && (handler == null || info.handler == handler)) {
                this.myProcMap.remove(key);
                this.myProcMap.notifyAll();
            } else {
                info = null;
            }
        }
        if (info instanceof PendingInfo) {
            PendingInfo pendingInfo = (PendingInfo)info;
            LOG.warn("Dropping process info for pending process: stder = " + String.valueOf(pendingInfo.stderr), error);
            if (error != null || !pendingInfo.stderr.isEmpty() || pendingInfo.ref.isNull()) {
                pendingInfo.ref.set((Object)new FailedInfo(error, pendingInfo.stderr.toString()));
            }
            Ref<RunningInfo> ref = pendingInfo.ref;
            synchronized (ref) {
                pendingInfo.ref.notifyAll();
            }
        }
        return info != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private EntryPoint acquireInProcess(@NotNull Target target, @NotNull Parameters configuration) throws Exception {
        InProcessInfo<EntryPoint> info;
        if (target == null) {
            RemoteProcessSupport.$$$reportNull$$$0(22);
        }
        if (configuration == null) {
            RemoteProcessSupport.$$$reportNull$$$0(23);
        }
        if (!RemoteObject.IN_PROCESS) {
            return null;
        }
        Pair key = Pair.create(target, configuration);
        boolean created = false;
        Map<Pair<Target, Parameters>, InProcessInfo<EntryPoint>> map = this.myInProcMap;
        synchronized (map) {
            info = this.myInProcMap.get(key);
            if (info == null) {
                LOG.info("Running remote service in process: " + String.valueOf(key));
                info = new InProcessInfo<EntryPoint>(this.acquireInProcessFactory(target, configuration));
                this.myInProcMap.put(key, info);
                created = true;
            }
        }
        Object result2 = info.factory.compute();
        if (created) {
            this.onCreated(target, configuration, result2);
        }
        return (EntryPoint)result2;
    }

    protected @NotNull ThrowableComputable<@Nullable EntryPoint, Exception> acquireInProcessFactory(Target target, Parameters configuration) throws Exception {
        ThrowableComputable throwableComputable = () -> null;
        if (throwableComputable == null) {
            RemoteProcessSupport.$$$reportNull$$$0(24);
        }
        return throwableComputable;
    }

    static {
        RemoteServer.setupRMI((boolean)true);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 14, 24 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "valueClass";
                break;
            }
            case 1: 
            case 6: 
            case 8: 
            case 10: 
            case 17: 
            case 23: {
                objectArray2 = objectArray3;
                objectArray3[0] = "configuration";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "event";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "outputType";
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 9: 
            case 12: 
            case 13: 
            case 16: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "target";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 14: 
            case 24: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/rmi/RemoteProcessSupport";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "infos";
                break;
            }
            case 18: 
            case 20: 
            case 21: {
                objectArray2 = objectArray3;
                objectArray3[0] = "key";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ref";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/rmi/RemoteProcessSupport";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "release";
                break;
            }
            case 24: {
                objectArray = objectArray2;
                objectArray2[1] = "acquireInProcessFactory";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "logText";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getActiveConfigurations";
                break;
            }
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "acquire";
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "onCreated";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "publishPort";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "release";
                break;
            }
            case 14: 
            case 24: {
                break;
            }
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "destroyProcessesImpl";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "startProcess";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "getExistingInfo";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getProcessListener";
                break;
            }
            case 22: 
            case 23: {
                objectArray = objectArray;
                objectArray[2] = "acquireInProcess";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 14, 24 -> new IllegalStateException(string);
        };
    }

    private static class Info {
        final ProcessHandler handler;

        Info(ProcessHandler handler) {
            this.handler = handler;
        }
    }

    private static class RunningInfo
    extends Info {
        final String host;
        final int port;
        final String name;
        final int servicesPort;
        Object entryPointHardRef;

        RunningInfo(ProcessHandler handler, String host, int port, String name) {
            this(handler, host, port, name, 0);
        }

        RunningInfo(ProcessHandler handler, String host, int port, String name, int servicesPort) {
            super(handler);
            this.host = host;
            this.port = port;
            this.name = name;
            this.servicesPort = servicesPort;
        }

        public String toString() {
            return this.host + ":" + this.port + "/" + this.name;
        }
    }

    private static class FailedInfo
    extends RunningInfo {
        final Throwable cause;
        @NlsSafe
        final String stderr;

        FailedInfo(Throwable cause, String stderr) {
            super(null, null, -1, null);
            this.cause = cause;
            this.stderr = stderr;
        }

        @Override
        public String toString() {
            return "FailedInfo{" + String.valueOf(this.cause) + "}";
        }
    }

    private static class PendingInfo
    extends Info {
        final Ref<RunningInfo> ref;
        final StringBuilder stderr = new StringBuilder();

        PendingInfo(Ref<RunningInfo> ref, ProcessHandler handler) {
            super(handler);
            this.ref = ref;
        }

        public String toString() {
            return "PendingInfo{" + String.valueOf(this.ref.get()) + "}";
        }
    }

    private static class InProcessInfo<EntryPoint>
    extends Info {
        final ThrowableComputable<EntryPoint, Exception> factory;

        InProcessInfo(ThrowableComputable<EntryPoint, Exception> factory) {
            super(null);
            this.factory = factory;
        }

        public String toString() {
            return "InProcessInfo{" + Integer.toHexString(this.hashCode()) + "}";
        }
    }

    public static class Heartbeat {
        private final Registry myRegistry;
        private boolean live = true;
        private ScheduledFuture<?> myFuture = null;

        Heartbeat(String host, int port, RMIClientSocketFactory clientSocketFactory) throws RemoteException {
            this.myRegistry = LocateRegistry.getRegistry(host, port, clientSocketFactory);
        }

        void stopBeat() {
            if (this.myFuture != null) {
                this.myFuture.cancel(false);
                this.myFuture = null;
            }
        }

        void startBeat() throws RemoteException, NotBoundException {
            IdeaWatchdog watchdog = this.getWatchdog();
            long pulseTimeoutMillis = watchdog.getPulseTimeoutMillis();
            this.myFuture = AppExecutorUtil.getAppScheduledExecutorService().scheduleWithFixedDelay(() -> this.beat(), pulseTimeoutMillis, pulseTimeoutMillis, TimeUnit.MILLISECONDS);
            Job contextJob = Cancellation.currentJob();
            if (contextJob != null) {
                contextJob.invokeOnCompletion(__ -> {
                    this.stopBeat();
                    return null;
                });
            } else {
                Disposer.register((Disposable)ApplicationManager.getApplication(), () -> this.stopBeat());
            }
        }

        public boolean beat() {
            try {
                if (this.live) {
                    IdeaWatchdog watchdog = this.getWatchdog();
                    return watchdog.ping();
                }
            }
            catch (Exception ignore) {
                this.live = false;
                this.stopBeat();
            }
            catch (Throwable t) {
                this.live = false;
                this.stopBeat();
                LOG.error(t);
            }
            return false;
        }

        @TestOnly
        public void kill(int exitCode) {
            try {
                this.getWatchdog().dieNowTestOnly(exitCode);
            }
            catch (NotBoundException | RemoteException exception) {
                // empty catch block
            }
        }

        private IdeaWatchdog getWatchdog() throws RemoteException, NotBoundException {
            Remote remote = this.myRegistry.lookup("_LIVE_PULSE_");
            if (remote instanceof IdeaWatchdog) {
                return (IdeaWatchdog)remote;
            }
            return (IdeaWatchdog)RemoteUtil.castToLocal((Object)remote, IdeaWatchdog.class);
        }
    }
}

