/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.target;

import com.intellij.execution.target.PtyOptions;
import com.intellij.execution.target.TargetEnvironmentRequest;
import com.intellij.execution.target.TargetedCommandLine;
import com.intellij.execution.target.value.TargetValue;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.openapi.vfs.CharsetToolkit;
import com.intellij.util.containers.ContainerUtil;
import java.io.File;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010!\n\u0000\n\u0002\u0010%\n\u0000\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u0011\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0010$\n\u0002\b\u0004\n\u0002\u0010\"\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0006\u0010-\u001a\u00020.J\u000e\u0010\r\u001a\u00020/2\u0006\u0010\b\u001a\u00020\nJ\u001d\u00100\u001a\u00020/2\u0015\u0010\u000f\u001a\u0011\u0012\r\u0012\u000b0\nj\u0002`\u0011\u00a2\u0006\u0002\b\u00100\tJ\u0017\u00100\u001a\u00020/2\u000f\u0010\u000f\u001a\u000b0\nj\u0002`\u0011\u00a2\u0006\u0002\b\u0010J\u0016\u00101\u001a\u0012\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\n0\t02J\u0018\u00103\u001a\u00020/2\u0010\u00104\u001a\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\n0\tJ\u000e\u00103\u001a\u00020/2\u0006\u00104\u001a\u00020\nJ\u0014\u00105\u001a\u00020/2\f\u00106\u001a\b\u0012\u0004\u0012\u00020\n02J\u001f\u00105\u001a\u00020/2\u0012\u00106\u001a\n\u0012\u0006\b\u0001\u0012\u00020\n07\"\u00020\n\u00a2\u0006\u0002\u00108J\u0016\u00109\u001a\u00020/2\u0006\u0010:\u001a\u00020;2\u0006\u00104\u001a\u00020\nJ \u00109\u001a\u00020/2\u0006\u0010:\u001a\u00020;2\u000e\u00104\u001a\n\u0012\u0006\u0012\u0004\u0018\u00010\n0\tH\u0002J\u001c\u0010<\u001a\u00020/2\u0006\u0010:\u001a\u00020;2\f\u0010\u001a\u001a\b\u0012\u0004\u0012\u00020\n02J&\u0010=\u001a\u00020/2\u0006\u0010:\u001a\u00020;2\u0016\u0010\u001a\u001a\u0012\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\n0\t02J\u001e\u0010>\u001a\u00020/2\u0016\u0010\u001a\u001a\u0012\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\n0\t02J\u001e\u0010?\u001a\u00020/2\u0006\u0010@\u001a\u00020\n2\u000e\u0010A\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\tJ\u0018\u0010?\u001a\u00020/2\u0006\u0010@\u001a\u00020\n2\b\u0010A\u001a\u0004\u0018\u00010\nJ\u000e\u0010B\u001a\u00020/2\u0006\u0010@\u001a\u00020\nJ\u0016\u0010C\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\t2\u0006\u0010@\u001a\u00020\nJ \u0010D\u001a\u00020/2\u0018\u0010E\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0FJ\u000e\u0010G\u001a\u00020/2\u0006\u0010H\u001a\u00020 J\u0014\u0010I\u001a\u00020/2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\n0\tJ\u0006\u0010N\u001a\u00020/R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R \u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\f\"\u0004\b\r\u0010\u000eRZ\u0010\u000f\u001aN\u0012 \u0012\u001e \u0012*\u000f\u0018\u00010\nj\u0004\u0018\u0001`\u0011\u00a2\u0006\u0002\b\u00100\nj\u0002`\u0011\u00a2\u0006\u0002\b\u0010 \u0012*&\u0012 \u0012\u001e \u0012*\u000f\u0018\u00010\nj\u0004\u0018\u0001`\u0011\u00a2\u0006\u0002\b\u00100\nj\u0002`\u0011\u00a2\u0006\u0002\b\u0010\u0018\u00010\t0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R2\u0010\u0013\u001a&\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\n0\n \u0012*\u0012\u0012\f\u0012\n \u0012*\u0004\u0018\u00010\n0\n\u0018\u00010\t0\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u00020\u0015X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0016\u0010\u0017\"\u0004\b\u0018\u0010\u0019R\u001e\u0010\u001a\u001a\u0012\u0012\u000e\u0012\f\u0012\b\b\u0001\u0012\u0004\u0018\u00010\n0\t0\u001bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u001c\u001a\u0014\u0012\u0004\u0012\u00020\n\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t0\u001dX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010!\u001a\u00020\"X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b#\u0010$\"\u0004\b%\u0010&R\u001c\u0010'\u001a\u0004\u0018\u00010(X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b)\u0010*\"\u0004\b+\u0010,R\u0017\u0010J\u001a\b\u0012\u0004\u0012\u00020 0K8F\u00a2\u0006\u0006\u001a\u0004\bL\u0010M\u00a8\u0006O"}, d2={"Lcom/intellij/execution/target/TargetedCommandLineBuilder;", "Lcom/intellij/openapi/util/UserDataHolderBase;", "request", "Lcom/intellij/execution/target/TargetEnvironmentRequest;", "<init>", "(Lcom/intellij/execution/target/TargetEnvironmentRequest;)V", "getRequest", "()Lcom/intellij/execution/target/TargetEnvironmentRequest;", "exePath", "Lcom/intellij/execution/target/value/TargetValue;", "", "getExePath", "()Lcom/intellij/execution/target/value/TargetValue;", "setExePath", "(Lcom/intellij/execution/target/value/TargetValue;)V", "workingDirectory", "Lcom/intellij/openapi/util/NlsSafe;", "Lcom/intellij/execution/target/FullPathOnTarget;", "kotlin.jvm.PlatformType", "inputFilePath", "charset", "Ljava/nio/charset/Charset;", "getCharset", "()Ljava/nio/charset/Charset;", "setCharset", "(Ljava/nio/charset/Charset;)V", "parameters", "", "environment", "", "_filesToDeleteOnTermination", "", "Ljava/io/File;", "redirectErrorStream", "", "getRedirectErrorStream", "()Z", "setRedirectErrorStream", "(Z)V", "ptyOptions", "Lcom/intellij/execution/target/PtyOptions;", "getPtyOptions", "()Lcom/intellij/execution/target/PtyOptions;", "setPtyOptions", "(Lcom/intellij/execution/target/PtyOptions;)V", "build", "Lcom/intellij/execution/target/TargetedCommandLine;", "", "setWorkingDirectory", "getParameters", "", "addParameter", "parameter", "addParameters", "parametersList", "", "([Ljava/lang/String;)V", "addParameterAt", "index", "", "addFixedParametersAt", "addParametersAt", "setParameters", "addEnvironmentVariable", "name", "value", "removeEnvironmentVariable", "getEnvironmentVariable", "setEnvironmentVariables", "envs", "", "addFileToDeleteOnTermination", "file", "setInputFile", "filesToDeleteOnTermination", "", "getFilesToDeleteOnTermination", "()Ljava/util/Set;", "setRedirectErrorStreamFromRegistry", "intellij.platform.execution"})
public final class TargetedCommandLineBuilder
extends UserDataHolderBase {
    @NotNull
    private final TargetEnvironmentRequest request;
    @NotNull
    private TargetValue<String> exePath;
    private TargetValue<String> workingDirectory;
    private TargetValue<String> inputFilePath;
    @NotNull
    private Charset charset;
    @NotNull
    private final List<TargetValue<? extends String>> parameters;
    @NotNull
    private final Map<String, TargetValue<String>> environment;
    @NotNull
    private final Set<File> _filesToDeleteOnTermination;
    private boolean redirectErrorStream;
    @Nullable
    private PtyOptions ptyOptions;

    public TargetedCommandLineBuilder(@NotNull TargetEnvironmentRequest request) {
        Intrinsics.checkNotNullParameter((Object)request, (String)"request");
        this.request = request;
        TargetValue targetValue = TargetValue.empty();
        Intrinsics.checkNotNullExpressionValue(targetValue, (String)"empty(...)");
        this.exePath = targetValue;
        this.workingDirectory = TargetValue.empty();
        this.inputFilePath = TargetValue.empty();
        Charset charset = CharsetToolkit.getDefaultSystemCharset();
        Intrinsics.checkNotNullExpressionValue((Object)charset, (String)"getDefaultSystemCharset(...)");
        this.charset = charset;
        this.parameters = new ArrayList();
        this.environment = new HashMap();
        this._filesToDeleteOnTermination = new HashSet();
    }

    @NotNull
    public final TargetEnvironmentRequest getRequest() {
        return this.request;
    }

    @NotNull
    public final TargetValue<String> getExePath() {
        return this.exePath;
    }

    public final void setExePath(@NotNull TargetValue<String> targetValue) {
        Intrinsics.checkNotNullParameter(targetValue, (String)"<set-?>");
        this.exePath = targetValue;
    }

    @NotNull
    public final Charset getCharset() {
        return this.charset;
    }

    public final void setCharset(@NotNull Charset charset) {
        Intrinsics.checkNotNullParameter((Object)charset, (String)"<set-?>");
        this.charset = charset;
    }

    public final boolean getRedirectErrorStream() {
        return this.redirectErrorStream;
    }

    public final void setRedirectErrorStream(boolean bl) {
        this.redirectErrorStream = bl;
    }

    @Nullable
    public final PtyOptions getPtyOptions() {
        return this.ptyOptions;
    }

    public final void setPtyOptions(@Nullable PtyOptions ptyOptions) {
        this.ptyOptions = ptyOptions;
    }

    @NotNull
    public final TargetedCommandLine build() {
        TargetValue<String> targetValue = this.workingDirectory;
        Intrinsics.checkNotNullExpressionValue(targetValue, (String)"workingDirectory");
        TargetValue<String> targetValue2 = this.inputFilePath;
        Intrinsics.checkNotNullExpressionValue(targetValue2, (String)"inputFilePath");
        return new TargetedCommandLine(this.exePath, targetValue, targetValue2, this.charset, CollectionsKt.toList((Iterable)this.parameters), MapsKt.toMap(this.environment), this.redirectErrorStream, this.ptyOptions);
    }

    public final void setExePath(@NotNull String exePath) {
        Intrinsics.checkNotNullParameter((Object)exePath, (String)"exePath");
        TargetValue<String> targetValue = TargetValue.fixed(exePath);
        Intrinsics.checkNotNullExpressionValue(targetValue, (String)"fixed(...)");
        this.exePath = targetValue;
    }

    public final void setWorkingDirectory(@NotNull TargetValue<String> workingDirectory) {
        Intrinsics.checkNotNullParameter(workingDirectory, (String)"workingDirectory");
        this.workingDirectory = workingDirectory;
    }

    public final void setWorkingDirectory(@NotNull String workingDirectory) {
        Intrinsics.checkNotNullParameter((Object)workingDirectory, (String)"workingDirectory");
        this.workingDirectory = TargetValue.fixed(workingDirectory);
    }

    @NotNull
    public final List<TargetValue<? extends String>> getParameters() {
        return this.parameters;
    }

    public final void addParameter(@NotNull TargetValue<? extends String> parameter) {
        Intrinsics.checkNotNullParameter(parameter, (String)"parameter");
        this.parameters.add(parameter);
    }

    public final void addParameter(@NotNull String parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        TargetValue<String> targetValue = TargetValue.fixed(parameter);
        Intrinsics.checkNotNullExpressionValue(targetValue, (String)"fixed(...)");
        this.parameters.add(targetValue);
    }

    public final void addParameters(@NotNull List<String> parametersList) {
        Intrinsics.checkNotNullParameter(parametersList, (String)"parametersList");
        for (String parameter : parametersList) {
            this.addParameter(parameter);
        }
    }

    public final void addParameters(String ... parametersList) {
        Intrinsics.checkNotNullParameter((Object)parametersList, (String)"parametersList");
        for (String parameter : parametersList) {
            this.addParameter(parameter);
        }
    }

    public final void addParameterAt(int index, @NotNull String parameter) {
        Intrinsics.checkNotNullParameter((Object)parameter, (String)"parameter");
        TargetValue<String> targetValue = TargetValue.fixed(parameter);
        Intrinsics.checkNotNullExpressionValue(targetValue, (String)"fixed(...)");
        this.addParameterAt(index, targetValue);
    }

    private final void addParameterAt(int index, TargetValue<String> parameter) {
        this.parameters.add(index, parameter);
    }

    public final void addFixedParametersAt(int index, @NotNull List<String> parameters) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        List list2 = ContainerUtil.map((Collection)parameters, arg_0 -> TargetedCommandLineBuilder.addFixedParametersAt$lambda$1(TargetedCommandLineBuilder::addFixedParametersAt$lambda$0, arg_0));
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"map(...)");
        this.addParametersAt(index, list2);
    }

    public final void addParametersAt(int index, @NotNull List<? extends TargetValue<? extends String>> parameters) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        this.parameters.addAll(index, (Collection<TargetValue<? extends String>>)parameters);
    }

    public final void setParameters(@NotNull List<? extends TargetValue<? extends String>> parameters) {
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        this.parameters.clear();
        this.parameters.addAll((Collection<TargetValue<? extends String>>)parameters);
    }

    public final void addEnvironmentVariable(@NotNull String name, @Nullable TargetValue<String> value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        if (value != null) {
            this.environment.put(name, value);
        } else {
            this.environment.remove(name);
        }
    }

    public final void addEnvironmentVariable(@NotNull String name, @Nullable String value) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        String string = value;
        this.addEnvironmentVariable(name, string != null ? TargetValue.fixed(string) : null);
    }

    public final void removeEnvironmentVariable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        this.environment.remove(name);
    }

    @Nullable
    public final TargetValue<String> getEnvironmentVariable(@NotNull String name) {
        Intrinsics.checkNotNullParameter((Object)name, (String)"name");
        return this.environment.get(name);
    }

    public final void setEnvironmentVariables(@NotNull Map<String, ? extends TargetValue<String>> envs) {
        Intrinsics.checkNotNullParameter(envs, (String)"envs");
        this.environment.clear();
        this.environment.putAll(envs);
    }

    public final void addFileToDeleteOnTermination(@NotNull File file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        this._filesToDeleteOnTermination.add(file);
    }

    public final void setInputFile(@NotNull TargetValue<String> inputFilePath) {
        Intrinsics.checkNotNullParameter(inputFilePath, (String)"inputFilePath");
        this.inputFilePath = inputFilePath;
    }

    @NotNull
    public final Set<File> getFilesToDeleteOnTermination() {
        return this._filesToDeleteOnTermination;
    }

    public final void setRedirectErrorStreamFromRegistry() {
        this.redirectErrorStream = Registry.Companion.is("run.processes.with.redirectedErrorStream", false);
    }

    private static final TargetValue addFixedParametersAt$lambda$0(String p) {
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return TargetValue.fixed(p);
    }

    private static final TargetValue addFixedParametersAt$lambda$1(Function1 $tmp0, Object p0) {
        return (TargetValue)$tmp0.invoke(p0);
    }
}

