/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.module.UnloadedModuleDescription;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.graph.Graph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.annotations.Unmodifiable;

public abstract class SourceScope {
    public abstract GlobalSearchScope getGlobalSearchScope();

    public abstract Project getProject();

    public abstract GlobalSearchScope getLibrariesScope();

    @NotNull
    private static Map<Module, Collection<Module>> buildAllDependencies(@NotNull Project project) {
        if (project == null) {
            SourceScope.$$$reportNull$$$0(0);
        }
        Graph graph = ModuleManager.getInstance((Project)project).moduleGraph();
        HashMap<Module, Collection<Module>> result2 = new HashMap<Module, Collection<Module>>();
        for (Module module : graph.getNodes()) {
            SourceScope.buildDependenciesForModule(module, (Graph<Module>)graph, result2);
        }
        HashMap<Module, Collection<Module>> hashMap = result2;
        if (hashMap == null) {
            SourceScope.$$$reportNull$$$0(1);
        }
        return hashMap;
    }

    private static void buildDependenciesForModule(@NotNull Module module, final Graph<Module> graph, Map<Module, Collection<Module>> map) {
        if (module == null) {
            SourceScope.$$$reportNull$$$0(2);
        }
        final HashSet deps = new HashSet();
        map.put(module, deps);
        new Object(){

            void traverse(Module m) {
                Iterator iterator = graph.getIn((Object)m);
                while (iterator.hasNext()) {
                    Module dep = (Module)iterator.next();
                    if (deps.contains(dep)) continue;
                    deps.add(dep);
                    this.traverse(dep);
                }
            }
        }.traverse(module);
    }

    public static SourceScope wholeProject(final Project project) {
        return new SourceScope(){

            @Override
            public GlobalSearchScope getGlobalSearchScope() {
                return GlobalSearchScope.allScope((Project)project);
            }

            @Override
            public Project getProject() {
                return project;
            }

            @Override
            public Module[] getModulesToCompile() {
                return ModuleManager.getInstance((Project)project).getModules();
            }

            @Override
            public GlobalSearchScope getLibrariesScope() {
                return this.getGlobalSearchScope();
            }
        };
    }

    public static SourceScope modulesWithDependencies(final Module[] modules) {
        if (modules == null || modules.length == 0) {
            return null;
        }
        return new ModuleSourceScope(modules[0].getProject()){

            @Override
            public GlobalSearchScope getGlobalSearchScope() {
                return SourceScope.evaluateScopesAndUnite(modules, module -> module.getModuleRuntimeScope(true));
            }

            @Override
            public GlobalSearchScope getLibrariesScope() {
                return SourceScope.evaluateScopesAndUnite(modules, module -> new ModuleWithDependenciesAndLibsDependencies(module));
            }

            @Override
            public Module[] getModulesToCompile() {
                return modules;
            }
        };
    }

    private static GlobalSearchScope evaluateScopesAndUnite(Module[] modules, ScopeForModuleEvaluator evaluator) {
        GlobalSearchScope[] scopes = (GlobalSearchScope[])ContainerUtil.map2Array((Object[])modules, GlobalSearchScope.class, module -> evaluator.evaluate((Module)module));
        return GlobalSearchScope.union((GlobalSearchScope[])scopes);
    }

    public static SourceScope modules(final Module[] modules) {
        if (modules == null || modules.length == 0) {
            return null;
        }
        return new ModuleSourceScope(modules[0].getProject()){

            @Override
            public GlobalSearchScope getGlobalSearchScope() {
                return SourceScope.evaluateScopesAndUnite(modules, module -> GlobalSearchScope.moduleScope((Module)module));
            }

            @Override
            public GlobalSearchScope getLibrariesScope() {
                return SourceScope.evaluateScopesAndUnite(modules, module -> GlobalSearchScope.moduleWithLibrariesScope((Module)module));
            }

            @Override
            public Module[] getModulesToCompile() {
                return modules;
            }
        };
    }

    public abstract Module[] getModulesToCompile();

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/SourceScope";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "module";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/SourceScope";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "buildAllDependencies";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "buildAllDependencies";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "buildDependenciesForModule";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }

    private static interface ScopeForModuleEvaluator {
        public GlobalSearchScope evaluate(Module var1);
    }

    private static class ModuleWithDependenciesAndLibsDependencies
    extends GlobalSearchScope {
        private final GlobalSearchScope myMainScope;
        private final List<GlobalSearchScope> myScopes = new ArrayList<GlobalSearchScope>();

        ModuleWithDependenciesAndLibsDependencies(Module module) {
            super(module.getProject());
            this.myMainScope = GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module);
            Map<Module, Collection<Module>> map = SourceScope.buildAllDependencies(module.getProject());
            Collection<Module> modules = map.get(module);
            for (Module dependency : modules) {
                this.myScopes.add(GlobalSearchScope.moduleWithLibrariesScope((Module)dependency));
            }
        }

        public boolean contains(@NotNull VirtualFile file) {
            if (file == null) {
                ModuleWithDependenciesAndLibsDependencies.$$$reportNull$$$0(0);
            }
            return this.findScopeFor(file) != null;
        }

        public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
            if (file1 == null) {
                ModuleWithDependenciesAndLibsDependencies.$$$reportNull$$$0(1);
            }
            if (file2 == null) {
                ModuleWithDependenciesAndLibsDependencies.$$$reportNull$$$0(2);
            }
            GlobalSearchScope scope = this.findScopeFor(file1);
            assert (scope != null);
            if (scope.contains(file2)) {
                return scope.compare(file1, file2);
            }
            return 0;
        }

        public boolean isSearchInModuleContent(@NotNull Module aModule) {
            if (aModule == null) {
                ModuleWithDependenciesAndLibsDependencies.$$$reportNull$$$0(3);
            }
            return this.myMainScope.isSearchInModuleContent(aModule);
        }

        public boolean isSearchInLibraries() {
            return true;
        }

        @NotNull
        public @Unmodifiable Collection<UnloadedModuleDescription> getUnloadedModulesBelongingToScope() {
            Collection collection = this.myMainScope.getUnloadedModulesBelongingToScope();
            if (collection == null) {
                ModuleWithDependenciesAndLibsDependencies.$$$reportNull$$$0(4);
            }
            return collection;
        }

        @Nullable
        private GlobalSearchScope findScopeFor(VirtualFile file) {
            if (this.myMainScope.contains(file)) {
                return this.myMainScope;
            }
            int size = this.myScopes.size();
            for (int i = 0; i < size; ++i) {
                GlobalSearchScope scope = this.myScopes.get(i);
                if (!scope.contains(file)) continue;
                return scope;
            }
            return null;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 4 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file1";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "file2";
                    break;
                }
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "aModule";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/SourceScope$ModuleWithDependenciesAndLibsDependencies";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/SourceScope$ModuleWithDependenciesAndLibsDependencies";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getUnloadedModulesBelongingToScope";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "contains";
                    break;
                }
                case 1: 
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "compare";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "isSearchInModuleContent";
                    break;
                }
                case 4: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 4 -> new IllegalStateException(string);
            };
        }
    }

    private static abstract class ModuleSourceScope
    extends SourceScope {
        private final Project myProject;

        ModuleSourceScope(Project project) {
            this.myProject = project;
        }

        @Override
        public Project getProject() {
            return this.myProject;
        }
    }
}

