/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Filter;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestTreeView;
import com.intellij.execution.testframework.ui.AbstractTestTreeBuilderBase;
import com.intellij.execution.testframework.ui.BaseTestProxyNodeDescriptor;
import com.intellij.ide.util.treeView.AlphaComparator;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.util.Comparing;
import com.intellij.util.config.AbstractProperty;
import java.util.Comparator;
import org.jetbrains.annotations.NotNull;

public interface TestFrameworkRunningModel
extends Disposable {
    public TestConsoleProperties getProperties();

    public void setFilter(@NotNull Filter<?> var1);

    public boolean isRunning();

    public TestTreeView getTreeView();

    public AbstractTestTreeBuilderBase<?> getTreeBuilder();

    public boolean hasTestSuites();

    public AbstractTestProxy getRoot();

    public void selectAndNotify(AbstractTestProxy var1);

    default public Comparator<NodeDescriptor<?>> createComparator() {
        TestConsoleProperties properties = this.getProperties();
        Comparator comparator = TestConsoleProperties.SORT_BY_DURATION.value((AbstractProperty.AbstractPropertyContainer)properties) && !this.isRunning() ? (node1, node2) -> {
            if (node1.getParentDescriptor() == node2.getParentDescriptor() && node1 instanceof BaseTestProxyNodeDescriptor) {
                BaseTestProxyNodeDescriptor testNodeDescriptor1 = (BaseTestProxyNodeDescriptor)node1;
                if (node2 instanceof BaseTestProxyNodeDescriptor) {
                    BaseTestProxyNodeDescriptor testNodeDescriptor2 = (BaseTestProxyNodeDescriptor)node2;
                    Object t1 = testNodeDescriptor1.getElement();
                    Object t2 = testNodeDescriptor2.getElement();
                    if (!TestConsoleProperties.SUITES_ALWAYS_ON_TOP.value((AbstractProperty.AbstractPropertyContainer)properties) || ((AbstractTestProxy)t1).isLeaf() == ((AbstractTestProxy)t2).isLeaf()) {
                        return Comparing.compare((Comparable)((AbstractTestProxy)t2).getDuration(), (Comparable)((AbstractTestProxy)t1).getDuration());
                    }
                }
            }
            return 0;
        } : (TestConsoleProperties.SORT_BY_DECLARATION_ORDER.value((AbstractProperty.AbstractPropertyContainer)properties) ? (node1, node2) -> {
            if (node1.getParentDescriptor() == node2.getParentDescriptor() && node1 instanceof BaseTestProxyNodeDescriptor) {
                BaseTestProxyNodeDescriptor testNodeDescriptor1 = (BaseTestProxyNodeDescriptor)node1;
                if (node2 instanceof BaseTestProxyNodeDescriptor) {
                    BaseTestProxyNodeDescriptor testNodeDescriptor2 = (BaseTestProxyNodeDescriptor)node2;
                    Object t1 = testNodeDescriptor1.getElement();
                    Object t2 = testNodeDescriptor2.getElement();
                    int offset1 = ((AbstractTestProxy)t1).getLocation(properties.getProject(), properties.getScope()).toPsiLocation().getPsiElement().getTextOffset();
                    int offset2 = ((AbstractTestProxy)t2).getLocation(properties.getProject(), properties.getScope()).toPsiLocation().getPsiElement().getTextOffset();
                    if (!TestConsoleProperties.SUITES_ALWAYS_ON_TOP.value((AbstractProperty.AbstractPropertyContainer)properties) || ((AbstractTestProxy)t1).isLeaf() == ((AbstractTestProxy)t2).isLeaf()) {
                        return Integer.compare(offset1, offset2);
                    }
                }
            }
            return 0;
        } : (TestConsoleProperties.SORT_ALPHABETICALLY.value((AbstractProperty.AbstractPropertyContainer)properties) ? AlphaComparator.getInstance() : null));
        return comparator;
    }
}

