/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.icons.AllIcons;
import com.intellij.ide.IconProvider;
import com.intellij.lang.Language;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.project.DumbService;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.testIntegration.TestFramework;
import com.intellij.ui.IconManager;
import com.intellij.ui.LayeredIcon;
import com.intellij.util.BitUtil;
import com.intellij.util.PlatformIcons;
import java.util.List;
import javax.swing.Icon;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public final class TestIconProvider
extends IconProvider {
    public Icon getIcon(@NotNull PsiElement element, int flags) {
        if (element == null) {
            TestIconProvider.$$$reportNull$$$0(0);
        }
        if (element.getContainingFile() == null) {
            return null;
        }
        List testFrameworks = DumbService.getDumbAwareExtensions((Project)element.getProject(), (ExtensionPointName)TestFramework.EXTENSION_NAME);
        for (TestFramework framework : testFrameworks) {
            if (!TestIconProvider.isSuitableByLanguage(element, framework)) continue;
            try {
                if (!framework.isIgnoredMethod(element)) continue;
                Icon ignoredTestIcon = AllIcons.RunConfigurations.IgnoredTest;
                if (BitUtil.isSet((int)flags, (int)1)) {
                    LayeredIcon icon = LayeredIcon.layeredIcon(() -> new Icon[]{ignoredTestIcon, PlatformIcons.PUBLIC_ICON});
                    icon.setIcon(PlatformIcons.PUBLIC_ICON, 1, ignoredTestIcon.getIconWidth(), 0);
                    return icon;
                }
                return ignoredTestIcon;
            }
            catch (AbstractMethodError ignoredTestIcon) {
            }
        }
        for (TestFramework framework : testFrameworks) {
            if (!TestIconProvider.isSuitableByLanguage(element, framework)) continue;
            try {
                LayeredIcon mark;
                if (!framework.isTestMethod(element)) continue;
                if (BitUtil.isSet((int)flags, (int)1)) {
                    mark = LayeredIcon.layeredIcon((Icon[])new Icon[]{IconManager.getInstance().getPlatformIcon(com.intellij.ui.PlatformIcons.Method), AllIcons.RunConfigurations.TestMark, PlatformIcons.PUBLIC_ICON});
                    mark.setIcon(PlatformIcons.PUBLIC_ICON, 2, IconManager.getInstance().getPlatformIcon(com.intellij.ui.PlatformIcons.Method).getIconWidth(), 0);
                } else {
                    mark = LayeredIcon.layeredIcon((Icon[])new Icon[]{IconManager.getInstance().getPlatformIcon(com.intellij.ui.PlatformIcons.Method), AllIcons.RunConfigurations.TestMark});
                }
                return mark;
            }
            catch (AbstractMethodError abstractMethodError) {
            }
        }
        return null;
    }

    private static boolean isSuitableByLanguage(PsiElement element, TestFramework framework) {
        Language frameworkLanguage = framework.getLanguage();
        return frameworkLanguage == Language.ANY || element.getLanguage().isKindOf(frameworkLanguage);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/execution/testframework/TestIconProvider", "getIcon"));
    }
}

