/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework;

import com.intellij.execution.Location;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestFrameworkRunningModel;
import com.intellij.ide.CopyProvider;
import com.intellij.ide.actions.CopyReferenceAction;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.PlatformDataKeys;
import com.intellij.openapi.actionSystem.UiCompatibleDataProvider;
import com.intellij.openapi.ide.CopyPasteManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.Navigatable;
import com.intellij.psi.PsiElement;
import com.intellij.ui.AnimatedIcon;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.TreeSpeedSearch;
import com.intellij.ui.popup.HintUpdateSupply;
import com.intellij.ui.render.RenderingHelper;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.datatransfer.StringSelection;
import java.util.Arrays;
import java.util.Objects;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TestTreeView
extends Tree
implements UiCompatibleDataProvider,
CopyProvider {
    public static final DataKey<TestFrameworkRunningModel> MODEL_DATA_KEY = DataKey.create((String)"testFrameworkModel.dataId");
    private TestFrameworkRunningModel myModel;

    public TestTreeView() {
        this.setLargeModel(true);
    }

    protected abstract TreeCellRenderer getRenderer(TestConsoleProperties var1);

    public abstract AbstractTestProxy getSelectedTest(@NotNull TreePath var1);

    protected TestFrameworkRunningModel getTestFrameworkRunningModel() {
        return this.myModel;
    }

    @Nullable
    public AbstractTestProxy getSelectedTest() {
        TreePath[] paths = this.getSelectionPaths();
        if (paths != null && paths.length > 1) {
            return null;
        }
        TreePath selectionPath = this.getSelectionPath();
        return selectionPath != null ? this.getSelectedTest(selectionPath) : null;
    }

    public void attachToModel(TestFrameworkRunningModel model2) {
        this.setModel(new DefaultTreeModel(new DefaultMutableTreeNode(model2.getRoot())));
        this.getSelectionModel().setSelectionMode(model2.getProperties().getSelectionMode());
        this.myModel = model2;
        Disposer.register((Disposable)this.myModel, (Disposable)this.myModel.getRoot());
        Disposer.register((Disposable)this.myModel, (Disposable)new Disposable(){

            public void dispose() {
                TestTreeView.this.setModel(null);
                TestTreeView.this.myModel = null;
            }
        });
        this.installHandlers();
        this.setCellRenderer(this.getRenderer(this.myModel.getProperties()));
        this.putClientProperty(RenderingHelper.SHRINK_LONG_RENDERER, true);
        this.putClientProperty(AnimatedIcon.ANIMATION_IN_RENDERER_ALLOWED, true);
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
        if (actionUpdateThread == null) {
            TestTreeView.$$$reportNull$$$0(0);
        }
        return actionUpdateThread;
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        RunProfile configuration;
        if (sink == null) {
            TestTreeView.$$$reportNull$$$0(1);
        }
        TreePath[] paths = this.getSelectionPaths();
        TreePath selectionPath = this.getSelectionPath();
        sink.set(PlatformDataKeys.COPY_PROVIDER, (Object)this);
        if (selectionPath == null) {
            return;
        }
        sink.set(MODEL_DATA_KEY, (Object)this.myModel);
        AbstractTestProxy[] testProxies = (AbstractTestProxy[])Arrays.stream(Objects.requireNonNull(paths)).map(path -> this.getSelectedTest((TreePath)path)).filter(Objects::nonNull).toArray(AbstractTestProxy[]::new);
        sink.set(AbstractTestProxy.DATA_KEYS, (Object)testProxies);
        AbstractTestProxy testProxy = this.getSelectedTest(selectionPath);
        if (testProxy == null) {
            return;
        }
        sink.set(AbstractTestProxy.DATA_KEY, (Object)testProxy);
        if (testProxy instanceof Navigatable) {
            Navigatable o = (Navigatable)testProxy;
            sink.set(CommonDataKeys.NAVIGATABLE, (Object)o);
        }
        if ((configuration = this.myModel.getProperties().getConfiguration()) instanceof RunConfiguration) {
            RunConfiguration o = (RunConfiguration)configuration;
            sink.set(RunConfiguration.DATA_KEY, (Object)o);
        }
        Project project = this.myModel.getProperties().getProject();
        TestFrameworkRunningModel model2 = this.myModel;
        sink.lazy(CommonDataKeys.PSI_ELEMENT, () -> {
            Location location = testProxy.getLocation(project, model2.getProperties().getScope());
            Object psiElement = location != null ? location.getPsiElement() : null;
            return psiElement == null || !psiElement.isValid() ? null : psiElement;
        });
        sink.lazy(Location.DATA_KEY, () -> testProxy.getLocation(project, model2.getProperties().getScope()));
        sink.lazy(Location.DATA_KEYS, () -> (Location[])Arrays.stream(testProxies).map(p -> p.getLocation(project, model2.getProperties().getScope())).filter(Objects::nonNull).toArray(Location[]::new));
        sink.lazy(PlatformCoreDataKeys.PSI_ELEMENT_ARRAY, () -> (PsiElement[])Arrays.stream(testProxies).map(p -> p.getLocation(project, model2.getProperties().getScope())).filter(Objects::nonNull).map(l -> l.getPsiElement()).toArray(PsiElement[]::new));
    }

    public void performCopy(@NotNull DataContext dataContext) {
        AbstractTestProxy selectedTest;
        PsiElement element;
        if (dataContext == null) {
            TestTreeView.$$$reportNull$$$0(2);
        }
        String fqn = (element = (PsiElement)CommonDataKeys.PSI_ELEMENT.getData(dataContext)) != null ? CopyReferenceAction.elementToFqn((PsiElement)element) : ((selectedTest = this.getSelectedTest()) != null ? selectedTest.getLocationUrl() : null);
        CopyPasteManager.getInstance().setContents(new StringSelection(fqn));
    }

    public boolean isCopyEnabled(@NotNull DataContext dataContext) {
        AbstractTestProxy test;
        if (dataContext == null) {
            TestTreeView.$$$reportNull$$$0(3);
        }
        return (test = this.getSelectedTest()) != null && test.getLocationUrl() != null;
    }

    public boolean isCopyVisible(@NotNull DataContext dataContext) {
        if (dataContext == null) {
            TestTreeView.$$$reportNull$$$0(4);
        }
        return true;
    }

    protected void installHandlers() {
        EditSourceOnDoubleClickHandler.install((JTree)((Object)this));
        EditSourceOnEnterKeyHandler.install((JTree)((Object)this));
        boolean canExpand = Registry.is((String)"tests.view.node.expanding.search");
        TreeSpeedSearch.installOn((JTree)((Object)this), (boolean)canExpand, path -> {
            AbstractTestProxy testProxy = this.getSelectedTest((TreePath)path);
            if (testProxy == null) {
                return null;
            }
            return this.getPresentableName(testProxy);
        });
        TreeUtil.installActions((JTree)((Object)this));
        PopupHandler.installPopupMenu((JComponent)((Object)this), (String)"TestTreePopupMenu", (String)"TestTreeViewPopup");
        HintUpdateSupply.installHintUpdateSupply((JComponent)((Object)this), obj2 -> {
            Object element;
            Object userObject = TreeUtil.getUserObject((Object)obj2);
            if (userObject instanceof NodeDescriptor) {
                NodeDescriptor o = (NodeDescriptor)userObject;
                v0 = o.getElement();
            } else {
                v0 = element = null;
            }
            if (!(element instanceof AbstractTestProxy)) {
                return null;
            }
            AbstractTestProxy testProxy = element;
            TestFrameworkRunningModel model2 = this.myModel;
            Project project = model2.getProperties().getProject();
            Location location = testProxy.getLocation(project, model2.getProperties().getScope());
            Object psiElement = location != null ? location.getPsiElement() : null;
            return psiElement == null || !psiElement.isValid() ? null : psiElement;
        });
    }

    protected String getPresentableName(AbstractTestProxy testProxy) {
        return testProxy.getName();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/TestTreeView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "dataContext";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/TestTreeView";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "performCopy";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isCopyEnabled";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "isCopyVisible";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

