/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.actions;

import com.intellij.diff.DiffContentFactory;
import com.intellij.diff.chains.DiffRequestChain;
import com.intellij.diff.chains.DiffRequestProducer;
import com.intellij.diff.chains.SimpleDiffRequestChain;
import com.intellij.diff.contents.DiffContent;
import com.intellij.diff.contents.DocumentContent;
import com.intellij.diff.requests.DiffRequest;
import com.intellij.diff.requests.SimpleDiffRequest;
import com.intellij.diff.util.DiffUserDataKeys;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.Location;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.TestProxyRoot;
import com.intellij.execution.testframework.actions.TestDiffContent;
import com.intellij.execution.testframework.actions.TestDiffProvider;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.openapi.ListSelection;
import com.intellij.openapi.application.ReadAction;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.PlainTextFileType;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.JarFileSystem;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiElement;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.util.PsiUtilCore;
import java.util.Objects;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class TestDiffRequestProcessor {
    @NotNull
    public static DiffRequestChain createRequestChain(@NotNull Project project, @NotNull ListSelection<? extends DiffHyperlink> requests) {
        if (project == null) {
            TestDiffRequestProcessor.$$$reportNull$$$0(0);
        }
        if (requests == null) {
            TestDiffRequestProcessor.$$$reportNull$$$0(1);
        }
        ListSelection producers = requests.map(hyperlink -> new DiffHyperlinkRequestProducer(project, (DiffHyperlink)hyperlink));
        SimpleDiffRequestChain chain = SimpleDiffRequestChain.fromProducers((ListSelection)producers);
        chain.putUserData(DiffUserDataKeys.PLACE, (Object)"TestsFiledAssertions");
        chain.putUserData(DiffUserDataKeys.DO_NOT_IGNORE_WHITESPACES, (Object)true);
        chain.putUserData(DiffUserDataKeys.DIALOG_GROUP_KEY, (Object)"#com.intellij.execution.junit2.states.ComparisonFailureState$DiffDialog");
        SimpleDiffRequestChain simpleDiffRequestChain = chain;
        if (simpleDiffRequestChain == null) {
            TestDiffRequestProcessor.$$$reportNull$$$0(2);
        }
        return simpleDiffRequestChain;
    }

    @Nullable
    private static VirtualFile findFile(@Nullable String path) {
        if (path == null) {
            return null;
        }
        JarFileSystem fs = path.contains("!/") ? JarFileSystem.getInstance() : LocalFileSystem.getInstance();
        return fs.refreshAndFindFileByPath(path);
    }

    @NotNull
    private static DiffContent createContentWithTitle(@Nullable Project project, @NotNull String content, @Nullable VirtualFile contentFile, @Nullable VirtualFile highlightFile) {
        if (content == null) {
            TestDiffRequestProcessor.$$$reportNull$$$0(3);
        }
        if (contentFile != null) {
            DiffContent diffContent = DiffContentFactory.getInstance().create(project, contentFile);
            if (diffContent == null) {
                TestDiffRequestProcessor.$$$reportNull$$$0(4);
            }
            return diffContent;
        }
        DocumentContent documentContent = DiffContentFactory.getInstance().create(project, content, highlightFile);
        if (documentContent == null) {
            TestDiffRequestProcessor.$$$reportNull$$$0(5);
        }
        return documentContent;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2, 4, 5 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "requests";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/actions/TestDiffRequestProcessor";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/actions/TestDiffRequestProcessor";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "createRequestChain";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "createContentWithTitle";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "createRequestChain";
                break;
            }
            case 2: 
            case 4: 
            case 5: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "createContentWithTitle";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2, 4, 5 -> new IllegalStateException(string);
        };
    }

    private static class DiffHyperlinkRequestProducer
    implements DiffRequestProducer {
        private final Project myProject;
        private final DiffHyperlink myHyperlink;

        private DiffHyperlinkRequestProducer(@NotNull Project project, @NotNull DiffHyperlink hyperlink) {
            if (project == null) {
                DiffHyperlinkRequestProducer.$$$reportNull$$$0(0);
            }
            if (hyperlink == null) {
                DiffHyperlinkRequestProducer.$$$reportNull$$$0(1);
            }
            this.myProject = project;
            this.myHyperlink = hyperlink;
        }

        @Nls
        @NotNull
        public String getName() {
            String testName = this.myHyperlink.getTestName();
            if (testName != null) {
                String string = testName;
                if (string == null) {
                    DiffHyperlinkRequestProducer.$$$reportNull$$$0(2);
                }
                return string;
            }
            String string = this.myHyperlink.getDiffTitle();
            if (string == null) {
                DiffHyperlinkRequestProducer.$$$reportNull$$$0(3);
            }
            return string;
        }

        @Nullable
        public FileType getContentType() {
            VirtualFile file = TestDiffRequestProcessor.findFile(this.myHyperlink.getFilePath());
            return file != null ? file.getFileType() : PlainTextFileType.INSTANCE;
        }

        @NotNull
        public DiffRequest process(@NotNull UserDataHolder context, @NotNull ProgressIndicator indicator) {
            PsiElement expected;
            TestDiffProvider provider;
            if (context == null) {
                DiffHyperlinkRequestProducer.$$$reportNull$$$0(4);
            }
            if (indicator == null) {
                DiffHyperlinkRequestProducer.$$$reportNull$$$0(5);
            }
            String windowTitle = this.myHyperlink.getDiffTitle();
            AbstractTestProxy testProxy = this.myHyperlink.getTestProxy();
            String text1 = this.myHyperlink.getLeft();
            String text2 = this.myHyperlink.getRight();
            VirtualFile file1 = TestDiffRequestProcessor.findFile(this.myHyperlink.getFilePath());
            VirtualFile file2 = TestDiffRequestProcessor.findFile(this.myHyperlink.getActualFilePath());
            DiffContent content1 = null;
            if (file1 == null && testProxy != null && (provider = this.getTestDiffProvider(testProxy)) != null && (expected = this.getExpected(provider, testProxy)) != null) {
                file1 = (VirtualFile)ReadAction.compute(() -> PsiUtilCore.getVirtualFile((PsiElement)expected));
                content1 = this.createPsiDiffContent(expected, text1);
            }
            if (content1 == null) {
                content1 = TestDiffRequestProcessor.createContentWithTitle(this.myProject, text1, file1, file2);
            }
            DiffContent content2 = TestDiffRequestProcessor.createContentWithTitle(this.myProject, text2, file2, file1);
            String title1 = file1 != null ? ExecutionBundle.message("diff.content.expected.title.with.file.url", file1.getPresentableUrl()) : ExecutionBundle.message("diff.content.expected.title", new Object[0]);
            String title2 = file2 != null ? ExecutionBundle.message("diff.content.actual.title.with.file.url", file2.getPresentableUrl()) : ExecutionBundle.message("diff.content.actual.title", new Object[0]);
            return new SimpleDiffRequest(windowTitle, content1, content2, title1, title2);
        }

        @Nullable
        private TestDiffProvider getTestDiffProvider(@NotNull AbstractTestProxy testProxy) {
            TestProxyRoot testRoot;
            if (testProxy == null) {
                DiffHyperlinkRequestProducer.$$$reportNull$$$0(6);
            }
            if ((testRoot = AbstractTestProxy.getTestRoot(testProxy)) == null) {
                return null;
            }
            Location loc = (Location)ReadAction.compute(() -> {
                ProgressManager.checkCanceled();
                return testProxy.getLocation(this.myProject, testRoot.getTestConsoleProperties().getScope());
            });
            if (loc == null) {
                return null;
            }
            return TestDiffProvider.getProviderByLanguage(loc.getPsiElement().getLanguage());
        }

        @Nullable
        private PsiElement getExpected(@NotNull TestDiffProvider provider, @NotNull AbstractTestProxy testProxy) {
            String stackTrace;
            if (provider == null) {
                DiffHyperlinkRequestProducer.$$$reportNull$$$0(7);
            }
            if (testProxy == null) {
                DiffHyperlinkRequestProducer.$$$reportNull$$$0(8);
            }
            if ((stackTrace = testProxy.getStacktrace()) == null) {
                return null;
            }
            return provider.findExpected(this.myProject, stackTrace, this.myHyperlink.getLeft());
        }

        @Nullable
        private DiffContent createPsiDiffContent(@NotNull PsiElement element, @NotNull String text2) {
            if (element == null) {
                DiffHyperlinkRequestProducer.$$$reportNull$$$0(9);
            }
            if (text2 == null) {
                DiffHyperlinkRequestProducer.$$$reportNull$$$0(10);
            }
            SmartPsiElementPointer elemPtr = (SmartPsiElementPointer)ReadAction.compute(() -> SmartPointerManager.createPointer((PsiElement)element));
            return TestDiffContent.Companion.create(this.myProject, text2, (SmartPsiElementPointer<PsiElement>)elemPtr);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            DiffHyperlinkRequestProducer producer = (DiffHyperlinkRequestProducer)o;
            return Objects.equals(this.myHyperlink, producer.myHyperlink);
        }

        public int hashCode() {
            return Objects.hash(this.myHyperlink);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2, 3 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "project";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "hyperlink";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/execution/testframework/actions/TestDiffRequestProcessor$DiffHyperlinkRequestProducer";
                    break;
                }
                case 4: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "indicator";
                    break;
                }
                case 6: 
                case 8: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "testProxy";
                    break;
                }
                case 7: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 9: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 10: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "text";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/execution/testframework/actions/TestDiffRequestProcessor$DiffHyperlinkRequestProducer";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getName";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "<init>";
                    break;
                }
                case 2: 
                case 3: {
                    break;
                }
                case 4: 
                case 5: {
                    objectArray = objectArray;
                    objectArray[2] = "process";
                    break;
                }
                case 6: {
                    objectArray = objectArray;
                    objectArray[2] = "getTestDiffProvider";
                    break;
                }
                case 7: 
                case 8: {
                    objectArray = objectArray;
                    objectArray[2] = "getExpected";
                    break;
                }
                case 9: 
                case 10: {
                    objectArray = objectArray;
                    objectArray[2] = "createPsiDiffContent";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2, 3 -> new IllegalStateException(string);
            };
        }
    }
}

