/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.autotest;

import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.configurations.RunProfile;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.process.ProcessEvent;
import com.intellij.execution.process.ProcessHandler;
import com.intellij.execution.process.ProcessListener;
import com.intellij.execution.runners.ExecutionEnvironment;
import com.intellij.execution.runners.ExecutionUtil;
import com.intellij.execution.testframework.autotest.AutoTestListener;
import com.intellij.execution.testframework.autotest.AutoTestWatcher;
import com.intellij.execution.ui.RunContentDescriptor;
import com.intellij.execution.ui.RunContentManager;
import com.intellij.ide.DataManager;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.actionSystem.ExecutionDataKeys;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.ObjectUtils;
import com.intellij.util.concurrency.annotations.RequiresEdt;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.xmlb.annotations.Attribute;
import com.intellij.util.xmlb.annotations.Tag;
import com.intellij.util.xmlb.annotations.XCollection;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.BooleanSupplier;
import javax.swing.JComponent;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class AbstractAutoTestManager
implements PersistentStateComponent<State> {
    private static final String AUTO_TEST_MANAGER_DELAY = "auto.test.manager.delay";
    private static final int AUTO_TEST_MANAGER_DELAY_DEFAULT = 3000;
    private static final Key<ProcessListener> ON_TERMINATION_RESTARTER_KEY = Key.create((String)"auto.test.manager.on.termination.restarter");
    private final Project myProject;
    private final Set<RunProfile> myEnabledRunProfiles;
    protected int myDelayMillis;
    private AutoTestWatcher myWatcher;

    public AbstractAutoTestManager(@NotNull Project project) {
        if (project == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(0);
        }
        this.myEnabledRunProfiles = new HashSet<RunProfile>();
        this.myProject = project;
        this.myDelayMillis = PropertiesComponent.getInstance((Project)project).getInt(AUTO_TEST_MANAGER_DELAY, 3000);
    }

    @Nullable
    private static ExecutionEnvironment getCurrentEnvironment(@NotNull RunContentDescriptor descriptor) {
        JComponent component;
        if (descriptor == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(1);
        }
        if ((component = descriptor.getComponent()) == null) {
            return null;
        }
        return (ExecutionEnvironment)((Object)ExecutionDataKeys.EXECUTION_ENVIRONMENT.getData(DataManager.getInstance().getDataContext(component)));
    }

    private static void clearRestarterListener(@NotNull ProcessHandler processHandler2) {
        ProcessListener restarterListener;
        if (processHandler2 == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(2);
        }
        if ((restarterListener = (ProcessListener)ON_TERMINATION_RESTARTER_KEY.get((UserDataHolder)processHandler2, null)) != null) {
            processHandler2.removeProcessListener(restarterListener);
            ON_TERMINATION_RESTARTER_KEY.set((UserDataHolder)processHandler2, null);
        }
    }

    private static void restart(@NotNull RunContentDescriptor descriptor) {
        if (descriptor == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(3);
        }
        descriptor.setActivateToolWindowWhenAdded(false);
        descriptor.setReuseToolWindowActivation(true);
        ExecutionEnvironment env = AbstractAutoTestManager.getCurrentEnvironment(descriptor);
        if (env != null) {
            env.setAutoTriggered(true);
            ExecutionUtil.restart(env);
        }
    }

    private static void saveConfigurationState(@NotNull State state, @NotNull RunProfile profile) {
        RunConfiguration runConfiguration;
        if (state == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(4);
        }
        if (profile == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(5);
        }
        if ((runConfiguration = (RunConfiguration)ObjectUtils.tryCast((Object)profile, RunConfiguration.class)) != null) {
            RunConfigurationDescriptor descriptor = new RunConfigurationDescriptor();
            descriptor.myType = runConfiguration.getType().getId();
            descriptor.myName = runConfiguration.getName();
            state.myEnabledRunConfigurations.add(descriptor);
        }
    }

    @NotNull
    private static List<RunConfiguration> loadConfigurations(@NotNull State state, @NotNull Project project) {
        if (state == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(6);
        }
        if (project == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(7);
        }
        ArrayList<RunConfiguration> configurations = new ArrayList<RunConfiguration>();
        RunManagerImpl runManager = RunManagerImpl.getInstanceImpl((Project)project);
        List descriptors = ContainerUtil.notNullize(state.myEnabledRunConfigurations);
        for (RunConfigurationDescriptor descriptor : descriptors) {
            RunnerAndConfigurationSettings settings;
            RunConfiguration configuration;
            if (descriptor.myType == null || descriptor.myName == null || (configuration = (settings = runManager.findConfigurationByTypeAndName(descriptor.myType, descriptor.myName)) != null ? settings.getConfiguration() : null) == null) continue;
            configurations.add(configuration);
        }
        ArrayList<RunConfiguration> arrayList = configurations;
        if (arrayList == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(8);
        }
        return arrayList;
    }

    @NotNull
    protected abstract AutoTestWatcher createWatcher(@NotNull Project var1);

    private void activateWatcher() {
        if (this.myWatcher == null) {
            this.myWatcher = this.createWatcher(this.myProject);
        }
        this.myWatcher.activate();
    }

    private void deactivateWatcher() {
        if (this.myWatcher != null) {
            this.myWatcher.deactivate();
            this.myWatcher = null;
        }
    }

    void setAutoTestEnabled(@NotNull RunContentDescriptor descriptor, @NotNull ExecutionEnvironment environment, boolean enabled) {
        if (descriptor == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(9);
        }
        if (environment == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(10);
        }
        if (enabled) {
            this.myEnabledRunProfiles.add(environment.getRunProfile());
            this.activateWatcher();
        } else {
            ProcessHandler processHandler2;
            this.myEnabledRunProfiles.remove(environment.getRunProfile());
            if (!this.hasEnabledAutoTests()) {
                this.deactivateWatcher();
            }
            if ((processHandler2 = descriptor.getProcessHandler()) != null) {
                AbstractAutoTestManager.clearRestarterListener(processHandler2);
            }
        }
        ((AutoTestListener)this.myProject.getMessageBus().syncPublisher(AutoTestListener.Companion.getTOPIC())).autoTestStatusChanged();
    }

    public void disableAllAutoTests() {
        this.deactivateWatcher();
        for (RunContentDescriptor descriptor : RunContentManager.getInstance(this.myProject).getAllDescriptors()) {
            ProcessHandler processHandler2;
            if (!this.isAutoTestEnabled(descriptor) || (processHandler2 = descriptor.getProcessHandler()) == null) continue;
            AbstractAutoTestManager.clearRestarterListener(processHandler2);
        }
        this.myEnabledRunProfiles.clear();
        ((AutoTestListener)this.myProject.getMessageBus().syncPublisher(AutoTestListener.Companion.getTOPIC())).autoTestStatusChanged();
    }

    @ApiStatus.Internal
    public boolean hasEnabledAutoTests() {
        return ContainerUtil.exists(RunContentManager.getInstance(this.myProject).getAllDescriptors(), this::isAutoTestEnabled);
    }

    @ApiStatus.Internal
    public boolean isAutoTestEnabled(@NotNull RunContentDescriptor descriptor) {
        ExecutionEnvironment environment;
        if (descriptor == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(11);
        }
        return (environment = AbstractAutoTestManager.getCurrentEnvironment(descriptor)) != null && this.myEnabledRunProfiles.contains(environment.getRunProfile());
    }

    @Deprecated(forRemoval=true)
    protected void restartAllAutoTests(int modificationStamp) {
        this.restartAllAutoTests(() -> this.myWatcher != null);
    }

    @RequiresEdt(generateAssertion=false)
    protected void restartAllAutoTests(@NotNull BooleanSupplier isUpToDate) {
        if (isUpToDate == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(12);
        }
        List<RunContentDescriptor> autoTestDescriptors = RunContentManager.getInstance(this.myProject).getAllDescriptors().stream().filter(this::isAutoTestEnabled).toList();
        for (RunContentDescriptor descriptor : autoTestDescriptors) {
            this.restartAutoTest(descriptor, isUpToDate);
        }
        if (autoTestDescriptors.isEmpty()) {
            this.deactivateWatcher();
        }
    }

    private void restartAutoTest(@NotNull RunContentDescriptor descriptor, @NotNull BooleanSupplier isUpToDate) {
        ProcessHandler processHandler2;
        if (descriptor == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(13);
        }
        if (isUpToDate == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(14);
        }
        if ((processHandler2 = descriptor.getProcessHandler()) != null && !processHandler2.isProcessTerminated()) {
            this.scheduleRestartOnTermination(descriptor, processHandler2, isUpToDate);
        } else {
            AbstractAutoTestManager.restart(descriptor);
        }
    }

    private void scheduleRestartOnTermination(final @NotNull RunContentDescriptor descriptor, final @NotNull ProcessHandler processHandler2, final @NotNull BooleanSupplier isUpToDate) {
        ProcessListener restarterListener;
        if (descriptor == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(15);
        }
        if (processHandler2 == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(16);
        }
        if (isUpToDate == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(17);
        }
        if ((restarterListener = (ProcessListener)ON_TERMINATION_RESTARTER_KEY.get((UserDataHolder)processHandler2)) != null) {
            AbstractAutoTestManager.clearRestarterListener(processHandler2);
        }
        restarterListener = new ProcessListener(){

            public void processTerminated(@NotNull ProcessEvent event) {
                if (event == null) {
                    1.$$$reportNull$$$0(0);
                }
                AbstractAutoTestManager.clearRestarterListener(processHandler2);
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (AbstractAutoTestManager.this.isAutoTestEnabled(descriptor) && isUpToDate.getAsBoolean()) {
                        AbstractAutoTestManager.restart(descriptor);
                    }
                }, ModalityState.any());
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "event", "com/intellij/execution/testframework/autotest/AbstractAutoTestManager$1", "processTerminated"));
            }
        };
        ON_TERMINATION_RESTARTER_KEY.set((UserDataHolder)processHandler2, (Object)restarterListener);
        processHandler2.addProcessListener(restarterListener);
    }

    int getDelay() {
        return this.myDelayMillis;
    }

    void setDelay(int delay) {
        PropertiesComponent.getInstance((Project)this.myProject).setValue(AUTO_TEST_MANAGER_DELAY, delay, 3000);
        this.myDelayMillis = delay;
        this.deactivateWatcher();
        if (this.hasEnabledAutoTests()) {
            this.activateWatcher();
        }
    }

    @Nullable
    public State getState() {
        State state = new State();
        for (RunProfile profile : this.myEnabledRunProfiles) {
            AbstractAutoTestManager.saveConfigurationState(state, profile);
        }
        return state;
    }

    public void loadState(@NotNull State state) {
        if (state == null) {
            AbstractAutoTestManager.$$$reportNull$$$0(18);
        }
        List<RunConfiguration> configurations = AbstractAutoTestManager.loadConfigurations(state, this.myProject);
        this.myEnabledRunProfiles.clear();
        this.myEnabledRunProfiles.addAll(configurations);
        if (!configurations.isEmpty()) {
            this.activateWatcher();
        }
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: 
            case 3: 
            case 9: 
            case 11: 
            case 13: 
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
            case 2: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "processHandler";
                break;
            }
            case 4: 
            case 6: 
            case 18: {
                objectArray2 = objectArray3;
                objectArray3[0] = "state";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "profile";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/execution/testframework/autotest/AbstractAutoTestManager";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "environment";
                break;
            }
            case 12: 
            case 14: 
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "isUpToDate";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/execution/testframework/autotest/AbstractAutoTestManager";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "loadConfigurations";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getCurrentEnvironment";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "clearRestarterListener";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "restart";
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "saveConfigurationState";
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "loadConfigurations";
                break;
            }
            case 8: {
                break;
            }
            case 9: 
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "setAutoTestEnabled";
                break;
            }
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "isAutoTestEnabled";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "restartAllAutoTests";
                break;
            }
            case 13: 
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "restartAutoTest";
                break;
            }
            case 15: 
            case 16: 
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "scheduleRestartOnTermination";
                break;
            }
            case 18: {
                objectArray = objectArray;
                objectArray[2] = "loadState";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8 -> new IllegalStateException(string);
        };
    }

    @Tag(value="run-configuration")
    static class RunConfigurationDescriptor {
        @Attribute(value="type")
        String myType;
        @Attribute(value="name")
        String myName;

        RunConfigurationDescriptor() {
        }
    }

    public static class State {
        @Tag(value="enabled-run-configurations")
        @XCollection
        List<RunConfigurationDescriptor> myEnabledRunConfigurations = new ArrayList<RunConfigurationDescriptor>();
    }
}

