/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.execution.testframework.export;

import com.intellij.execution.DefaultExecutionTarget;
import com.intellij.execution.ExecutionBundle;
import com.intellij.execution.ExecutionTarget;
import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.impl.ConsoleBuffer;
import com.intellij.execution.impl.RunManagerImpl;
import com.intellij.execution.testframework.AbstractTestProxy;
import com.intellij.execution.testframework.Printable;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.TestConsoleProperties;
import com.intellij.execution.testframework.TestProxyRoot;
import com.intellij.execution.testframework.stacktrace.DiffHyperlink;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.openapi.application.ApplicationNamesInfo;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.util.config.AbstractProperty;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.StringTokenizer;
import java.util.TreeMap;
import org.jdom.Attribute;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public final class TestResultsXmlFormatter {
    @NonNls
    private static final String ELEM_RUN = "testrun";
    @NonNls
    public static final String ELEM_TEST = "test";
    @NonNls
    public static final String ELEM_SUITE = "suite";
    @NonNls
    public static final String ATTR_NAME = "name";
    @NonNls
    public static final String ATTR_DURATION = "duration";
    @NonNls
    public static final String ATTR_LOCATION = "locationUrl";
    @NonNls
    public static final String ATTR_METAINFO = "metainfo";
    @NonNls
    public static final String ELEM_COUNT = "count";
    @NonNls
    public static final String ATTR_VALUE = "value";
    @NonNls
    public static final String ELEM_OUTPUT = "output";
    @NonNls
    public static final String DIFF = "diff";
    @NonNls
    public static final String EXPECTED = "expected";
    @NonNls
    public static final String ACTUAL = "actual";
    @NonNls
    public static final String ATTR_OUTPUT_TYPE = "type";
    @NonNls
    public static final String ATTR_STATUS = "status";
    @NonNls
    public static final String TOTAL_STATUS = "total";
    @NonNls
    private static final String ATTR_FOORTER_TEXT = "footerText";
    @NonNls
    public static final String ATTR_CONFIG = "isConfig";
    @NonNls
    public static final String STATUS_PASSED = "passed";
    @NonNls
    public static final String STATUS_FAILED = "failed";
    @NonNls
    public static final String STATUS_ERROR = "error";
    @NonNls
    public static final String STATUS_IGNORED = "ignored";
    @NonNls
    public static final String STATUS_SKIPPED = "skipped";
    @NonNls
    public static final String ROOT_ELEM = "root";
    private final RunConfiguration myRuntimeConfiguration;
    private final ContentHandler myResultHandler;
    private final AbstractTestProxy myTestRoot;
    private final boolean myHidePassedConfig;
    private final ExecutionTarget myExecutionTarget;
    private final TestConsoleProperties myTestConsoleProperties;

    public static void execute(AbstractTestProxy root, RunConfiguration runtimeConfiguration, TestConsoleProperties properties, ContentHandler resultHandler) throws SAXException {
        new TestResultsXmlFormatter(root, runtimeConfiguration, properties, resultHandler).execute();
    }

    private TestResultsXmlFormatter(AbstractTestProxy root, RunConfiguration runtimeConfiguration, TestConsoleProperties properties, ContentHandler resultHandler) {
        this.myRuntimeConfiguration = runtimeConfiguration;
        this.myTestRoot = root;
        this.myResultHandler = resultHandler;
        this.myHidePassedConfig = TestConsoleProperties.HIDE_SUCCESSFUL_CONFIG.value((AbstractProperty.AbstractPropertyContainer)properties);
        this.myExecutionTarget = properties.getExecutionTarget();
        this.myTestConsoleProperties = properties;
    }

    private void execute() throws SAXException {
        String presentation;
        this.myResultHandler.startDocument();
        TreeMap<String, Integer> counts = new TreeMap<String, Integer>((o1, o2) -> {
            if (TOTAL_STATUS.equals(o1) && !TOTAL_STATUS.equals(o2)) {
                return -1;
            }
            if (TOTAL_STATUS.equals(o2) && !TOTAL_STATUS.equals(o1)) {
                return 1;
            }
            return o1.compareTo((String)o2);
        });
        for (AbstractTestProxy abstractTestProxy : this.myTestRoot.getAllTests()) {
            if (!abstractTestProxy.isLeaf()) continue;
            String status = TestResultsXmlFormatter.getStatusString(abstractTestProxy);
            TestResultsXmlFormatter.increment(counts, status);
            TestResultsXmlFormatter.increment(counts, TOTAL_STATUS);
        }
        HashMap<String, String> runAttrs = new HashMap<String, String>();
        runAttrs.put(ATTR_NAME, this.myRuntimeConfiguration.getName());
        String string = ExecutionBundle.message("export.test.results.footer", ApplicationNamesInfo.getInstance().getFullProductName(), new SimpleDateFormat().format(new Date()));
        runAttrs.put(ATTR_FOORTER_TEXT, string);
        Long duration = this.myTestRoot.getCustomizedDuration(this.myTestConsoleProperties);
        if (duration != null) {
            runAttrs.put(ATTR_DURATION, String.valueOf(duration));
        }
        this.startElement(ELEM_RUN, runAttrs);
        for (Map.Entry<String, Integer> entry : counts.entrySet()) {
            HashMap<String, String> hashMap = new HashMap<String, String>();
            hashMap.put(ATTR_NAME, entry.getKey());
            hashMap.put(ATTR_VALUE, String.valueOf(entry.getValue()));
            this.startElement(ELEM_COUNT, hashMap);
            this.endElement(ELEM_COUNT);
        }
        Element config = new Element("config");
        try {
            this.myRuntimeConfiguration.writeExternal(config);
            config.setAttribute("configId", this.myRuntimeConfiguration.getType().getId());
            config.setAttribute(ATTR_NAME, this.myRuntimeConfiguration.getName());
            if (!DefaultExecutionTarget.INSTANCE.equals(this.myExecutionTarget)) {
                config.setAttribute("target", this.myExecutionTarget.getId());
            }
            config.addContent(RunManagerImpl.getInstanceImpl((Project)this.myRuntimeConfiguration.getProject()).writeBeforeRunTasks(this.myRuntimeConfiguration));
        }
        catch (WriteExternalException entry) {
            // empty catch block
        }
        this.processJDomElement(config);
        if (this.myTestRoot instanceof TestProxyRoot && (presentation = ((TestProxyRoot)((Object)this.myTestRoot)).getPresentation()) != null) {
            String rootLocation;
            LinkedHashMap<String, String> linkedHashMap = new LinkedHashMap<String, String>();
            linkedHashMap.put(ATTR_NAME, presentation);
            String comment = ((TestProxyRoot)((Object)this.myTestRoot)).getComment();
            if (comment != null) {
                linkedHashMap.put("comment", comment);
            }
            if ((rootLocation = this.myTestRoot.getLocationUrl()) != null) {
                linkedHashMap.put("location", rootLocation);
            }
            this.startElement(ROOT_ELEM, linkedHashMap);
            this.writeOutput(this.myTestRoot);
            this.endElement(ROOT_ELEM);
        }
        if (this.myTestRoot.shouldSkipRootNodeForExport()) {
            for (AbstractTestProxy abstractTestProxy : this.myTestRoot.getChildren()) {
                this.processNode(abstractTestProxy);
            }
        } else {
            this.processNode(this.myTestRoot);
        }
        this.endElement(ELEM_RUN);
        this.myResultHandler.endDocument();
    }

    private void processJDomElement(Element config) throws SAXException {
        String name = config.getName();
        LinkedHashMap<String, String> attributes = new LinkedHashMap<String, String>();
        for (Attribute attribute : config.getAttributes()) {
            attributes.put(attribute.getName(), attribute.getValue());
        }
        this.startElement(name, attributes);
        for (Element child : config.getChildren()) {
            this.processJDomElement(child);
        }
        this.endElement(name);
    }

    private static void increment(Map<String, Integer> counts, String status) {
        Integer count = counts.get(status);
        counts.put(status, count != null ? count + 1 : 1);
    }

    private void processNode(AbstractTestProxy node) throws SAXException {
        String elemName;
        String metainfo;
        String locationUrl;
        ProgressManager.checkCanceled();
        HashMap<String, String> attrs = new HashMap<String, String>();
        attrs.put(ATTR_NAME, node.getName());
        attrs.put(ATTR_STATUS, TestResultsXmlFormatter.getStatusString(node));
        Long duration = node.getCustomizedDuration(this.myTestConsoleProperties);
        if (duration != null) {
            attrs.put(ATTR_DURATION, String.valueOf(duration));
        }
        if ((locationUrl = node.getLocationUrl()) != null) {
            attrs.put(ATTR_LOCATION, locationUrl);
        }
        if ((metainfo = node.getMetainfo()) != null) {
            attrs.put(ATTR_METAINFO, metainfo);
        }
        if (node.isConfig()) {
            attrs.put(ATTR_CONFIG, "true");
        }
        boolean started = false;
        String string = elemName = node.isLeaf() ? ELEM_TEST : ELEM_SUITE;
        if (node.isLeaf()) {
            started = true;
            this.startElement(elemName, attrs);
            this.writeOutput(node);
        } else {
            for (AbstractTestProxy abstractTestProxy : node.getChildren()) {
                if (this.myHidePassedConfig && abstractTestProxy.isConfig() && abstractTestProxy.isPassed()) continue;
                if (!started) {
                    started = true;
                    this.startElement(elemName, attrs);
                }
                this.processNode(abstractTestProxy);
            }
        }
        if (started) {
            this.endElement(elemName);
        }
    }

    private void writeOutput(AbstractTestProxy node) throws SAXException {
        String stacktrace;
        final StringBuilder buffer = new StringBuilder();
        final Ref lastType = new Ref();
        final Ref error = new Ref();
        final int bufferSize = ConsoleBuffer.useCycleBuffer() ? ConsoleBuffer.getCycleBufferSize() : -1;
        Printer printer = new Printer(){

            @Override
            public void print(@NotNull String text2, @NotNull ConsoleViewContentType contentType) {
                if (text2 == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (contentType == null) {
                    1.$$$reportNull$$$0(1);
                }
                ProgressManager.checkCanceled();
                if (contentType != lastType.get()) {
                    if (!buffer.isEmpty()) {
                        try {
                            TestResultsXmlFormatter.this.writeOutput((ConsoleViewContentType)lastType.get(), buffer);
                        }
                        catch (SAXException e) {
                            error.set((Object)e);
                        }
                    }
                    lastType.set((Object)contentType);
                }
                if (bufferSize <= 0 || buffer.length() < bufferSize) {
                    buffer.append(text2);
                }
            }

            @Override
            public void onNewAvailable(@NotNull Printable printable) {
                if (printable == null) {
                    1.$$$reportNull$$$0(2);
                }
            }

            @Override
            public void printHyperlink(@NotNull String text2, HyperlinkInfo info) {
                if (text2 == null) {
                    1.$$$reportNull$$$0(3);
                }
                if (info instanceof DiffHyperlink.DiffHyperlinkInfo) {
                    DiffHyperlink diffHyperlink = ((DiffHyperlink.DiffHyperlinkInfo)info).getPrintable();
                    try {
                        HashMap<String, String> attributes = new HashMap<String, String>();
                        attributes.put(TestResultsXmlFormatter.EXPECTED, TestResultsXmlFormatter.replaceZeroTokens(diffHyperlink.getLeft()));
                        attributes.put(TestResultsXmlFormatter.ACTUAL, TestResultsXmlFormatter.replaceZeroTokens(diffHyperlink.getRight()));
                        TestResultsXmlFormatter.this.startElement(TestResultsXmlFormatter.DIFF, attributes);
                        TestResultsXmlFormatter.this.endElement(TestResultsXmlFormatter.DIFF);
                    }
                    catch (SAXException e) {
                        error.set((Object)e);
                    }
                } else {
                    this.print(text2, ConsoleViewContentType.NORMAL_OUTPUT);
                }
            }

            @Override
            public void mark() {
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[3];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "text";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "contentType";
                        break;
                    }
                    case 2: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "printable";
                        break;
                    }
                }
                objectArray2[1] = "com/intellij/execution/testframework/export/TestResultsXmlFormatter$1";
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[2] = "print";
                        break;
                    }
                    case 2: {
                        objectArray = objectArray2;
                        objectArray2[2] = "onNewAvailable";
                        break;
                    }
                    case 3: {
                        objectArray = objectArray2;
                        objectArray2[2] = "printHyperlink";
                        break;
                    }
                }
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
            }
        };
        node.printOwnPrintablesOn(printer, false);
        for (DiffHyperlink hyperlink : node.getDiffViewerProviders()) {
            printer.printHyperlink(hyperlink.getDiffTitle(), hyperlink.getInfo());
        }
        String errorMessage = node.getErrorMessage();
        if (errorMessage != null) {
            printer.print(errorMessage, ConsoleViewContentType.ERROR_OUTPUT);
        }
        if ((stacktrace = node.getStacktrace()) != null) {
            printer.print(stacktrace, ConsoleViewContentType.ERROR_OUTPUT);
        }
        if (!error.isNull()) {
            throw (SAXException)error.get();
        }
        if (!buffer.isEmpty()) {
            this.writeOutput((ConsoleViewContentType)lastType.get(), buffer);
        }
    }

    private void writeOutput(ConsoleViewContentType type, StringBuilder text2) throws SAXException {
        StringBuilder output = new StringBuilder();
        StringTokenizer t = new StringTokenizer(text2.toString(), "\n");
        while (t.hasMoreTokens()) {
            output.append(TestResultsXmlFormatter.replaceZeroTokens(t.nextToken())).append("\n");
        }
        HashMap<String, String> a = new HashMap<String, String>();
        a.put(ATTR_OUTPUT_TYPE, TestResultsXmlFormatter.getTypeString(type));
        this.startElement(ELEM_OUTPUT, a);
        this.writeText(output.toString());
        text2.delete(0, text2.length());
        this.endElement(ELEM_OUTPUT);
    }

    @NotNull
    private static String replaceZeroTokens(String str) {
        String string = str.replaceAll("\u0000", "");
        if (string == null) {
            TestResultsXmlFormatter.$$$reportNull$$$0(0);
        }
        return string;
    }

    @NonNls
    private static String getTypeString(ConsoleViewContentType type) {
        return type == ConsoleViewContentType.ERROR_OUTPUT ? "stderr" : "stdout";
    }

    private static String getStatusString(AbstractTestProxy node) {
        int magnitude = node.getMagnitude();
        return switch (magnitude) {
            case 0, 2, 4 -> STATUS_SKIPPED;
            case 5 -> STATUS_IGNORED;
            case 1 -> STATUS_PASSED;
            case 6 -> STATUS_FAILED;
            case 8 -> STATUS_ERROR;
            default -> node.isPassed() ? STATUS_PASSED : STATUS_FAILED;
        };
    }

    private void startElement(String name, Map<String, String> attributes) throws SAXException {
        AttributesImpl attrs = new AttributesImpl();
        for (Map.Entry<String, String> entry : attributes.entrySet()) {
            attrs.addAttribute("", entry.getKey(), entry.getKey(), "CDATA", entry.getValue());
        }
        this.myResultHandler.startElement("", name, name, attrs);
    }

    private void endElement(String name) throws SAXException {
        this.myResultHandler.endElement("", name, name);
    }

    private void writeText(String text2) throws SAXException {
        char[] chars = text2.toCharArray();
        this.myResultHandler.characters(chars, 0, chars.length);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/execution/testframework/export/TestResultsXmlFormatter", "replaceZeroTokens"));
    }
}

