/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark;

import com.intellij.ide.bookmark.Bookmark;
import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarkType;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.LineBookmark;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.ex.ActionUtil;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.colors.CodeInsightColors;
import com.intellij.openapi.editor.ex.MarkupModelEx;
import com.intellij.openapi.editor.impl.DocumentMarkupModel;
import com.intellij.openapi.editor.markup.GutterIconRenderer;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.editor.markup.RangeHighlighter;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.AppUIUtil;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0094\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\f\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u00012\u00020\u0002B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0005\u0010\u0006J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\n\u0010(\u001a\u0004\u0018\u00010)H\u0016J\n\u0010*\u001a\u0004\u0018\u00010)H\u0016J\n\u0010+\u001a\u0004\u0018\u00010,H\u0016J\r\u0010-\u001a\u00070.\u00a2\u0006\u0002\b/H\u0016J\b\u00100\u001a\u00020.H\u0016J\n\u00101\u001a\u0004\u0018\u00010.H\u0002J\u0012\u00101\u001a\u0004\u0018\u00010.2\u0006\u00102\u001a\u000203H\u0002J\b\u00104\u001a\u000205H\u0002J\b\u00106\u001a\u000205H\u0002J\u0014\u00107\u001a\u0002052\f\u00108\u001a\b\u0012\u0004\u0012\u00020:09J\t\u0010;\u001a\u00020\u0004H\u00c6\u0003J\u0013\u0010<\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u0004H\u00c6\u0001J\u0013\u0010=\u001a\u00020:2\b\u0010>\u001a\u0004\u0018\u00010?H\u00d6\u0003J\t\u0010@\u001a\u00020\u0016H\u00d6\u0001J\t\u0010A\u001a\u00020.H\u00d6\u0001R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0016\u0010\t\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001b\u0010\f\u001a\t\u0018\u00010\r\u00a2\u0006\u0002\b\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0019\u0010\u0011\u001a\u00070\u0012\u00a2\u0006\u0002\b\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014R\u0014\u0010\u0015\u001a\u00020\u00168BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0018R\u001b\u0010\u0019\u001a\t\u0018\u00010\u001a\u00a2\u0006\u0002\b\u000e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001b\u0010\u001cR\u0016\u0010\u001d\u001a\u0004\u0018\u00010\u001e8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0016\u0010!\u001a\u0004\u0018\u00010\u000b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#\u00a8\u0006B"}, d2={"Lcom/intellij/ide/bookmark/GutterLineBookmarkRenderer;", "Lcom/intellij/openapi/project/DumbAware;", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer;", "bookmark", "Lcom/intellij/ide/bookmark/LineBookmark;", "<init>", "(Lcom/intellij/ide/bookmark/LineBookmark;)V", "getBookmark", "()Lcom/intellij/ide/bookmark/LineBookmark;", "reference", "Ljava/lang/ref/WeakReference;", "Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "manager", "Lcom/intellij/ide/bookmark/BookmarksManager;", "Lorg/jetbrains/annotations/Nullable;", "getManager", "()Lcom/intellij/ide/bookmark/BookmarksManager;", "type", "Lcom/intellij/ide/bookmark/BookmarkType;", "getType", "()Lcom/intellij/ide/bookmark/BookmarkType;", "layer", "", "getLayer", "()I", "document", "Lcom/intellij/openapi/editor/Document;", "getDocument", "()Lcom/intellij/openapi/editor/Document;", "markup", "Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "getMarkup", "()Lcom/intellij/openapi/editor/ex/MarkupModelEx;", "highlighter", "getHighlighter$intellij_platform_bookmarks", "()Lcom/intellij/openapi/editor/markup/RangeHighlighter;", "getIcon", "Ljavax/swing/Icon;", "getAlignment", "Lcom/intellij/openapi/editor/markup/GutterIconRenderer$Alignment;", "getClickAction", "Lcom/intellij/openapi/actionSystem/AnAction;", "getMiddleButtonClickAction", "getPopupMenuActions", "Lcom/intellij/openapi/actionSystem/ActionGroup;", "getAccessibleName", "", "Lorg/jetbrains/annotations/Nls;", "getTooltipText", "getShortcut", "mnemonic", "", "createHighlighter", "", "releaseHighlighter", "refreshHighlighter", "release", "Lkotlin/Function0;", "", "component1", "copy", "equals", "other", "", "hashCode", "toString", "intellij.platform.bookmarks"})
@SourceDebugExtension(value={"SMAP\nGutterLineBookmarkRenderer.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GutterLineBookmarkRenderer.kt\ncom/intellij/ide/bookmark/GutterLineBookmarkRenderer\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 3 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,117:1\n1#2:118\n1#2:129\n1617#3,9:119\n1869#3:128\n1870#3:130\n1626#3:131\n*S KotlinDebug\n*F\n+ 1 GutterLineBookmarkRenderer.kt\ncom/intellij/ide/bookmark/GutterLineBookmarkRenderer\n*L\n61#1:129\n61#1:119,9\n61#1:128\n61#1:130\n61#1:131\n*E\n"})
public final class GutterLineBookmarkRenderer
extends GutterIconRenderer
implements DumbAware {
    @NotNull
    private final LineBookmark bookmark;
    @Nullable
    private WeakReference<RangeHighlighter> reference;

    public GutterLineBookmarkRenderer(@NotNull LineBookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        this.bookmark = bookmark;
    }

    @NotNull
    public final LineBookmark getBookmark() {
        return this.bookmark;
    }

    private final BookmarksManager getManager() {
        return BookmarksManager.getInstance((Project)this.bookmark.getProvider().getProject());
    }

    private final BookmarkType getType() {
        BookmarksManager bookmarksManager = this.getManager();
        if (bookmarksManager == null || (bookmarksManager = bookmarksManager.getType((Bookmark)this.bookmark)) == null) {
            bookmarksManager = BookmarkType.DEFAULT;
        }
        return bookmarksManager;
    }

    private final int getLayer() {
        return 5001;
    }

    private final Document getDocument() {
        return this.bookmark.getLine() < 0 ? null : FileDocumentManager.getInstance().getCachedDocument(this.bookmark.getFile());
    }

    private final MarkupModelEx getMarkup() {
        MarkupModelEx markupModelEx;
        Document document = this.getDocument();
        if (document != null) {
            Document it = document;
            boolean bl = false;
            MarkupModel markupModel = DocumentMarkupModel.forDocument(it, this.bookmark.getProvider().getProject(), false);
            markupModelEx = markupModel instanceof MarkupModelEx ? (MarkupModelEx)markupModel : null;
        } else {
            markupModelEx = null;
        }
        return markupModelEx;
    }

    @Nullable
    public final RangeHighlighter getHighlighter$intellij_platform_bookmarks() {
        WeakReference<RangeHighlighter> weakReference;
        block4: {
            weakReference = this.reference;
            if (weakReference == null || (weakReference = (RangeHighlighter)weakReference.get()) == null) {
                RangeHighlighter[] rangeHighlighterArray = this.getMarkup();
                if (rangeHighlighterArray != null && (rangeHighlighterArray = rangeHighlighterArray.getAllHighlighters()) != null) {
                    RangeHighlighter[] rangeHighlighterArray2 = rangeHighlighterArray;
                    int n = rangeHighlighterArray2.length;
                    for (int i = 0; i < n; ++i) {
                        RangeHighlighter rangeHighlighter;
                        RangeHighlighter it = rangeHighlighter = rangeHighlighterArray2[i];
                        boolean bl = false;
                        if (!Intrinsics.areEqual((Object)it.getGutterIconRenderer(), (Object)this)) continue;
                        weakReference = rangeHighlighter;
                        break block4;
                    }
                    weakReference = null;
                } else {
                    weakReference = null;
                }
            }
        }
        return weakReference;
    }

    @Override
    @NotNull
    public Icon getIcon() {
        return this.getType().getGutterIcon();
    }

    @Override
    @NotNull
    public GutterIconRenderer.Alignment getAlignment() {
        return GutterIconRenderer.Alignment.RIGHT;
    }

    @Override
    @Nullable
    public AnAction getClickAction() {
        return ActionUtil.getAction((String)"ToggleBookmark");
    }

    @Override
    @Nullable
    public AnAction getMiddleButtonClickAction() {
        return ActionUtil.getAction((String)"EditBookmark");
    }

    @Override
    @Nullable
    public ActionGroup getPopupMenuActions() {
        return ActionUtil.getActionGroup((String)"popup@BookmarkContextMenu");
    }

    @Override
    @NotNull
    public String getAccessibleName() {
        Object[] objectArray = new Object[]{this.getType()};
        String string = BookmarkBundle.message("accessible.name.icon.bookmark.0", objectArray);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @NotNull
    public String getTooltipText() {
        Object shortcut;
        Object object;
        StringBuilder result2;
        block14: {
            block13: {
                String description;
                String string;
                Object object2;
                Character mnemonic;
                result2 = new StringBuilder(BookmarkBundle.message("bookmark.text", new Object[0]));
                BookmarkType it = this.getType();
                boolean bl = false;
                Character c = mnemonic = it == BookmarkType.DEFAULT ? null : Character.valueOf(it.getMnemonic());
                if (c != null) {
                    char it2 = c.charValue();
                    boolean bl2 = false;
                    result2.append(" ").append(it2);
                }
                if ((object2 = this.getManager()) != null && (object2 = object2.getGroups((Bookmark)this.bookmark)) != null) {
                    void $this$mapNotNullTo$iv$iv;
                    Iterable $this$mapNotNull$iv = (Iterable)object2;
                    boolean $i$f$mapNotNull = false;
                    Iterable iterable = $this$mapNotNull$iv;
                    Collection destination$iv$iv = new ArrayList();
                    boolean $i$f$mapNotNullTo = false;
                    void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                    boolean $i$f$forEach = false;
                    Iterator iterator = $this$forEach$iv$iv$iv.iterator();
                    while (iterator.hasNext()) {
                        String it$iv$iv;
                        Object element$iv$iv$iv;
                        Object element$iv$iv = element$iv$iv$iv = iterator.next();
                        boolean bl3 = false;
                        BookmarkGroup group = (BookmarkGroup)element$iv$iv;
                        boolean bl4 = false;
                        if (group.getDescription((Bookmark)this.bookmark) == null) continue;
                        boolean bl5 = false;
                        destination$iv$iv.add(it$iv$iv);
                    }
                    string = (String)CollectionsKt.singleOrNull((List)((List)destination$iv$iv));
                } else {
                    string = null;
                }
                String string2 = description = string;
                if (string2 != null) {
                    String it3 = string2;
                    boolean bl6 = false;
                    if (((CharSequence)it3).length() > 0) {
                        result2.append(": ").append(StringUtil.escapeXmlEntities(it3));
                    }
                }
                if ((object = mnemonic) == null) break block13;
                char it4 = ((Character)object).charValue();
                boolean bl7 = false;
                String string3 = this.getShortcut(it4);
                object = string3;
                if (string3 != null) break block14;
            }
            object = this.getShortcut();
        }
        Object object3 = shortcut = object;
        if (object3 != null) {
            Object it = object3;
            boolean bl = false;
            if (((CharSequence)it).length() > 0) {
                result2.append(" (").append((String)it).append(")");
            }
        }
        String string = result2.toString();
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toString(...)");
        return string;
    }

    private final String getShortcut() {
        String string;
        String string2 = KeymapUtil.getFirstKeyboardShortcutText((String)"ToggleBookmark");
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFirstKeyboardShortcutText(...)");
        String toggle = string2;
        if (((CharSequence)toggle).length() > 0) {
            Object[] objectArray = new Object[]{toggle};
            string = BookmarkBundle.message("bookmark.shortcut.to.toggle", objectArray);
        } else {
            string = null;
        }
        return string;
    }

    private final String getShortcut(char mnemonic) {
        String string;
        String string2 = KeymapUtil.getFirstKeyboardShortcutText((String)("ToggleBookmark" + mnemonic));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getFirstKeyboardShortcutText(...)");
        String toggle = string2;
        String string3 = KeymapUtil.getFirstKeyboardShortcutText((String)("GotoBookmark" + mnemonic));
        Intrinsics.checkNotNullExpressionValue((Object)string3, (String)"getFirstKeyboardShortcutText(...)");
        String jump = string3;
        if (((CharSequence)toggle).length() > 0 && ((CharSequence)jump).length() > 0) {
            Object[] objectArray = new Object[]{toggle, jump};
            string = BookmarkBundle.message("bookmark.shortcut.to.toggle.and.jump", objectArray);
        } else if (((CharSequence)toggle).length() > 0) {
            Object[] objectArray = new Object[]{toggle};
            string = BookmarkBundle.message("bookmark.shortcut.to.toggle", objectArray);
        } else if (((CharSequence)jump).length() > 0) {
            Object[] objectArray = new Object[]{jump};
            string = BookmarkBundle.message("bookmark.shortcut.to.jump", objectArray);
        } else {
            string = null;
        }
        return string;
    }

    private final void createHighlighter() {
        WeakReference<Object> weakReference;
        GutterLineBookmarkRenderer gutterLineBookmarkRenderer = this;
        Object object = this.getMarkup();
        if (object != null && (object = object.addPersistentLineHighlighter(CodeInsightColors.BOOKMARKS_ATTRIBUTES, this.bookmark.getLine(), this.getLayer())) != null) {
            Object it = object;
            GutterLineBookmarkRenderer gutterLineBookmarkRenderer2 = gutterLineBookmarkRenderer;
            boolean bl = false;
            it.setGutterIconRenderer(this);
            it.setErrorStripeTooltip(this.getTooltipText());
            weakReference = new WeakReference<Object>(it);
            gutterLineBookmarkRenderer = gutterLineBookmarkRenderer2;
        } else {
            weakReference = null;
        }
        gutterLineBookmarkRenderer.reference = weakReference;
    }

    private final void releaseHighlighter() {
        RangeHighlighter rangeHighlighter = this.getHighlighter$intellij_platform_bookmarks();
        if (rangeHighlighter != null) {
            rangeHighlighter.dispose();
        }
        this.reference = null;
    }

    public final void refreshHighlighter(@NotNull Function0<Boolean> release) {
        Intrinsics.checkNotNullParameter(release, (String)"release");
        Project project = this.bookmark.getProvider().getProject();
        Intrinsics.checkNotNullExpressionValue((Object)project, (String)"getProject(...)");
        AppUIUtil.invokeLaterIfProjectAlive((Project)project, () -> GutterLineBookmarkRenderer.refreshHighlighter$lambda$0(release, this));
    }

    @NotNull
    public final LineBookmark component1() {
        return this.bookmark;
    }

    @NotNull
    public final GutterLineBookmarkRenderer copy(@NotNull LineBookmark bookmark) {
        Intrinsics.checkNotNullParameter((Object)bookmark, (String)"bookmark");
        return new GutterLineBookmarkRenderer(bookmark);
    }

    public static /* synthetic */ GutterLineBookmarkRenderer copy$default(GutterLineBookmarkRenderer gutterLineBookmarkRenderer, LineBookmark lineBookmark, int n, Object object) {
        if ((n & 1) != 0) {
            lineBookmark = gutterLineBookmarkRenderer.bookmark;
        }
        return gutterLineBookmarkRenderer.copy(lineBookmark);
    }

    @NotNull
    public String toString() {
        return "GutterLineBookmarkRenderer(bookmark=" + this.bookmark + ")";
    }

    @Override
    public int hashCode() {
        return this.bookmark.hashCode();
    }

    @Override
    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof GutterLineBookmarkRenderer)) {
            return false;
        }
        GutterLineBookmarkRenderer gutterLineBookmarkRenderer = (GutterLineBookmarkRenderer)other;
        return Intrinsics.areEqual((Object)this.bookmark, (Object)gutterLineBookmarkRenderer.bookmark);
    }

    private static final void refreshHighlighter$lambda$0(Function0 $release, GutterLineBookmarkRenderer this$0) {
        if (((Boolean)$release.invoke()).booleanValue()) {
            this$0.releaseHighlighter();
        } else {
            RangeHighlighter rangeHighlighter = this$0.getHighlighter$intellij_platform_bookmarks();
            if (rangeHighlighter != null) {
                RangeHighlighter rangeHighlighter2;
                RangeHighlighter it = rangeHighlighter2 = rangeHighlighter;
                boolean bl = false;
                it.setGutterIconRenderer(null);
                it.setGutterIconRenderer(this$0);
            } else {
                this$0.createHighlighter();
            }
        }
    }
}

