/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui.tree;

import com.intellij.ide.bookmark.ui.tree.ExtensionsKt;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ProjectViewNode;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import java.util.Collection;
import javax.swing.Icon;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0002\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0019\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0004\b\u0006\u0010\u0007J\u0012\u0010\b\u001a\u00020\t2\b\u0010\n\u001a\u0004\u0018\u00010\u000bH\u0016J\u0011\u0010\f\u001a\u00020\t2\u0006\u0010\r\u001a\u00020\u000eH\u0096\u0002J\u0010\u0010\u000f\u001a\n \u0010*\u0004\u0018\u00010\u000e0\u000eH\u0016J\u0012\u0010\u0011\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00130\u0012H\u0016J\u0010\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u0017H\u0014\u00a8\u0006\u0018"}, d2={"Lcom/intellij/ide/bookmark/ui/tree/FileSystemNode;", "Lcom/intellij/ide/projectView/ProjectViewNode;", "Lcom/intellij/psi/PsiFileSystemItem;", "fileSystemItem", "settings", "Lcom/intellij/ide/projectView/ViewSettings;", "<init>", "(Lcom/intellij/psi/PsiFileSystemItem;Lcom/intellij/ide/projectView/ViewSettings;)V", "canRepresent", "", "element", "", "contains", "file", "Lcom/intellij/openapi/vfs/VirtualFile;", "getVirtualFile", "kotlin.jvm.PlatformType", "getChildren", "", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "update", "", "presentation", "Lcom/intellij/ide/projectView/PresentationData;", "intellij.platform.bookmarks"})
@SourceDebugExtension(value={"SMAP\nextensions.kt\nKotlin\n*S Kotlin\n*F\n+ 1 extensions.kt\ncom/intellij/ide/bookmark/ui/tree/FileSystemNode\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,92:1\n1#2:93\n*E\n"})
final class FileSystemNode
extends ProjectViewNode<PsiFileSystemItem> {
    public FileSystemNode(@NotNull PsiFileSystemItem fileSystemItem, @Nullable ViewSettings settings) {
        Intrinsics.checkNotNullParameter((Object)fileSystemItem, (String)"fileSystemItem");
        super(fileSystemItem.getProject(), (Object)fileSystemItem, settings);
    }

    public boolean canRepresent(@Nullable Object element) {
        return this.getVirtualFile().equals(element);
    }

    public boolean contains(@NotNull VirtualFile file) {
        Intrinsics.checkNotNullParameter((Object)file, (String)"file");
        VirtualFile it = this.getVirtualFile();
        boolean bl = false;
        return VfsUtil.isAncestor((VirtualFile)it, (VirtualFile)file, (boolean)true);
    }

    public VirtualFile getVirtualFile() {
        Object object = this.getValue();
        Intrinsics.checkNotNull((Object)object);
        return ((PsiFileSystemItem)object).getVirtualFile();
    }

    @NotNull
    public Collection<AbstractTreeNode<?>> getChildren() {
        return this.getVirtualFile().isDirectory() ? ExtensionsKt.computeDirectoryChildren(this) : (Collection<AbstractTreeNode<?>>)CollectionsKt.emptyList();
    }

    protected void update(@NotNull PresentationData presentation) {
        Intrinsics.checkNotNullParameter((Object)presentation, (String)"presentation");
        VirtualFile file = this.getVirtualFile();
        ProjectViewNode projectViewNode = this;
        Intrinsics.checkNotNull((Object)file);
        Pair<String, Icon> scratch = ExtensionsKt.computeScratchPresentation(projectViewNode, file);
        Object object = scratch;
        if (object == null || (object = (Icon)object.getSecond()) == null) {
            object = ExtensionsKt.findFileIcon(this);
        }
        presentation.setIcon((Icon)object);
        Object object2 = scratch;
        if (object2 == null || (object2 = (String)object2.getFirst()) == null) {
            String string = file.getPresentableName();
            object2 = string;
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getPresentableName(...)");
        }
        presentation.setPresentableText((String)object2);
    }
}

