/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.bookmark.ui.tree;

import com.intellij.ide.bookmark.BookmarkBundle;
import com.intellij.ide.bookmark.BookmarkGroup;
import com.intellij.ide.bookmark.BookmarksListProvider;
import com.intellij.ide.bookmark.BookmarksManager;
import com.intellij.ide.bookmark.ui.GroupRenameDialog;
import com.intellij.ide.bookmark.ui.tree.ExtensionsKt;
import com.intellij.ide.bookmark.ui.tree.GroupNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.openapi.project.Project;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0000\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\b\u0010\u0006\u001a\u00020\u0007H\u0016J\b\u0010\b\u001a\u00020\u0003H\u0016J\u000e\u0010\t\u001a\b\u0012\u0002\b\u0003\u0018\u00010\nH\u0016J\r\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\rH\u0016J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u0018\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0014\u001a\u00020\u0015H\u0016J\r\u0010\u0016\u001a\u00070\f\u00a2\u0006\u0002\b\rH\u0016J\u0014\u0010\u0017\u001a\u00020\u000f2\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u0018H\u0016J\u001c\u0010\u0019\u001a\u00020\u00132\n\u0010\u0010\u001a\u0006\u0012\u0002\b\u00030\u00182\u0006\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/ide/bookmark/ui/tree/GroupListProvider;", "Lcom/intellij/ide/bookmark/BookmarksListProvider;", "project", "Lcom/intellij/openapi/project/Project;", "<init>", "(Lcom/intellij/openapi/project/Project;)V", "getWeight", "", "getProject", "createNode", "Lcom/intellij/ide/util/treeView/AbstractTreeNode;", "getEditActionText", "", "Lorg/jetbrains/annotations/Nls;", "canEdit", "", "selection", "", "performEdit", "", "parent", "Ljavax/swing/JComponent;", "getDeleteActionText", "canDelete", "", "performDelete", "intellij.platform.bookmarks"})
@SourceDebugExtension(value={"SMAP\nGroupListProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 GroupListProvider.kt\ncom/intellij/ide/bookmark/ui/tree/GroupListProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,34:1\n1740#2,3:35\n1869#2,2:38\n*S KotlinDebug\n*F\n+ 1 GroupListProvider.kt\ncom/intellij/ide/bookmark/ui/tree/GroupListProvider\n*L\n28#1:35,3\n29#1:38,2\n*E\n"})
public final class GroupListProvider
implements BookmarksListProvider {
    @NotNull
    private final Project project;

    public GroupListProvider(@NotNull Project project) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        this.project = project;
    }

    public int getWeight() {
        return Integer.MAX_VALUE;
    }

    @NotNull
    public Project getProject() {
        return this.project;
    }

    @Nullable
    public AbstractTreeNode<?> createNode() {
        return null;
    }

    @NotNull
    public String getEditActionText() {
        String string = BookmarkBundle.message("bookmark.group.rename.action.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean canEdit(@NotNull Object selection) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        return selection instanceof GroupNode;
    }

    public void performEdit(@NotNull Object selection, @NotNull JComponent parent) {
        Intrinsics.checkNotNullParameter((Object)selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        GroupNode groupNode = selection instanceof GroupNode ? (GroupNode)selection : null;
        if (groupNode == null) {
            return;
        }
        GroupNode node = groupNode;
        BookmarkGroup bookmarkGroup = (BookmarkGroup)node.getValue();
        if (bookmarkGroup == null) {
            return;
        }
        BookmarkGroup group = bookmarkGroup;
        BookmarksManager bookmarksManager = ExtensionsKt.getBookmarksManager(node);
        if (bookmarksManager == null) {
            return;
        }
        BookmarksManager manager = bookmarksManager;
        new GroupRenameDialog(this.project, parent, manager, group).showAndGetGroup();
    }

    @NotNull
    public String getDeleteActionText() {
        String string = BookmarkBundle.message("bookmark.group.delete.action.text", new Object[0]);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"message(...)");
        return string;
    }

    public boolean canDelete(@NotNull List<?> selection) {
        boolean bl;
        block3: {
            Intrinsics.checkNotNullParameter(selection, (String)"selection");
            Iterable $this$all$iv = selection;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                Iterator iterator = $this$all$iv.iterator();
                while (iterator.hasNext()) {
                    Object element$iv;
                    Object it = element$iv = iterator.next();
                    boolean bl2 = false;
                    if (it instanceof GroupNode) continue;
                    bl = false;
                    break block3;
                }
                bl = true;
            }
        }
        return bl;
    }

    public void performDelete(@NotNull List<?> selection, @NotNull JComponent parent) {
        Intrinsics.checkNotNullParameter(selection, (String)"selection");
        Intrinsics.checkNotNullParameter((Object)parent, (String)"parent");
        Iterable $this$forEach$iv = selection;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.iterator();
        while (iterator.hasNext()) {
            Object element$iv;
            Object it = element$iv = iterator.next();
            boolean bl = false;
            GroupNode node = it instanceof GroupNode ? (GroupNode)it : null;
            GroupNode groupNode = node;
            if (groupNode == null || (groupNode = (BookmarkGroup)groupNode.getValue()) == null) continue;
            groupNode.remove();
        }
    }
}

