/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.ide.todo.nodes.SingleFileToDoNode;
import com.intellij.ide.todo.nodes.ToDoRootNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public final class CurrentFileTodosTreeStructure
extends TodoTreeStructure {
    private PsiFile myPsiFile;

    public CurrentFileTodosTreeStructure(Project project) {
        super(project);
    }

    @Override
    protected void validateCache() {
        super.validateCache();
        if (this.myPsiFile != null && !this.myPsiFile.isValid()) {
            VirtualFile vFile = this.myPsiFile.getVirtualFile();
            this.myPsiFile = vFile.isValid() ? PsiManager.getInstance((Project)this.myProject).findFile(vFile) : null;
        }
    }

    @Nullable
    PsiFile getFile() {
        return this.myPsiFile;
    }

    public void setFile(@Nullable PsiFile psiFile) {
        this.myPsiFile = psiFile;
        this.myRootElement = this.createRootElement();
    }

    @Override
    public boolean accept(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            CurrentFileTodosTreeStructure.$$$reportNull$$$0(0);
        }
        if (this.myPsiFile == null || !this.myPsiFile.equals((Object)psiFile) || !this.myPsiFile.isValid()) {
            return false;
        }
        return this.acceptTodoFilter(psiFile);
    }

    @Override
    boolean isAutoExpandNode(NodeDescriptor descriptor) {
        Object element = descriptor.getElement();
        if (element instanceof AbstractTreeNode) {
            element = ((AbstractTreeNode)element).getValue();
        }
        if (element == this.myPsiFile) {
            return true;
        }
        return element == this.getRootElement() || element == this.mySummaryElement;
    }

    @Override
    Object getFirstSelectableElement() {
        if (this.myRootElement instanceof SingleFileToDoNode) {
            return ((SingleFileToDoNode)this.myRootElement).getFileNode();
        }
        return null;
    }

    protected AbstractTreeNode createRootElement() {
        if (this.myPsiFile == null) {
            return new ToDoRootNode(this.myProject, new Object(), this.myBuilder, this.mySummaryElement);
        }
        return new SingleFileToDoNode(this.myProject, this.myPsiFile, this.myBuilder);
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "psiFile", "com/intellij/ide/todo/CurrentFileTodosTreeStructure", "accept"));
    }
}

