/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.find.FindModel;
import com.intellij.find.impl.FindInProjectUtil;
import com.intellij.icons.AllIcons;
import com.intellij.ide.CommonActionsManager;
import com.intellij.ide.DefaultTreeExpander;
import com.intellij.ide.IdeBundle;
import com.intellij.ide.OccurenceNavigator;
import com.intellij.ide.TreeExpander;
import com.intellij.ide.actions.NextOccurenceToolbarAction;
import com.intellij.ide.actions.PreviousOccurenceToolbarAction;
import com.intellij.ide.todo.SetTodoFilterAction;
import com.intellij.ide.todo.SmartTodoItemPointer;
import com.intellij.ide.todo.TodoCompositeRenderer;
import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoPanelCoroutineHelper;
import com.intellij.ide.todo.TodoPanelSettings;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.TodoTreeStructure;
import com.intellij.ide.todo.TodoView;
import com.intellij.ide.todo.nodes.TodoFileNode;
import com.intellij.ide.todo.nodes.TodoItemNode;
import com.intellij.ide.todo.nodes.TodoTreeHelper;
import com.intellij.ide.util.PsiNavigationSupport;
import com.intellij.ide.util.treeView.AbstractTreeStructure;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.ToggleAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.SimpleToolWindowPanel;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.NlsContexts;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.util.PsiUtilCore;
import com.intellij.ui.AutoScrollToSourceHandler;
import com.intellij.ui.OnePixelSplitter;
import com.intellij.ui.PopupHandler;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.components.JBLoadingPanel;
import com.intellij.ui.content.Content;
import com.intellij.ui.tree.AsyncTreeModel;
import com.intellij.ui.tree.StructureTreeModel;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.usages.impl.UsagePreviewPanel;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.EditSourceOnDoubleClickHandler;
import com.intellij.util.EditSourceOnEnterKeyHandler;
import com.intellij.util.ObjectUtils;
import com.intellij.util.PlatformIcons;
import com.intellij.util.ui.tree.TreeModelAdapter;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import javax.swing.JComponent;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class TodoPanel
extends SimpleToolWindowPanel
implements OccurenceNavigator,
Disposable {
    protected static final Logger LOG = Logger.getInstance(TodoPanel.class);
    @NotNull
    protected final TodoView myTodoView;
    @NotNull
    protected final Project myProject;
    @NotNull
    private final TodoPanelSettings mySettings;
    private final boolean myCurrentFileMode;
    @NotNull
    private final Content myContent;
    @NotNull
    private final Tree myTree;
    @NotNull
    private final TreeExpander myTreeExpander;
    @NotNull
    private final MyOccurenceNavigator myOccurenceNavigator;
    @NotNull
    private final TodoTreeBuilder myTodoTreeBuilder;
    @NotNull
    private final UsagePreviewPanel myUsagePreviewPanel;
    private MyAutoScrollToSourceHandler myAutoScrollToSourceHandler;
    private final TodoPanelCoroutineHelper myCoroutineHelper;
    public static final DataKey<TodoPanel> TODO_PANEL_DATA_KEY = DataKey.create((String)"TodoPanel");
    private boolean myInitialized;
    private Runnable myPostponedRunnable;

    public TodoPanel(@NotNull TodoView todoView, @NotNull TodoPanelSettings settings, boolean currentFileMode, @NotNull Content content) {
        if (todoView == null) {
            TodoPanel.$$$reportNull$$$0(0);
        }
        if (settings == null) {
            TodoPanel.$$$reportNull$$$0(1);
        }
        if (content == null) {
            TodoPanel.$$$reportNull$$$0(2);
        }
        super(false, true);
        this.myCoroutineHelper = new TodoPanelCoroutineHelper(this);
        this.myInitialized = false;
        this.myTodoView = todoView;
        this.myProject = todoView.getProject();
        this.mySettings = settings;
        this.myCurrentFileMode = currentFileMode;
        this.myContent = content;
        DefaultTreeModel model2 = new DefaultTreeModel(new DefaultMutableTreeNode());
        this.myTree = new Tree((TreeModel)model2);
        this.myTreeExpander = new DefaultTreeExpander((JTree)this.myTree);
        this.myOccurenceNavigator = new MyOccurenceNavigator();
        this.myUsagePreviewPanel = new UsagePreviewPanel(this.myProject, FindInProjectUtil.setupViewPresentation((boolean)false, (FindModel)new FindModel()));
        Disposer.register((Disposable)this, (Disposable)this.myUsagePreviewPanel);
        this.initUI();
        this.myTodoTreeBuilder = this.setupTreeStructure();
        Disposer.register((Disposable)this, (Disposable)this.myTodoTreeBuilder);
        this.updateTodoFilter();
        this.myTodoTreeBuilder.setShowPackages(this.mySettings.arePackagesShown);
        this.myTodoTreeBuilder.setShowModules(this.mySettings.areModulesShown);
        this.myTodoTreeBuilder.setFlattenPackages(this.mySettings.areFlattenPackages);
    }

    @NotNull
    private TodoTreeBuilder setupTreeStructure() {
        TodoTreeBuilder todoTreeBuilder = this.createTreeBuilder((JTree)this.myTree, this.myProject);
        TodoTreeStructure structure = todoTreeBuilder.getTodoTreeStructure();
        StructureTreeModel structureTreeModel = new StructureTreeModel((AbstractTreeStructure)structure, TodoTreeBuilder.NODE_DESCRIPTOR_COMPARATOR, (Disposable)this.myProject);
        AsyncTreeModel asyncTreeModel = new AsyncTreeModel((TreeModel)structureTreeModel, (Disposable)this.myProject);
        this.myTree.setModel((TreeModel)asyncTreeModel);
        asyncTreeModel.addTreeModelListener((TreeModelListener)((Object)new MyExpandListener(todoTreeBuilder)));
        todoTreeBuilder.setModel((StructureTreeModel<? extends TodoTreeStructure>)structureTreeModel);
        Object selectableElement = structure.getFirstSelectableElement();
        if (selectableElement != null) {
            todoTreeBuilder.select(selectableElement);
        }
        TodoTreeBuilder todoTreeBuilder2 = todoTreeBuilder;
        if (todoTreeBuilder2 == null) {
            TodoPanel.$$$reportNull$$$0(3);
        }
        return todoTreeBuilder2;
    }

    @NotNull
    protected final Tree getTree() {
        Tree tree = this.myTree;
        if (tree == null) {
            TodoPanel.$$$reportNull$$$0(4);
        }
        return tree;
    }

    @NotNull
    protected final TodoTreeBuilder getTreeBuilder() {
        TodoTreeBuilder todoTreeBuilder = this.myTodoTreeBuilder;
        if (todoTreeBuilder == null) {
            TodoPanel.$$$reportNull$$$0(5);
        }
        return todoTreeBuilder;
    }

    @NotNull
    protected final UsagePreviewPanel getUsagePreviewPanel() {
        UsagePreviewPanel usagePreviewPanel = this.myUsagePreviewPanel;
        if (usagePreviewPanel == null) {
            TodoPanel.$$$reportNull$$$0(6);
        }
        return usagePreviewPanel;
    }

    public void selectItem(final @NotNull TodoItem todoItem) {
        if (todoItem == null) {
            TodoPanel.$$$reportNull$$$0(7);
        }
        this.runWhenInitialized(() -> {
            TodoView todoView = (TodoView)this.myProject.getService(TodoView.class);
            todoView.setSelectedContent(this);
            TreeVisitor.Acceptor model2 = (TreeVisitor.Acceptor)((Object)this.myTree.getModel());
            model2.accept(new TreeVisitor(){

                @Override
                @NotNull
                public TreeVisitor.Action visit(@NotNull TreePath path) {
                    TodoItem nodeTodoItem;
                    if (path == null) {
                        1.$$$reportNull$$$0(0);
                    }
                    if ((nodeTodoItem = TodoPanel.getTodoItem(path)) == null) {
                        TreeVisitor.Action action = TreeVisitor.Action.CONTINUE;
                        if (action == null) {
                            1.$$$reportNull$$$0(1);
                        }
                        return action;
                    }
                    if (nodeTodoItem.equals((Object)todoItem)) {
                        TreeVisitor.Action action = TreeVisitor.Action.INTERRUPT;
                        if (action == null) {
                            1.$$$reportNull$$$0(2);
                        }
                        return action;
                    }
                    if (nodeTodoItem.getTextRange().getStartOffset() > todoItem.getTextRange().getStartOffset()) {
                        TreeVisitor.Action action = TreeVisitor.Action.INTERRUPT;
                        if (action == null) {
                            1.$$$reportNull$$$0(3);
                        }
                        return action;
                    }
                    TreeVisitor.Action action = TreeVisitor.Action.CONTINUE;
                    if (action == null) {
                        1.$$$reportNull$$$0(4);
                    }
                    return action;
                }

                private static /* synthetic */ void $$$reportNull$$$0(int n) {
                    Object[] objectArray;
                    Object[] objectArray2;
                    Object[] objectArray3 = new Object[switch (n) {
                        default -> 3;
                        case 1, 2, 3, 4 -> 2;
                    }];
                    switch (n) {
                        default: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "path";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            objectArray2 = objectArray3;
                            objectArray3[0] = "com/intellij/ide/todo/TodoPanel$1";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray2;
                            objectArray2[1] = "com/intellij/ide/todo/TodoPanel$1";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            objectArray = objectArray2;
                            objectArray2[1] = "visit";
                            break;
                        }
                    }
                    switch (n) {
                        default: {
                            objectArray = objectArray;
                            objectArray[2] = "visit";
                            break;
                        }
                        case 1: 
                        case 2: 
                        case 3: 
                        case 4: {
                            break;
                        }
                    }
                    String string = String.format(v0, objectArray);
                    throw switch (n) {
                        default -> new IllegalArgumentException(string);
                        case 1, 2, 3, 4 -> new IllegalStateException(string);
                    };
                }
            }).onSuccess(path -> {
                if (path != null && todoItem.equals((Object)TodoPanel.getTodoItem(path))) {
                    new Alarm().addRequest(() -> this.myTree.setSelectionPath(path), 100);
                }
            });
        });
    }

    private void runWhenInitialized(Runnable runnable) {
        if (this.myInitialized) {
            runnable.run();
        } else {
            this.myPostponedRunnable = runnable;
        }
    }

    void invokePostponedRunnable() {
        this.myInitialized = true;
        if (this.myPostponedRunnable != null) {
            ApplicationManager.getApplication().invokeLater(this.myPostponedRunnable);
            this.myPostponedRunnable = null;
        }
    }

    @Nullable
    private static TodoItem getTodoItem(@NotNull TreePath path) {
        Object component;
        if (path == null) {
            TodoPanel.$$$reportNull$$$0(8);
        }
        if (!((component = path.getLastPathComponent()) instanceof DefaultMutableTreeNode)) {
            return null;
        }
        DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)component;
        Object userObject = treeNode.getUserObject();
        if (!(userObject instanceof TodoItemNode)) {
            return null;
        }
        TodoItemNode itemNode = (TodoItemNode)userObject;
        SmartTodoItemPointer value = (SmartTodoItemPointer)itemNode.getValue();
        if (value == null) {
            return null;
        }
        return value.getTodoItem();
    }

    protected abstract TodoTreeBuilder createTreeBuilder(@NotNull JTree var1, @NotNull Project var2);

    private void initUI() {
        this.myTree.setShowsRootHandles(true);
        this.myTree.setRootVisible(false);
        this.myTree.setRowHeight(0);
        this.myTree.setCellRenderer((TreeCellRenderer)new TodoCompositeRenderer());
        EditSourceOnDoubleClickHandler.install((JTree)this.myTree);
        EditSourceOnEnterKeyHandler.install((JTree)this.myTree);
        TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)this.myTree);
        DefaultActionGroup group = new DefaultActionGroup();
        group.add(ActionManager.getInstance().getAction("EditSource"));
        group.addSeparator();
        group.add(CommonActionsManager.getInstance().createExpandAllAction(this.myTreeExpander, (JComponent)((Object)this)));
        group.add(CommonActionsManager.getInstance().createCollapseAllAction(this.myTreeExpander, (JComponent)((Object)this)));
        group.addSeparator();
        group.add(ActionManager.getInstance().getAction("VersionControlsGroup"));
        PopupHandler.installPopupMenu((JComponent)this.myTree, (ActionGroup)group, (String)"TodoViewPopup");
        this.myUsagePreviewPanel.setVisible(this.mySettings.showPreview);
        this.setContent(this.createCenterComponent());
        this.myTree.getSelectionModel().addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(@NotNull TreeSelectionEvent e) {
                if (e == null) {
                    2.$$$reportNull$$$0(0);
                }
                TodoPanel.this.myCoroutineHelper.schedulePreviewPanelLayoutUpdate();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/ide/todo/TodoPanel$2", "valueChanged"));
            }
        });
        this.myAutoScrollToSourceHandler = new MyAutoScrollToSourceHandler();
        this.myAutoScrollToSourceHandler.install((JTree)this.myTree);
        DefaultActionGroup toolbarGroup = new DefaultActionGroup();
        toolbarGroup.add((AnAction)new PreviousOccurenceToolbarAction((OccurenceNavigator)this.myOccurenceNavigator));
        toolbarGroup.add((AnAction)new NextOccurenceToolbarAction((OccurenceNavigator)this.myOccurenceNavigator));
        toolbarGroup.add((AnAction)new SetTodoFilterAction(this.myProject, this.mySettings, (Consumer<? super TodoFilter>)((Consumer)todoFilter -> this.setTodoFilter((TodoFilter)todoFilter))));
        toolbarGroup.add(this.createAutoScrollToSourceAction());
        toolbarGroup.add(CommonActionsManager.getInstance().createExpandAllAction(this.myTreeExpander, (JComponent)((Object)this)));
        toolbarGroup.add(CommonActionsManager.getInstance().createCollapseAllAction(this.myTreeExpander, (JComponent)((Object)this)));
        if (!this.myCurrentFileMode) {
            DefaultActionGroup groupBy = this.createGroupByActionGroup();
            toolbarGroup.add((AnAction)groupBy);
        }
        toolbarGroup.add((AnAction)((Object)new MyPreviewAction()));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("TodoViewToolbar", (ActionGroup)toolbarGroup, false);
        toolbar.setTargetComponent((JComponent)this.myTree);
        this.setToolbar(toolbar.getComponent());
    }

    @NotNull
    protected DefaultActionGroup createGroupByActionGroup() {
        ActionManager actionManager = ActionManager.getInstance();
        DefaultActionGroup defaultActionGroup = (DefaultActionGroup)actionManager.getAction("TodoViewGroupByGroup");
        if (defaultActionGroup == null) {
            TodoPanel.$$$reportNull$$$0(9);
        }
        return defaultActionGroup;
    }

    protected AnAction createAutoScrollToSourceAction() {
        return this.myAutoScrollToSourceHandler.createToggleAction();
    }

    protected JComponent createCenterComponent() {
        OnePixelSplitter splitter = new OnePixelSplitter(false);
        splitter.setSecondComponent((JComponent)((Object)this.myUsagePreviewPanel));
        JBLoadingPanel loadingPanel = new JBLoadingPanel((LayoutManager)new BorderLayout(), (Disposable)this, 1000);
        loadingPanel.add((Component)ScrollPaneFactory.createScrollPane((Component)this.myTree), (Object)"Center");
        splitter.setFirstComponent((JComponent)loadingPanel);
        return splitter;
    }

    public void dispose() {
    }

    void updateTodoFilter() {
        TodoFilter filter = TodoConfiguration.getInstance().getTodoFilter(this.mySettings.todoFilterName);
        this.setTodoFilter(filter);
    }

    private void setTodoFilter(TodoFilter filter) {
        String filterName;
        this.mySettings.todoFilterName = filterName = filter != null ? filter.getName() : null;
        this.myTodoTreeBuilder.setTodoFilter(filter);
        this.myContent.setDescription(filterName);
    }

    @Nullable
    protected PsiFile getSelectedFile() {
        Object object = TreeUtil.getLastUserObject((TreePath)this.myTree.getSelectionPath());
        return object instanceof NodeDescriptor ? TodoTreeBuilder.getFileForNodeDescriptor((NodeDescriptor)object) : null;
    }

    protected void setDisplayName(@NlsContexts.TabTitle String tabName) {
        this.myContent.setDisplayName(tabName);
    }

    public void uiDataSnapshot(@NotNull DataSink sink) {
        if (sink == null) {
            TodoPanel.$$$reportNull$$$0(10);
        }
        super.uiDataSnapshot(sink);
        sink.set(TODO_PANEL_DATA_KEY, (Object)this);
        sink.set(PlatformCoreDataKeys.HELP_ID, (Object)"find.todoList");
        NodeDescriptor selection = (NodeDescriptor)ObjectUtils.tryCast((Object)TreeUtil.getLastUserObject((TreePath)this.myTree.getSelectionPath()), NodeDescriptor.class);
        if (selection == null) {
            return;
        }
        sink.lazy(CommonDataKeys.VIRTUAL_FILE, () -> {
            PsiFile file = TodoTreeBuilder.getFileForNodeDescriptor(selection);
            return PsiUtilCore.getVirtualFile((PsiElement)file);
        });
        sink.lazy(CommonDataKeys.PSI_ELEMENT, () -> {
            PsiElement selectedElement = TodoTreeHelper.getInstance(this.myProject).getSelectedElement(selection);
            if (selectedElement != null) {
                return selectedElement;
            }
            return TodoTreeBuilder.getFileForNodeDescriptor(selection);
        });
        sink.lazy(CommonDataKeys.VIRTUAL_FILE_ARRAY, () -> {
            VirtualFile[] virtualFileArray;
            VirtualFile file = PsiUtilCore.getVirtualFile((PsiElement)TodoTreeBuilder.getFileForNodeDescriptor(selection));
            if (file == null) {
                virtualFileArray = null;
            } else {
                VirtualFile[] virtualFileArray2 = new VirtualFile[1];
                virtualFileArray = virtualFileArray2;
                virtualFileArray2[0] = file;
            }
            return virtualFileArray;
        });
        sink.lazy(CommonDataKeys.NAVIGATABLE, () -> {
            Object element = selection.getElement();
            if (!(element instanceof TodoFileNode) && !(element instanceof TodoItemNode)) {
                return null;
            }
            TodoItemNode pointer = this.myTodoTreeBuilder.getFirstPointerForElement(element);
            SmartTodoItemPointer value = pointer == null ? null : (SmartTodoItemPointer)pointer.getValue();
            return value == null ? null : PsiNavigationSupport.getInstance().createNavigatable(this.myProject, value.getTodoItem().getFile().getVirtualFile(), value.getRangeMarker().getStartOffset());
        });
    }

    @NotNull
    public ActionUpdateThread getActionUpdateThread() {
        ActionUpdateThread actionUpdateThread = this.myOccurenceNavigator.getActionUpdateThread();
        if (actionUpdateThread == null) {
            TodoPanel.$$$reportNull$$$0(11);
        }
        return actionUpdateThread;
    }

    @Nullable
    public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
        return this.myOccurenceNavigator.goPreviousOccurence();
    }

    @NotNull
    public String getNextOccurenceActionName() {
        String string = this.myOccurenceNavigator.getNextOccurenceActionName();
        if (string == null) {
            TodoPanel.$$$reportNull$$$0(12);
        }
        return string;
    }

    @Nullable
    public OccurenceNavigator.OccurenceInfo goNextOccurence() {
        return this.myOccurenceNavigator.goNextOccurence();
    }

    public boolean hasNextOccurence() {
        return this.myOccurenceNavigator.hasNextOccurence();
    }

    @NotNull
    public String getPreviousOccurenceActionName() {
        String string = this.myOccurenceNavigator.getPreviousOccurenceActionName();
        if (string == null) {
            TodoPanel.$$$reportNull$$$0(13);
        }
        return string;
    }

    public boolean hasPreviousOccurence() {
        return this.myOccurenceNavigator.hasPreviousOccurence();
    }

    protected void rebuildWithAlarm(Alarm alarm) {
        alarm.cancelAllRequests();
        alarm.addRequest(() -> this.myTodoTreeBuilder.rebuildCache(), 300);
    }

    void updateVisibility(@NotNull ToolWindow toolWindow) {
        if (toolWindow == null) {
            TodoPanel.$$$reportNull$$$0(14);
        }
        this.myTodoTreeBuilder.setUpdatable(toolWindow.isVisible() && this.myContent.isSelected());
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 3, 4, 5, 6, 9, 11, 12, 13 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "todoView";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "settings";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "content";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/TodoPanel";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "todoItem";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "path";
                break;
            }
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sink";
                break;
            }
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "toolWindow";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/TodoPanel";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "setupTreeStructure";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getTree";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getTreeBuilder";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getUsagePreviewPanel";
                break;
            }
            case 9: {
                objectArray = objectArray2;
                objectArray2[1] = "createGroupByActionGroup";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "getActionUpdateThread";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "getNextOccurenceActionName";
                break;
            }
            case 13: {
                objectArray = objectArray2;
                objectArray2[1] = "getPreviousOccurenceActionName";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 9: 
            case 11: 
            case 12: 
            case 13: {
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "selectItem";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getTodoItem";
                break;
            }
            case 10: {
                objectArray = objectArray;
                objectArray[2] = "uiDataSnapshot";
                break;
            }
            case 14: {
                objectArray = objectArray;
                objectArray[2] = "updateVisibility";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 3, 4, 5, 6, 9, 11, 12, 13 -> new IllegalStateException(string);
        };
    }

    private final class MyOccurenceNavigator
    implements OccurenceNavigator {
        private MyOccurenceNavigator() {
        }

        public boolean hasNextOccurence() {
            TreePath path = TodoPanel.this.myTree.getSelectionPath();
            if (path == null) {
                return false;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (userObject == null) {
                return false;
            }
            if (userObject instanceof NodeDescriptor && ((NodeDescriptor)userObject).getElement() instanceof TodoItemNode) {
                return TodoPanel.this.myTree.getRowCount() != TodoPanel.this.myTree.getRowForPath(path) + 1;
            }
            TreeModel model2 = TodoPanel.this.myTree.getModel();
            return !model2.isLeaf(node);
        }

        public boolean hasPreviousOccurence() {
            TreePath path = TodoPanel.this.myTree.getSelectionPath();
            if (path == null) {
                return false;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            return userObject instanceof NodeDescriptor && !MyOccurenceNavigator.isFirst(node);
        }

        private static boolean isFirst(TreeNode node) {
            TreeNode parent = node.getParent();
            return parent == null || parent.getIndex(node) == 0 && MyOccurenceNavigator.isFirst(parent);
        }

        @Nullable
        public OccurenceNavigator.OccurenceInfo goNextOccurence() {
            return this.goToPointer(this.getNextPointer());
        }

        @Nullable
        public OccurenceNavigator.OccurenceInfo goPreviousOccurence() {
            return this.goToPointer(this.getPreviousPointer());
        }

        @NotNull
        public String getNextOccurenceActionName() {
            String string = IdeBundle.message((String)"action.next.todo", (Object[])new Object[0]);
            if (string == null) {
                MyOccurenceNavigator.$$$reportNull$$$0(0);
            }
            return string;
        }

        @NotNull
        public String getPreviousOccurenceActionName() {
            String string = IdeBundle.message((String)"action.previous.todo", (Object[])new Object[0]);
            if (string == null) {
                MyOccurenceNavigator.$$$reportNull$$$0(1);
            }
            return string;
        }

        @Nullable
        private OccurenceNavigator.OccurenceInfo goToPointer(TodoItemNode pointer) {
            if (pointer == null) {
                return null;
            }
            TodoPanel.this.myTodoTreeBuilder.select(pointer);
            return new OccurenceNavigator.OccurenceInfo(PsiNavigationSupport.getInstance().createNavigatable(TodoPanel.this.myProject, ((SmartTodoItemPointer)pointer.getValue()).getTodoItem().getFile().getVirtualFile(), ((SmartTodoItemPointer)pointer.getValue()).getRangeMarker().getStartOffset()), -1, -1);
        }

        @Nullable
        private TodoItemNode getNextPointer() {
            TreePath path = TodoPanel.this.myTree.getSelectionPath();
            if (path == null) {
                return null;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof NodeDescriptor)) {
                return null;
            }
            Object element = ((NodeDescriptor)userObject).getElement();
            TodoItemNode pointer = element instanceof TodoItemNode ? TodoPanel.this.myTodoTreeBuilder.getNextPointer((TodoItemNode)element) : TodoPanel.this.myTodoTreeBuilder.getFirstPointerForElement(element);
            return pointer;
        }

        @Nullable
        private TodoItemNode getPreviousPointer() {
            TodoItemNode pointer;
            TreePath path = TodoPanel.this.myTree.getSelectionPath();
            if (path == null) {
                return null;
            }
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)path.getLastPathComponent();
            Object userObject = node.getUserObject();
            if (!(userObject instanceof NodeDescriptor)) {
                return null;
            }
            Object element = ((NodeDescriptor)userObject).getElement();
            if (element instanceof TodoItemNode) {
                pointer = TodoPanel.this.myTodoTreeBuilder.getPreviousPointer((TodoItemNode)element);
            } else {
                Object sibling = TodoPanel.this.myTodoTreeBuilder.getPreviousSibling(element);
                if (sibling == null) {
                    return null;
                }
                pointer = TodoPanel.this.myTodoTreeBuilder.getLastPointerForElement(sibling);
            }
            return pointer;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                MyOccurenceNavigator.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[2];
            objectArray2[0] = "com/intellij/ide/todo/TodoPanel$MyOccurenceNavigator";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getNextOccurenceActionName";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getPreviousOccurenceActionName";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", objectArray));
        }
    }

    private final class MyExpandListener
    extends TreeModelAdapter {
        private final TodoTreeBuilder myBuilder;

        MyExpandListener(TodoTreeBuilder builder) {
            this.myBuilder = builder;
        }

        public void treeNodesInserted(TreeModelEvent e) {
            Object[] children;
            TreePath parentPath = e.getTreePath();
            if (parentPath == null || parentPath.getPathCount() > 2) {
                return;
            }
            for (Object o : children = e.getChildren()) {
                NodeDescriptor descriptor = (NodeDescriptor)TreeUtil.getUserObject(NodeDescriptor.class, (Object)o);
                if (descriptor == null || !this.myBuilder.isAutoExpandNode(descriptor)) continue;
                ApplicationManager.getApplication().invokeLater(() -> {
                    if (TodoPanel.this.myTree.isVisible(parentPath) && TodoPanel.this.myTree.isExpanded(parentPath)) {
                        TodoPanel.this.myTree.expandPath(parentPath.pathByAddingChild(o));
                    }
                }, this.myBuilder.myProject.getDisposed());
            }
        }
    }

    private final class MyAutoScrollToSourceHandler
    extends AutoScrollToSourceHandler {
        MyAutoScrollToSourceHandler() {
        }

        protected boolean isAutoScrollMode() {
            return TodoPanel.this.mySettings.isAutoScrollToSource;
        }

        protected void setAutoScrollMode(boolean state) {
            TodoPanel.this.mySettings.isAutoScrollToSource = state;
        }
    }

    private final class MyPreviewAction
    extends ToggleAction
    implements DumbAware {
        MyPreviewAction() {
            super(IdeBundle.messagePointer((String)"todo.panel.preview.source.action.text", (Object[])new Object[0]), Presentation.NULL_STRING, AllIcons.Actions.PreviewDetails);
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            if (e == null) {
                MyPreviewAction.$$$reportNull$$$0(0);
            }
            return TodoPanel.this.mySettings.showPreview;
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyPreviewAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            if (e == null) {
                MyPreviewAction.$$$reportNull$$$0(2);
            }
            TodoPanel.this.mySettings.showPreview = state;
            TodoPanel.this.myUsagePreviewPanel.setVisible(state);
            TodoPanel.this.myCoroutineHelper.schedulePreviewPanelLayoutUpdate();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/todo/TodoPanel$MyPreviewAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/todo/TodoPanel$MyPreviewAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    static final class MyFlattenPackagesAction
    extends ToggleAction
    implements DumbAware {
        MyFlattenPackagesAction() {
            super(IdeBundle.messagePointer((String)"action.flatten.view", (Object[])new Object[0]), PlatformIcons.FLATTEN_PACKAGES_ICON);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyFlattenPackagesAction.$$$reportNull$$$0(0);
            }
            super.update(e);
            e.getPresentation().setText("   " + this.getTemplateText());
            TodoPanel todoPanel = e.getData(TODO_PANEL_DATA_KEY);
            e.getPresentation().setEnabled(todoPanel != null && todoPanel.mySettings.arePackagesShown);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyFlattenPackagesAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            TodoPanel todoPanel;
            if (e == null) {
                MyFlattenPackagesAction.$$$reportNull$$$0(2);
            }
            return (todoPanel = e.getData(TODO_PANEL_DATA_KEY)) != null && todoPanel.mySettings.areFlattenPackages;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            TodoPanel todoPanel;
            if (e == null) {
                MyFlattenPackagesAction.$$$reportNull$$$0(3);
            }
            if ((todoPanel = e.getData(TODO_PANEL_DATA_KEY)) != null) {
                todoPanel.mySettings.areFlattenPackages = state;
                todoPanel.myTodoTreeBuilder.setFlattenPackages(state);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/todo/TodoPanel$MyFlattenPackagesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/todo/TodoPanel$MyFlattenPackagesAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    static final class MyShowModulesAction
    extends ToggleAction
    implements DumbAware {
        MyShowModulesAction() {
            super(IdeBundle.messagePointer((String)"action.group.by.modules", (Object[])new Object[0]), AllIcons.Actions.GroupByModule);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowModulesAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(e.getData(TODO_PANEL_DATA_KEY) != null);
            super.update(e);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyShowModulesAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            TodoPanel todoPanel;
            if (e == null) {
                MyShowModulesAction.$$$reportNull$$$0(2);
            }
            return (todoPanel = e.getData(TODO_PANEL_DATA_KEY)) != null && todoPanel.mySettings.areModulesShown;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            TodoPanel todoPanel;
            if (e == null) {
                MyShowModulesAction.$$$reportNull$$$0(3);
            }
            if ((todoPanel = e.getData(TODO_PANEL_DATA_KEY)) != null) {
                todoPanel.mySettings.areModulesShown = state;
                todoPanel.myTodoTreeBuilder.setShowModules(state);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/todo/TodoPanel$MyShowModulesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/todo/TodoPanel$MyShowModulesAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }

    @ApiStatus.Internal
    static final class MyShowPackagesAction
    extends ToggleAction
    implements DumbAware {
        MyShowPackagesAction() {
            super(IdeBundle.messagePointer((String)"action.group.by.packages", (Object[])new Object[0]), PlatformIcons.GROUP_BY_PACKAGES);
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                MyShowPackagesAction.$$$reportNull$$$0(0);
            }
            e.getPresentation().setEnabled(e.getData(TODO_PANEL_DATA_KEY) != null);
            super.update(e);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                MyShowPackagesAction.$$$reportNull$$$0(1);
            }
            return actionUpdateThread;
        }

        public boolean isSelected(@NotNull AnActionEvent e) {
            TodoPanel todoPanel;
            if (e == null) {
                MyShowPackagesAction.$$$reportNull$$$0(2);
            }
            return (todoPanel = e.getData(TODO_PANEL_DATA_KEY)) != null && todoPanel.mySettings.arePackagesShown;
        }

        public void setSelected(@NotNull AnActionEvent e, boolean state) {
            TodoPanel todoPanel;
            if (e == null) {
                MyShowPackagesAction.$$$reportNull$$$0(3);
            }
            if ((todoPanel = e.getData(TODO_PANEL_DATA_KEY)) != null) {
                todoPanel.mySettings.arePackagesShown = state;
                todoPanel.myTodoTreeBuilder.setShowPackages(state);
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 1 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/ide/todo/TodoPanel$MyShowPackagesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/ide/todo/TodoPanel$MyShowPackagesAction";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 1: {
                    break;
                }
                case 2: {
                    objectArray = objectArray;
                    objectArray[2] = "isSelected";
                    break;
                }
                case 3: {
                    objectArray = objectArray;
                    objectArray[2] = "setSelected";
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 1 -> new IllegalStateException(string);
            };
        }
    }
}

