/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo;

import com.intellij.ide.projectView.TreeStructureProvider;
import com.intellij.ide.todo.ToDoSettings;
import com.intellij.ide.todo.ToDoSummary;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.nodes.ToDoRootNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.ide.util.treeView.AbstractTreeStructureBase;
import com.intellij.ide.util.treeView.NodeDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.ActionCallback;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoPattern;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;

@ApiStatus.Internal
public abstract class TodoTreeStructure
extends AbstractTreeStructureBase
implements ToDoSettings {
    protected TodoTreeBuilder myBuilder;
    protected AbstractTreeNode<?> myRootElement;
    protected final ToDoSummary mySummaryElement = new ToDoSummary();
    private boolean myFlattenPackages;
    private boolean myArePackagesShown = true;
    private boolean myAreModulesShown;
    private final PsiTodoSearchHelper mySearchHelper;
    private TodoFilter myTodoFilter;

    public TodoTreeStructure(Project project) {
        super(project);
        this.mySearchHelper = PsiTodoSearchHelper.getInstance((Project)project);
    }

    final void setTreeBuilder(TodoTreeBuilder builder) {
        this.myBuilder = builder;
        this.myRootElement = this.createRootElement();
    }

    protected AbstractTreeNode<?> createRootElement() {
        return new ToDoRootNode(this.myProject, new Object(), this.myBuilder, this.mySummaryElement);
    }

    public abstract boolean accept(@NotNull PsiFile var1);

    protected void validateCache() {
    }

    public final boolean isPackagesShown() {
        return this.myArePackagesShown;
    }

    final void setShownPackages(boolean state) {
        this.myArePackagesShown = state;
    }

    public final boolean areFlattenPackages() {
        return this.myFlattenPackages;
    }

    public final void setFlattenPackages(boolean state) {
        this.myFlattenPackages = state;
    }

    final void setTodoFilter(TodoFilter todoFilter) {
        this.myTodoFilter = todoFilter;
    }

    Object getFirstSelectableElement() {
        return ((ToDoRootNode)this.myRootElement).getSummaryNode();
    }

    public final int getTodoItemCount(PsiFile psiFile) {
        int count = 0;
        if (psiFile != null) {
            if (this.myTodoFilter != null) {
                for (TodoPattern pattern : this.myTodoFilter) {
                    count += this.getSearchHelper().getTodoItemsCount(psiFile, pattern);
                }
            } else {
                count = this.getSearchHelper().getTodoItemsCount(psiFile);
            }
        }
        return count;
    }

    boolean isAutoExpandNode(NodeDescriptor descriptor) {
        Object element = descriptor.getElement();
        if (element instanceof AbstractTreeNode) {
            element = ((AbstractTreeNode)element).getValue();
        }
        return element == this.getRootElement() || element == this.mySummaryElement && (this.myAreModulesShown || this.myArePackagesShown);
    }

    protected final boolean acceptTodoFilter(@NotNull PsiFile psiFile) {
        if (psiFile == null) {
            TodoTreeStructure.$$$reportNull$$$0(0);
        }
        PsiTodoSearchHelper searchHelper = this.getSearchHelper();
        return this.myTodoFilter != null && this.myTodoFilter.accept(searchHelper, psiFile) || this.myTodoFilter == null && searchHelper.getTodoItemsCount(psiFile) > 0;
    }

    @Override
    public final void commit() {
        PsiDocumentManager.getInstance((Project)this.myProject).commitAllDocuments();
    }

    @Override
    public boolean hasSomethingToCommit() {
        return PsiDocumentManager.getInstance((Project)this.myProject).hasUncommitedDocuments();
    }

    @Override
    @NotNull
    public ActionCallback asyncCommit() {
        ActionCallback actionCallback = TodoTreeStructure.asyncCommitDocuments(this.myProject);
        if (actionCallback == null) {
            TodoTreeStructure.$$$reportNull$$$0(1);
        }
        return actionCallback;
    }

    @Override
    @NotNull
    public final Object getRootElement() {
        AbstractTreeNode<?> abstractTreeNode = this.myRootElement;
        if (abstractTreeNode == null) {
            TodoTreeStructure.$$$reportNull$$$0(2);
        }
        return abstractTreeNode;
    }

    public boolean getIsFlattenPackages() {
        return this.myFlattenPackages;
    }

    @Override
    public boolean getIsPackagesShown() {
        return this.myArePackagesShown;
    }

    public PsiTodoSearchHelper getSearchHelper() {
        return this.mySearchHelper;
    }

    public TodoFilter getTodoFilter() {
        return this.myTodoFilter;
    }

    @Override
    public List<TreeStructureProvider> getProviders() {
        return Collections.emptyList();
    }

    void setShownModules(boolean state) {
        this.myAreModulesShown = state;
    }

    @Override
    public boolean isModulesShown() {
        return this.myAreModulesShown;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/TodoTreeStructure";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/TodoTreeStructure";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "asyncCommit";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getRootElement";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "acceptTodoFilter";
                break;
            }
            case 1: 
            case 2: {
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2 -> new IllegalStateException(string);
        };
    }
}

