/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.ide.todo.nodes;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.projectView.PresentationData;
import com.intellij.ide.projectView.ViewSettings;
import com.intellij.ide.projectView.impl.nodes.PsiFileNode;
import com.intellij.ide.todo.SmartTodoItemPointer;
import com.intellij.ide.todo.TodoFilter;
import com.intellij.ide.todo.TodoTreeBuilder;
import com.intellij.ide.todo.nodes.TodoItemNode;
import com.intellij.ide.util.treeView.AbstractTreeNode;
import com.intellij.injected.editor.DocumentWindow;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.IndexNotReadyException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiRecursiveElementWalkingVisitor;
import com.intellij.psi.impl.search.TodoItemImpl;
import com.intellij.psi.search.PsiTodoSearchHelper;
import com.intellij.psi.search.TodoItem;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;

public final class TodoFileNode
extends PsiFileNode {
    private final TodoTreeBuilder myBuilder;
    private final boolean mySingleFileMode;

    public TodoFileNode(Project project, @NotNull PsiFile file, TodoTreeBuilder treeBuilder, boolean singleFileMode) {
        if (file == null) {
            TodoFileNode.$$$reportNull$$$0(0);
        }
        super(project, file, ViewSettings.DEFAULT);
        this.myBuilder = treeBuilder;
        this.mySingleFileMode = singleFileMode;
    }

    @NotNull
    public List<AbstractTreeNode<?>> getChildrenImpl() {
        List<AbstractTreeNode<?>> list2;
        Document document;
        ArrayList<TodoItemNode> children;
        List<? extends TodoItem> items;
        block8: {
            PsiFile psiFile = (PsiFile)this.getValue();
            assert (psiFile != null);
            items = TodoFileNode.findAllTodos(psiFile, this.myBuilder.getTodoTreeStructure().getSearchHelper());
            children = new ArrayList<TodoItemNode>(items.size());
            document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(psiFile);
            if (document != null) break block8;
            List<AbstractTreeNode<?>> list3 = List.of();
            if (list3 == null) {
                TodoFileNode.$$$reportNull$$$0(1);
            }
            return list3;
        }
        try {
            for (TodoItem todoItem : items) {
                TodoFilter todoFilter;
                if (todoItem.getTextRange().getEndOffset() > document.getTextLength() || (todoFilter = this.getToDoFilter()) != null && !todoFilter.contains(todoItem.getPattern())) continue;
                TodoItemNode node = new TodoItemNode(this.getProject(), new SmartTodoItemPointer(todoItem, document), this.myBuilder);
                children.add(node);
            }
            children.sort(Comparator.comparingInt(TodoFileNode::getOffset));
            list2 = Collections.unmodifiableList(children);
        }
        catch (IndexNotReadyException e) {
            List<AbstractTreeNode<?>> list4 = List.of();
            if (list4 == null) {
                TodoFileNode.$$$reportNull$$$0(3);
            }
            return list4;
        }
        if (list2 == null) {
            TodoFileNode.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @NotNull
    public static List<? extends TodoItem> findAllTodos(final @NotNull PsiFile psiFile, final @NotNull PsiTodoSearchHelper helper) {
        if (psiFile == null) {
            TodoFileNode.$$$reportNull$$$0(4);
        }
        if (helper == null) {
            TodoFileNode.$$$reportNull$$$0(5);
        }
        final ArrayList<TodoItem> todoItems = new ArrayList<TodoItem>(Arrays.asList(helper.findTodoItems(psiFile)));
        psiFile.accept((PsiElementVisitor)new PsiRecursiveElementWalkingVisitor(){

            public void visitElement(@NotNull PsiElement element) {
                if (element == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (element instanceof PsiLanguageInjectionHost) {
                    InjectedLanguageManager.getInstance((Project)psiFile.getProject()).enumerate(element, (injectedPsi, places) -> {
                        if (places.size() == 1) {
                            Document document = PsiDocumentManager.getInstance((Project)injectedPsi.getProject()).getCachedDocument(injectedPsi);
                            if (!(document instanceof DocumentWindow)) {
                                return;
                            }
                            for (TodoItem item : helper.findTodoItems(injectedPsi)) {
                                TextRange rangeInHost = ((DocumentWindow)document).injectedToHost(item.getTextRange());
                                List additionalRanges = ContainerUtil.map((Collection)item.getAdditionalTextRanges(), arg_0 -> ((DocumentWindow)((DocumentWindow)document)).injectedToHost(arg_0));
                                TodoItemImpl hostItem = new TodoItemImpl(psiFile, rangeInHost.getStartOffset(), rangeInHost.getEndOffset(), item.getPattern(), additionalRanges);
                                todoItems.add(hostItem);
                            }
                        }
                    });
                }
                super.visitElement(element);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "element", "com/intellij/ide/todo/nodes/TodoFileNode$1", "visitElement"));
            }
        });
        List<TodoItem> list2 = Collections.unmodifiableList(todoItems);
        if (list2 == null) {
            TodoFileNode.$$$reportNull$$$0(6);
        }
        return list2;
    }

    private TodoFilter getToDoFilter() {
        return this.myBuilder.getTodoTreeStructure().getTodoFilter();
    }

    public boolean isAlwaysShowPlus() {
        return !this.mySingleFileMode;
    }

    protected void updateImpl(@NotNull PresentationData data) {
        int todoItemCount;
        if (data == null) {
            TodoFileNode.$$$reportNull$$$0(7);
        }
        super.updateImpl(data);
        String newName = this.myBuilder.getTodoTreeStructure().isPackagesShown() ? ((PsiFile)this.getValue()).getName() : (this.mySingleFileMode ? ((PsiFile)this.getValue()).getName() : ((PsiFile)this.getValue()).getVirtualFile().getPresentableUrl());
        data.setPresentableText(newName);
        try {
            todoItemCount = this.myBuilder.getTodoTreeStructure().getTodoItemCount((PsiFile)this.getValue());
        }
        catch (IndexNotReadyException e) {
            return;
        }
        if (todoItemCount > 0) {
            data.setLocationString(IdeBundle.message((String)"node.todo.items", (Object[])new Object[]{todoItemCount}));
        }
    }

    public int getWeight() {
        return 4;
    }

    private static int getOffset(@NotNull TodoItemNode node) {
        if (node == null) {
            TodoFileNode.$$$reportNull$$$0(8);
        }
        return Objects.requireNonNull((SmartTodoItemPointer)node.getValue()).getTodoItem().getTextRange().getStartOffset();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 6 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/ide/todo/nodes/TodoFileNode";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiFile";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "helper";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "data";
                break;
            }
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/ide/todo/nodes/TodoFileNode";
                break;
            }
            case 1: 
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getChildrenImpl";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "findAllTodos";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: {
                break;
            }
            case 4: 
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "findAllTodos";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "updateImpl";
                break;
            }
            case 8: {
                objectArray = objectArray;
                objectArray[2] = "getOffset";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 6 -> new IllegalStateException(string);
        };
    }
}

