/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector;

import com.intellij.ide.IdeEventQueue;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.MouseShortcut;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.WriteIntentReadAction;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManagerListener;
import com.intellij.openapi.keymap.ex.KeymapManagerEx;
import com.intellij.openapi.keymap.impl.KeymapManagerImpl;
import com.intellij.openapi.keymap.impl.ui.MouseShortcutPanel;
import com.intellij.openapi.project.DumbAwareAction;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.wm.IdeFocusManager;
import com.intellij.util.ui.UIUtil;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.event.InputEvent;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b'\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0006\u0010\u000f\u001a\u00020\u0010J\u000e\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u000e\u0010\u0015\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014J\u001a\u0010\u0016\u001a\u00020\u00122\u0006\u0010\u0017\u001a\u00020\u00182\b\u0010\r\u001a\u0004\u0018\u00010\u0019H$J\b\u0010\u001a\u001a\u00020\u0012H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001b"}, d2={"Lcom/intellij/internal/inspector/UiMouseAction;", "Lcom/intellij/openapi/project/DumbAwareAction;", "uiActionId", "", "<init>", "(Ljava/lang/String;)V", "getUiActionId", "()Ljava/lang/String;", "myMouseShortcuts", "", "Lcom/intellij/openapi/actionSystem/MouseShortcut;", "handleEvent", "", "event", "Ljava/awt/AWTEvent;", "getActionUpdateThread", "Lcom/intellij/openapi/actionSystem/ActionUpdateThread;", "update", "", "e", "Lcom/intellij/openapi/actionSystem/AnActionEvent;", "actionPerformed", "handleClick", "component", "Ljava/awt/Component;", "Ljava/awt/event/MouseEvent;", "updateMouseShortcuts", "intellij.platform.ide.ui.inspector"})
@ApiStatus.Internal
@SourceDebugExtension(value={"SMAP\nUiMouseAction.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiMouseAction.kt\ncom/intellij/internal/inspector/UiMouseAction\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n*L\n1#1,100:1\n4225#2,11:101\n*S KotlinDebug\n*F\n+ 1 UiMouseAction.kt\ncom/intellij/internal/inspector/UiMouseAction\n*L\n97#1:101,11\n*E\n"})
public abstract class UiMouseAction
extends DumbAwareAction {
    @NotNull
    private final String uiActionId;
    @NotNull
    private final List<MouseShortcut> myMouseShortcuts;

    public UiMouseAction(@NotNull String uiActionId) {
        Intrinsics.checkNotNullParameter((Object)uiActionId, (String)"uiActionId");
        this.uiActionId = uiActionId;
        this.myMouseShortcuts = new ArrayList();
        this.setEnabledInModalContext(true);
        this.updateMouseShortcuts();
        KeymapManagerEx.getInstanceEx().addWeakListener(new KeymapManagerListener(){

            public void activeKeymapChanged(Keymap keymap) {
                this.updateMouseShortcuts();
            }

            public void shortcutsChanged(Keymap keymap, Collection<String> actionIds, boolean fromSettings) {
                Intrinsics.checkNotNullParameter((Object)keymap, (String)"keymap");
                Intrinsics.checkNotNullParameter(actionIds, (String)"actionIds");
                if (actionIds.contains(this.getUiActionId())) {
                    this.updateMouseShortcuts();
                }
            }
        });
        IdeEventQueue.Companion.getInstance().addDispatcher(new IdeEventQueue.NonLockedEventDispatcher(){

            public boolean dispatch(AWTEvent e) {
                Intrinsics.checkNotNullParameter((Object)e, (String)"e");
                return this.handleEvent(e);
            }
        }, (Disposable)ApplicationManager.getApplication());
    }

    @NotNull
    public final String getUiActionId() {
        return this.uiActionId;
    }

    private final boolean handleEvent(AWTEvent event) {
        if (event instanceof MouseEvent && ((MouseEvent)event).getClickCount() > 0 && !this.myMouseShortcuts.isEmpty()) {
            if (((MouseEvent)event).getComponent() instanceof MouseShortcutPanel) {
                return false;
            }
            MouseShortcut mouseShortcut = new MouseShortcut(((MouseEvent)event).getButton(), ((MouseEvent)event).getModifiersEx(), ((MouseEvent)event).getClickCount());
            if (this.myMouseShortcuts.contains(mouseShortcut)) {
                if (((MouseEvent)event).getID() == 501) {
                    Component component = UIUtil.getDeepestComponentAt((Component)((MouseEvent)event).getComponent(), (int)((MouseEvent)event).getX(), (int)((MouseEvent)event).getY());
                    if (component == null) {
                        component = ((MouseEvent)event).getComponent();
                    }
                    Component component2 = component;
                    WriteIntentReadAction.run(() -> UiMouseAction.handleEvent$lambda$0(this, component2, event));
                }
                return true;
            }
        }
        return false;
    }

    @NotNull
    public final ActionUpdateThread getActionUpdateThread() {
        return ActionUpdateThread.BGT;
    }

    public final void update(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
    }

    public final void actionPerformed(@NotNull AnActionEvent e) {
        Intrinsics.checkNotNullParameter((Object)e, (String)"e");
        InputEvent event = e.getInputEvent();
        if (event instanceof MouseEvent) {
            Component component = UIUtil.getDeepestComponentAt((Component)((MouseEvent)event).getComponent(), (int)((MouseEvent)event).getX(), (int)((MouseEvent)event).getY());
            if (component == null) {
                component = ((MouseEvent)event).getComponent();
            }
            Component component2 = component;
            Intrinsics.checkNotNull((Object)component2);
            this.handleClick(component2, (MouseEvent)event);
        } else {
            Component component = (Component)e.getData(PlatformCoreDataKeys.CONTEXT_COMPONENT);
            if (component == null && (component = IdeFocusManager.getInstance((Project)e.getProject()).getFocusOwner()) == null) {
                return;
            }
            Component component3 = component;
            this.handleClick(component3, null);
        }
    }

    protected abstract void handleClick(@NotNull Component var1, @Nullable MouseEvent var2);

    /*
     * WARNING - void declaration
     */
    private final void updateMouseShortcuts() {
        if (KeymapManagerImpl.Companion.isKeymapManagerInitialized() && ApplicationManager.getApplication().isInternal()) {
            void $this$filterIsInstanceTo$iv$iv;
            Keymap keymap = KeymapManagerEx.getInstanceEx().getActiveKeymap();
            Intrinsics.checkNotNullExpressionValue((Object)keymap, (String)"getActiveKeymap(...)");
            Keymap keymap2 = keymap;
            this.myMouseShortcuts.clear();
            Collection collection = this.myMouseShortcuts;
            Shortcut[] shortcutArray = keymap2.getShortcuts(this.uiActionId);
            Intrinsics.checkNotNullExpressionValue((Object)shortcutArray, (String)"getShortcuts(...)");
            Object[] $this$filterIsInstance$iv = shortcutArray;
            boolean $i$f$filterIsInstance = false;
            Object[] objectArray = $this$filterIsInstance$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterIsInstanceTo = false;
            for (void element$iv$iv : $this$filterIsInstanceTo$iv$iv) {
                if (!(element$iv$iv instanceof MouseShortcut)) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Iterable iterable = (List)destination$iv$iv;
            CollectionsKt.addAll((Collection)collection, (Iterable)iterable);
        }
    }

    private static final void handleEvent$lambda$0(UiMouseAction this$0, Component $component, AWTEvent $event) {
        Intrinsics.checkNotNull((Object)$component);
        this$0.handleClick($component, (MouseEvent)$event);
    }
}

