/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector.accessibilityAudit;

import com.intellij.internal.inspector.accessibilityAudit.Severity;
import com.intellij.internal.inspector.accessibilityAudit.UiInspectorAccessibilityInspection;
import com.intellij.ui.SimpleColoredComponent;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JLabel;
import kotlin.Metadata;
import kotlin.Triple;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0012\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u0016R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\u0010"}, d2={"Lcom/intellij/internal/inspector/accessibilityAudit/ComponentWithIconHasNonDefaultAccessibleNameInspection;", "Lcom/intellij/internal/inspector/accessibilityAudit/UiInspectorAccessibilityInspection;", "<init>", "()V", "propertyName", "", "getPropertyName", "()Ljava/lang/String;", "severity", "Lcom/intellij/internal/inspector/accessibilityAudit/Severity;", "getSeverity", "()Lcom/intellij/internal/inspector/accessibilityAudit/Severity;", "passesInspection", "", "accessible", "Ljavax/accessibility/Accessible;", "intellij.platform.ide.ui.inspector"})
@ApiStatus.Internal
@ApiStatus.Experimental
public final class ComponentWithIconHasNonDefaultAccessibleNameInspection
implements UiInspectorAccessibilityInspection {
    @NotNull
    private final String propertyName;
    @NotNull
    private final Severity severity = Severity.RECOMMENDATION;

    public ComponentWithIconHasNonDefaultAccessibleNameInspection() {
        this.propertyName = "AccessibleName";
    }

    @Override
    @NotNull
    public String getPropertyName() {
        return this.propertyName;
    }

    @Override
    @NotNull
    public Severity getSeverity() {
        return this.severity;
    }

    @Override
    public boolean passesInspection(@Nullable Accessible accessible) {
        CharSequence charSequence;
        Triple triple;
        Accessible accessible2 = accessible;
        if (accessible2 instanceof JLabel) {
            AccessibleContext accessibleContext = ((JLabel)accessible).getAccessibleContext();
            triple = new Triple((Object)((JLabel)accessible).getIcon(), (Object)((JLabel)accessible).getText(), (Object)(accessibleContext != null ? accessibleContext.getAccessibleName() : null));
        } else if (accessible2 instanceof SimpleColoredComponent) {
            AccessibleContext accessibleContext = ((SimpleColoredComponent)accessible).getAccessibleContext();
            triple = new Triple((Object)((SimpleColoredComponent)accessible).getIcon(), (Object)((SimpleColoredComponent)accessible).toString(), (Object)(accessibleContext != null ? accessibleContext.getAccessibleName() : null));
        } else {
            return true;
        }
        Triple triple2 = triple;
        Icon icon = (Icon)triple2.component1();
        String text2 = (String)triple2.component2();
        String accessibleName = (String)triple2.component3();
        if (icon == null || icon.getIconWidth() == 0 || icon.getIconHeight() == 0 || (charSequence = (CharSequence)text2) == null || charSequence.length() == 0 || accessibleName == null) {
            return true;
        }
        return !Intrinsics.areEqual((Object)accessibleName, (Object)text2);
    }
}

