/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector.components;

import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.internal.inspector.components.HierarchyTree;
import com.intellij.ui.components.breadcrumbs.Breadcrumbs;
import com.intellij.ui.components.breadcrumbs.Crumb;
import com.intellij.ui.scale.JBUIScale;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Rectangle;
import java.util.List;
import java.util.function.Consumer;
import javax.swing.Icon;
import javax.swing.Scrollable;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

final class ComponentsNavBarPanel
extends Breadcrumbs
implements Scrollable {
    private boolean isAccessibleEnabled;

    ComponentsNavBarPanel(@NotNull Component selectedComponent, @NotNull Consumer<? super Component> selectionHandler) {
        if (selectedComponent == null) {
            ComponentsNavBarPanel.$$$reportNull$$$0(0);
        }
        if (selectionHandler == null) {
            ComponentsNavBarPanel.$$$reportNull$$$0(1);
        }
        this.isAccessibleEnabled = false;
        this.rebuild(selectedComponent);
        this.onSelect((crumb, event) -> {
            if (crumb != null) {
                ComponentItem item = (ComponentItem)crumb;
                selectionHandler.accept(item.myComponent);
            }
        });
        SwingUtilities.invokeLater(() -> this.scrollToLastItem());
    }

    @Override
    public Dimension getPreferredScrollableViewportSize() {
        Dimension preferredSize = this.getPreferredSize();
        return new Dimension(JBUIScale.scale((int)300), preferredSize.height);
    }

    @Override
    public int getScrollableUnitIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 1;
    }

    @Override
    public int getScrollableBlockIncrement(Rectangle visibleRect, int orientation, int direction) {
        return 50;
    }

    @Override
    public boolean getScrollableTracksViewportWidth() {
        return false;
    }

    @Override
    public boolean getScrollableTracksViewportHeight() {
        return true;
    }

    public void setSelectedComponent(@NotNull Component component) {
        if (component == null) {
            ComponentsNavBarPanel.$$$reportNull$$$0(2);
        }
        this.rebuild(component);
        this.revalidate();
        this.repaint();
        SwingUtilities.invokeLater(() -> this.scrollToLastItem());
    }

    private void rebuild(@NotNull Component component) {
        if (component == null) {
            ComponentsNavBarPanel.$$$reportNull$$$0(3);
        }
        JBIterable components = UIUtil.uiParents((Component)component, (boolean)false);
        List items = ContainerUtil.reverse((List)ContainerUtil.map((Iterable)components, c -> new ComponentItem((Component)c)));
        this.setCrumbs(items);
    }

    private void scrollToLastItem() {
        JBIterable crumbs = JBIterable.from((Iterable)this.getCrumbs());
        Crumb last = (Crumb)crumbs.last();
        if (last != null) {
            this.scrollRectToVisible(this.getCrumbBounds(last));
        }
    }

    public void setAccessibleEnabled(boolean accessibleEnabled) {
        this.isAccessibleEnabled = accessibleEnabled;
    }

    protected Color getBackground(Crumb crumb) {
        return this.isHovered(crumb) ? JBUI.CurrentTheme.StatusBar.Breadcrumbs.HOVER_BACKGROUND : this.getBackground();
    }

    public Font getFont() {
        Font font = super.getFont();
        return font != null ? font.deriveFont(13.0f) : null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectedComponent";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "selectionHandler";
                break;
            }
            case 2: 
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/inspector/components/ComponentsNavBarPanel";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "setSelectedComponent";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "rebuild";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private final class ComponentItem
    implements Crumb {
        @NotNull
        private final Component myComponent;

        ComponentItem(Component component) {
            if (component == null) {
                ComponentItem.$$$reportNull$$$0(0);
            }
            this.myComponent = component;
        }

        public Icon getIcon() {
            return HierarchyTree.Icons.findIconFor(this.myComponent);
        }

        @Nls
        public String getText() {
            Object obj2 = ComponentsNavBarPanel.this.isAccessibleEnabled ? this.myComponent.getAccessibleContext() : this.myComponent;
            return UiInspectorUtil.getClassPresentation((Object)obj2);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "component", "com/intellij/internal/inspector/components/ComponentsNavBarPanel$ComponentItem", "<init>"));
        }
    }
}

