/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector.components;

import com.intellij.ide.DataManager;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.internal.inspector.components.ContextData;
import com.intellij.internal.inspector.components.DataContextDialogKt;
import com.intellij.internal.inspector.components.Header;
import com.intellij.internal.inspector.components.MyTableCellRenderer;
import com.intellij.openapi.actionSystem.CustomizedDataContext;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.PlatformCoreDataKeys;
import com.intellij.openapi.actionSystem.impl.Utils;
import com.intellij.openapi.application.AccessToken;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ScreenUtil;
import com.intellij.ui.TableSpeedSearch;
import com.intellij.ui.components.JBCheckBox;
import com.intellij.ui.dsl.builder.Align;
import com.intellij.ui.dsl.builder.BuilderKt;
import com.intellij.ui.dsl.builder.ButtonKt;
import com.intellij.ui.dsl.builder.Cell;
import com.intellij.ui.dsl.builder.Panel;
import com.intellij.ui.dsl.builder.Row;
import com.intellij.ui.table.JBTable;
import com.intellij.util.SlowOperations;
import java.awt.Component;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin._Assertions;
import kotlin.collections.CollectionsKt;
import kotlin.jdk7.AutoCloseableKt;
import kotlin.jvm.JvmField;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000l\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0010\u0000\n\u0002\b\u0003\b\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\b\u0010\r\u001a\u00020\u000eH\u0014J\u0013\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00110\u0010H\u0014\u00a2\u0006\u0002\u0010\u0012J\n\u0010\u0013\u001a\u0004\u0018\u00010\u0014H\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0002J\b\u0010\u0019\u001a\u00020\u001aH\u0002J\u001c\u0010\u001b\u001a\u00020\u0016*\u00020\u001a2\u0006\u0010\u001c\u001a\u00020\u00062\u0006\u0010\u001d\u001a\u00020\u001eH\u0002J\u0014\u0010\u001f\u001a\u00020\u0016*\u00020\u001a2\u0006\u0010 \u001a\u00020!H\u0002J\f\u0010\"\u001a\u00020\u0016*\u00020\u001aH\u0002J*\u0010#\u001a\b\u0012\u0004\u0012\u00020!0\u00052\u0006\u0010\u001c\u001a\u00020\u00062\u0012\u0010$\u001a\u000e\u0012\u0004\u0012\u00020\u000e\u0012\u0004\u0012\u00020&0%H\u0002J\u0010\u0010'\u001a\u00020\u000e2\u0006\u0010(\u001a\u00020&H\u0002R\u0016\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00058\u0006X\u0087\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/internal/inspector/components/DataContextDialog;", "Lcom/intellij/openapi/ui/DialogWrapper;", "project", "Lcom/intellij/openapi/project/Project;", "componentList", "", "Ljava/awt/Component;", "<init>", "(Lcom/intellij/openapi/project/Project;Ljava/util/List;)V", "showLazyValues", "", "showBGTData", "showFQNs", "getDimensionServiceKey", "", "createActions", "", "Ljavax/swing/Action;", "()[Ljavax/swing/Action;", "createCenterPanel", "Ljavax/swing/JComponent;", "rebuild", "", "table", "Lcom/intellij/ui/table/JBTable;", "buildTreeModel", "Ljavax/swing/table/DefaultTableModel;", "appendHeader", "component", "index", "", "appendRow", "data", "Lcom/intellij/internal/inspector/components/ContextData;", "appendEmptyRow", "collectDataFrom", "childDataMap", "", "", "getClassPresentationOrFQN", "value", "intellij.platform.ide.ui.inspector"})
@SourceDebugExtension(value={"SMAP\nDataContextDialog.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DataContextDialog.kt\ncom/intellij/internal/inspector/components/DataContextDialog\n+ 2 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,276:1\n126#2:277\n153#2,3:278\n*S KotlinDebug\n*F\n+ 1 DataContextDialog.kt\ncom/intellij/internal/inspector/components/DataContextDialog\n*L\n157#1:277\n157#1:278,3\n*E\n"})
public final class DataContextDialog
extends DialogWrapper {
    @JvmField
    @NotNull
    public final List<Component> componentList;
    private boolean showLazyValues;
    private boolean showBGTData;
    private boolean showFQNs;

    public DataContextDialog(@Nullable Project project, @NotNull List<? extends Component> componentList) {
        Intrinsics.checkNotNullParameter(componentList, (String)"componentList");
        super(project, false, DialogWrapper.IdeModalityType.MODELESS);
        this.componentList = componentList;
        Component component = (Component)CollectionsKt.firstOrNull(this.componentList);
        if (component == null) {
            throw new IllegalStateException("No component".toString());
        }
        Component component2 = component;
        this.setTitle(UiInspectorUtil.getComponentName((Component)component2) + " DataContext");
        this.init();
    }

    @NotNull
    protected String getDimensionServiceKey() {
        return "UiInternal.DataContextDialog";
    }

    @NotNull
    protected Action[] createActions() {
        Action[] actionArray = new Action[1];
        Intrinsics.checkNotNullExpressionValue((Object)this.getCancelAction(), (String)"getCancelAction(...)");
        return actionArray;
    }

    @Nullable
    protected JComponent createCenterPanel() {
        JBTable table = new JBTable();
        table.setDefaultRenderer(Object.class, (TableCellRenderer)((Object)new MyTableCellRenderer()));
        this.rebuild(table);
        TableSpeedSearch.installOn((JTable)((JTable)table));
        DialogPanel panel2 = BuilderKt.panel(arg_0 -> DataContextDialog.createCenterPanel$lambda$0(this, table, arg_0));
        Rectangle rectangle = ScreenUtil.getMainScreenBounds();
        Intrinsics.checkNotNullExpressionValue((Object)rectangle, (String)"getMainScreenBounds(...)");
        Rectangle screenBounds = rectangle;
        int width = (int)((double)screenBounds.width * 0.8);
        int height = (int)((double)screenBounds.height * 0.8);
        return (JComponent)panel2.withPreferredSize(width, height);
    }

    private final void rebuild(JBTable table) {
        table.setModel((TableModel)this.buildTreeModel());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final DefaultTableModel buildTreeModel() {
        DefaultTableModel model2 = new DefaultTableModel(){

            public boolean isCellEditable(int row, int column) {
                return false;
            }
        };
        model2.addColumn("Key");
        model2.addColumn("Value");
        model2.addColumn("Value type");
        int index = 0;
        Component prev = null;
        Map childDataMap = new LinkedHashMap();
        for (Component c : this.componentList) {
            List<ContextData> list2;
            Iterator<ContextData> iterator;
            boolean bl;
            Component component = prev;
            boolean bl2 = bl = (component != null ? component.getParent() : null) == null || prev.getParent() == c;
            if (_Assertions.ENABLED && !bl) {
                iterator = "Assertion failed";
                throw new AssertionError(iterator);
            }
            iterator = (AutoCloseable)SlowOperations.startSection((String)"action.perform");
            Throwable throwable = null;
            try {
                AccessToken it = (AccessToken)iterator;
                boolean bl3 = false;
                list2 = this.collectDataFrom(c, childDataMap);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
            finally {
                AutoCloseableKt.closeFinally((AutoCloseable)((Object)iterator), (Throwable)throwable);
            }
            List<ContextData> result2 = list2;
            if (!((Collection)result2).isEmpty()) {
                if (model2.getRowCount() > 0) {
                    this.appendEmptyRow(model2);
                }
                this.appendHeader(model2, c, ++index);
                for (ContextData data : result2) {
                    this.appendRow(model2, data);
                }
            }
            prev = c;
        }
        return model2;
    }

    private final void appendHeader(DefaultTableModel $this$appendHeader, Component component, int index) {
        Object[] objectArray = new Object[]{new Header(index + ". " + UiInspectorUtil.getComponentName((Component)component)), null, this.getClassPresentationOrFQN(component)};
        $this$appendHeader.addRow(objectArray);
    }

    private final void appendRow(DefaultTableModel $this$appendRow, ContextData data) {
        Object[] objectArray = new String[]{DataContextDialogKt.access$getKeyPresentation(data.getKey(), data.getOverridden()), data.getValueStr(), data.getValueClass()};
        $this$appendRow.addRow(objectArray);
    }

    private final void appendEmptyRow(DefaultTableModel $this$appendEmptyRow) {
        Object[] objectArray = new String[]{"", "", ""};
        $this$appendEmptyRow.addRow(objectArray);
    }

    /*
     * WARNING - void declaration
     */
    private final List<ContextData> collectDataFrom(Component component, Map<String, Object> childDataMap) {
        DataContext dataContext;
        DataContext dataContext2;
        DataManager dataManager = DataManager.getInstance();
        DataContext it = dataManager.getDataContext(component);
        boolean bl = false;
        if (this.showBGTData) {
            dataContext2 = it;
        } else {
            Intrinsics.checkNotNull((Object)it);
            dataContext2 = Utils.getUiOnlyDataContext((DataContext)it);
        }
        Intrinsics.checkNotNullExpressionValue((Object)dataContext2, (String)"let(...)");
        DataContext context = dataContext2;
        DataContext it2 = dataManager.getDataContext(component.getParent());
        boolean bl2 = false;
        if (this.showBGTData) {
            dataContext = it2;
        } else {
            Intrinsics.checkNotNull((Object)it2);
            dataContext = Utils.getUiOnlyDataContext((DataContext)it2);
        }
        Intrinsics.checkNotNullExpressionValue((Object)dataContext, (String)"let(...)");
        DataContext parentContext = dataContext;
        List result2 = new ArrayList();
        for (DataKey key : DataKey.Companion.allKeys()) {
            Object parentData;
            boolean specialKey = DataContextDialogKt.access$isSpecialContextComponentOnlyKey(key);
            if (specialKey && component != CollectionsKt.first(this.componentList)) continue;
            Object data = context.getData(key);
            Object object = parentData = specialKey ? null : parentContext.getData(key);
            if (DataContextDialogKt.access$equalData(data, parentData, 0, null)) continue;
            Object childData = childDataMap.get(key.getName());
            Collection collection = result2;
            String string = key.getName();
            Object object2 = data;
            if (object2 == null) {
                object2 = CustomizedDataContext.EXPLICIT_NULL;
            }
            Object object3 = object2;
            Intrinsics.checkNotNull((Object)object3);
            String string2 = DataContextDialogKt.access$getValuePresentation(object3);
            Object object4 = data;
            if (object4 == null) {
                object4 = CustomizedDataContext.EXPLICIT_NULL;
            }
            object3 = object4;
            Intrinsics.checkNotNull((Object)object3);
            collection.add(new ContextData(string, string2, this.getClassPresentationOrFQN(object3), childData != null && !DataContextDialogKt.access$equalData(data, childData, 0, null)));
            if (this.showLazyValues && data instanceof DataManagerImpl.KeyedDataProvider) {
                void $this$mapTo$iv$iv;
                collection = result2;
                Map $this$map$iv = ((DataManagerImpl.KeyedDataProvider)data).getMap();
                boolean $i$f$map = false;
                Map map = $this$map$iv;
                Collection destination$iv$iv = new ArrayList($this$map$iv.size());
                boolean $i$f$mapTo = false;
                Iterator iterator = $this$mapTo$iv$iv.entrySet().iterator();
                while (iterator.hasNext()) {
                    Map.Entry item$iv$iv;
                    Map.Entry entry = item$iv$iv = iterator.next();
                    Collection collection2 = destination$iv$iv;
                    boolean bl3 = false;
                    String k = (String)entry.getKey();
                    DataProvider v = (DataProvider)entry.getValue();
                    collection2.add(new ContextData(key.getName() + " - " + k, DataContextDialogKt.access$getValuePresentation(v), this.getClassPresentationOrFQN(v), false));
                }
                object3 = (List)destination$iv$iv;
                CollectionsKt.addAll((Collection)collection, (Iterable)object3);
            }
            if (data == null || Intrinsics.areEqual((Object)key, (Object)PlatformCoreDataKeys.BGT_DATA_PROVIDER)) continue;
            childDataMap.put(key.getName(), data);
        }
        Comparator<Object> comparator = Comparator.comparing(arg_0 -> DataContextDialog.collectDataFrom$lambda$4(DataContextDialog::collectDataFrom$lambda$3, arg_0));
        Intrinsics.checkNotNullExpressionValue(comparator, (String)"comparing(...)");
        CollectionsKt.sortWith((List)result2, comparator);
        return result2;
    }

    private final String getClassPresentationOrFQN(Object value) {
        String string;
        if (this.showFQNs) {
            string = value.getClass().getName();
            if (string == null) {
                string = "null";
            }
        } else {
            string = DataContextDialogKt.access$getClassPresentation(value);
        }
        return string;
    }

    private static final Unit createCenterPanel$lambda$0(DataContextDialog this$0, JBTable $table, Panel $this$panel) {
        Intrinsics.checkNotNullParameter((Object)$this$panel, (String)"$this$panel");
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DataContextDialog.createCenterPanel$lambda$0$0(this$0, $table, arg_0), (int)1, null);
        Panel.row$default((Panel)$this$panel, null, arg_0 -> DataContextDialog.createCenterPanel$lambda$0$1($table, arg_0), (int)1, null).resizableRow();
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0(DataContextDialog this$0, JBTable $table, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        ButtonKt.actionListener((Cell)$this$row.checkBox("Show BGT Data"), (arg_0, arg_1) -> DataContextDialog.createCenterPanel$lambda$0$0$0(this$0, $table, arg_0, arg_1));
        ButtonKt.actionListener((Cell)$this$row.checkBox("Show lazy keys"), (arg_0, arg_1) -> DataContextDialog.createCenterPanel$lambda$0$0$1(this$0, $table, arg_0, arg_1));
        ButtonKt.actionListener((Cell)$this$row.checkBox("Show raw FQNs"), (arg_0, arg_1) -> DataContextDialog.createCenterPanel$lambda$0$0$2(this$0, $table, arg_0, arg_1));
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0$0(DataContextDialog this$0, JBTable $table, ActionEvent actionEvent, JBCheckBox component) {
        Intrinsics.checkNotNullParameter((Object)actionEvent, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this$0.showBGTData = component.isSelected();
        this$0.rebuild($table);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0$1(DataContextDialog this$0, JBTable $table, ActionEvent actionEvent, JBCheckBox component) {
        Intrinsics.checkNotNullParameter((Object)actionEvent, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this$0.showLazyValues = component.isSelected();
        this$0.rebuild($table);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$0$2(DataContextDialog this$0, JBTable $table, ActionEvent actionEvent, JBCheckBox component) {
        Intrinsics.checkNotNullParameter((Object)actionEvent, (String)"<unused var>");
        Intrinsics.checkNotNullParameter((Object)component, (String)"component");
        this$0.showFQNs = component.isSelected();
        this$0.rebuild($table);
        return Unit.INSTANCE;
    }

    private static final Unit createCenterPanel$lambda$0$1(JBTable $table, Row $this$row) {
        Intrinsics.checkNotNullParameter((Object)$this$row, (String)"$this$row");
        $this$row.scrollCell((JComponent)$table).align(Align.FILL).resizableColumn();
        return Unit.INSTANCE;
    }

    private static final String collectDataFrom$lambda$3(ContextData it) {
        return StringUtil.toUpperCase((String)it.getKey());
    }

    private static final String collectDataFrom$lambda$4(Function1 $tmp0, Object p0) {
        return (String)$tmp0.invoke(p0);
    }
}

