/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector.components;

import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.DataManagerImpl;
import com.intellij.internal.InternalActionsBundle;
import com.intellij.internal.inspector.PropertyBean;
import com.intellij.internal.inspector.UiInspectorAction;
import com.intellij.internal.inspector.UiInspectorCustomComponentChildProvider;
import com.intellij.internal.inspector.UiInspectorCustomComponentProvider;
import com.intellij.internal.inspector.UiInspectorUtil;
import com.intellij.internal.inspector.accessibilityAudit.AccessibilityAuditManager;
import com.intellij.internal.inspector.accessibilityAudit.SeverityCount;
import com.intellij.internal.inspector.accessibilityAudit.UiInspectorAccessibilityInspection;
import com.intellij.internal.inspector.components.InspectorWindow;
import com.intellij.internal.inspector.components.ValueCellRenderer;
import com.intellij.openapi.actionSystem.DataProvider;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.ui.DialogPanel;
import com.intellij.openapi.util.IconLoader;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ScalableIcon;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.ui.ClientProperty;
import com.intellij.ui.ColoredTreeCellRenderer;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.JBColor;
import com.intellij.ui.RowIcon;
import com.intellij.ui.SimpleColoredComponent;
import com.intellij.ui.SimpleTextAttributes;
import com.intellij.ui.TreeUIHelper;
import com.intellij.ui.speedSearch.SpeedSearchUtil;
import com.intellij.util.IconUtil;
import com.intellij.util.ObjectUtils;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.ui.GraphicsUtil;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.PlatformColors;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.lang.reflect.Field;
import java.lang.reflect.InaccessibleObjectException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.accessibility.Accessible;
import javax.accessibility.AccessibleContext;
import javax.swing.Icon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JEditorPane;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JProgressBar;
import javax.swing.JRadioButton;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JSeparator;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JTextPane;
import javax.swing.JToolBar;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.ToolTipManager;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public abstract class HierarchyTree
extends JTree
implements TreeSelectionListener {
    private static final int MAX_DEEPNESS_TO_DISCOVER_FIELD_NAME = 8;

    HierarchyTree(Component c) {
        this.setCellRenderer((TreeCellRenderer)((Object)new ComponentTreeCellRenderer(c)));
        this.setModel(HierarchyTree.buildModel(c));
        this.getSelectionModel().addTreeSelectionListener(this);
        TreeUIHelper.getInstance().installTreeSpeedSearch((JTree)this);
        if (c instanceof JComponent && ClientProperty.get((Component)c, UiInspectorAction.CLICK_INFO) != null) {
            SwingUtilities.invokeLater(() -> this.getSelectionModel().setSelectionPath(this.getPathForRow(this.getLeadSelectionRow() + 1)));
        }
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    private static TreeModel buildModel(Component c) {
        return HierarchyTree.buildModel(c, false);
    }

    private static TreeModel buildModel(Component c, boolean accessibleModel) {
        Accessible axComponent;
        Component parent = null;
        if (accessibleModel && c instanceof Accessible) {
            axComponent = c.getAccessibleContext().getAccessibleParent();
            if (axComponent instanceof Component) {
                parent = (Component)((Object)axComponent);
            }
        } else {
            parent = c.getParent();
        }
        while (parent != null) {
            c = parent;
            if (accessibleModel && c instanceof Accessible) {
                axComponent = c.getAccessibleContext().getAccessibleParent();
                if (axComponent instanceof Component) {
                    parent = (Component)((Object)axComponent);
                    continue;
                }
                parent = null;
                continue;
            }
            parent = c.getParent();
        }
        return new DefaultTreeModel(ComponentNode.createComponentNode(c, accessibleModel));
    }

    public void resetModel(Component c, boolean accessibleModel) {
        this.setModel(HierarchyTree.buildModel(c, accessibleModel));
    }

    public void selectPath(@NotNull Component component) {
        if (component == null) {
            HierarchyTree.$$$reportNull$$$0(0);
        }
        this.selectPath(component, false);
    }

    public void selectPath(@NotNull Component component, @Nullable MouseEvent event) {
        if (component == null) {
            HierarchyTree.$$$reportNull$$$0(1);
        }
        if (event == null || !(component instanceof JComponent) || ((JComponent)component).getClientProperty("UiInspectorCustomComponentProvider") == null) {
            this.selectPath(component);
            return;
        }
        int count = this.getRowCount();
        for (int i = 0; i < count; ++i) {
            TreePath row = this.getPathForRow(i);
            Object last = row.getLastPathComponent();
            if (!(last instanceof ComponentNode)) continue;
            ComponentNode node = (ComponentNode)last;
            if (node.myComponent != component) continue;
            TreePath path = HierarchyTree.findNode(node, SwingUtilities.convertPoint(event.getComponent(), event.getPoint(), component));
            this.setSelectionPath(path == null ? row : path);
            this.scrollPathToVisible(this.getSelectionPath());
            return;
        }
    }

    @Nullable
    private static TreePath findNode(@NotNull ComponentNode node, @NotNull Point location) {
        if (node == null) {
            HierarchyTree.$$$reportNull$$$0(2);
        }
        if (location == null) {
            HierarchyTree.$$$reportNull$$$0(3);
        }
        int count = node.getChildCount();
        for (int i = 0; i < count; ++i) {
            ComponentNode childNode = (ComponentNode)node.getChildAt(i);
            TreePath result2 = HierarchyTree.findNode(childNode, location);
            if (result2 != null) {
                return result2;
            }
            UiInspectorCustomComponentChildProvider childProvider = (UiInspectorCustomComponentChildProvider)childNode.getUserObject();
            Rectangle bounds = childProvider.getHighlightingBounds();
            if (bounds == null || !bounds.contains(location)) continue;
            return new TreePath(childNode.getPath());
        }
        return null;
    }

    public void selectPath(@NotNull Component component, boolean isAccessibleTree) {
        if (component == null) {
            HierarchyTree.$$$reportNull$$$0(4);
        }
        int count = this.getRowCount();
        for (int i = 0; i < count; ++i) {
            TreePath row = this.getPathForRow(i);
            Object last = row.getLastPathComponent();
            if (!(last instanceof ComponentNode)) continue;
            ComponentNode node = (ComponentNode)last;
            if ((!isAccessibleTree || node.myAccessible != component) && (isAccessibleTree || node.myComponent != component)) continue;
            this.setSelectionPath(row);
            this.scrollPathToVisible(this.getSelectionPath());
            break;
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        ComponentNode node;
        Object object;
        Object[] paths = this.getSelectionPaths();
        if (paths == null) {
            this.onComponentsChanged(Collections.emptyList());
            return;
        }
        List providers = ContainerUtil.mapNotNull((Object[])paths, path -> {
            ComponentNode node;
            Object patt0$temp;
            Object component = path.getLastPathComponent();
            if (component instanceof ComponentNode && (patt0$temp = (node = (ComponentNode)component).getUserObject()) instanceof UiInspectorCustomComponentChildProvider) {
                UiInspectorCustomComponentChildProvider provider = (UiInspectorCustomComponentChildProvider)patt0$temp;
                return provider;
            }
            return null;
        });
        if (!providers.isEmpty()) {
            this.onCustomComponentChanged((UiInspectorCustomComponentChildProvider)providers.get(0));
            return;
        }
        if (paths.length > 0 && (object = ((TreePath)paths[0]).getLastPathComponent()) instanceof ComponentNode && (node = (ComponentNode)object).getComponent() == null && node.getAccessible() != null) {
            this.onAccessibleChanged(node.getAccessible());
            return;
        }
        List clickInfos = ContainerUtil.mapNotNull((Object[])paths, path -> {
            Object node = path.getLastPathComponent();
            if (node instanceof ComponentNode && ((ComponentNode)node).getUserObject() instanceof List) {
                return (List)((ComponentNode)node).getUserObject();
            }
            return null;
        });
        if (!clickInfos.isEmpty()) {
            this.onClickInfoChanged((List)clickInfos.get(0));
            return;
        }
        List components = ContainerUtil.mapNotNull((Object[])paths, path -> {
            Object node = path.getLastPathComponent();
            if (node instanceof ComponentNode) {
                return ((ComponentNode)node).getComponent();
            }
            return null;
        });
        this.onComponentsChanged(components);
    }

    public abstract void onClickInfoChanged(List<? extends PropertyBean> var1);

    public abstract void onComponentsChanged(List<? extends Component> var1);

    public abstract void onCustomComponentChanged(UiInspectorCustomComponentChildProvider var1);

    public abstract void onAccessibleChanged(Accessible var1);

    @Nullable
    private static Pair<Class<?>, String> getClassAndFieldName(Component component) {
        Container parent = component.getParent();
        for (int deepness = 1; parent != null && deepness <= 8; parent = parent.getParent(), ++deepness) {
            HashMap fields = new HashMap();
            for (Class<?> aClass = parent.getClass(); aClass != null; aClass = aClass.getSuperclass()) {
                for (Field field : aClass.getDeclaredFields()) {
                    fields.put(field, aClass);
                }
            }
            for (Map.Entry entry : fields.entrySet()) {
                try {
                    Field field = (Field)entry.getKey();
                    field.setAccessible(true);
                    if (field.get(parent) != component) continue;
                    return Pair.create((Object)((Class)entry.getValue()), (Object)field.getName());
                }
                catch (IllegalAccessException | InaccessibleObjectException exception) {
                }
            }
        }
        return null;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "location";
                break;
            }
        }
        objectArray2[1] = "com/intellij/internal/inspector/components/HierarchyTree";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "selectPath";
                break;
            }
            case 2: 
            case 3: {
                objectArray = objectArray2;
                objectArray2[2] = "findNode";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    private static final class ComponentTreeCellRenderer
    extends ColoredTreeCellRenderer {
        private final Component myInitialSelection;
        private final List<IconWithErrorCount> myAccessibilityAuditIcons = new ArrayList<IconWithErrorCount>();
        private String myToolTipText = "";

        ComponentTreeCellRenderer(Component initialSelection) {
            this.myInitialSelection = initialSelection;
            this.setFont((Font)JBUI.Fonts.label((float)11.0f));
            this.setBorder((Border)JBUI.Borders.empty((int)0, (int)3));
        }

        public void customizeCellRenderer(@NotNull JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            if (tree == null) {
                ComponentTreeCellRenderer.$$$reportNull$$$0(0);
            }
            Color foreground = UIUtil.getTreeForeground((boolean)selected, (boolean)hasFocus);
            Color background = selected ? UIUtil.getTreeSelectionBackground((boolean)hasFocus) : null;
            boolean isRenderer = false;
            this.myAccessibilityAuditIcons.clear();
            this.myToolTipText = "";
            if (value instanceof ComponentNode) {
                ComponentNode componentNode = (ComponentNode)value;
                isRenderer = componentNode.getUserObject() instanceof List || componentNode.getUserObject() instanceof UiInspectorCustomComponentChildProvider;
                Component component = componentNode.getComponent();
                if (component != null && !selected) {
                    if (!component.isVisible()) {
                        foreground = JBColor.GRAY;
                    } else if (component.getWidth() == 0 || component.getHeight() == 0) {
                        foreground = new JBColor(new Color(128, 10, 0), (Color)JBColor.BLUE);
                    } else if (component.getPreferredSize() != null && (component.getSize().width < component.getPreferredSize().width || component.getSize().height < component.getPreferredSize().height)) {
                        foreground = PlatformColors.BLUE;
                    }
                    if (this.myInitialSelection == componentNode.getComponent()) {
                        background = new Color(31, 128, 8, 58);
                    }
                }
                if (componentNode.isAccessibleNode) {
                    AccessibleContext ac = component != null ? component.getAccessibleContext() : componentNode.getAccessible().getAccessibleContext();
                    String simpleName = ac.getClass().getSimpleName();
                    if (StringUtil.isEmpty((String)simpleName)) {
                        this.append(ac.getClass().getName());
                    } else {
                        this.append(simpleName);
                    }
                    String axName = ac.getAccessibleName();
                    if (axName != null) {
                        this.append(" " + axName);
                    }
                } else if (component != null) {
                    this.append(UiInspectorUtil.getComponentName((Component)component));
                    Pair<Class<?>, String> class2field = HierarchyTree.getClassAndFieldName(component);
                    if (class2field != null) {
                        this.append("(" + (String)class2field.second + "@" + ((Class)class2field.first).getSimpleName() + ")");
                    }
                    this.append(": " + ValueCellRenderer.RectangleRenderer.toString(component.getBounds()), SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    if (component.isOpaque()) {
                        this.append(", opaque", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                    if (component.isDoubleBuffered()) {
                        this.append(", double-buffered", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                    }
                    if (component instanceof UiDataProvider) {
                        this.append(", ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        this.append("ui-data-provider", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    } else if (component instanceof DataProvider) {
                        this.append(", ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        this.append("data-provider", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    } else if (DataManagerImpl.getDataProviderEx((Object)component) != null) {
                        this.append(", ", SimpleTextAttributes.GRAYED_ATTRIBUTES);
                        this.append("with data-provider", SimpleTextAttributes.REGULAR_BOLD_ATTRIBUTES);
                    }
                    componentNode.setText(this.toString());
                    this.setIcon(Icons.findIconFor(component));
                } else {
                    this.append(componentNode.myName);
                }
                AccessibilityAuditManager accessibilityAudit = componentNode.accessibilityAudit;
                if (accessibilityAudit.isRunning()) {
                    int fontHeight = this.getFontMetrics(this.getFont()).getHeight();
                    SeverityCount count = accessibilityAudit.getSeverityCount();
                    if (count.getTotal() == 0) {
                        this.myAccessibilityAuditIcons.add(new IconWithErrorCount(IconUtil.scale((Icon)AllIcons.General.GreenCheckmark, (Component)((Object)this), (float)((float)fontHeight / (float)AllIcons.General.GreenCheckmark.getIconHeight())), 0));
                    } else {
                        if (count.getErrors() > 0) {
                            this.myAccessibilityAuditIcons.add(new IconWithErrorCount(IconUtil.scale((Icon)AllIcons.General.Error, (Component)((Object)this), (float)((float)fontHeight / (float)AllIcons.General.Error.getIconHeight())), count.getErrors()));
                        }
                        if (count.getWarnings() > 0) {
                            this.myAccessibilityAuditIcons.add(new IconWithErrorCount(IconUtil.scale((Icon)AllIcons.General.Warning, (Component)((Object)this), (float)((float)fontHeight / (float)AllIcons.General.Warning.getIconHeight())), count.getWarnings()));
                        }
                        if (count.getRecommendations() > 0) {
                            this.myAccessibilityAuditIcons.add(new IconWithErrorCount(IconUtil.scale((Icon)AllIcons.General.Information, (Component)((Object)this), (float)((float)fontHeight / (float)AllIcons.General.Information.getIconHeight())), count.getRecommendations()));
                        }
                    }
                    this.myToolTipText = InternalActionsBundle.message((String)"ui.inspector.accessibility.audit.tree.tooltip", (Object[])new Object[]{count.getTotal(), count.getErrors(), count.getWarnings(), count.getRecommendations()});
                }
            }
            if (isRenderer) {
                this.setIcon(AllIcons.Ide.Rating);
            }
            this.setForeground(foreground);
            this.setBackground(background);
            SpeedSearchUtil.applySpeedSearchHighlighting((JComponent)tree, (SimpleColoredComponent)this, (boolean)false, (boolean)selected);
        }

        public String getToolTipText(MouseEvent event) {
            return this.myToolTipText;
        }

        public void paint(Graphics g) {
            super.paint(g);
            if (this.myAccessibilityAuditIcons.isEmpty()) {
                return;
            }
            GraphicsUtil.setupAntialiasing((Graphics)g);
            int iconX = this.getPreferredSize().width;
            int iconSpacing = this.getIconTextGap() * 2;
            FontMetrics fontMetrics = g.getFontMetrics();
            g.setColor(UIUtil.getTreeForeground());
            for (IconWithErrorCount entry : this.myAccessibilityAuditIcons) {
                Icon icon = entry.getIcon();
                int iconY = (this.getHeight() - icon.getIconHeight()) / 2;
                icon.paintIcon((Component)((Object)this), g, iconX, iconY);
                if (entry.getErrorCount() != 0) {
                    int textX = iconX + icon.getIconWidth() + iconSpacing;
                    int textY = (this.getHeight() + fontMetrics.getAscent() - fontMetrics.getDescent()) / 2;
                    String countStr = String.valueOf(entry.getErrorCount());
                    g.drawString(countStr, textX, textY);
                    iconX = textX + fontMetrics.stringWidth(countStr) + iconSpacing;
                    continue;
                }
                iconX += icon.getIconWidth() + iconSpacing;
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "tree", "com/intellij/internal/inspector/components/HierarchyTree$ComponentTreeCellRenderer", "customizeCellRenderer"));
        }
    }

    public static final class ComponentNode
    extends DefaultMutableTreeNode {
        private final Component myComponent;
        private final Accessible myAccessible;
        private final String myName;
        private final boolean isAccessibleNode;
        private final AccessibilityAuditManager accessibilityAudit;
        String myText;

        public static ComponentNode createAccessibleNode(@NotNull Accessible accessible) {
            if (accessible == null) {
                ComponentNode.$$$reportNull$$$0(0);
            }
            String name = accessible.getClass().getName();
            JComponent component = (JComponent)ObjectUtils.tryCast((Object)accessible, JComponent.class);
            ComponentNode node = new ComponentNode(component, accessible, name, true);
            TreeUtil.addChildrenTo((MutableTreeNode)node, ComponentNode.prepareAccessibleChildren(accessible));
            return node;
        }

        public static ComponentNode createComponentNode(@NotNull Component component) {
            if (component == null) {
                ComponentNode.$$$reportNull$$$0(1);
            }
            return ComponentNode.createComponentNode(component, false);
        }

        public static ComponentNode createComponentNode(@NotNull UiInspectorCustomComponentChildProvider provider) {
            if (provider == null) {
                ComponentNode.$$$reportNull$$$0(2);
            }
            ComponentNode node = new ComponentNode(null, null, provider.getTreeName(), false);
            node.setUserObject(provider);
            ArrayList<ComponentNode> result2 = new ArrayList<ComponentNode>();
            for (UiInspectorCustomComponentChildProvider child : provider.getChildren()) {
                result2.add(ComponentNode.createComponentNode(child));
            }
            TreeUtil.addChildrenTo((MutableTreeNode)node, result2);
            return node;
        }

        public static ComponentNode createComponentNode(@NotNull Component component, boolean isAccessibleComponent) {
            if (component == null) {
                ComponentNode.$$$reportNull$$$0(3);
            }
            String name = component.getClass().getName();
            Accessible accessible = (Accessible)ObjectUtils.tryCast((Object)component, Accessible.class);
            ComponentNode node = new ComponentNode(component, accessible, name, isAccessibleComponent);
            if (isAccessibleComponent) {
                TreeUtil.addChildrenTo((MutableTreeNode)node, ComponentNode.prepareAccessibleChildren(accessible));
            } else {
                TreeUtil.addChildrenTo((MutableTreeNode)node, ComponentNode.prepareComponentChildren(component));
            }
            return node;
        }

        public static ComponentNode createNamedNode(@NotNull String name, @Nullable Component component) {
            if (name == null) {
                ComponentNode.$$$reportNull$$$0(4);
            }
            Accessible accessible = (Accessible)ObjectUtils.tryCast((Object)component, Accessible.class);
            ComponentNode node = new ComponentNode(component, accessible, name, false);
            TreeUtil.addChildrenTo((MutableTreeNode)node, ComponentNode.prepareComponentChildren(component));
            return node;
        }

        private ComponentNode(@Nullable Component component, @Nullable Accessible accessible, @NotNull String name, boolean isAccessibleComponent) {
            if (name == null) {
                ComponentNode.$$$reportNull$$$0(5);
            }
            super(component);
            this.myComponent = component;
            this.myAccessible = accessible;
            this.myName = name;
            this.isAccessibleNode = isAccessibleComponent;
            this.accessibilityAudit = new AccessibilityAuditManager();
        }

        private static List<TreeNode> prepareAccessibleChildren(@Nullable Accessible a) {
            AccessibleContext ac;
            ArrayList<TreeNode> result2 = new ArrayList<TreeNode>();
            if (a != null && (ac = a.getAccessibleContext()) != null) {
                int count = ac.getAccessibleChildrenCount();
                for (int i = 0; i < count; ++i) {
                    Accessible axComponent = a.getAccessibleContext().getAccessibleChild(i);
                    if (axComponent == null) continue;
                    result2.add(ComponentNode.createAccessibleNode(axComponent));
                }
            }
            return result2;
        }

        public Component getComponent() {
            return this.myComponent;
        }

        public Accessible getAccessible() {
            return this.myAccessible;
        }

        @Override
        public String toString() {
            if (this.myText != null) {
                return this.myText;
            }
            return this.myName;
        }

        private void setText(String value) {
            this.myText = value;
        }

        public boolean equals(Object obj2) {
            return obj2 instanceof ComponentNode && ((ComponentNode)obj2).getComponent() == this.getComponent();
        }

        private static List<TreeNode> prepareComponentChildren(Component parent) {
            JComponent jComponent;
            Object clientProperty;
            Component[] node;
            ArrayList<TreeNode> result2 = new ArrayList<TreeNode>();
            if (parent instanceof JComponent && (node = (Component[])ClientProperty.get((Component)parent, UiInspectorAction.CLICK_INFO)) != null) {
                result2.add((TreeNode)node);
            }
            if (parent instanceof Container) {
                for (Component component : ((Container)parent).getComponents()) {
                    result2.add(ComponentNode.createComponentNode(component));
                }
            }
            if (parent instanceof Window) {
                Window[] children;
                for (Window child : children = ((Window)parent).getOwnedWindows()) {
                    if (child instanceof InspectorWindow) continue;
                    result2.add(ComponentNode.createComponentNode(child));
                }
            }
            if (parent instanceof JComponent && (clientProperty = (jComponent = (JComponent)parent).getClientProperty("UiInspectorCustomComponentProvider")) instanceof UiInspectorCustomComponentProvider) {
                UiInspectorCustomComponentProvider provider = (UiInspectorCustomComponentProvider)clientProperty;
                for (Window child : provider.getChildren()) {
                    result2.add(ComponentNode.createComponentNode((UiInspectorCustomComponentChildProvider)child));
                }
            }
            return result2;
        }

        public List<UiInspectorAccessibilityInspection> getFailedAccessibilityInspections() {
            return this.accessibilityAudit.getFailedInspections();
        }

        public void runAccessibilityAudit() {
            if (this.myAccessible != null || this.myComponent != null) {
                this.accessibilityAudit.runAccessibilityTests(this.myAccessible);
            }
        }

        public void clearAccessibilityAuditResult() {
            this.accessibilityAudit.clearAccessibilityTestsResult();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "accessible";
                    break;
                }
                case 1: 
                case 3: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "provider";
                    break;
                }
                case 4: 
                case 5: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "name";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/inspector/components/HierarchyTree$ComponentNode";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createAccessibleNode";
                    break;
                }
                case 1: 
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createComponentNode";
                    break;
                }
                case 4: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createNamedNode";
                    break;
                }
                case 5: {
                    objectArray = objectArray2;
                    objectArray2[2] = "<init>";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    static final class Icons {
        private static final Map<Class<?>, Icon> COMPONENT_MAPPING = new HashMap();
        @NotNull
        static final Icon Kotlin;
        @NotNull
        static final Icon Unknown;

        Icons() {
        }

        @NotNull
        private static Icon load(@NotNull String path) {
            if (path == null) {
                Icons.$$$reportNull$$$0(0);
            }
            return Icons.load(path, null);
        }

        @NotNull
        private static Icon load(@NotNull String path, Class<?> cls) {
            if (path == null) {
                Icons.$$$reportNull$$$0(1);
            }
            Icon icon = IconLoader.getIcon((String)("com/intellij/internal/inspector/icons/" + path), (ClassLoader)UiInspectorAction.class.getClassLoader());
            if (cls != null) {
                COMPONENT_MAPPING.put(cls, icon);
            }
            Icon icon2 = icon;
            if (icon2 == null) {
                Icons.$$$reportNull$$$0(2);
            }
            return icon2;
        }

        public static Icon findIconFor(Component component) {
            Icon icon = null;
            for (Class<?> aClass = component.getClass(); icon == null && aClass != null; aClass = aClass.getSuperclass()) {
                icon = COMPONENT_MAPPING.get(aClass);
            }
            if (icon == null) {
                icon = Unknown;
            }
            if (ComponentUtil.findParentByCondition((Component)component, c -> c.getClass() == DialogPanel.class) != null) {
                Icon kotlinIcon = ((ScalableIcon)Kotlin).scale(0.5f);
                return new RowIcon(new Icon[]{icon, IconUtil.toSize((Icon)kotlinIcon, (int)icon.getIconWidth(), (int)icon.getIconHeight())});
            }
            return icon;
        }

        static {
            Icons.load("button.svg", JButton.class);
            Icons.load("checkBox.svg", JCheckBox.class);
            Icons.load("comboBox.svg", JComboBox.class);
            Icons.load("editorPane.svg", JEditorPane.class);
            Icons.load("formattedTextField.svg", JFormattedTextField.class);
            Icons.load("label.svg", JLabel.class);
            Icons.load("list.svg", JList.class);
            Icons.load("panel.svg", JPanel.class);
            Icons.load("passwordField.svg", JPasswordField.class);
            Icons.load("progressbar.svg", JProgressBar.class);
            Icons.load("radioButton.svg", JRadioButton.class);
            Icons.load("scrollbar.svg", JScrollBar.class);
            Icons.load("scrollPane.svg", JScrollPane.class);
            Icons.load("separator.svg", JSeparator.class);
            Icons.load("slider.svg", JSlider.class);
            Icons.load("spinner.svg", JSpinner.class);
            Icons.load("splitPane.svg", JSplitPane.class);
            Icons.load("tabbedPane.svg", JTabbedPane.class);
            Icons.load("table.svg", JTable.class);
            Icons.load("textArea.svg", JTextArea.class);
            Icons.load("textField.svg", JTextField.class);
            Icons.load("textPane.svg", JTextPane.class);
            Icons.load("toolbar.svg", JToolBar.class);
            Icons.load("tree.svg", JTree.class);
            Kotlin = Icons.load("kotlin.svg");
            Unknown = Icons.load("unknown.svg");
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "path";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/components/HierarchyTree$Icons";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/components/HierarchyTree$Icons";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "load";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "load";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private static class IconWithErrorCount {
        private final Icon icon;
        private final int errorCount;

        private IconWithErrorCount(Icon icon, int errorCount) {
            this.icon = icon;
            this.errorCount = errorCount;
        }

        public Icon getIcon() {
            return this.icon;
        }

        public int getErrorCount() {
            return this.errorCount;
        }
    }
}

