/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.internal.inspector.components;

import com.intellij.ide.IdeBundle;
import com.intellij.ide.actions.BaseNavigateToSourceAction;
import com.intellij.ide.ui.laf.darcula.ui.DarculaSeparatorUI;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.idea.ActionsBundle;
import com.intellij.internal.InternalActionsBundle;
import com.intellij.internal.inspector.PropertyBean;
import com.intellij.internal.inspector.UiInspectorAction;
import com.intellij.internal.inspector.UiInspectorCustomComponentChildProvider;
import com.intellij.internal.inspector.UiInspectorImpl;
import com.intellij.internal.inspector.accessibilityAudit.UiInspectorAccessibilityInspection;
import com.intellij.internal.inspector.components.ComponentsNavBarPanel;
import com.intellij.internal.inspector.components.DataContextDialog;
import com.intellij.internal.inspector.components.DimensionsComponent;
import com.intellij.internal.inspector.components.HierarchyTree;
import com.intellij.internal.inspector.components.InspectorTable;
import com.intellij.internal.inspector.themePicker.UiThemeColorPicker;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.actionSystem.ActionGroup;
import com.intellij.openapi.actionSystem.ActionManager;
import com.intellij.openapi.actionSystem.ActionToolbar;
import com.intellij.openapi.actionSystem.ActionUpdateThread;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataSink;
import com.intellij.openapi.actionSystem.DefaultActionGroup;
import com.intellij.openapi.actionSystem.KeyboardShortcut;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.actionSystem.Toggleable;
import com.intellij.openapi.actionSystem.UiDataProvider;
import com.intellij.openapi.actionSystem.ex.CustomComponentAction;
import com.intellij.openapi.actionSystem.impl.ActionButtonWithText;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ui.configuration.actions.IconWithTextAction;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.util.DimensionService;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.pom.Navigatable;
import com.intellij.ui.ColorUtil;
import com.intellij.ui.ComponentUtil;
import com.intellij.ui.EditorNotificationPanel;
import com.intellij.ui.InlineBanner;
import com.intellij.ui.JBColor;
import com.intellij.ui.JBSplitter;
import com.intellij.ui.components.JBScrollPane;
import com.intellij.ui.components.JBThinOverlappingScrollBar;
import com.intellij.ui.components.panels.Wrapper;
import com.intellij.ui.paint.LinePainter2D;
import com.intellij.ui.paint.RectanglePainter;
import com.intellij.ui.tree.TreeVisitor;
import com.intellij.util.MethodInvocator;
import com.intellij.util.ObjectUtils;
import com.intellij.util.SystemProperties;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.JBIterable;
import com.intellij.util.ui.JBInsets;
import com.intellij.util.ui.JBUI;
import com.intellij.util.ui.UIUtil;
import com.intellij.util.ui.tree.TreeUtil;
import java.awt.AlphaComposite;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.HeadlessException;
import java.awt.Insets;
import java.awt.Paint;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.ActionEvent;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.accessibility.Accessible;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import javax.swing.JScrollBar;
import javax.swing.JSeparator;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.RootPaneContainer;
import javax.swing.SwingUtilities;
import javax.swing.plaf.SeparatorUI;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class InspectorWindow
extends JDialog
implements Disposable {
    private static final JBColor HIGHLIGHT_COLOR = new JBColor((Color)JBColor.GREEN, (Color)JBColor.RED);
    private InspectorTable myInspectorTable;
    @NotNull
    private final List<Component> myComponents;
    private List<? extends PropertyBean> myInfo;
    @NotNull
    private final Component myInitialComponent;
    @NotNull
    private final List<JComponent> myHighlightComponents;
    private boolean myIsHighlighted;
    private boolean myIsAccessibleEnabled;
    @NotNull
    private final HierarchyTree myHierarchyTree;
    @NotNull
    private final ComponentsNavBarPanel myNavBarPanel;
    @NotNull
    private final Wrapper myWrapperPanel;
    @Nullable
    private final Project myProject;
    private final UiInspectorAction.UiInspector myInspector;
    private final ToggleShowAccessibilityIssuesAction myShowAccessibilityIssuesAction;
    private AWTEventListener myAltKeyListener;
    private AWTEventListener myChangeSelectionOnHoverListener;

    public InspectorWindow(@Nullable Project project, @NotNull Component component, @NotNull UiInspectorAction.UiInspector inspector, @Nullable MouseEvent event) throws HeadlessException {
        if (component == null) {
            InspectorWindow.$$$reportNull$$$0(0);
        }
        if (inspector == null) {
            InspectorWindow.$$$reportNull$$$0(1);
        }
        super(InspectorWindow.findOwnerDialog(component));
        this.myComponents = new ArrayList<Component>();
        this.myHighlightComponents = new ArrayList<JComponent>();
        this.myIsHighlighted = true;
        this.myIsAccessibleEnabled = false;
        this.myProject = project;
        this.myInspector = inspector;
        Window ownerWindow = InspectorWindow.findOwnerDialog(component);
        this.setModal(ownerWindow instanceof JDialog && ((JDialog)ownerWindow).isModal());
        this.myComponents.add(component);
        this.myInitialComponent = component;
        this.getRootPane().setBorder(JBUI.Borders.empty((int)5));
        this.setDefaultCloseOperation(2);
        this.setLayout(new BorderLayout());
        this.setTitle(component.getClass().getName());
        Dimension size = DimensionService.getInstance().getSize(InspectorWindow.getDimensionServiceKey(), null);
        Point location = DimensionService.getInstance().getLocation(InspectorWindow.getDimensionServiceKey(), null);
        if (size != null) {
            this.setSize(size);
        }
        if (location != null) {
            this.setLocation(location);
        }
        this.myWrapperPanel = new Wrapper();
        this.myInspectorTable = new InspectorTable(component, this.myProject);
        this.myWrapperPanel.setContent((JComponent)((Object)this.myInspectorTable));
        this.myHierarchyTree = new HierarchyTree(component){

            @Override
            public void onComponentsChanged(List<? extends Component> components) {
                InspectorWindow.this.switchComponentsInfo(components);
                InspectorWindow.this.updateHighlighting();
            }

            @Override
            public void onAccessibleChanged(Accessible a) {
                InspectorWindow.this.switchAccessibleInfo(a);
                InspectorWindow.this.updateHighlighting();
            }

            @Override
            public void onClickInfoChanged(List<? extends PropertyBean> info) {
                InspectorWindow.this.switchClickInfo(info);
                InspectorWindow.this.updateHighlighting();
            }

            @Override
            public void onCustomComponentChanged(UiInspectorCustomComponentChildProvider provider) {
                InspectorWindow.this.switchCustomComponentInfo(provider);
                InspectorWindow.this.updateHighlighting();
            }
        };
        JBSplitter splitPane = new JBSplitter(false, "UiInspector.splitter.proportion", 0.5f);
        splitPane.setSecondComponent((JComponent)this.myWrapperPanel);
        splitPane.setFirstComponent((JComponent)new JBScrollPane((Component)this.myHierarchyTree));
        this.add((Component)splitPane, "Center");
        DefaultActionGroup actions = new DefaultActionGroup();
        actions.addAction((AnAction)((Object)new ToggleHighlightAction()));
        actions.addSeparator();
        actions.add((AnAction)((Object)new RefreshAction()));
        actions.addSeparator();
        actions.add((AnAction)((Object)new ToggleAccessibleAction()));
        actions.addSeparator();
        actions.addAction((AnAction)((Object)new ToggleThemeColorPickerAction(this)));
        actions.addSeparator();
        actions.add((AnAction)((Object)new ShowDataContextAction()));
        actions.addSeparator();
        actions.add((AnAction)((Object)new MyNavigateAction()));
        actions.addSeparator();
        this.myShowAccessibilityIssuesAction = new ToggleShowAccessibilityIssuesAction();
        actions.add((AnAction)((Object)this.myShowAccessibilityIssuesAction));
        ActionToolbar toolbar = ActionManager.getInstance().createActionToolbar("ContextToolbar", (ActionGroup)actions, true);
        toolbar.setTargetComponent(this.getRootPane());
        Consumer<Component> selectionHandler = selectedComponent -> {
            TreePath pathToSelect = TreeUtil.visitVisibleRows((JTree)this.myHierarchyTree, path -> {
                Object node = path.getLastPathComponent();
                Component curComponent = ((HierarchyTree.ComponentNode)node).getComponent();
                return curComponent == selectedComponent ? TreeVisitor.Action.INTERRUPT : TreeVisitor.Action.CONTINUE;
            });
            if (pathToSelect != null) {
                this.myHierarchyTree.setSelectionPath(pathToSelect);
                this.myHierarchyTree.scrollPathToVisible(pathToSelect);
            }
        };
        this.myNavBarPanel = new ComponentsNavBarPanel(component, selectionHandler);
        JBScrollPane navBarScroll = new JBScrollPane((Component)((Object)this.myNavBarPanel), 21, 30);
        navBarScroll.setHorizontalScrollBar((JScrollBar)new JBThinOverlappingScrollBar(0));
        navBarScroll.setOverlappingScrollBar(true);
        navBarScroll.setBorder(BorderFactory.createEmptyBorder());
        navBarScroll.putClientProperty(JBScrollPane.Flip.class, (Object)JBScrollPane.Flip.VERTICAL);
        JPanel topPanel = new JPanel();
        topPanel.setLayout(new BoxLayout(topPanel, 1));
        topPanel.add(toolbar.getComponent());
        topPanel.add(new JSeparator(0){

            @Override
            public void updateUI() {
                this.setUI((SeparatorUI)new DarculaSeparatorUI(this){

                    protected int getStripeIndent() {
                        return 0;
                    }

                    public Dimension getPreferredSize(JComponent c) {
                        return JBUI.size((int)0, (int)1);
                    }
                });
            }
        });
        if (InspectorWindow.isDoubleBufferingDisabled(component)) {
            Object message = "Double buffering is disabled for this window. See 'com.intellij.util.ui.GraphicsUtil.safelyGetGraphics' JavaDoc.";
            if (SystemProperties.getBooleanProperty((String)"idea.debug.mode", (boolean)false)) {
                message = (String)message + "<br>To find the cause, you may pass a '-Dswing.logDoubleBufferingDisable=true' option or put a breakpoint into 'javax.swing.JRootPane.disableTrueDoubleBuffering', and restart IDE. Please report an issue in YouTrack.";
            }
            InlineBanner banner = new InlineBanner((String)message, EditorNotificationPanel.Status.Error);
            topPanel.add((Component)banner);
        }
        String altHoverHint = InternalActionsBundle.message((String)"ui.inspector.hint.alt.hover.next", (Object[])new Object[0]);
        String altHoverHintKey = "ui.inspector.hint.alt.hover.next.dismissed";
        PropertiesComponent props = PropertiesComponent.getInstance();
        if (!props.getBoolean(altHoverHintKey, false)) {
            InlineBanner hintBanner = new InlineBanner(altHoverHint, EditorNotificationPanel.Status.Info).showCloseButton(true).setCloseAction(() -> props.setValue(altHoverHintKey, true));
            topPanel.add((Component)hintBanner);
        }
        topPanel.add((Component)navBarScroll);
        this.add((Component)topPanel, "North");
        TreeUtil.expandAll((JTree)this.myHierarchyTree);
        this.myHierarchyTree.selectPath(component, event);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent e) {
                InspectorWindow.this.close();
            }
        });
        this.getRootPane().getActionMap().put("CLOSE", new AbstractAction(){

            @Override
            public void actionPerformed(ActionEvent e) {
                InspectorWindow.this.close();
            }
        });
        this.updateHighlighting();
        this.getRootPane().getInputMap(2).put(KeyStroke.getKeyStroke(27, 0), "CLOSE");
        if (this.myShowAccessibilityIssuesAction.showAccessibilityIssues) {
            this.myShowAccessibilityIssuesAction.updateTreeWithAccessibilityAuditStatus();
        }
        this.installAltKeyListener();
    }

    private void installAltKeyListener() {
        this.myAltKeyListener = event -> {
            KeyEvent keyEvent = (KeyEvent)event;
            int eventId = event.getID();
            if (keyEvent.getKeyCode() == 18) {
                if (eventId == 401) {
                    this.installChangeSelectionOnHoverListener();
                    this.resetTree(true);
                } else if (eventId == 402) {
                    this.removeChangeSelectionOnHoverListener();
                }
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.myAltKeyListener, 8L);
    }

    private void installChangeSelectionOnHoverListener() {
        if (this.myChangeSelectionOnHoverListener != null) {
            return;
        }
        this.myChangeSelectionOnHoverListener = event -> {
            if (event.getID() != 503) {
                return;
            }
            MouseEvent mouseEvent = (MouseEvent)event;
            if (mouseEvent.isControlDown() || mouseEvent.isMetaDown() || mouseEvent.isShiftDown()) {
                return;
            }
            Component source = mouseEvent.getComponent();
            if (source == null || SwingUtilities.isDescendingFrom(source, this)) {
                return;
            }
            Component componentUnderMouse = UIUtil.getDeepestComponentAt((Component)source, (int)mouseEvent.getX(), (int)mouseEvent.getY());
            if (componentUnderMouse != null) {
                this.myHierarchyTree.selectPath(componentUnderMouse);
            }
        };
        Toolkit.getDefaultToolkit().addAWTEventListener(this.myChangeSelectionOnHoverListener, 32L);
    }

    private void removeChangeSelectionOnHoverListener() {
        if (this.myChangeSelectionOnHoverListener == null) {
            return;
        }
        Toolkit.getDefaultToolkit().removeAWTEventListener(this.myChangeSelectionOnHoverListener);
        this.myChangeSelectionOnHoverListener = null;
        this.updateHighlighting();
    }

    private void resetTree(boolean ignoreOrphanComponents) {
        TreePath path = this.myHierarchyTree.getLeadSelectionPath();
        if (path == null) {
            return;
        }
        HierarchyTree.ComponentNode node = (HierarchyTree.ComponentNode)ObjectUtils.tryCast((Object)path.getLastPathComponent(), HierarchyTree.ComponentNode.class);
        if (node == null) {
            return;
        }
        Component c = node.getComponent();
        if (c == null) {
            return;
        }
        if (ignoreOrphanComponents && UIUtil.getRootPane((Component)c) == null) {
            return;
        }
        Component selected = (Component)ContainerUtil.getFirstItem(this.myComponents);
        this.myHierarchyTree.resetModel(c, this.myIsAccessibleEnabled);
        TreeUtil.expandAll((JTree)this.myHierarchyTree);
        if (selected != null) {
            this.myHierarchyTree.selectPath(selected, this.myIsAccessibleEnabled);
        }
    }

    @Override
    protected JRootPane createRootPane() {
        MyRootPane rp = new MyRootPane();
        rp.setOpaque(true);
        return rp;
    }

    public static String getDimensionServiceKey() {
        return "UiInspectorWindow";
    }

    private static Window findOwnerDialog(Component component) {
        DialogWrapper dialogWrapper = DialogWrapper.findInstance((Component)component);
        if (dialogWrapper != null) {
            return dialogWrapper.getPeer().getWindow();
        }
        return null;
    }

    private InspectorTable getCurrentTable() {
        return this.myInspectorTable;
    }

    private void switchComponentsInfo(@NotNull List<? extends Component> components) {
        if (components == null) {
            InspectorWindow.$$$reportNull$$$0(2);
        }
        if (components.isEmpty()) {
            return;
        }
        this.myComponents.clear();
        this.myComponents.addAll(components);
        this.myInfo = null;
        Component showingComponent = components.getFirst();
        this.setTitle(showingComponent.getClass().getName());
        Disposer.dispose((Disposable)this.myInspectorTable);
        this.myInspectorTable = new InspectorTable(showingComponent, this.myProject, this.getSelectedNodeFailedAccessibilityInspections());
        this.myWrapperPanel.setContent((JComponent)((Object)this.myInspectorTable));
        this.myNavBarPanel.setSelectedComponent(showingComponent);
    }

    private void switchClickInfo(@NotNull List<? extends PropertyBean> clickInfo) {
        if (clickInfo == null) {
            InspectorWindow.$$$reportNull$$$0(3);
        }
        this.myComponents.clear();
        this.myInfo = clickInfo;
        this.setTitle("Click Info");
        Disposer.dispose((Disposable)this.myInspectorTable);
        this.myInspectorTable = new InspectorTable(clickInfo, this.myProject, this.getSelectedNodeFailedAccessibilityInspections());
        this.myWrapperPanel.setContent((JComponent)((Object)this.myInspectorTable));
    }

    private void switchCustomComponentInfo(@NotNull UiInspectorCustomComponentChildProvider provider) {
        Rectangle bounds;
        if (provider == null) {
            InspectorWindow.$$$reportNull$$$0(4);
        }
        this.myInfo = (bounds = provider.getHighlightingBounds()) == null ? null : Collections.singletonList(new PropertyBean("clicked renderer", (Object)bounds));
        this.myComponents.clear();
        this.setTitle(provider.getTreeName());
        Disposer.dispose((Disposable)this.myInspectorTable);
        this.myInspectorTable = new InspectorTable(provider, this.myProject);
        this.myWrapperPanel.setContent((JComponent)((Object)this.myInspectorTable));
    }

    private void switchAccessibleInfo(@NotNull Accessible accessible) {
        if (accessible == null) {
            InspectorWindow.$$$reportNull$$$0(5);
        }
        this.myComponents.clear();
        this.myInfo = null;
        this.setTitle(accessible.getClass().getName());
        Disposer.dispose((Disposable)this.myInspectorTable);
        this.myInspectorTable = new InspectorTable(accessible, this.myProject);
        this.myWrapperPanel.setContent((JComponent)((Object)this.myInspectorTable));
    }

    @Override
    public void dispose() {
        if (this.myAltKeyListener != null) {
            Toolkit.getDefaultToolkit().removeAWTEventListener(this.myAltKeyListener);
            this.myAltKeyListener = null;
        }
        this.removeChangeSelectionOnHoverListener();
        DimensionService.getInstance().setSize(InspectorWindow.getDimensionServiceKey(), this.getSize(), null);
        DimensionService.getInstance().setLocation(InspectorWindow.getDimensionServiceKey(), this.getLocation(), null);
        Disposer.dispose((Disposable)this.myInspectorTable);
        super.dispose();
        Disposer.dispose((Disposable)this);
        DialogWrapper.cleanupRootPane((JRootPane)this.rootPane);
        DialogWrapper.cleanupWindowListeners((Window)this);
    }

    public void close() {
        if (this.myInitialComponent instanceof JComponent) {
            ((JComponent)this.myInitialComponent).putClientProperty(UiInspectorAction.CLICK_INFO, null);
        }
        this.myIsHighlighted = false;
        this.myInfo = null;
        this.myComponents.clear();
        this.updateHighlighting();
        this.setVisible(false);
        Disposer.dispose((Disposable)this);
    }

    public UiInspectorAction.UiInspector getInspector() {
        return this.myInspector;
    }

    private void updateHighlighting() {
        for (JComponent jComponent : this.myHighlightComponents) {
            JComponent jComponent2 = InspectorWindow.getGlassPane(jComponent);
            if (jComponent2 == null) continue;
            jComponent2.remove(jComponent);
            jComponent2.revalidate();
            jComponent2.repaint();
        }
        this.myHighlightComponents.clear();
        if (this.myIsHighlighted) {
            for (Component component : this.myComponents) {
                this.createHighlighter(component, null);
            }
            if (this.myInfo != null) {
                Rectangle bounds = null;
                for (PropertyBean propertyBean : this.myInfo) {
                    if (!"clicked renderer".equals(propertyBean.propertyName)) continue;
                    bounds = (Rectangle)propertyBean.propertyValue;
                    break;
                }
                this.createHighlighter(this.myInitialComponent, bounds);
            }
        }
    }

    private void createHighlighter(@NotNull Component component, @Nullable Rectangle bounds) {
        JComponent glassPane;
        if (component == null) {
            InspectorWindow.$$$reportNull$$$0(6);
        }
        if ((glassPane = InspectorWindow.getGlassPane(component)) == null) {
            return;
        }
        HighlightComponent highlightComponent = InspectorWindow.createHighlightComponent(component, bounds, glassPane);
        ContainerUtil.addIfNotNull(this.myHighlightComponents, (Object)highlightComponent);
        glassPane.add(highlightComponent);
        if (this.myChangeSelectionOnHoverListener != null) {
            JComponent dimensionComponent = InspectorWindow.createDimensionComponent(component, highlightComponent.getBounds(), glassPane);
            ContainerUtil.addIfNotNull(this.myHighlightComponents, (Object)dimensionComponent);
            glassPane.add(dimensionComponent);
        }
        glassPane.revalidate();
        glassPane.repaint();
    }

    @NotNull
    private static HighlightComponent createHighlightComponent(@NotNull Component component, @Nullable Rectangle bounds, JComponent glassPane) {
        if (component == null) {
            InspectorWindow.$$$reportNull$$$0(7);
        }
        if (bounds != null) {
            bounds = SwingUtilities.convertRectangle(component, bounds, glassPane);
        } else {
            Point pt = SwingUtilities.convertPoint(component, new Point(0, 0), glassPane);
            bounds = new Rectangle(pt.x, pt.y, component.getWidth(), component.getHeight());
        }
        JBColor color = HIGHLIGHT_COLOR;
        if (bounds.width == 0 || bounds.height == 0) {
            bounds.width = Math.max(bounds.width, 1);
            bounds.height = Math.max(bounds.height, 1);
            color = JBColor.BLUE;
        }
        JBInsets insets = component instanceof JComponent ? ((JComponent)component).getInsets() : JBInsets.emptyInsets();
        HighlightComponent highlightComponent = new HighlightComponent((Color)color, (Insets)insets);
        highlightComponent.setBounds(bounds);
        HighlightComponent highlightComponent2 = highlightComponent;
        if (highlightComponent2 == null) {
            InspectorWindow.$$$reportNull$$$0(8);
        }
        return highlightComponent2;
    }

    @NotNull
    private static JComponent createDimensionComponent(@NotNull Component component, @NotNull Rectangle highlighterBounds, @NotNull JComponent glassPane) {
        if (component == null) {
            InspectorWindow.$$$reportNull$$$0(9);
        }
        if (highlighterBounds == null) {
            InspectorWindow.$$$reportNull$$$0(10);
        }
        if (glassPane == null) {
            InspectorWindow.$$$reportNull$$$0(11);
        }
        DimensionsComponent dimensionsComponent = new DimensionsComponent(component);
        dimensionsComponent.setForeground(new JPanel().getForeground());
        dimensionsComponent.setBackground(ColorUtil.blendColorsInRgb((Color)new JPanel().getBackground(), (Color)HIGHLIGHT_COLOR, (double)0.2));
        dimensionsComponent.setBounds(InspectorWindow.findBounds(highlighterBounds, glassPane, dimensionsComponent.getPreferredSize()));
        DimensionsComponent dimensionsComponent2 = dimensionsComponent;
        if (dimensionsComponent2 == null) {
            InspectorWindow.$$$reportNull$$$0(12);
        }
        return dimensionsComponent2;
    }

    @NotNull
    private static Rectangle findBounds(@NotNull Rectangle highlighterBounds, @NotNull JComponent glassPane, @NotNull Dimension size) {
        if (highlighterBounds == null) {
            InspectorWindow.$$$reportNull$$$0(13);
        }
        if (glassPane == null) {
            InspectorWindow.$$$reportNull$$$0(14);
        }
        if (size == null) {
            InspectorWindow.$$$reportNull$$$0(15);
        }
        Dimension glassPaneSize = glassPane.getSize();
        int gap = JBUI.scale((int)10);
        ArrayList<Point> possiblePositions = new ArrayList<Point>();
        ArrayList<Rectangle> fitBounds = new ArrayList<Rectangle>();
        possiblePositions.add(new Point(highlighterBounds.x + (highlighterBounds.width - size.width) / 2, highlighterBounds.y + highlighterBounds.height + gap));
        possiblePositions.add(new Point(highlighterBounds.x + (highlighterBounds.width - size.width) / 2, highlighterBounds.y - size.height - gap));
        possiblePositions.add(new Point(highlighterBounds.x + highlighterBounds.width + gap, highlighterBounds.y + (highlighterBounds.height - size.height) / 2));
        possiblePositions.add(new Point(highlighterBounds.x - size.width - gap, highlighterBounds.y + (highlighterBounds.height - size.height) / 2));
        for (Point position : possiblePositions) {
            Rectangle possibleBounds = new Rectangle(position, size);
            InspectorWindow.fitToGlassPane(possibleBounds, glassPaneSize);
            fitBounds.add(possibleBounds);
            if (!possibleBounds.getLocation().equals(position)) continue;
            Rectangle rectangle = possibleBounds;
            if (rectangle == null) {
                InspectorWindow.$$$reportNull$$$0(16);
            }
            return rectangle;
        }
        for (int i = 0; i < possiblePositions.size(); ++i) {
            Point original = (Point)possiblePositions.get(i);
            Point fit = ((Rectangle)fitBounds.get(i)).getLocation();
            if (original.x != fit.x && original.y != fit.y) continue;
            Rectangle rectangle = (Rectangle)fitBounds.get(i);
            if (rectangle == null) {
                InspectorWindow.$$$reportNull$$$0(17);
            }
            return rectangle;
        }
        Rectangle rectangle = (Rectangle)fitBounds.getFirst();
        if (rectangle == null) {
            InspectorWindow.$$$reportNull$$$0(18);
        }
        return rectangle;
    }

    private static void fitToGlassPane(@NotNull Rectangle result2, @NotNull Dimension glassPaneSize) {
        if (result2 == null) {
            InspectorWindow.$$$reportNull$$$0(19);
        }
        if (glassPaneSize == null) {
            InspectorWindow.$$$reportNull$$$0(20);
        }
        result2.x = Math.min(Math.max(result2.x, 0), glassPaneSize.width - result2.width);
        result2.y = Math.min(Math.max(result2.y, 0), glassPaneSize.height - result2.height);
    }

    @Nullable
    private static JComponent getGlassPane(@NotNull Component component) {
        JRootPane rootPane;
        if (component == null) {
            InspectorWindow.$$$reportNull$$$0(21);
        }
        return (rootPane = SwingUtilities.getRootPane(component)) == null ? null : (JComponent)rootPane.getGlassPane();
    }

    private String findSelectedClassName() {
        if (this.myHierarchyTree.hasFocus()) {
            Component comp;
            Object obj2;
            if (!this.myComponents.isEmpty()) {
                return this.myComponents.getFirst().getClass().getName();
            }
            TreePath path = this.myHierarchyTree.getSelectionPath();
            if (path != null && (obj2 = path.getLastPathComponent()) instanceof HierarchyTree.ComponentNode && (comp = ((HierarchyTree.ComponentNode)obj2).getComponent()) != null) {
                return comp.getClass().getName();
            }
        } else if (this.myInspectorTable.getTable().hasFocus()) {
            int row = this.myInspectorTable.getTable().getSelectedRow();
            String value = this.myInspectorTable.getCellTextValue(row, 1);
            String[] parts = value.split("[@,\\[]");
            return parts[0];
        }
        return null;
    }

    private static boolean isDoubleBufferingDisabled(Component component) {
        Component window = ComponentUtil.findParentByCondition((Component)component, it -> it instanceof JFrame || it instanceof JDialog);
        if (window instanceof RootPaneContainer) {
            JRootPane rootPane = ((RootPaneContainer)((Object)window)).getRootPane();
            try {
                MethodInvocator invocator = new MethodInvocator(JRootPane.class, "getUseTrueDoubleBuffering", new Class[0]);
                if (invocator.isAvailable()) {
                    boolean useTrueDoubleBuffering = (Boolean)invocator.invoke((Object)rootPane, new Object[0]);
                    return !useTrueDoubleBuffering;
                }
            }
            catch (Throwable e) {
                Logger.getInstance(InspectorWindow.class).warn(e);
                return false;
            }
        }
        return false;
    }

    @NotNull
    private List<UiInspectorAccessibilityInspection> getSelectedNodeFailedAccessibilityInspections() {
        Object object;
        List<UiInspectorAccessibilityInspection> failedInspections = Collections.emptyList();
        TreePath path = this.myHierarchyTree.getSelectionPath();
        if (path != null && (object = path.getLastPathComponent()) instanceof HierarchyTree.ComponentNode) {
            HierarchyTree.ComponentNode node = (HierarchyTree.ComponentNode)object;
            failedInspections = node.getFailedAccessibilityInspections();
        }
        List<UiInspectorAccessibilityInspection> list2 = failedInspections;
        if (list2 == null) {
            InspectorWindow.$$$reportNull$$$0(22);
        }
        return list2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 8, 12, 16, 17, 18, 22 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "component";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "inspector";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "components";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "clickInfo";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "provider";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "accessible";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/internal/inspector/components/InspectorWindow";
                break;
            }
            case 10: 
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "highlighterBounds";
                break;
            }
            case 11: 
            case 14: {
                objectArray2 = objectArray3;
                objectArray3[0] = "glassPane";
                break;
            }
            case 15: {
                objectArray2 = objectArray3;
                objectArray3[0] = "size";
                break;
            }
            case 19: {
                objectArray2 = objectArray3;
                objectArray3[0] = "result";
                break;
            }
            case 20: {
                objectArray2 = objectArray3;
                objectArray3[0] = "glassPaneSize";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/internal/inspector/components/InspectorWindow";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "createHighlightComponent";
                break;
            }
            case 12: {
                objectArray = objectArray2;
                objectArray2[1] = "createDimensionComponent";
                break;
            }
            case 16: 
            case 17: 
            case 18: {
                objectArray = objectArray2;
                objectArray2[1] = "findBounds";
                break;
            }
            case 22: {
                objectArray = objectArray2;
                objectArray2[1] = "getSelectedNodeFailedAccessibilityInspections";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "switchComponentsInfo";
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "switchClickInfo";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "switchCustomComponentInfo";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "switchAccessibleInfo";
                break;
            }
            case 6: {
                objectArray = objectArray;
                objectArray[2] = "createHighlighter";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "createHighlightComponent";
                break;
            }
            case 8: 
            case 12: 
            case 16: 
            case 17: 
            case 18: 
            case 22: {
                break;
            }
            case 9: 
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "createDimensionComponent";
                break;
            }
            case 13: 
            case 14: 
            case 15: {
                objectArray = objectArray;
                objectArray[2] = "findBounds";
                break;
            }
            case 19: 
            case 20: {
                objectArray = objectArray;
                objectArray[2] = "fitToGlassPane";
                break;
            }
            case 21: {
                objectArray = objectArray;
                objectArray[2] = "getGlassPane";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 8, 12, 16, 17, 18, 22 -> new IllegalStateException(string);
        };
    }

    private final class ToggleHighlightAction
    extends MyTextAction
    implements Toggleable {
        private ToggleHighlightAction() {
            super(IdeBundle.messagePointer((String)"action.Anonymous.text.highlight", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleHighlightAction.$$$reportNull$$$0(0);
            }
            InspectorWindow.this.myIsHighlighted = !InspectorWindow.this.myIsHighlighted;
            InspectorWindow.this.updateHighlighting();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleHighlightAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(InspectorWindow.this.myInfo != null || !InspectorWindow.this.myComponents.isEmpty());
            Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)InspectorWindow.this.myIsHighlighted);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                ToggleHighlightAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/components/InspectorWindow$ToggleHighlightAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/components/InspectorWindow$ToggleHighlightAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class RefreshAction
    extends MyTextAction {
        private RefreshAction() {
            super(InternalActionsBundle.messagePointer((String)"action.Anonymous.text.refresh", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                RefreshAction.$$$reportNull$$$0(0);
            }
            InspectorWindow.this.getCurrentTable().refresh();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                RefreshAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabled(!InspectorWindow.this.myComponents.isEmpty());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.EDT;
            if (actionUpdateThread == null) {
                RefreshAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/components/InspectorWindow$RefreshAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/components/InspectorWindow$RefreshAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class ToggleAccessibleAction
    extends MyTextAction
    implements Toggleable {
        private ToggleAccessibleAction() {
            super(InternalActionsBundle.messagePointer((String)"action.Anonymous.text.Accessible", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleAccessibleAction.$$$reportNull$$$0(0);
            }
            this.switchHierarchy();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleAccessibleAction.$$$reportNull$$$0(1);
            }
            Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)InspectorWindow.this.myIsAccessibleEnabled);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ToggleAccessibleAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private void switchHierarchy() {
            InspectorWindow.this.myIsAccessibleEnabled = !InspectorWindow.this.myIsAccessibleEnabled;
            InspectorWindow.this.myNavBarPanel.setAccessibleEnabled(InspectorWindow.this.myIsAccessibleEnabled);
            InspectorWindow.this.resetTree(false);
            if (InspectorWindow.this.myShowAccessibilityIssuesAction.showAccessibilityIssues) {
                InspectorWindow.this.myShowAccessibilityIssuesAction.updateTreeWithAccessibilityAuditStatus();
            }
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/components/InspectorWindow$ToggleAccessibleAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/components/InspectorWindow$ToggleAccessibleAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class ToggleThemeColorPickerAction
    extends MyTextAction
    implements Toggleable {
        private ToggleThemeColorPickerAction(InspectorWindow inspectorWindow) {
            super(InternalActionsBundle.messagePointer((String)"action.Anonymous.text.colorPicker", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleThemeColorPickerAction.$$$reportNull$$$0(0);
            }
            UiThemeColorPicker.getInstance().setEnabled(!UiThemeColorPicker.getInstance().isEnabled());
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleThemeColorPickerAction.$$$reportNull$$$0(1);
            }
            Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)UiThemeColorPicker.getInstance().isEnabled());
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ToggleThemeColorPickerAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/components/InspectorWindow$ToggleThemeColorPickerAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/components/InspectorWindow$ToggleThemeColorPickerAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private final class ShowDataContextAction
    extends MyTextAction {
        private ShowDataContextAction() {
            super(InternalActionsBundle.messagePointer((String)"action.Anonymous.text.DataContext", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            TreePath path;
            if (e == null) {
                ShowDataContextAction.$$$reportNull$$$0(0);
            }
            if ((path = InspectorWindow.this.myHierarchyTree.getLeadSelectionPath()) == null) {
                return;
            }
            HierarchyTree.ComponentNode node = (HierarchyTree.ComponentNode)ObjectUtils.tryCast((Object)path.getLastPathComponent(), HierarchyTree.ComponentNode.class);
            if (node == null) {
                return;
            }
            JComponent c = (JComponent)UIUtil.getParentOfType(JComponent.class, (Component)node.getComponent());
            if (c == null) {
                return;
            }
            List components = JBIterable.generate((Object)node, o -> o.getParent()).filter(HierarchyTree.ComponentNode.class).filterMap(o -> o.getComponent()).toList();
            new DataContextDialog(InspectorWindow.this.myProject, components).show();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "e", "com/intellij/internal/inspector/components/InspectorWindow$ShowDataContextAction", "actionPerformed"));
        }
    }

    private static final class MyNavigateAction
    extends BaseNavigateToSourceAction
    implements CustomComponentAction {
        private MyNavigateAction() {
            super(true);
            Presentation presentation = this.getTemplatePresentation();
            presentation.setText(ActionsBundle.messagePointer((String)"action.EditSource.text", (Object[])new Object[0]));
            presentation.setDescription(InternalActionsBundle.messagePointer((String)"action.Anonymous.description.open.definition", (Object[])new Object[0]));
            presentation.putClientProperty(ActionButtonWithText.SHORTCUT_SHOULD_SHOWN, true);
        }

        @Override
        @NotNull
        public JComponent createCustomComponent(@NotNull Presentation presentation, @NotNull String place) {
            if (presentation == null) {
                MyNavigateAction.$$$reportNull$$$0(0);
            }
            if (place == null) {
                MyNavigateAction.$$$reportNull$$$0(1);
            }
            return new ActionButtonWithText((AnAction)((Object)this), presentation, place, ActionToolbar.DEFAULT_MINIMUM_BUTTON_SIZE){

                @Nullable
                protected String getShortcutText() {
                    KeyboardShortcut shortcut = ActionManager.getInstance().getKeyboardShortcut("EditSource");
                    if (shortcut != null) {
                        return KeymapUtil.getShortcutText((Shortcut)shortcut);
                    }
                    return null;
                }
            };
        }

        @Override
        public void updateCustomComponent(@NotNull JComponent component, @NotNull Presentation presentation) {
            if (component == null) {
                MyNavigateAction.$$$reportNull$$$0(2);
            }
            if (presentation == null) {
                MyNavigateAction.$$$reportNull$$$0(3);
            }
            component.setEnabled(presentation.isEnabled());
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[3];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "presentation";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "place";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "component";
                    break;
                }
            }
            objectArray2[1] = "com/intellij/internal/inspector/components/InspectorWindow$MyNavigateAction";
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[2] = "createCustomComponent";
                    break;
                }
                case 2: 
                case 3: {
                    objectArray = objectArray2;
                    objectArray2[2] = "updateCustomComponent";
                    break;
                }
            }
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private final class ToggleShowAccessibilityIssuesAction
    extends MyTextAction
    implements Toggleable {
        private final boolean isAccessibilityAuditEnabled;
        public static final String SHOW_ACCESSIBILITY_ISSUES_KEY = "ui.inspector.show.accessibility.issues.key";
        private boolean showAccessibilityIssues;

        private ToggleShowAccessibilityIssuesAction() {
            super(InternalActionsBundle.messagePointer((String)"action.Anonymous.text.ShowAccessibilityIssues", (Object[])new Object[0]));
            this.isAccessibilityAuditEnabled = Registry.is((String)"ui.inspector.accessibility.audit", (boolean)true);
            this.showAccessibilityIssues = this.isAccessibilityAuditEnabled && PropertiesComponent.getInstance().getBoolean(SHOW_ACCESSIBILITY_ISSUES_KEY, false);
            this.getTemplatePresentation().setDescription(InternalActionsBundle.messagePointer((String)"action.Anonymous.description.ShowAccessibilityIssues", (Object[])new Object[0]));
        }

        public void actionPerformed(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleShowAccessibilityIssuesAction.$$$reportNull$$$0(0);
            }
            this.showAccessibilityIssues = !this.showAccessibilityIssues;
            PropertiesComponent.getInstance().setValue(SHOW_ACCESSIBILITY_ISSUES_KEY, this.showAccessibilityIssues);
            this.updateTreeWithAccessibilityAuditStatus();
        }

        public void update(@NotNull AnActionEvent e) {
            if (e == null) {
                ToggleShowAccessibilityIssuesAction.$$$reportNull$$$0(1);
            }
            e.getPresentation().setEnabledAndVisible(this.isAccessibilityAuditEnabled);
            Toggleable.setSelected((Presentation)e.getPresentation(), (boolean)this.showAccessibilityIssues);
        }

        @NotNull
        public ActionUpdateThread getActionUpdateThread() {
            ActionUpdateThread actionUpdateThread = ActionUpdateThread.BGT;
            if (actionUpdateThread == null) {
                ToggleShowAccessibilityIssuesAction.$$$reportNull$$$0(2);
            }
            return actionUpdateThread;
        }

        private void updateTreeWithAccessibilityAuditStatus() {
            TreeUtil.visitVisibleRows((JTree)InspectorWindow.this.myHierarchyTree, path -> {
                Object node = path.getLastPathComponent();
                if (node instanceof HierarchyTree.ComponentNode) {
                    HierarchyTree.ComponentNode componentNode = (HierarchyTree.ComponentNode)node;
                    if (this.showAccessibilityIssues) {
                        componentNode.runAccessibilityAudit();
                    } else {
                        componentNode.clearAccessibilityAuditResult();
                    }
                }
                return TreeVisitor.Action.CONTINUE;
            });
            InspectorWindow.this.myHierarchyTree.repaint();
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "e";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/internal/inspector/components/InspectorWindow$ToggleShowAccessibilityIssuesAction";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/internal/inspector/components/InspectorWindow$ToggleShowAccessibilityIssuesAction";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getActionUpdateThread";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "actionPerformed";
                    break;
                }
                case 1: {
                    objectArray = objectArray;
                    objectArray[2] = "update";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }

    private class MyRootPane
    extends JRootPane
    implements UiDataProvider {
        private MyRootPane() {
        }

        public void uiDataSnapshot(@NotNull DataSink sink) {
            String selectedClassName;
            if (sink == null) {
                MyRootPane.$$$reportNull$$$0(0);
            }
            if ((selectedClassName = InspectorWindow.this.findSelectedClassName()) == null) {
                return;
            }
            sink.set(CommonDataKeys.NAVIGATABLE, (Object)new Navigatable(){

                public void navigate(boolean requestFocus) {
                    UiInspectorImpl.openClassByFqn(InspectorWindow.this.myProject, selectedClassName, requestFocus);
                }

                public boolean canNavigate() {
                    return true;
                }

                public boolean canNavigateToSource() {
                    return true;
                }
            });
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "sink", "com/intellij/internal/inspector/components/InspectorWindow$MyRootPane", "uiDataSnapshot"));
        }
    }

    private static final class HighlightComponent
    extends JComponent {
        @NotNull
        private final Color myColor;
        @NotNull
        private final Insets myInsets;

        private HighlightComponent(@NotNull Color c, @NotNull Insets insets) {
            if (c == null) {
                HighlightComponent.$$$reportNull$$$0(0);
            }
            if (insets == null) {
                HighlightComponent.$$$reportNull$$$0(1);
            }
            this.myColor = c;
            this.myInsets = insets;
        }

        @Override
        protected void paintComponent(Graphics g) {
            int i;
            Graphics2D g2d = (Graphics2D)g;
            Color oldColor = g2d.getColor();
            Composite old = g2d.getComposite();
            g2d.setComposite(AlphaComposite.getInstance(3, 0.2f));
            Rectangle r = this.getBounds();
            RectanglePainter.paint((Graphics2D)g2d, (int)0, (int)0, (int)r.width, (int)r.height, (int)0, (Paint)this.myColor, null);
            ((Graphics2D)g).setPaint(this.myColor.darker());
            for (i = 0; i < this.myInsets.left; ++i) {
                LinePainter2D.paint((Graphics2D)g2d, (double)i, (double)this.myInsets.top, (double)i, (double)(r.height - this.myInsets.bottom - 1));
            }
            for (i = 0; i < this.myInsets.right; ++i) {
                LinePainter2D.paint((Graphics2D)g2d, (double)(r.width - i - 1), (double)this.myInsets.top, (double)(r.width - i - 1), (double)(r.height - this.myInsets.bottom - 1));
            }
            for (i = 0; i < this.myInsets.top; ++i) {
                LinePainter2D.paint((Graphics2D)g2d, (double)0.0, (double)i, (double)r.width, (double)i);
            }
            for (i = 0; i < this.myInsets.bottom; ++i) {
                LinePainter2D.paint((Graphics2D)g2d, (double)0.0, (double)(r.height - i - 1), (double)r.width, (double)(r.height - i - 1));
            }
            g2d.setComposite(old);
            g2d.setColor(oldColor);
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2 = new Object[3];
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[0] = "c";
                    break;
                }
                case 1: {
                    objectArray = objectArray2;
                    objectArray2[0] = "insets";
                    break;
                }
            }
            objectArray[1] = "com/intellij/internal/inspector/components/InspectorWindow$HighlightComponent";
            objectArray[2] = "<init>";
            throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
        }
    }

    private static abstract class MyTextAction
    extends IconWithTextAction
    implements DumbAware {
        private MyTextAction(Supplier<String> text2) {
            super(text2);
        }
    }
}

