/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.markdown.utils.doc.impl;

import java.net.URI;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.Regex;
import kotlin.text.RegexOption;
import kotlin.text.StringsKt;
import org.intellij.markdown.MarkdownElementTypes;
import org.intellij.markdown.ast.ASTNode;
import org.intellij.markdown.html.HtmlGenerator;
import org.intellij.markdown.html.LinkGeneratingProvider;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=2, xi=48, d1={"\u0000 \n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b\u001a\u0014\u0010\t\u001a\u00020\n*\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\b\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\"\u000e\u0010\u0003\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\f"}, d2={"UNSAFE_LINK_REGEX", "Lkotlin/text/Regex;", "UNSAFE_LINK_REGEX_IMAGE", "ALLOWED_DATA_LINK_REGEX", "makeXssSafeDestination", "", "s", "isImage", "", "makeXssSafe", "Lorg/intellij/markdown/html/LinkGeneratingProvider;", "useSafeLinks", "intellij.platform.markdown.utils"})
public final class XssSafeLinksKt {
    @NotNull
    private static final Regex UNSAFE_LINK_REGEX = new Regex("^(vbscript|javascript|file|data):", RegexOption.IGNORE_CASE);
    @NotNull
    private static final Regex UNSAFE_LINK_REGEX_IMAGE = new Regex("^(vbscript|javascript|data):", RegexOption.IGNORE_CASE);
    @NotNull
    private static final Regex ALLOWED_DATA_LINK_REGEX = new Regex("^data:image/(gif|png|jpeg|webp|svg)[+;=a-z0-9A-Z]*,", RegexOption.IGNORE_CASE);

    @NotNull
    public static final CharSequence makeXssSafeDestination(@NotNull CharSequence s, boolean isImage) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)s, (String)"s");
        CharSequence it = charSequence = s;
        boolean bl = false;
        CharSequence charSequence2 = !(isImage ? UNSAFE_LINK_REGEX_IMAGE : UNSAFE_LINK_REGEX).containsMatchIn(StringsKt.trim((CharSequence)s)) || ALLOWED_DATA_LINK_REGEX.containsMatchIn(StringsKt.trim((CharSequence)s)) ? charSequence : null;
        if (charSequence2 == null) {
            charSequence2 = "#";
        }
        return charSequence2;
    }

    @NotNull
    public static final LinkGeneratingProvider makeXssSafe(@NotNull LinkGeneratingProvider $this$makeXssSafe, boolean useSafeLinks) {
        Intrinsics.checkNotNullParameter((Object)$this$makeXssSafe, (String)"<this>");
        if (!useSafeLinks) {
            return $this$makeXssSafe;
        }
        URI uRI = $this$makeXssSafe.getBaseURI();
        boolean bl = $this$makeXssSafe.getResolveAnchors();
        return new LinkGeneratingProvider($this$makeXssSafe, uRI, bl){
            final /* synthetic */ LinkGeneratingProvider $this_makeXssSafe;
            {
                this.$this_makeXssSafe = $receiver;
                super($super_call_param$1, $super_call_param$2);
            }

            public void renderLink(HtmlGenerator.HtmlGeneratingVisitor visitor, String text2, ASTNode node, LinkGeneratingProvider.RenderInfo info) {
                Intrinsics.checkNotNullParameter((Object)visitor, (String)"visitor");
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                Intrinsics.checkNotNullParameter((Object)info, (String)"info");
                this.$this_makeXssSafe.renderLink(visitor, text2, node, info);
            }

            public LinkGeneratingProvider.RenderInfo getRenderInfo(String text2, ASTNode node) {
                LinkGeneratingProvider.RenderInfo renderInfo;
                Intrinsics.checkNotNullParameter((Object)text2, (String)"text");
                Intrinsics.checkNotNullParameter((Object)node, (String)"node");
                LinkGeneratingProvider.RenderInfo renderInfo2 = this.$this_makeXssSafe.getRenderInfo(text2, node);
                if (renderInfo2 != null) {
                    LinkGeneratingProvider.RenderInfo it = renderInfo2;
                    boolean bl = false;
                    renderInfo = LinkGeneratingProvider.RenderInfo.copy$default((LinkGeneratingProvider.RenderInfo)it, null, (CharSequence)XssSafeLinksKt.makeXssSafeDestination(it.getDestination(), Intrinsics.areEqual((Object)node.getType(), (Object)MarkdownElementTypes.IMAGE)), null, (int)5, null);
                } else {
                    renderInfo = null;
                }
                return renderInfo;
            }
        };
    }

    public static /* synthetic */ LinkGeneratingProvider makeXssSafe$default(LinkGeneratingProvider linkGeneratingProvider, boolean bl, int n, Object object) {
        if ((n & 1) != 0) {
            bl = true;
        }
        return XssSafeLinksKt.makeXssSafe(linkGeneratingProvider, bl);
    }
}

