/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.actionSystem;

import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.util.Comparing;
import javax.swing.KeyStroke;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class KeyboardShortcut
extends Shortcut {
    private final KeyStroke myFirstKeyStroke;
    private final KeyStroke mySecondKeyStroke;

    public KeyboardShortcut(@NotNull KeyStroke firstKeyStroke, @Nullable KeyStroke secondKeyStroke) {
        if (firstKeyStroke == null) {
            KeyboardShortcut.$$$reportNull$$$0(0);
        }
        this.myFirstKeyStroke = firstKeyStroke;
        this.mySecondKeyStroke = secondKeyStroke;
    }

    @NotNull
    public KeyStroke getFirstKeyStroke() {
        KeyStroke keyStroke = this.myFirstKeyStroke;
        if (keyStroke == null) {
            KeyboardShortcut.$$$reportNull$$$0(1);
        }
        return keyStroke;
    }

    @Nullable
    public KeyStroke getSecondKeyStroke() {
        return this.mySecondKeyStroke;
    }

    public int hashCode() {
        int hashCode = this.myFirstKeyStroke.hashCode();
        if (this.mySecondKeyStroke != null) {
            hashCode += this.mySecondKeyStroke.hashCode();
        }
        return hashCode;
    }

    public boolean equals(Object obj2) {
        if (!(obj2 instanceof KeyboardShortcut)) {
            return false;
        }
        KeyboardShortcut second = (KeyboardShortcut)obj2;
        return Comparing.equal((Object)this.myFirstKeyStroke, (Object)second.myFirstKeyStroke) && Comparing.equal((Object)this.mySecondKeyStroke, (Object)second.mySecondKeyStroke);
    }

    @Override
    public boolean isKeyboard() {
        return true;
    }

    @Override
    public boolean startsWith(@NotNull Shortcut sc) {
        if (sc == null) {
            KeyboardShortcut.$$$reportNull$$$0(2);
        }
        if (sc instanceof KeyboardShortcut) {
            KeyboardShortcut other = (KeyboardShortcut)sc;
            return this.myFirstKeyStroke.equals(other.myFirstKeyStroke) && (other.mySecondKeyStroke == null || other.mySecondKeyStroke.equals(this.mySecondKeyStroke));
        }
        return false;
    }

    public static KeyboardShortcut fromString(@NonNls String s) {
        KeyStroke keyStroke = KeyStroke.getKeyStroke(s);
        assert (keyStroke != null) : "Can't create key stroke for " + s;
        return new KeyboardShortcut(keyStroke, null);
    }

    @NonNls
    public String toString() {
        return this.mySecondKeyStroke == null ? "[" + String.valueOf(this.myFirstKeyStroke) + "]" : "[" + String.valueOf(this.myFirstKeyStroke) + "]+[" + String.valueOf(this.mySecondKeyStroke) + "]";
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "firstKeyStroke";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/actionSystem/KeyboardShortcut";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "sc";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/actionSystem/KeyboardShortcut";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getFirstKeyStroke";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "startsWith";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1 -> new IllegalStateException(string);
        };
    }
}

