/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.codeWithMe.ClientId;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.client.ClientKind;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.WeakList;
import java.util.List;
import java.util.stream.Stream;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0007\u0018\u0000 \u00172\u00020\u0001:\u0001\u0017B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\b0\fJ\f\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\rJ\u001e\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\f2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\bJ\u000e\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0014\u001a\u00020\bR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0017\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Lcom/intellij/openapi/editor/ClientEditorManager;", "", "<init>", "()V", "clientId", "Lcom/intellij/codeWithMe/ClientId;", "editors", "", "Lcom/intellij/openapi/editor/Editor;", "getEditors", "()Ljava/util/List;", "editorsSequence", "Lkotlin/sequences/Sequence;", "Ljava/util/stream/Stream;", "document", "Lcom/intellij/openapi/editor/Document;", "project", "Lcom/intellij/openapi/project/Project;", "editorCreated", "", "editor", "editorReleased", "", "Companion", "intellij.platform.editor.ui"})
@ApiStatus.Experimental
@ApiStatus.Internal
public final class ClientEditorManager {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ClientId clientId = ClientId.Companion.getCurrent();
    @NotNull
    private final List<Editor> editors;
    @NotNull
    private static final Key<ClientId> CLIENT_ID;
    @NotNull
    private static final Key<WeakList<Editor>> COPIED_EDITORS;

    public ClientEditorManager() {
        List list2 = ContainerUtil.createLockFreeCopyOnWriteList();
        Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"createLockFreeCopyOnWriteList(...)");
        this.editors = list2;
    }

    @NotNull
    public final List<Editor> getEditors() {
        return this.editors;
    }

    @NotNull
    public final Sequence<Editor> editorsSequence() {
        return CollectionsKt.asSequence((Iterable)this.editors);
    }

    @NotNull
    public final Stream<Editor> editors() {
        Stream<Editor> stream = this.editors.stream();
        Intrinsics.checkNotNullExpressionValue(stream, (String)"stream(...)");
        return stream;
    }

    @NotNull
    public final Sequence<Editor> editors(@NotNull Document document, @Nullable Project project) {
        Intrinsics.checkNotNullParameter((Object)document, (String)"document");
        return SequencesKt.filter((Sequence)CollectionsKt.asSequence((Iterable)this.editors), arg_0 -> ClientEditorManager.editors$lambda$0(document, project, arg_0));
    }

    public final void editorCreated(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!ClientId.Companion.isLocal(this.clientId)) {
            CLIENT_ID.set((UserDataHolder)editor, (Object)this.clientId);
        }
        this.editors.add(editor);
    }

    public final boolean editorReleased(@NotNull Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        if (!ClientId.Companion.isLocal(this.clientId)) {
            CLIENT_ID.set((UserDataHolder)editor, null);
        }
        return this.editors.remove(editor);
    }

    private static final boolean editors$lambda$0(Document $document, Project $project, Editor editor) {
        Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
        return Intrinsics.areEqual((Object)editor.getDocument(), (Object)$document) && ($project == null || Intrinsics.areEqual((Object)$project, (Object)editor.getProject()));
    }

    @JvmStatic
    @Nullable
    public static final ClientId getClientId(@NotNull Editor editor) {
        return Companion.getClientId(editor);
    }

    @JvmStatic
    @NotNull
    public static final Editor getClientEditor(@NotNull Editor editor, @Nullable ClientId clientId) {
        return Companion.getClientEditor(editor, clientId);
    }

    static {
        Key key = Key.create((String)"CLIENT_ID");
        Intrinsics.checkNotNullExpressionValue((Object)key, (String)"create(...)");
        CLIENT_ID = key;
        Key key2 = Key.create((String)"COPIED_EDITORS");
        Intrinsics.checkNotNullExpressionValue((Object)key2, (String)"create(...)");
        COPIED_EDITORS = key2;
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0006\u0010\u0004\u001a\u00020\u0005J\b\u0010\u0006\u001a\u0004\u0018\u00010\u0005J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00050\bJ\u0012\u0010\t\u001a\u0004\u0018\u00010\n2\u0006\u0010\u000b\u001a\u00020\fH\u0007J\u001a\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0007J\u001a\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u000b\u001a\u00020\f2\b\u0010\u000e\u001a\u0004\u0018\u00010\nH\u0007J\u0018\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\f2\u0006\u0010\u0013\u001a\u00020\fH\u0007R!\u0010\u0014\u001a\u0015\u0012\f\u0012\n \u0016*\u0004\u0018\u00010\n0\n0\u0015\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R-\u0010\u0018\u001a!\u0012\u0018\u0012\u0016\u0012\u0004\u0012\u00020\f \u0016*\n\u0012\u0004\u0012\u00020\f\u0018\u00010\u00190\u00190\u0015\u00a2\u0006\u0002\b\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001a"}, d2={"Lcom/intellij/openapi/editor/ClientEditorManager$Companion;", "", "<init>", "()V", "getCurrentInstance", "Lcom/intellij/openapi/editor/ClientEditorManager;", "getCurrentInstanceIfCreated", "getAllInstances", "", "getClientId", "Lcom/intellij/codeWithMe/ClientId;", "editor", "Lcom/intellij/openapi/editor/Editor;", "getClientEditor", "clientId", "assignClientId", "", "addCopiedEditor", "from", "to", "CLIENT_ID", "Lcom/intellij/openapi/util/Key;", "kotlin.jvm.PlatformType", "Lorg/jetbrains/annotations/NotNull;", "COPIED_EDITORS", "Lcom/intellij/util/containers/WeakList;", "intellij.platform.editor.ui"})
    @SourceDebugExtension(value={"SMAP\nClientEditorManager.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ClientEditorManager.kt\ncom/intellij/openapi/editor/ClientEditorManager$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,88:1\n295#2,2:89\n*S KotlinDebug\n*F\n+ 1 ClientEditorManager.kt\ncom/intellij/openapi/editor/ClientEditorManager$Companion\n*L\n45#1:89,2\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ClientEditorManager getCurrentInstance() {
            Object object = ApplicationManager.getApplication().getService(ClientEditorManager.class);
            Intrinsics.checkNotNullExpressionValue((Object)object, (String)"getService(...)");
            return (ClientEditorManager)object;
        }

        @Nullable
        public final ClientEditorManager getCurrentInstanceIfCreated() {
            return (ClientEditorManager)ApplicationManager.getApplication().getServiceIfCreated(ClientEditorManager.class);
        }

        @NotNull
        public final List<ClientEditorManager> getAllInstances() {
            List list2 = ApplicationManager.getApplication().getServices(ClientEditorManager.class, ClientKind.ALL);
            Intrinsics.checkNotNullExpressionValue((Object)list2, (String)"getServices(...)");
            return list2;
        }

        @JvmStatic
        @Nullable
        public final ClientId getClientId(@NotNull Editor editor) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            return (ClientId)CLIENT_ID.get((UserDataHolder)editor);
        }

        @JvmStatic
        @NotNull
        public final Editor getClientEditor(@NotNull Editor editor, @Nullable ClientId clientId) {
            Editor editor2;
            Object v0;
            block3: {
                Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
                WeakList editors = (WeakList)COPIED_EDITORS.get((UserDataHolder)editor);
                if (clientId == null || editors == null) {
                    return editor;
                }
                Iterable $this$firstOrNull$iv = (Iterable)editors;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    Editor it = (Editor)element$iv;
                    boolean bl = false;
                    Intrinsics.checkNotNull((Object)it);
                    if (!Intrinsics.areEqual((Object)clientId, (Object)Companion.getClientId(it))) continue;
                    v0 = element$iv;
                    break block3;
                }
                v0 = null;
            }
            if ((editor2 = (Editor)v0) == null) {
                editor2 = editor;
            }
            return editor2;
        }

        @ApiStatus.Internal
        public final void assignClientId(@NotNull Editor editor, @Nullable ClientId clientId) {
            Intrinsics.checkNotNullParameter((Object)editor, (String)"editor");
            CLIENT_ID.set((UserDataHolder)editor, (Object)clientId);
        }

        @ApiStatus.Internal
        public final void addCopiedEditor(@NotNull Editor from, @NotNull Editor to) {
            Intrinsics.checkNotNullParameter((Object)from, (String)"from");
            Intrinsics.checkNotNullParameter((Object)to, (String)"to");
            WeakList list2 = (WeakList)COPIED_EDITORS.get((UserDataHolder)from);
            if (list2 == null) {
                list2 = new WeakList();
                COPIED_EDITORS.set((UserDataHolder)from, (Object)list2);
            }
            list2.add((Object)to);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

