/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.editor.CaretModel;
import com.intellij.openapi.editor.CustomFoldRegion;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.EditorCoreUtil;
import com.intellij.openapi.editor.EditorGutter;
import com.intellij.openapi.editor.EditorKind;
import com.intellij.openapi.editor.EditorSettings;
import com.intellij.openapi.editor.EditorThreading;
import com.intellij.openapi.editor.FoldRegion;
import com.intellij.openapi.editor.FoldingModel;
import com.intellij.openapi.editor.IndentsModel;
import com.intellij.openapi.editor.InlayModel;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.ModNavigator;
import com.intellij.openapi.editor.ScrollingModel;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.SoftWrapModel;
import com.intellij.openapi.editor.VisualPosition;
import com.intellij.openapi.editor.colors.EditorColorsScheme;
import com.intellij.openapi.editor.colors.EditorFontType;
import com.intellij.openapi.editor.event.EditorMouseEventArea;
import com.intellij.openapi.editor.event.EditorMouseListener;
import com.intellij.openapi.editor.event.EditorMouseMotionListener;
import com.intellij.openapi.editor.highlighter.EditorHighlighter;
import com.intellij.openapi.editor.markup.MarkupModel;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.openapi.vfs.VirtualFile;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.geom.Point2D;
import javax.swing.JComponent;
import javax.swing.border.Border;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface Editor
extends UserDataHolder {
    public static final Editor[] EMPTY_ARRAY = new Editor[0];

    @NotNull
    public Document getDocument();

    public boolean isViewer();

    @NotNull
    public JComponent getComponent();

    @NotNull
    public JComponent getContentComponent();

    public void setBorder(@Nullable Border var1);

    public Insets getInsets();

    @NotNull
    public SelectionModel getSelectionModel();

    @NotNull
    public MarkupModel getMarkupModel();

    @NotNull
    public FoldingModel getFoldingModel();

    @NotNull
    public ScrollingModel getScrollingModel();

    @NotNull
    public CaretModel getCaretModel();

    @NotNull
    public SoftWrapModel getSoftWrapModel();

    @NotNull
    public EditorSettings getSettings();

    @NotNull
    public EditorColorsScheme getColorsScheme();

    public int getLineHeight();

    @NotNull
    public Point logicalPositionToXY(@NotNull LogicalPosition var1);

    public int logicalPositionToOffset(@NotNull LogicalPosition var1);

    @NotNull
    public VisualPosition logicalToVisualPosition(@NotNull LogicalPosition var1);

    @NotNull
    public Point visualPositionToXY(@NotNull VisualPosition var1);

    @NotNull
    public Point2D visualPositionToPoint2D(@NotNull VisualPosition var1);

    @NotNull
    public LogicalPosition visualToLogicalPosition(@NotNull VisualPosition var1);

    default public int visualPositionToOffset(@NotNull VisualPosition pos) {
        if (pos == null) {
            Editor.$$$reportNull$$$0(0);
        }
        return this.logicalPositionToOffset(this.visualToLogicalPosition(pos));
    }

    @NotNull
    public LogicalPosition offsetToLogicalPosition(int var1);

    @NotNull
    public VisualPosition offsetToVisualPosition(int var1);

    @NotNull
    public VisualPosition offsetToVisualPosition(int var1, boolean var2, boolean var3);

    default public int offsetToVisualLine(int offset, boolean beforeSoftWrap) {
        return this.offsetToVisualPosition((int)offset, (boolean)false, (boolean)beforeSoftWrap).line;
    }

    @NotNull
    public LogicalPosition xyToLogicalPosition(@NotNull Point var1);

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point var1);

    @NotNull
    public VisualPosition xyToVisualPosition(@NotNull Point2D var1);

    @NotNull
    default public Point offsetToXY(int offset) {
        Point point = this.offsetToXY(offset, false, false);
        if (point == null) {
            Editor.$$$reportNull$$$0(1);
        }
        return point;
    }

    @NotNull
    default public Point offsetToXY(int offset, boolean leanForward, boolean beforeSoftWrap) {
        VisualPosition visualPosition = this.offsetToVisualPosition(offset, leanForward, beforeSoftWrap);
        Point point = this.visualPositionToXY(visualPosition);
        if (point == null) {
            Editor.$$$reportNull$$$0(2);
        }
        return point;
    }

    @NotNull
    default public Point2D offsetToPoint2D(int offset) {
        Point2D point2D = this.offsetToPoint2D(offset, false, false);
        if (point2D == null) {
            Editor.$$$reportNull$$$0(3);
        }
        return point2D;
    }

    @NotNull
    default public Point2D offsetToPoint2D(int offset, boolean leanForward, boolean beforeSoftWrap) {
        VisualPosition visualPosition = this.offsetToVisualPosition(offset, leanForward, beforeSoftWrap);
        Point2D point2D = this.visualPositionToPoint2D(visualPosition);
        if (point2D == null) {
            Editor.$$$reportNull$$$0(4);
        }
        return point2D;
    }

    default public int visualLineToY(int visualLine) {
        return this.visualPositionToXY((VisualPosition)new VisualPosition((int)visualLine, (int)0)).y;
    }

    default public int yToVisualLine(int y) {
        return this.xyToVisualPosition((Point)new Point((int)0, (int)y)).line;
    }

    default public int @NotNull [] visualLineToYRange(int visualLine) {
        int startY = this.visualLineToY(visualLine);
        int startOffset = this.visualPositionToOffset(new VisualPosition(visualLine, 0));
        FoldRegion foldRegion = this.getFoldingModel().getCollapsedRegionAtOffset(startOffset);
        int endY = startY + (foldRegion instanceof CustomFoldRegion ? ((CustomFoldRegion)foldRegion).getHeightInPixels() : this.getLineHeight());
        int[] nArray = new int[]{startY, endY};
        if (nArray == null) {
            Editor.$$$reportNull$$$0(5);
        }
        return nArray;
    }

    public void addEditorMouseListener(@NotNull EditorMouseListener var1);

    default public void addEditorMouseListener(@NotNull EditorMouseListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            Editor.$$$reportNull$$$0(6);
        }
        if (parentDisposable == null) {
            Editor.$$$reportNull$$$0(7);
        }
        this.addEditorMouseListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.removeEditorMouseListener(listener2));
    }

    public void removeEditorMouseListener(@NotNull EditorMouseListener var1);

    public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener var1);

    default public void addEditorMouseMotionListener(@NotNull EditorMouseMotionListener listener2, @NotNull Disposable parentDisposable) {
        if (listener2 == null) {
            Editor.$$$reportNull$$$0(8);
        }
        if (parentDisposable == null) {
            Editor.$$$reportNull$$$0(9);
        }
        this.addEditorMouseMotionListener(listener2);
        Disposer.register((Disposable)parentDisposable, () -> this.removeEditorMouseMotionListener(listener2));
    }

    public void removeEditorMouseMotionListener(@NotNull EditorMouseMotionListener var1);

    public boolean isDisposed();

    @Nullable
    public Project getProject();

    @Nullable
    @ApiStatus.Obsolete
    default public VirtualFile getVirtualFile() {
        return null;
    }

    public boolean isInsertMode();

    public boolean isColumnMode();

    public boolean isOneLineMode();

    @NotNull
    public EditorGutter getGutter();

    @Nullable
    public EditorMouseEventArea getMouseEventArea(@NotNull MouseEvent var1);

    public void setHeaderComponent(@Nullable JComponent var1);

    public boolean hasHeaderComponent();

    @Nullable
    public JComponent getHeaderComponent();

    @NotNull
    public IndentsModel getIndentsModel();

    @NotNull
    public InlayModel getInlayModel();

    @NotNull
    public EditorKind getEditorKind();

    @NotNull
    default public EditorHighlighter getHighlighter() {
        EditorHighlighter editorHighlighter = EditorCoreUtil.createEmptyHighlighter(this.getProject(), this.getDocument());
        if (editorHighlighter == null) {
            Editor.$$$reportNull$$$0(10);
        }
        return editorHighlighter;
    }

    default public int getAscent() {
        return ((Float)EditorThreading.compute(() -> Float.valueOf((float)this.getContentComponent().getFontMetrics(this.getColorsScheme().getFont(EditorFontType.PLAIN)).getAscent() * this.getColorsScheme().getLineSpacing()))).intValue();
    }

    @NotNull
    default public ProperTextRange calculateVisibleRange() {
        EditorThreading.assertInteractionAllowed();
        ProperTextRange properTextRange = (ProperTextRange)EditorThreading.compute(() -> {
            Rectangle rect = this.getScrollingModel().getVisibleArea();
            LogicalPosition startPosition = this.xyToLogicalPosition(new Point(rect.x, rect.y));
            int visibleStart = this.logicalPositionToOffset(startPosition);
            LogicalPosition endPosition = this.xyToLogicalPosition(new Point(rect.x + rect.width, rect.y + rect.height));
            int visibleEnd = this.logicalPositionToOffset(new LogicalPosition(endPosition.line + 1, 0));
            return new ProperTextRange(visibleStart, Math.max(visibleEnd, visibleStart));
        });
        if (properTextRange == null) {
            Editor.$$$reportNull$$$0(11);
        }
        return properTextRange;
    }

    @NotNull
    default public ModNavigator asModNavigator() {
        return new ModNavigator(){

            @NotNull
            public Document getDocument() {
                Document document = Editor.this.getDocument();
                if (document == null) {
                    1.$$$reportNull$$$0(0);
                }
                return document;
            }

            public void select(@NotNull TextRange range) {
                if (range == null) {
                    1.$$$reportNull$$$0(1);
                }
                Editor.this.getSelectionModel().setSelection(range.getStartOffset(), range.getEndOffset());
            }

            public void moveCaretTo(int offset) {
                Editor.this.getCaretModel().moveToOffset(offset);
            }

            public int getCaretOffset() {
                return Editor.this.getCaretModel().getOffset();
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                Object[] objectArray;
                Object[] objectArray2;
                Object[] objectArray3 = new Object[switch (n) {
                    default -> 2;
                    case 1 -> 3;
                }];
                switch (n) {
                    default: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "com/intellij/openapi/editor/Editor$1";
                        break;
                    }
                    case 1: {
                        objectArray2 = objectArray3;
                        objectArray3[0] = "range";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        objectArray = objectArray2;
                        objectArray2[1] = "getDocument";
                        break;
                    }
                    case 1: {
                        objectArray = objectArray2;
                        objectArray2[1] = "com/intellij/openapi/editor/Editor$1";
                        break;
                    }
                }
                switch (n) {
                    default: {
                        break;
                    }
                    case 1: {
                        objectArray = objectArray;
                        objectArray[2] = "select";
                        break;
                    }
                }
                String string = String.format(v0, objectArray);
                throw switch (n) {
                    default -> new IllegalStateException(string);
                    case 1 -> new IllegalArgumentException(string);
                };
            }
        };
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 1, 2, 3, 4, 5, 10, 11 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "pos";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/Editor";
                break;
            }
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 7: 
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/Editor";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToXY";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "offsetToPoint2D";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "visualLineToYRange";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "getHighlighter";
                break;
            }
            case 11: {
                objectArray = objectArray2;
                objectArray2[1] = "calculateVisibleRange";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "visualPositionToOffset";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 10: 
            case 11: {
                break;
            }
            case 6: 
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "addEditorMouseListener";
                break;
            }
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "addEditorMouseMotionListener";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 1, 2, 3, 4, 5, 10, 11 -> new IllegalStateException(string);
        };
    }
}

