/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.openapi.editor.impl;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.SelectionModel;
import com.intellij.openapi.editor.event.SelectionListener;
import com.intellij.openapi.editor.impl.ImaginaryEditor;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.util.TextRange;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ApiStatus.Internal
public class ImaginarySelectionModel
implements SelectionModel {
    private final ImaginaryEditor myEditor;
    private static final Logger LOG = Logger.getInstance(ImaginarySelectionModel.class);

    public ImaginarySelectionModel(ImaginaryEditor editor) {
        this.myEditor = editor;
    }

    @Override
    @NotNull
    public Editor getEditor() {
        ImaginaryEditor imaginaryEditor = this.myEditor;
        if (imaginaryEditor == null) {
            ImaginarySelectionModel.$$$reportNull$$$0(0);
        }
        return imaginaryEditor;
    }

    @Override
    @Nullable
    public String getSelectedText(boolean allCarets) {
        return this.myEditor.getDocument().getText(TextRange.create((int)this.getSelectionStart(), (int)this.getSelectionEnd()));
    }

    @Override
    public void addSelectionListener(@NotNull SelectionListener listener2) {
        if (listener2 == null) {
            ImaginarySelectionModel.$$$reportNull$$$0(1);
        }
        LOG.info("Called ImaginarySelectionModel#addSelectionListener which is stubbed and has no implementation");
    }

    @Override
    public void removeSelectionListener(@NotNull SelectionListener listener2) {
        if (listener2 == null) {
            ImaginarySelectionModel.$$$reportNull$$$0(2);
        }
        LOG.info("Called ImaginarySelectionModel#addSelectionListener which is stubbed and has no implementation");
    }

    @Override
    public void copySelectionToClipboard() {
        throw this.myEditor.notImplemented();
    }

    @Override
    public void setBlockSelection(@NotNull LogicalPosition blockStart, @NotNull LogicalPosition blockEnd) {
        if (blockStart == null) {
            ImaginarySelectionModel.$$$reportNull$$$0(3);
        }
        if (blockEnd == null) {
            ImaginarySelectionModel.$$$reportNull$$$0(4);
        }
        throw this.myEditor.notImplemented();
    }

    @Override
    public int @NotNull [] getBlockSelectionStarts() {
        int[] nArray = new int[]{this.myEditor.getSelectionModel().getSelectionStart()};
        if (nArray == null) {
            ImaginarySelectionModel.$$$reportNull$$$0(5);
        }
        return nArray;
    }

    @Override
    public int @NotNull [] getBlockSelectionEnds() {
        int[] nArray = new int[]{this.myEditor.getSelectionModel().getSelectionEnd()};
        if (nArray == null) {
            ImaginarySelectionModel.$$$reportNull$$$0(6);
        }
        return nArray;
    }

    @Override
    public TextAttributes getTextAttributes() {
        throw this.myEditor.notImplemented();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 2;
            case 1, 2, 3, 4 -> 3;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/openapi/editor/impl/ImaginarySelectionModel";
                break;
            }
            case 1: 
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "listener";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockStart";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "blockEnd";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "getEditor";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/openapi/editor/impl/ImaginarySelectionModel";
                break;
            }
            case 5: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockSelectionStarts";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getBlockSelectionEnds";
                break;
            }
        }
        switch (n) {
            default: {
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "addSelectionListener";
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "removeSelectionListener";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "setBlockSelection";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalStateException(string);
            case 1, 2, 3, 4 -> new IllegalArgumentException(string);
        };
    }
}

